/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;

public class Constraints
extends ViewGroup {
    public static final String TAG = "Constraints";
    ConstraintSet mConstraintSet;

    public Constraints(Context context) {
        super(context);
        super.setVisibility(8);
    }

    public Constraints(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        super.setVisibility(8);
    }

    public Constraints(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        super.setVisibility(8);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    private void init() {
        Log.v((String)TAG, (String)" ################# init");
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ConstraintLayout.LayoutParams(p);
    }

    public ConstraintSet getConstraintSet() {
        if (this.mConstraintSet == null) {
            this.mConstraintSet = new ConstraintSet();
        }
        this.mConstraintSet.clone(this);
        return this.mConstraintSet;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    public static class LayoutParams
    extends ConstraintLayout.LayoutParams {
        public float alpha = 1.0f;
        public boolean applyElevation = false;
        public float elevation = 0.0f;
        public float rotation = 0.0f;
        public float rotationX = 0.0f;
        public float rotationY = 0.0f;
        public float scaleX = 1.0f;
        public float scaleY = 1.0f;
        public float transformPivotX = 0.0f;
        public float transformPivotY = 0.0f;
        public float translationX = 0.0f;
        public float translationY = 0.0f;
        public float translationZ = 0.0f;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.LayoutParams)source);
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ConstraintSet);
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.ConstraintSet_android_alpha) {
                    this.alpha = a.getFloat(attr2, this.alpha);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_elevation) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.elevation = a.getFloat(attr2, this.elevation);
                    this.applyElevation = true;
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_rotationX) {
                    this.rotationX = a.getFloat(attr2, this.rotationX);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_rotationY) {
                    this.rotationY = a.getFloat(attr2, this.rotationY);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_rotation) {
                    this.rotation = a.getFloat(attr2, this.rotation);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_scaleX) {
                    this.scaleX = a.getFloat(attr2, this.scaleX);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_scaleY) {
                    this.scaleY = a.getFloat(attr2, this.scaleY);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_transformPivotX) {
                    this.transformPivotX = a.getFloat(attr2, this.transformPivotX);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_transformPivotY) {
                    this.transformPivotY = a.getFloat(attr2, this.transformPivotY);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_translationX) {
                    this.translationX = a.getFloat(attr2, this.translationX);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintSet_android_translationY) {
                    this.translationY = a.getFloat(attr2, this.translationY);
                    continue;
                }
                if (attr2 != R.styleable.ConstraintSet_android_translationZ || Build.VERSION.SDK_INT < 21) continue;
                this.translationZ = a.getFloat(attr2, this.translationZ);
            }
            a.recycle();
        }
    }
}

