/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.R;

public class Placeholder
extends View {
    private int mContentId = -1;
    private View mContent = null;
    private int mEmptyVisibility = 4;

    public Placeholder(Context context) {
        super(context);
        this.init(null);
    }

    public Placeholder(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public Placeholder(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public Placeholder(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        super.setVisibility(this.mEmptyVisibility);
        this.mContentId = -1;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_placeholder);
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.ConstraintLayout_placeholder_content) {
                    this.mContentId = a.getResourceId(attr2, this.mContentId);
                    continue;
                }
                if (attr2 != R.styleable.ConstraintLayout_placeholder_placeholder_emptyVisibility) continue;
                this.mEmptyVisibility = a.getInt(attr2, this.mEmptyVisibility);
            }
            a.recycle();
        }
    }

    public int getEmptyVisibility() {
        return this.mEmptyVisibility;
    }

    public void setEmptyVisibility(int visibility) {
        this.mEmptyVisibility = visibility;
    }

    public View getContent() {
        return this.mContent;
    }

    public void onDraw(@NonNull Canvas canvas) {
        if (this.isInEditMode()) {
            canvas.drawRGB(223, 223, 223);
            Paint paint = new Paint();
            paint.setARGB(255, 210, 210, 210);
            paint.setTextAlign(Paint.Align.CENTER);
            paint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)0));
            Rect r = new Rect();
            canvas.getClipBounds(r);
            paint.setTextSize((float)r.height());
            int cHeight = r.height();
            int cWidth = r.width();
            paint.setTextAlign(Paint.Align.LEFT);
            String text = "?";
            paint.getTextBounds(text, 0, text.length(), r);
            float x = (float)cWidth / 2.0f - (float)r.width() / 2.0f - (float)r.left;
            float y = (float)cHeight / 2.0f + (float)r.height() / 2.0f - (float)r.bottom;
            canvas.drawText(text, x, y, paint);
        }
    }

    public void updatePreLayout(ConstraintLayout container) {
        if (this.mContentId == -1 && !this.isInEditMode()) {
            this.setVisibility(this.mEmptyVisibility);
        }
        this.mContent = container.findViewById(this.mContentId);
        if (this.mContent != null) {
            ConstraintLayout.LayoutParams layoutParamsContent = (ConstraintLayout.LayoutParams)this.mContent.getLayoutParams();
            layoutParamsContent.mIsInPlaceholder = true;
            this.mContent.setVisibility(0);
            this.setVisibility(0);
        }
    }

    public void setContentId(int id2) {
        View v;
        if (this.mContentId == id2) {
            return;
        }
        if (this.mContent != null) {
            this.mContent.setVisibility(0);
            ConstraintLayout.LayoutParams layoutParamsContent = (ConstraintLayout.LayoutParams)this.mContent.getLayoutParams();
            layoutParamsContent.mIsInPlaceholder = false;
            this.mContent = null;
        }
        this.mContentId = id2;
        if (id2 != -1 && (v = ((View)this.getParent()).findViewById(id2)) != null) {
            v.setVisibility(8);
        }
    }

    public void updatePostMeasure(ConstraintLayout container) {
        if (this.mContent == null) {
            return;
        }
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        ConstraintLayout.LayoutParams layoutParamsContent = (ConstraintLayout.LayoutParams)this.mContent.getLayoutParams();
        layoutParamsContent.mWidget.setVisibility(0);
        if (layoutParams.mWidget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.FIXED) {
            layoutParams.mWidget.setWidth(layoutParamsContent.mWidget.getWidth());
        }
        if (layoutParams.mWidget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.FIXED) {
            layoutParams.mWidget.setHeight(layoutParamsContent.mWidget.getHeight());
        }
        layoutParamsContent.mWidget.setVisibility(8);
    }
}

