/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import androidx.annotation.CallSuper;
import androidx.annotation.DoNotInline;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatCallback;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.app.AppCompatDialog;
import androidx.appcompat.app.AppCompatViewInflater;
import androidx.appcompat.app.LayoutIncludeDetector;
import androidx.appcompat.app.LocaleOverlayHelper;
import androidx.appcompat.app.ResourcesFlusher;
import androidx.appcompat.app.ToolbarActionBar;
import androidx.appcompat.app.TwilightManager;
import androidx.appcompat.app.WindowDecorActionBar;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.view.ActionMode;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.view.StandaloneActionMode;
import androidx.appcompat.view.SupportActionModeWrapper;
import androidx.appcompat.view.SupportMenuInflater;
import androidx.appcompat.view.WindowCallbackWrapper;
import androidx.appcompat.view.menu.ListMenuPresenter;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.ActionBarContextView;
import androidx.appcompat.widget.AppCompatDrawableManager;
import androidx.appcompat.widget.ContentFrameLayout;
import androidx.appcompat.widget.DecorContentParent;
import androidx.appcompat.widget.FitWindowsViewGroup;
import androidx.appcompat.widget.TintTypedArray;
import androidx.appcompat.widget.Toolbar;
import androidx.appcompat.widget.VectorEnabledTintResources;
import androidx.appcompat.widget.ViewStubCompat;
import androidx.appcompat.widget.ViewUtils;
import androidx.collection.SimpleArrayMap;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NavUtils;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.os.LocaleListCompat;
import androidx.core.util.ObjectsCompat;
import androidx.core.view.KeyEventDispatcher;
import androidx.core.view.LayoutInflaterCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.core.view.ViewPropertyAnimatorListenerAdapter;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.widget.PopupWindowCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import java.util.List;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class AppCompatDelegateImpl
extends AppCompatDelegate
implements MenuBuilder.Callback,
LayoutInflater.Factory2 {
    private static final SimpleArrayMap<String, Integer> sLocalNightModes = new SimpleArrayMap();
    private static final boolean IS_PRE_LOLLIPOP = Build.VERSION.SDK_INT < 21;
    private static final int[] sWindowBackgroundStyleable = new int[]{16842836};
    private static final boolean sCanReturnDifferentContext;
    private static boolean sInstalledExceptionHandler;
    static final String EXCEPTION_HANDLER_MESSAGE_SUFFIX = ". If the resource you are trying to use is a vector resource, you may be referencing it in an unsupported way. See AppCompatDelegate.setCompatVectorFromResourcesEnabled() for more info.";
    final Object mHost;
    final Context mContext;
    Window mWindow;
    private AppCompatWindowCallback mAppCompatWindowCallback;
    final AppCompatCallback mAppCompatCallback;
    ActionBar mActionBar;
    MenuInflater mMenuInflater;
    private CharSequence mTitle;
    private DecorContentParent mDecorContentParent;
    private ActionMenuPresenterCallback mActionMenuPresenterCallback;
    private PanelMenuPresenterCallback mPanelMenuPresenterCallback;
    ActionMode mActionMode;
    ActionBarContextView mActionModeView;
    PopupWindow mActionModePopup;
    Runnable mShowActionModePopup;
    ViewPropertyAnimatorCompat mFadeAnim = null;
    private boolean mHandleNativeActionModes = true;
    private boolean mSubDecorInstalled;
    ViewGroup mSubDecor;
    private TextView mTitleView;
    private View mStatusGuard;
    private boolean mFeatureProgress;
    private boolean mFeatureIndeterminateProgress;
    boolean mHasActionBar;
    boolean mOverlayActionBar;
    boolean mOverlayActionMode;
    boolean mIsFloating;
    boolean mWindowNoTitle;
    private boolean mClosingActionMenu;
    private PanelFeatureState[] mPanels;
    private PanelFeatureState mPreparedPanel;
    private boolean mLongPressBackDown;
    private boolean mBaseContextAttached;
    private boolean mCreated;
    boolean mDestroyed;
    private Configuration mEffectiveConfiguration;
    private int mLocalNightMode = -100;
    private int mThemeResId;
    private int mActivityHandlesConfigFlags;
    private boolean mActivityHandlesConfigFlagsChecked;
    private AutoNightModeManager mAutoTimeNightModeManager;
    private AutoNightModeManager mAutoBatteryNightModeManager;
    boolean mInvalidatePanelMenuPosted;
    int mInvalidatePanelMenuFeatures;
    private final Runnable mInvalidatePanelMenuRunnable = new Runnable(){

        @Override
        public void run() {
            if ((AppCompatDelegateImpl.this.mInvalidatePanelMenuFeatures & 1) != 0) {
                AppCompatDelegateImpl.this.doInvalidatePanelMenu(0);
            }
            if ((AppCompatDelegateImpl.this.mInvalidatePanelMenuFeatures & 0x1000) != 0) {
                AppCompatDelegateImpl.this.doInvalidatePanelMenu(108);
            }
            AppCompatDelegateImpl.this.mInvalidatePanelMenuPosted = false;
            AppCompatDelegateImpl.this.mInvalidatePanelMenuFeatures = 0;
        }
    };
    private boolean mEnableDefaultActionBarUp;
    private Rect mTempRect1;
    private Rect mTempRect2;
    private AppCompatViewInflater mAppCompatViewInflater;
    private LayoutIncludeDetector mLayoutIncludeDetector;
    private OnBackInvokedDispatcher mDispatcher;
    private OnBackInvokedCallback mBackCallback;

    AppCompatDelegateImpl(Activity activity, AppCompatCallback callback) {
        this((Context)activity, null, callback, activity);
    }

    AppCompatDelegateImpl(Dialog dialog, AppCompatCallback callback) {
        this(dialog.getContext(), dialog.getWindow(), callback, dialog);
    }

    AppCompatDelegateImpl(Context context, Window window, AppCompatCallback callback) {
        this(context, window, callback, context);
    }

    AppCompatDelegateImpl(Context context, Activity activity, AppCompatCallback callback) {
        this(context, null, callback, activity);
    }

    private AppCompatDelegateImpl(Context context, Window window, AppCompatCallback callback, Object host) {
        Integer value;
        AppCompatActivity activity;
        this.mContext = context;
        this.mAppCompatCallback = callback;
        this.mHost = host;
        if (this.mLocalNightMode == -100 && this.mHost instanceof Dialog && (activity = this.tryUnwrapContext()) != null) {
            this.mLocalNightMode = activity.getDelegate().getLocalNightMode();
        }
        if (this.mLocalNightMode == -100 && (value = (Integer)sLocalNightModes.get((Object)this.mHost.getClass().getName())) != null) {
            this.mLocalNightMode = value;
            sLocalNightModes.remove((Object)this.mHost.getClass().getName());
        }
        if (window != null) {
            this.attachToWindow(window);
        }
        AppCompatDrawableManager.preload();
    }

    @Override
    @RequiresApi(value=33)
    public void setOnBackInvokedDispatcher(@Nullable OnBackInvokedDispatcher dispatcher) {
        super.setOnBackInvokedDispatcher(dispatcher);
        if (this.mDispatcher != null && this.mBackCallback != null) {
            Api33Impl.unregisterOnBackInvokedCallback(this.mDispatcher, this.mBackCallback);
            this.mBackCallback = null;
        }
        this.mDispatcher = dispatcher == null && this.mHost instanceof Activity && ((Activity)this.mHost).getWindow() != null ? Api33Impl.getOnBackInvokedDispatcher((Activity)this.mHost) : dispatcher;
        this.updateBackInvokedCallbackState();
    }

    void updateBackInvokedCallbackState() {
        if (Build.VERSION.SDK_INT >= 33) {
            boolean shouldRegister = this.shouldRegisterBackInvokedCallback();
            if (shouldRegister && this.mBackCallback == null) {
                this.mBackCallback = Api33Impl.registerOnBackPressedCallback(this.mDispatcher, this);
            } else if (!shouldRegister && this.mBackCallback != null) {
                Api33Impl.unregisterOnBackInvokedCallback(this.mDispatcher, this.mBackCallback);
                this.mBackCallback = null;
            }
        }
    }

    @Override
    @NonNull
    @CallSuper
    public Context attachBaseContext2(@NonNull Context baseContext) {
        boolean needsThemeRebase;
        Configuration config;
        this.mBaseContextAttached = true;
        int modeToApply = this.mapNightMode(baseContext, this.calculateNightMode());
        if (AppCompatDelegateImpl.isAutoStorageOptedIn(baseContext)) {
            AppCompatDelegateImpl.syncRequestedAndStoredLocales(baseContext);
        }
        LocaleListCompat localesToApply = this.calculateApplicationLocales(baseContext);
        if (baseContext instanceof android.view.ContextThemeWrapper) {
            config = this.createOverrideAppConfiguration(baseContext, modeToApply, localesToApply, null, false);
            try {
                ((android.view.ContextThemeWrapper)baseContext).applyOverrideConfiguration(config);
                return baseContext;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (baseContext instanceof ContextThemeWrapper) {
            config = this.createOverrideAppConfiguration(baseContext, modeToApply, localesToApply, null, false);
            try {
                ((ContextThemeWrapper)baseContext).applyOverrideConfiguration(config);
                return baseContext;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (!sCanReturnDifferentContext) {
            return super.attachBaseContext2(baseContext);
        }
        Configuration configOverlay = null;
        Configuration overrideConfig = new Configuration();
        overrideConfig.uiMode = -1;
        overrideConfig.fontScale = 0.0f;
        Configuration referenceConfig = baseContext.createConfigurationContext(overrideConfig).getResources().getConfiguration();
        Configuration baseConfig = baseContext.getResources().getConfiguration();
        referenceConfig.uiMode = baseConfig.uiMode;
        if (!referenceConfig.equals(baseConfig)) {
            configOverlay = AppCompatDelegateImpl.generateConfigDelta(referenceConfig, baseConfig);
        }
        Configuration config2 = this.createOverrideAppConfiguration(baseContext, modeToApply, localesToApply, configOverlay, true);
        ContextThemeWrapper wrappedContext = new ContextThemeWrapper(baseContext, R.style.Theme_AppCompat_Empty);
        wrappedContext.applyOverrideConfiguration(config2);
        try {
            needsThemeRebase = baseContext.getTheme() != null;
        }
        catch (NullPointerException e) {
            needsThemeRebase = false;
        }
        if (needsThemeRebase) {
            ResourcesCompat.ThemeCompat.rebase((Resources.Theme)wrappedContext.getTheme());
        }
        return super.attachBaseContext2((Context)wrappedContext);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.mBaseContextAttached = true;
        this.applyApplicationSpecificConfig(false);
        this.ensureWindow();
        if (this.mHost instanceof Activity) {
            String parentActivityName = null;
            try {
                parentActivityName = NavUtils.getParentActivityName((Activity)((Activity)this.mHost));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (parentActivityName != null) {
                ActionBar ab = this.peekSupportActionBar();
                if (ab == null) {
                    this.mEnableDefaultActionBarUp = true;
                } else {
                    ab.setDefaultDisplayHomeAsUpEnabled(true);
                }
            }
            AppCompatDelegateImpl.addActiveDelegate(this);
        }
        this.mEffectiveConfiguration = new Configuration(this.mContext.getResources().getConfiguration());
        this.mCreated = true;
    }

    @Override
    public void onPostCreate(Bundle savedInstanceState) {
        this.ensureSubDecor();
    }

    @Override
    public ActionBar getSupportActionBar() {
        this.initWindowDecorActionBar();
        return this.mActionBar;
    }

    final ActionBar peekSupportActionBar() {
        return this.mActionBar;
    }

    final Window.Callback getWindowCallback() {
        return this.mWindow.getCallback();
    }

    private void initWindowDecorActionBar() {
        this.ensureSubDecor();
        if (!this.mHasActionBar || this.mActionBar != null) {
            return;
        }
        if (this.mHost instanceof Activity) {
            this.mActionBar = new WindowDecorActionBar((Activity)this.mHost, this.mOverlayActionBar);
        } else if (this.mHost instanceof Dialog) {
            this.mActionBar = new WindowDecorActionBar((Dialog)this.mHost);
        }
        if (this.mActionBar != null) {
            this.mActionBar.setDefaultDisplayHomeAsUpEnabled(this.mEnableDefaultActionBarUp);
        }
    }

    @Override
    public void setSupportActionBar(Toolbar toolbar) {
        if (!(this.mHost instanceof Activity)) {
            return;
        }
        ActionBar ab = this.getSupportActionBar();
        if (ab instanceof WindowDecorActionBar) {
            throw new IllegalStateException("This Activity already has an action bar supplied by the window decor. Do not request Window.FEATURE_SUPPORT_ACTION_BAR and set windowActionBar to false in your theme to use a Toolbar instead.");
        }
        this.mMenuInflater = null;
        if (ab != null) {
            ab.onDestroy();
        }
        this.mActionBar = null;
        if (toolbar != null) {
            ToolbarActionBar tbab = new ToolbarActionBar(toolbar, this.getTitle(), this.mAppCompatWindowCallback);
            this.mActionBar = tbab;
            this.mAppCompatWindowCallback.setActionBarCallback(tbab.mMenuCallback);
            toolbar.setBackInvokedCallbackEnabled(true);
        } else {
            this.mAppCompatWindowCallback.setActionBarCallback(null);
        }
        this.invalidateOptionsMenu();
    }

    final Context getActionBarThemedContext() {
        Context context = null;
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            context = ab.getThemedContext();
        }
        if (context == null) {
            context = this.mContext;
        }
        return context;
    }

    @Override
    public MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.initWindowDecorActionBar();
            this.mMenuInflater = new SupportMenuInflater(this.mActionBar != null ? this.mActionBar.getThemedContext() : this.mContext);
        }
        return this.mMenuInflater;
    }

    @Override
    @Nullable
    public <T extends View> T findViewById(@IdRes int id2) {
        this.ensureSubDecor();
        return (T)this.mWindow.findViewById(id2);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        ActionBar ab;
        if (this.mHasActionBar && this.mSubDecorInstalled && (ab = this.getSupportActionBar()) != null) {
            ab.onConfigurationChanged(newConfig);
        }
        AppCompatDrawableManager.get().onConfigurationChanged(this.mContext);
        this.mEffectiveConfiguration = new Configuration(this.mContext.getResources().getConfiguration());
        this.applyApplicationSpecificConfig(false, false);
    }

    @Override
    public void onStart() {
        this.applyApplicationSpecificConfig(true, false);
    }

    @Override
    public void onStop() {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setShowHideAnimationEnabled(false);
        }
    }

    @Override
    public void onPostResume() {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setShowHideAnimationEnabled(true);
        }
    }

    @Override
    public void setContentView(View v) {
        this.ensureSubDecor();
        ViewGroup contentParent = (ViewGroup)this.mSubDecor.findViewById(0x1020002);
        contentParent.removeAllViews();
        contentParent.addView(v);
        this.mAppCompatWindowCallback.bypassOnContentChanged(this.mWindow.getCallback());
    }

    @Override
    public void setContentView(int resId) {
        this.ensureSubDecor();
        ViewGroup contentParent = (ViewGroup)this.mSubDecor.findViewById(0x1020002);
        contentParent.removeAllViews();
        LayoutInflater.from((Context)this.mContext).inflate(resId, contentParent);
        this.mAppCompatWindowCallback.bypassOnContentChanged(this.mWindow.getCallback());
    }

    @Override
    public void setContentView(View v, ViewGroup.LayoutParams lp) {
        this.ensureSubDecor();
        ViewGroup contentParent = (ViewGroup)this.mSubDecor.findViewById(0x1020002);
        contentParent.removeAllViews();
        contentParent.addView(v, lp);
        this.mAppCompatWindowCallback.bypassOnContentChanged(this.mWindow.getCallback());
    }

    @Override
    public void addContentView(View v, ViewGroup.LayoutParams lp) {
        this.ensureSubDecor();
        ViewGroup contentParent = (ViewGroup)this.mSubDecor.findViewById(0x1020002);
        contentParent.addView(v, lp);
        this.mAppCompatWindowCallback.bypassOnContentChanged(this.mWindow.getCallback());
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    }

    @Override
    public void onDestroy() {
        if (this.mHost instanceof Activity) {
            AppCompatDelegateImpl.removeActivityDelegate(this);
        }
        if (this.mInvalidatePanelMenuPosted) {
            this.mWindow.getDecorView().removeCallbacks(this.mInvalidatePanelMenuRunnable);
        }
        this.mDestroyed = true;
        if (this.mLocalNightMode != -100 && this.mHost instanceof Activity && ((Activity)this.mHost).isChangingConfigurations()) {
            sLocalNightModes.put((Object)this.mHost.getClass().getName(), (Object)this.mLocalNightMode);
        } else {
            sLocalNightModes.remove((Object)this.mHost.getClass().getName());
        }
        if (this.mActionBar != null) {
            this.mActionBar.onDestroy();
        }
        this.cleanupAutoManagers();
    }

    private void cleanupAutoManagers() {
        if (this.mAutoTimeNightModeManager != null) {
            this.mAutoTimeNightModeManager.cleanup();
        }
        if (this.mAutoBatteryNightModeManager != null) {
            this.mAutoBatteryNightModeManager.cleanup();
        }
    }

    @Override
    public void setTheme(@StyleRes int themeResId) {
        this.mThemeResId = themeResId;
    }

    private void ensureWindow() {
        if (this.mWindow == null && this.mHost instanceof Activity) {
            this.attachToWindow(((Activity)this.mHost).getWindow());
        }
        if (this.mWindow == null) {
            throw new IllegalStateException("We have not been given a Window");
        }
    }

    private void attachToWindow(@NonNull Window window) {
        if (this.mWindow != null) {
            throw new IllegalStateException("AppCompat has already installed itself into the Window");
        }
        Window.Callback callback = window.getCallback();
        if (callback instanceof AppCompatWindowCallback) {
            throw new IllegalStateException("AppCompat has already installed itself into the Window");
        }
        this.mAppCompatWindowCallback = new AppCompatWindowCallback(callback);
        window.setCallback((Window.Callback)this.mAppCompatWindowCallback);
        TintTypedArray a = TintTypedArray.obtainStyledAttributes(this.mContext, null, sWindowBackgroundStyleable);
        Drawable winBg = a.getDrawableIfKnown(0);
        if (winBg != null) {
            window.setBackgroundDrawable(winBg);
        }
        a.recycle();
        this.mWindow = window;
        if (Build.VERSION.SDK_INT >= 33 && this.mDispatcher == null) {
            this.setOnBackInvokedDispatcher(null);
        }
    }

    private void ensureSubDecor() {
        if (!this.mSubDecorInstalled) {
            this.mSubDecor = this.createSubDecor();
            CharSequence title = this.getTitle();
            if (!TextUtils.isEmpty((CharSequence)title)) {
                if (this.mDecorContentParent != null) {
                    this.mDecorContentParent.setWindowTitle(title);
                } else if (this.peekSupportActionBar() != null) {
                    this.peekSupportActionBar().setWindowTitle(title);
                } else if (this.mTitleView != null) {
                    this.mTitleView.setText(title);
                }
            }
            this.applyFixedSizeWindow();
            this.onSubDecorInstalled(this.mSubDecor);
            this.mSubDecorInstalled = true;
            PanelFeatureState st = this.getPanelState(0, false);
            if (!(this.mDestroyed || st != null && st.menu != null)) {
                this.invalidatePanelMenu(108);
            }
        }
    }

    private ViewGroup createSubDecor() {
        TypedArray a = this.mContext.obtainStyledAttributes(R.styleable.AppCompatTheme);
        if (!a.hasValue(R.styleable.AppCompatTheme_windowActionBar)) {
            a.recycle();
            throw new IllegalStateException("You need to use a Theme.AppCompat theme (or descendant) with this activity.");
        }
        if (a.getBoolean(R.styleable.AppCompatTheme_windowNoTitle, false)) {
            this.requestWindowFeature(1);
        } else if (a.getBoolean(R.styleable.AppCompatTheme_windowActionBar, false)) {
            this.requestWindowFeature(108);
        }
        if (a.getBoolean(R.styleable.AppCompatTheme_windowActionBarOverlay, false)) {
            this.requestWindowFeature(109);
        }
        if (a.getBoolean(R.styleable.AppCompatTheme_windowActionModeOverlay, false)) {
            this.requestWindowFeature(10);
        }
        this.mIsFloating = a.getBoolean(R.styleable.AppCompatTheme_android_windowIsFloating, false);
        a.recycle();
        this.ensureWindow();
        this.mWindow.getDecorView();
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        ViewGroup subDecor = null;
        if (!this.mWindowNoTitle) {
            if (this.mIsFloating) {
                subDecor = (ViewGroup)inflater.inflate(R.layout.abc_dialog_title_material, null);
                this.mOverlayActionBar = false;
                this.mHasActionBar = false;
            } else if (this.mHasActionBar) {
                TypedValue outValue = new TypedValue();
                this.mContext.getTheme().resolveAttribute(R.attr.actionBarTheme, outValue, true);
                Object themedContext = outValue.resourceId != 0 ? new ContextThemeWrapper(this.mContext, outValue.resourceId) : this.mContext;
                subDecor = (ViewGroup)LayoutInflater.from((Context)themedContext).inflate(R.layout.abc_screen_toolbar, null);
                this.mDecorContentParent = (DecorContentParent)subDecor.findViewById(R.id.decor_content_parent);
                this.mDecorContentParent.setWindowCallback(this.getWindowCallback());
                if (this.mOverlayActionBar) {
                    this.mDecorContentParent.initFeature(109);
                }
                if (this.mFeatureProgress) {
                    this.mDecorContentParent.initFeature(2);
                }
                if (this.mFeatureIndeterminateProgress) {
                    this.mDecorContentParent.initFeature(5);
                }
            }
        } else {
            subDecor = this.mOverlayActionMode ? (ViewGroup)inflater.inflate(R.layout.abc_screen_simple_overlay_action_mode, null) : (ViewGroup)inflater.inflate(R.layout.abc_screen_simple, null);
        }
        if (subDecor == null) {
            throw new IllegalArgumentException("AppCompat does not support the current theme features: { windowActionBar: " + this.mHasActionBar + ", windowActionBarOverlay: " + this.mOverlayActionBar + ", android:windowIsFloating: " + this.mIsFloating + ", windowActionModeOverlay: " + this.mOverlayActionMode + ", windowNoTitle: " + this.mWindowNoTitle + " }");
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ViewCompat.setOnApplyWindowInsetsListener((View)subDecor, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

                public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                    int newTop;
                    int top = insets.getSystemWindowInsetTop();
                    if (top != (newTop = AppCompatDelegateImpl.this.updateStatusGuard(insets, null))) {
                        insets = insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), newTop, insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
                    }
                    return ViewCompat.onApplyWindowInsets((View)v, (WindowInsetsCompat)insets);
                }
            });
        } else if (subDecor instanceof FitWindowsViewGroup) {
            ((FitWindowsViewGroup)subDecor).setOnFitSystemWindowsListener(new FitWindowsViewGroup.OnFitSystemWindowsListener(){

                @Override
                public void onFitSystemWindows(Rect insets) {
                    insets.top = AppCompatDelegateImpl.this.updateStatusGuard(null, insets);
                }
            });
        }
        if (this.mDecorContentParent == null) {
            this.mTitleView = (TextView)subDecor.findViewById(R.id.title);
        }
        ViewUtils.makeOptionalFitsSystemWindows((View)subDecor);
        ContentFrameLayout contentView = (ContentFrameLayout)subDecor.findViewById(R.id.action_bar_activity_content);
        ViewGroup windowContentView = (ViewGroup)this.mWindow.findViewById(0x1020002);
        if (windowContentView != null) {
            while (windowContentView.getChildCount() > 0) {
                View child = windowContentView.getChildAt(0);
                windowContentView.removeViewAt(0);
                contentView.addView(child);
            }
            windowContentView.setId(-1);
            contentView.setId(0x1020002);
            if (windowContentView instanceof FrameLayout) {
                ((FrameLayout)windowContentView).setForeground(null);
            }
        }
        this.mWindow.setContentView((View)subDecor);
        contentView.setAttachListener(new ContentFrameLayout.OnAttachListener(){

            @Override
            public void onAttachedFromWindow() {
            }

            @Override
            public void onDetachedFromWindow() {
                AppCompatDelegateImpl.this.dismissPopups();
            }
        });
        return subDecor;
    }

    void onSubDecorInstalled(ViewGroup subDecor) {
    }

    private void applyFixedSizeWindow() {
        ContentFrameLayout cfl = (ContentFrameLayout)this.mSubDecor.findViewById(0x1020002);
        View windowDecor = this.mWindow.getDecorView();
        cfl.setDecorPadding(windowDecor.getPaddingLeft(), windowDecor.getPaddingTop(), windowDecor.getPaddingRight(), windowDecor.getPaddingBottom());
        TypedArray a = this.mContext.obtainStyledAttributes(R.styleable.AppCompatTheme);
        a.getValue(R.styleable.AppCompatTheme_windowMinWidthMajor, cfl.getMinWidthMajor());
        a.getValue(R.styleable.AppCompatTheme_windowMinWidthMinor, cfl.getMinWidthMinor());
        if (a.hasValue(R.styleable.AppCompatTheme_windowFixedWidthMajor)) {
            a.getValue(R.styleable.AppCompatTheme_windowFixedWidthMajor, cfl.getFixedWidthMajor());
        }
        if (a.hasValue(R.styleable.AppCompatTheme_windowFixedWidthMinor)) {
            a.getValue(R.styleable.AppCompatTheme_windowFixedWidthMinor, cfl.getFixedWidthMinor());
        }
        if (a.hasValue(R.styleable.AppCompatTheme_windowFixedHeightMajor)) {
            a.getValue(R.styleable.AppCompatTheme_windowFixedHeightMajor, cfl.getFixedHeightMajor());
        }
        if (a.hasValue(R.styleable.AppCompatTheme_windowFixedHeightMinor)) {
            a.getValue(R.styleable.AppCompatTheme_windowFixedHeightMinor, cfl.getFixedHeightMinor());
        }
        a.recycle();
        cfl.requestLayout();
    }

    @Override
    public boolean requestWindowFeature(int featureId) {
        featureId = this.sanitizeWindowFeatureId(featureId);
        if (this.mWindowNoTitle && featureId == 108) {
            return false;
        }
        if (this.mHasActionBar && featureId == 1) {
            this.mHasActionBar = false;
        }
        switch (featureId) {
            case 108: {
                this.throwFeatureRequestIfSubDecorInstalled();
                this.mHasActionBar = true;
                return true;
            }
            case 109: {
                this.throwFeatureRequestIfSubDecorInstalled();
                this.mOverlayActionBar = true;
                return true;
            }
            case 10: {
                this.throwFeatureRequestIfSubDecorInstalled();
                this.mOverlayActionMode = true;
                return true;
            }
            case 2: {
                this.throwFeatureRequestIfSubDecorInstalled();
                this.mFeatureProgress = true;
                return true;
            }
            case 5: {
                this.throwFeatureRequestIfSubDecorInstalled();
                this.mFeatureIndeterminateProgress = true;
                return true;
            }
            case 1: {
                this.throwFeatureRequestIfSubDecorInstalled();
                this.mWindowNoTitle = true;
                return true;
            }
        }
        return this.mWindow.requestFeature(featureId);
    }

    @Override
    public boolean hasWindowFeature(int featureId) {
        boolean result = false;
        switch (this.sanitizeWindowFeatureId(featureId)) {
            case 108: {
                result = this.mHasActionBar;
                break;
            }
            case 109: {
                result = this.mOverlayActionBar;
                break;
            }
            case 10: {
                result = this.mOverlayActionMode;
                break;
            }
            case 2: {
                result = this.mFeatureProgress;
                break;
            }
            case 5: {
                result = this.mFeatureIndeterminateProgress;
                break;
            }
            case 1: {
                result = this.mWindowNoTitle;
            }
        }
        return result || this.mWindow.hasFeature(featureId);
    }

    @Override
    public final void setTitle(CharSequence title) {
        this.mTitle = title;
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setWindowTitle(title);
        } else if (this.peekSupportActionBar() != null) {
            this.peekSupportActionBar().setWindowTitle(title);
        } else if (this.mTitleView != null) {
            this.mTitleView.setText(title);
        }
    }

    final CharSequence getTitle() {
        if (this.mHost instanceof Activity) {
            return ((Activity)this.mHost).getTitle();
        }
        return this.mTitle;
    }

    void onPanelClosed(int featureId) {
        if (featureId == 108) {
            ActionBar ab = this.getSupportActionBar();
            if (ab != null) {
                ab.dispatchMenuVisibilityChanged(false);
            }
        } else if (featureId == 0) {
            PanelFeatureState st = this.getPanelState(featureId, true);
            if (st.isOpen) {
                this.closePanel(st, false);
            }
        }
    }

    void onMenuOpened(int featureId) {
        ActionBar ab;
        if (featureId == 108 && (ab = this.getSupportActionBar()) != null) {
            ab.dispatchMenuVisibilityChanged(true);
        }
    }

    @Override
    public boolean onMenuItemSelected(@NonNull MenuBuilder menu, @NonNull MenuItem item) {
        PanelFeatureState panel;
        Window.Callback cb = this.getWindowCallback();
        if (cb != null && !this.mDestroyed && (panel = this.findMenuPanel((Menu)menu.getRootMenu())) != null) {
            return cb.onMenuItemSelected(panel.featureId, item);
        }
        return false;
    }

    @Override
    public void onMenuModeChange(@NonNull MenuBuilder menu) {
        this.reopenMenu(true);
    }

    @Override
    public ActionMode startSupportActionMode(@NonNull ActionMode.Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("ActionMode callback can not be null.");
        }
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        ActionModeCallbackWrapperV9 wrappedCallback = new ActionModeCallbackWrapperV9(callback);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            this.mActionMode = ab.startActionMode(wrappedCallback);
            if (this.mActionMode != null && this.mAppCompatCallback != null) {
                this.mAppCompatCallback.onSupportActionModeStarted(this.mActionMode);
            }
        }
        if (this.mActionMode == null) {
            this.mActionMode = this.startSupportActionModeFromWindow(wrappedCallback);
        }
        this.updateBackInvokedCallbackState();
        return this.mActionMode;
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.peekSupportActionBar() == null || this.getSupportActionBar().invalidateOptionsMenu()) {
            return;
        }
        this.invalidatePanelMenu(0);
    }

    ActionMode startSupportActionModeFromWindow(@NonNull ActionMode.Callback callback) {
        this.endOnGoingFadeAnimation();
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        if (!(callback instanceof ActionModeCallbackWrapperV9)) {
            callback = new ActionModeCallbackWrapperV9(callback);
        }
        ActionMode mode = null;
        if (this.mAppCompatCallback != null && !this.mDestroyed) {
            try {
                mode = this.mAppCompatCallback.onWindowStartingSupportActionMode(callback);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        if (mode != null) {
            this.mActionMode = mode;
        } else {
            if (this.mActionModeView == null) {
                if (this.mIsFloating) {
                    Object actionBarContext;
                    TypedValue outValue = new TypedValue();
                    Resources.Theme baseTheme = this.mContext.getTheme();
                    baseTheme.resolveAttribute(R.attr.actionBarTheme, outValue, true);
                    if (outValue.resourceId != 0) {
                        Resources.Theme actionBarTheme = this.mContext.getResources().newTheme();
                        actionBarTheme.setTo(baseTheme);
                        actionBarTheme.applyStyle(outValue.resourceId, true);
                        actionBarContext = new ContextThemeWrapper(this.mContext, 0);
                        actionBarContext.getTheme().setTo(actionBarTheme);
                    } else {
                        actionBarContext = this.mContext;
                    }
                    this.mActionModeView = new ActionBarContextView((Context)actionBarContext);
                    this.mActionModePopup = new PopupWindow(actionBarContext, null, R.attr.actionModePopupWindowStyle);
                    PopupWindowCompat.setWindowLayoutType((PopupWindow)this.mActionModePopup, (int)2);
                    this.mActionModePopup.setContentView((View)this.mActionModeView);
                    this.mActionModePopup.setWidth(-1);
                    actionBarContext.getTheme().resolveAttribute(R.attr.actionBarSize, outValue, true);
                    int height = TypedValue.complexToDimensionPixelSize((int)outValue.data, (DisplayMetrics)actionBarContext.getResources().getDisplayMetrics());
                    this.mActionModeView.setContentHeight(height);
                    this.mActionModePopup.setHeight(-2);
                    this.mShowActionModePopup = new Runnable(){

                        @Override
                        public void run() {
                            AppCompatDelegateImpl.this.mActionModePopup.showAtLocation((View)AppCompatDelegateImpl.this.mActionModeView, 55, 0, 0);
                            AppCompatDelegateImpl.this.endOnGoingFadeAnimation();
                            if (AppCompatDelegateImpl.this.shouldAnimateActionModeView()) {
                                AppCompatDelegateImpl.this.mActionModeView.setAlpha(0.0f);
                                AppCompatDelegateImpl.this.mFadeAnim = ViewCompat.animate((View)AppCompatDelegateImpl.this.mActionModeView).alpha(1.0f);
                                AppCompatDelegateImpl.this.mFadeAnim.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                                    public void onAnimationStart(View view) {
                                        AppCompatDelegateImpl.this.mActionModeView.setVisibility(0);
                                    }

                                    public void onAnimationEnd(View view) {
                                        AppCompatDelegateImpl.this.mActionModeView.setAlpha(1.0f);
                                        AppCompatDelegateImpl.this.mFadeAnim.setListener(null);
                                        AppCompatDelegateImpl.this.mFadeAnim = null;
                                    }
                                });
                            } else {
                                AppCompatDelegateImpl.this.mActionModeView.setAlpha(1.0f);
                                AppCompatDelegateImpl.this.mActionModeView.setVisibility(0);
                            }
                        }
                    };
                } else {
                    ViewStubCompat stub = (ViewStubCompat)this.mSubDecor.findViewById(R.id.action_mode_bar_stub);
                    if (stub != null) {
                        stub.setLayoutInflater(LayoutInflater.from((Context)this.getActionBarThemedContext()));
                        this.mActionModeView = (ActionBarContextView)stub.inflate();
                    }
                }
            }
            if (this.mActionModeView != null) {
                this.endOnGoingFadeAnimation();
                this.mActionModeView.killMode();
                mode = new StandaloneActionMode(this.mActionModeView.getContext(), this.mActionModeView, callback, this.mActionModePopup == null);
                if (callback.onCreateActionMode(mode, mode.getMenu())) {
                    mode.invalidate();
                    this.mActionModeView.initForMode(mode);
                    this.mActionMode = mode;
                    if (this.shouldAnimateActionModeView()) {
                        this.mActionModeView.setAlpha(0.0f);
                        this.mFadeAnim = ViewCompat.animate((View)this.mActionModeView).alpha(1.0f);
                        this.mFadeAnim.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                            public void onAnimationStart(View view) {
                                AppCompatDelegateImpl.this.mActionModeView.setVisibility(0);
                                if (AppCompatDelegateImpl.this.mActionModeView.getParent() instanceof View) {
                                    ViewCompat.requestApplyInsets((View)((View)AppCompatDelegateImpl.this.mActionModeView.getParent()));
                                }
                            }

                            public void onAnimationEnd(View view) {
                                AppCompatDelegateImpl.this.mActionModeView.setAlpha(1.0f);
                                AppCompatDelegateImpl.this.mFadeAnim.setListener(null);
                                AppCompatDelegateImpl.this.mFadeAnim = null;
                            }
                        });
                    } else {
                        this.mActionModeView.setAlpha(1.0f);
                        this.mActionModeView.setVisibility(0);
                        if (this.mActionModeView.getParent() instanceof View) {
                            ViewCompat.requestApplyInsets((View)((View)this.mActionModeView.getParent()));
                        }
                    }
                    if (this.mActionModePopup != null) {
                        this.mWindow.getDecorView().post(this.mShowActionModePopup);
                    }
                } else {
                    this.mActionMode = null;
                }
            }
        }
        if (this.mActionMode != null && this.mAppCompatCallback != null) {
            this.mAppCompatCallback.onSupportActionModeStarted(this.mActionMode);
        }
        this.updateBackInvokedCallbackState();
        return this.mActionMode;
    }

    final boolean shouldAnimateActionModeView() {
        return this.mSubDecorInstalled && this.mSubDecor != null && this.mSubDecor.isLaidOut();
    }

    @Override
    public void setHandleNativeActionModesEnabled(boolean enabled) {
        this.mHandleNativeActionModes = enabled;
    }

    @Override
    public boolean isHandleNativeActionModesEnabled() {
        return this.mHandleNativeActionModes;
    }

    void endOnGoingFadeAnimation() {
        if (this.mFadeAnim != null) {
            this.mFadeAnim.cancel();
        }
    }

    boolean shouldRegisterBackInvokedCallback() {
        if (this.mDispatcher == null) {
            return false;
        }
        PanelFeatureState st = this.getPanelState(0, false);
        if (st != null && st.isOpen) {
            return true;
        }
        return this.mActionMode != null;
    }

    boolean onBackPressed() {
        boolean wasLongPressBackDown = this.mLongPressBackDown;
        this.mLongPressBackDown = false;
        PanelFeatureState st = this.getPanelState(0, false);
        if (st != null && st.isOpen) {
            if (!wasLongPressBackDown) {
                this.closePanel(st, true);
            }
            return true;
        }
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            return true;
        }
        ActionBar ab = this.getSupportActionBar();
        return ab != null && ab.collapseActionView();
    }

    boolean onKeyShortcut(int keyCode, KeyEvent ev) {
        boolean handled;
        ActionBar ab = this.getSupportActionBar();
        if (ab != null && ab.onKeyShortcut(keyCode, ev)) {
            return true;
        }
        if (this.mPreparedPanel != null && (handled = this.performPanelShortcut(this.mPreparedPanel, ev.getKeyCode(), ev, 1))) {
            if (this.mPreparedPanel != null) {
                this.mPreparedPanel.isHandled = true;
            }
            return true;
        }
        if (this.mPreparedPanel == null) {
            PanelFeatureState st = this.getPanelState(0, true);
            this.preparePanel(st, ev);
            handled = this.performPanelShortcut(st, ev.getKeyCode(), ev, 1);
            st.isPrepared = false;
            if (handled) {
                return true;
            }
        }
        return false;
    }

    boolean dispatchKeyEvent(KeyEvent event) {
        View root;
        if ((this.mHost instanceof KeyEventDispatcher.Component || this.mHost instanceof AppCompatDialog) && (root = this.mWindow.getDecorView()) != null && KeyEventDispatcher.dispatchBeforeHierarchy((View)root, (KeyEvent)event)) {
            return true;
        }
        if (event.getKeyCode() == 82 && this.mAppCompatWindowCallback.bypassDispatchKeyEvent(this.mWindow.getCallback(), event)) {
            return true;
        }
        int keyCode = event.getKeyCode();
        int action = event.getAction();
        boolean isDown = action == 0;
        return isDown ? this.onKeyDown(keyCode, event) : this.onKeyUp(keyCode, event);
    }

    boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 82: {
                this.onKeyUpPanel(0, event);
                return true;
            }
            case 4: {
                if (!this.onBackPressed()) break;
                return true;
            }
        }
        return false;
    }

    boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 82: {
                this.onKeyDownPanel(0, event);
                return true;
            }
            case 4: {
                this.mLongPressBackDown = (event.getFlags() & 0x80) != 0;
            }
        }
        return false;
    }

    @Override
    public View createView(View parent, String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        if (this.mAppCompatViewInflater == null) {
            TypedArray a = this.mContext.obtainStyledAttributes(R.styleable.AppCompatTheme);
            String viewInflaterClassName = a.getString(R.styleable.AppCompatTheme_viewInflaterClass);
            a.recycle();
            if (viewInflaterClassName == null) {
                this.mAppCompatViewInflater = new AppCompatViewInflater();
            } else {
                try {
                    Class<?> viewInflaterClass = this.mContext.getClassLoader().loadClass(viewInflaterClassName);
                    this.mAppCompatViewInflater = (AppCompatViewInflater)viewInflaterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    Log.i((String)"AppCompatDelegate", (String)("Failed to instantiate custom view inflater " + viewInflaterClassName + ". Falling back to default."), (Throwable)t);
                    this.mAppCompatViewInflater = new AppCompatViewInflater();
                }
            }
        }
        boolean inheritContext = false;
        if (IS_PRE_LOLLIPOP) {
            if (this.mLayoutIncludeDetector == null) {
                this.mLayoutIncludeDetector = new LayoutIncludeDetector();
            }
            inheritContext = this.mLayoutIncludeDetector.detect(attrs) ? true : (attrs instanceof XmlPullParser ? ((XmlPullParser)attrs).getDepth() > 1 : this.shouldInheritContext((ViewParent)parent));
        }
        return this.mAppCompatViewInflater.createView(parent, name, context, attrs, inheritContext, IS_PRE_LOLLIPOP, true, VectorEnabledTintResources.shouldBeUsed());
    }

    private boolean shouldInheritContext(ViewParent parent) {
        if (parent == null) {
            return false;
        }
        View windowDecor = this.mWindow.getDecorView();
        while (parent != null) {
            if (parent == windowDecor || !(parent instanceof View) || ((View)parent).isAttachedToWindow()) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    @Override
    public void installViewFactory() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        if (layoutInflater.getFactory() == null) {
            LayoutInflaterCompat.setFactory2((LayoutInflater)layoutInflater, (LayoutInflater.Factory2)this);
        } else if (!(layoutInflater.getFactory2() instanceof AppCompatDelegateImpl)) {
            Log.i((String)"AppCompatDelegate", (String)"The Activity's LayoutInflater already has a Factory installed so we can not install AppCompat's");
        }
    }

    public final View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        return this.createView(parent, name, context, attrs);
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return this.onCreateView(null, name, context, attrs);
    }

    @Nullable
    private AppCompatActivity tryUnwrapContext() {
        Context context = this.mContext;
        while (context != null) {
            if (context instanceof AppCompatActivity) {
                return (AppCompatActivity)context;
            }
            if (context instanceof ContextWrapper) {
                context = ((ContextWrapper)context).getBaseContext();
                continue;
            }
            return null;
        }
        return null;
    }

    private void openPanel(PanelFeatureState st, KeyEvent event) {
        ViewGroup.LayoutParams lp;
        Window.Callback cb;
        if (st.isOpen || this.mDestroyed) {
            return;
        }
        if (st.featureId == 0) {
            boolean isXLarge;
            Configuration config = this.mContext.getResources().getConfiguration();
            boolean bl = isXLarge = (config.screenLayout & 0xF) == 4;
            if (isXLarge) {
                return;
            }
        }
        if ((cb = this.getWindowCallback()) != null && !cb.onMenuOpened(st.featureId, (Menu)st.menu)) {
            this.closePanel(st, true);
            return;
        }
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        if (wm == null) {
            return;
        }
        if (!this.preparePanel(st, event)) {
            return;
        }
        int width = -2;
        if (st.decorView == null || st.refreshDecorView) {
            if (st.decorView == null) {
                if (!this.initializePanelDecor(st) || st.decorView == null) {
                    return;
                }
            } else if (st.refreshDecorView && st.decorView.getChildCount() > 0) {
                st.decorView.removeAllViews();
            }
            if (!this.initializePanelContent(st) || !st.hasPanelItems()) {
                st.refreshDecorView = true;
                return;
            }
            lp = st.shownPanelView.getLayoutParams();
            if (lp == null) {
                lp = new ViewGroup.LayoutParams(-2, -2);
            }
            int backgroundResId = st.background;
            st.decorView.setBackgroundResource(backgroundResId);
            ViewParent shownPanelParent = st.shownPanelView.getParent();
            if (shownPanelParent instanceof ViewGroup) {
                ((ViewGroup)shownPanelParent).removeView(st.shownPanelView);
            }
            st.decorView.addView(st.shownPanelView, lp);
            if (!st.shownPanelView.hasFocus()) {
                st.shownPanelView.requestFocus();
            }
        } else if (st.createdPanelView != null && (lp = st.createdPanelView.getLayoutParams()) != null && lp.width == -1) {
            width = -1;
        }
        st.isHandled = false;
        lp = new WindowManager.LayoutParams(width, -2, st.x, st.y, 1002, 0x820000, -3);
        lp.gravity = st.gravity;
        lp.windowAnimations = st.windowAnimations;
        wm.addView((View)st.decorView, lp);
        st.isOpen = true;
        if (st.featureId == 0) {
            this.updateBackInvokedCallbackState();
        }
    }

    private boolean initializePanelDecor(PanelFeatureState st) {
        st.setStyle(this.getActionBarThemedContext());
        st.decorView = new ListMenuDecorView(st.listPresenterContext);
        st.gravity = 81;
        return true;
    }

    private void reopenMenu(boolean toggleMenuMode) {
        if (this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && (!ViewConfiguration.get((Context)this.mContext).hasPermanentMenuKey() || this.mDecorContentParent.isOverflowMenuShowPending())) {
            Window.Callback cb = this.getWindowCallback();
            if (!this.mDecorContentParent.isOverflowMenuShowing() || !toggleMenuMode) {
                if (cb != null && !this.mDestroyed) {
                    if (this.mInvalidatePanelMenuPosted && (this.mInvalidatePanelMenuFeatures & 1) != 0) {
                        this.mWindow.getDecorView().removeCallbacks(this.mInvalidatePanelMenuRunnable);
                        this.mInvalidatePanelMenuRunnable.run();
                    }
                    PanelFeatureState st = this.getPanelState(0, true);
                    if (st.menu != null && !st.refreshMenuContent && cb.onPreparePanel(0, st.createdPanelView, (Menu)st.menu)) {
                        cb.onMenuOpened(108, (Menu)st.menu);
                        this.mDecorContentParent.showOverflowMenu();
                    }
                }
            } else {
                this.mDecorContentParent.hideOverflowMenu();
                if (!this.mDestroyed) {
                    PanelFeatureState st = this.getPanelState(0, true);
                    cb.onPanelClosed(108, (Menu)st.menu);
                }
            }
            return;
        }
        PanelFeatureState st = this.getPanelState(0, true);
        st.refreshDecorView = true;
        this.closePanel(st, false);
        this.openPanel(st, null);
    }

    private boolean initializePanelMenu(PanelFeatureState st) {
        Object context = this.mContext;
        if ((st.featureId == 0 || st.featureId == 108) && this.mDecorContentParent != null) {
            TypedValue outValue = new TypedValue();
            Resources.Theme baseTheme = context.getTheme();
            baseTheme.resolveAttribute(R.attr.actionBarTheme, outValue, true);
            Resources.Theme widgetTheme = null;
            if (outValue.resourceId != 0) {
                widgetTheme = context.getResources().newTheme();
                widgetTheme.setTo(baseTheme);
                widgetTheme.applyStyle(outValue.resourceId, true);
                widgetTheme.resolveAttribute(R.attr.actionBarWidgetTheme, outValue, true);
            } else {
                baseTheme.resolveAttribute(R.attr.actionBarWidgetTheme, outValue, true);
            }
            if (outValue.resourceId != 0) {
                if (widgetTheme == null) {
                    widgetTheme = context.getResources().newTheme();
                    widgetTheme.setTo(baseTheme);
                }
                widgetTheme.applyStyle(outValue.resourceId, true);
            }
            if (widgetTheme != null) {
                context = new ContextThemeWrapper((Context)context, 0);
                context.getTheme().setTo(widgetTheme);
            }
        }
        MenuBuilder menu = new MenuBuilder((Context)context);
        menu.setCallback(this);
        st.setMenu(menu);
        return true;
    }

    private boolean initializePanelContent(PanelFeatureState st) {
        if (st.createdPanelView != null) {
            st.shownPanelView = st.createdPanelView;
            return true;
        }
        if (st.menu == null) {
            return false;
        }
        if (this.mPanelMenuPresenterCallback == null) {
            this.mPanelMenuPresenterCallback = new PanelMenuPresenterCallback();
        }
        MenuView menuView = st.getListMenuView(this.mPanelMenuPresenterCallback);
        st.shownPanelView = (View)menuView;
        return st.shownPanelView != null;
    }

    private boolean preparePanel(PanelFeatureState st, KeyEvent event) {
        boolean isActionBarMenu;
        Window.Callback cb;
        if (this.mDestroyed) {
            return false;
        }
        if (st.isPrepared) {
            return true;
        }
        if (this.mPreparedPanel != null && this.mPreparedPanel != st) {
            this.closePanel(this.mPreparedPanel, false);
        }
        if ((cb = this.getWindowCallback()) != null) {
            st.createdPanelView = cb.onCreatePanelView(st.featureId);
        }
        boolean bl = isActionBarMenu = st.featureId == 0 || st.featureId == 108;
        if (isActionBarMenu && this.mDecorContentParent != null) {
            this.mDecorContentParent.setMenuPrepared();
        }
        if (!(st.createdPanelView != null || isActionBarMenu && this.peekSupportActionBar() instanceof ToolbarActionBar)) {
            if (st.menu == null || st.refreshMenuContent) {
                if (!(st.menu != null || this.initializePanelMenu(st) && st.menu != null)) {
                    return false;
                }
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    if (this.mActionMenuPresenterCallback == null) {
                        this.mActionMenuPresenterCallback = new ActionMenuPresenterCallback();
                    }
                    this.mDecorContentParent.setMenu((Menu)st.menu, this.mActionMenuPresenterCallback);
                }
                st.menu.stopDispatchingItemsChanged();
                if (!cb.onCreatePanelMenu(st.featureId, (Menu)st.menu)) {
                    st.setMenu(null);
                    if (isActionBarMenu && this.mDecorContentParent != null) {
                        this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                    }
                    return false;
                }
                st.refreshMenuContent = false;
            }
            st.menu.stopDispatchingItemsChanged();
            if (st.frozenActionViewState != null) {
                st.menu.restoreActionViewStates(st.frozenActionViewState);
                st.frozenActionViewState = null;
            }
            if (!cb.onPreparePanel(0, st.createdPanelView, (Menu)st.menu)) {
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                }
                st.menu.startDispatchingItemsChanged();
                return false;
            }
            KeyCharacterMap kmap = KeyCharacterMap.load((int)(event != null ? event.getDeviceId() : -1));
            st.qwertyMode = kmap.getKeyboardType() != 1;
            st.menu.setQwertyMode(st.qwertyMode);
            st.menu.startDispatchingItemsChanged();
        }
        st.isPrepared = true;
        st.isHandled = false;
        this.mPreparedPanel = st;
        return true;
    }

    void checkCloseActionMenu(@NonNull MenuBuilder menu) {
        if (this.mClosingActionMenu) {
            return;
        }
        this.mClosingActionMenu = true;
        this.mDecorContentParent.dismissPopups();
        Window.Callback cb = this.getWindowCallback();
        if (cb != null && !this.mDestroyed) {
            cb.onPanelClosed(108, (Menu)menu);
        }
        this.mClosingActionMenu = false;
    }

    void closePanel(int featureId) {
        this.closePanel(this.getPanelState(featureId, true), true);
    }

    void closePanel(PanelFeatureState st, boolean doCallback) {
        if (doCallback && st.featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.isOverflowMenuShowing()) {
            this.checkCloseActionMenu(st.menu);
            return;
        }
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        if (wm != null && st.isOpen && st.decorView != null) {
            wm.removeView((View)st.decorView);
            if (doCallback) {
                this.callOnPanelClosed(st.featureId, st, null);
            }
        }
        st.isPrepared = false;
        st.isHandled = false;
        st.isOpen = false;
        st.shownPanelView = null;
        st.refreshDecorView = true;
        if (this.mPreparedPanel == st) {
            this.mPreparedPanel = null;
        }
        if (st.featureId == 0) {
            this.updateBackInvokedCallbackState();
        }
    }

    private boolean onKeyDownPanel(int featureId, KeyEvent event) {
        if (event.getRepeatCount() == 0) {
            PanelFeatureState st = this.getPanelState(featureId, true);
            if (!st.isOpen) {
                return this.preparePanel(st, event);
            }
        }
        return false;
    }

    private boolean onKeyUpPanel(int featureId, KeyEvent event) {
        if (this.mActionMode != null) {
            return false;
        }
        boolean handled = false;
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get((Context)this.mContext).hasPermanentMenuKey()) {
            if (!this.mDecorContentParent.isOverflowMenuShowing()) {
                if (!this.mDestroyed && this.preparePanel(st, event)) {
                    handled = this.mDecorContentParent.showOverflowMenu();
                }
            } else {
                handled = this.mDecorContentParent.hideOverflowMenu();
            }
        } else if (st.isOpen || st.isHandled) {
            handled = st.isOpen;
            this.closePanel(st, true);
        } else if (st.isPrepared) {
            boolean show = true;
            if (st.refreshMenuContent) {
                st.isPrepared = false;
                show = this.preparePanel(st, event);
            }
            if (show) {
                this.openPanel(st, event);
                handled = true;
            }
        }
        if (handled) {
            AudioManager audioManager = (AudioManager)this.mContext.getApplicationContext().getSystemService("audio");
            if (audioManager != null) {
                audioManager.playSoundEffect(0);
            } else {
                Log.w((String)"AppCompatDelegate", (String)"Couldn't get audio manager");
            }
        }
        return handled;
    }

    void callOnPanelClosed(int featureId, PanelFeatureState panel, Menu menu) {
        if (menu == null) {
            if (panel == null && featureId >= 0 && featureId < this.mPanels.length) {
                panel = this.mPanels[featureId];
            }
            if (panel != null) {
                menu = panel.menu;
            }
        }
        if (panel != null && !panel.isOpen) {
            return;
        }
        if (!this.mDestroyed) {
            this.mAppCompatWindowCallback.bypassOnPanelClosed(this.mWindow.getCallback(), featureId, (Menu)menu);
        }
    }

    PanelFeatureState findMenuPanel(Menu menu) {
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null || panel.menu != menu) continue;
            return panel;
        }
        return null;
    }

    protected PanelFeatureState getPanelState(int featureId, boolean required) {
        PanelFeatureState st;
        PanelFeatureState[] ar = this.mPanels;
        if (this.mPanels == null || ar.length <= featureId) {
            PanelFeatureState[] nar = new PanelFeatureState[featureId + 1];
            if (ar != null) {
                System.arraycopy(ar, 0, nar, 0, ar.length);
            }
            ar = nar;
            this.mPanels = nar;
        }
        if ((st = ar[featureId]) == null) {
            ar[featureId] = st = new PanelFeatureState(featureId);
        }
        return st;
    }

    private boolean performPanelShortcut(PanelFeatureState st, int keyCode, KeyEvent event, int flags) {
        if (event.isSystem()) {
            return false;
        }
        boolean handled = false;
        if ((st.isPrepared || this.preparePanel(st, event)) && st.menu != null) {
            handled = st.menu.performShortcut(keyCode, event, flags);
        }
        if (handled && (flags & 1) == 0 && this.mDecorContentParent == null) {
            this.closePanel(st, true);
        }
        return handled;
    }

    private void invalidatePanelMenu(int featureId) {
        this.mInvalidatePanelMenuFeatures |= 1 << featureId;
        if (!this.mInvalidatePanelMenuPosted) {
            ViewCompat.postOnAnimation((View)this.mWindow.getDecorView(), (Runnable)this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuPosted = true;
        }
    }

    void doInvalidatePanelMenu(int featureId) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        Bundle savedActionViewStates = null;
        if (st.menu != null) {
            savedActionViewStates = new Bundle();
            st.menu.saveActionViewStates(savedActionViewStates);
            if (savedActionViewStates.size() > 0) {
                st.frozenActionViewState = savedActionViewStates;
            }
            st.menu.stopDispatchingItemsChanged();
            st.menu.clear();
        }
        st.refreshMenuContent = true;
        st.refreshDecorView = true;
        if ((featureId == 108 || featureId == 0) && this.mDecorContentParent != null && (st = this.getPanelState(0, false)) != null) {
            st.isPrepared = false;
            this.preparePanel(st, null);
        }
    }

    final int updateStatusGuard(@Nullable WindowInsetsCompat insets, @Nullable Rect rectInsets) {
        int systemWindowInsetTop = 0;
        if (insets != null) {
            systemWindowInsetTop = insets.getSystemWindowInsetTop();
        } else if (rectInsets != null) {
            systemWindowInsetTop = rectInsets.top;
        }
        boolean showStatusGuard = false;
        if (this.mActionModeView != null && this.mActionModeView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.mActionModeView.getLayoutParams();
            boolean mlpChanged = false;
            if (this.mActionModeView.isShown()) {
                int newGuardRightMargin;
                if (this.mTempRect1 == null) {
                    this.mTempRect1 = new Rect();
                    this.mTempRect2 = new Rect();
                }
                Rect innerInsets = this.mTempRect1;
                Rect rect = this.mTempRect2;
                if (insets == null) {
                    innerInsets.set(rectInsets);
                } else {
                    innerInsets.set(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
                }
                ViewUtils.computeFitSystemWindows((View)this.mSubDecor, innerInsets, rect);
                int newTopMargin = innerInsets.top;
                int newLeftMargin = innerInsets.left;
                int newRightMargin = innerInsets.right;
                WindowInsetsCompat rootInsets = ViewCompat.getRootWindowInsets((View)this.mSubDecor);
                int newGuardLeftMargin = rootInsets == null ? 0 : rootInsets.getSystemWindowInsetLeft();
                int n = newGuardRightMargin = rootInsets == null ? 0 : rootInsets.getSystemWindowInsetRight();
                if (mlp.topMargin != newTopMargin || mlp.leftMargin != newLeftMargin || mlp.rightMargin != newRightMargin) {
                    mlpChanged = true;
                    mlp.topMargin = newTopMargin;
                    mlp.leftMargin = newLeftMargin;
                    mlp.rightMargin = newRightMargin;
                }
                if (newTopMargin > 0 && this.mStatusGuard == null) {
                    this.mStatusGuard = new View(this.mContext);
                    this.mStatusGuard.setVisibility(8);
                    FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, mlp.topMargin, 51);
                    lp.leftMargin = newGuardLeftMargin;
                    lp.rightMargin = newGuardRightMargin;
                    this.mSubDecor.addView(this.mStatusGuard, -1, (ViewGroup.LayoutParams)lp);
                } else if (this.mStatusGuard != null) {
                    ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mStatusGuard.getLayoutParams();
                    if (lp.height != mlp.topMargin || lp.leftMargin != newGuardLeftMargin || lp.rightMargin != newGuardRightMargin) {
                        lp.height = mlp.topMargin;
                        lp.leftMargin = newGuardLeftMargin;
                        lp.rightMargin = newGuardRightMargin;
                        this.mStatusGuard.setLayoutParams((ViewGroup.LayoutParams)lp);
                    }
                }
                boolean bl = showStatusGuard = this.mStatusGuard != null;
                if (showStatusGuard && this.mStatusGuard.getVisibility() != 0) {
                    this.updateStatusGuardColor(this.mStatusGuard);
                }
                if (!this.mOverlayActionMode && showStatusGuard) {
                    systemWindowInsetTop = 0;
                }
            } else if (mlp.topMargin != 0) {
                mlpChanged = true;
                mlp.topMargin = 0;
            }
            if (mlpChanged) {
                this.mActionModeView.setLayoutParams((ViewGroup.LayoutParams)mlp);
            }
        }
        if (this.mStatusGuard != null) {
            this.mStatusGuard.setVisibility(showStatusGuard ? 0 : 8);
        }
        return systemWindowInsetTop;
    }

    private void updateStatusGuardColor(View v) {
        boolean lightStatusBar = (ViewCompat.getWindowSystemUiVisibility((View)v) & 0x2000) != 0;
        v.setBackgroundColor(lightStatusBar ? ContextCompat.getColor((Context)this.mContext, (int)R.color.abc_decor_view_status_guard_light) : ContextCompat.getColor((Context)this.mContext, (int)R.color.abc_decor_view_status_guard));
    }

    private void throwFeatureRequestIfSubDecorInstalled() {
        if (this.mSubDecorInstalled) {
            throw new AndroidRuntimeException("Window feature must be requested before adding content");
        }
    }

    private int sanitizeWindowFeatureId(int featureId) {
        if (featureId == 8) {
            Log.i((String)"AppCompatDelegate", (String)"You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR id when requesting this feature.");
            return 108;
        }
        if (featureId == 9) {
            Log.i((String)"AppCompatDelegate", (String)"You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR_OVERLAY id when requesting this feature.");
            return 109;
        }
        return featureId;
    }

    ViewGroup getSubDecor() {
        return this.mSubDecor;
    }

    void dismissPopups() {
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.dismissPopups();
        }
        if (this.mActionModePopup != null) {
            this.mWindow.getDecorView().removeCallbacks(this.mShowActionModePopup);
            if (this.mActionModePopup.isShowing()) {
                try {
                    this.mActionModePopup.dismiss();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.mActionModePopup = null;
        }
        this.endOnGoingFadeAnimation();
        PanelFeatureState st = this.getPanelState(0, false);
        if (st != null && st.menu != null) {
            st.menu.close();
        }
    }

    @Override
    public Context getContextForDelegate() {
        return this.mContext;
    }

    @Override
    public boolean applyDayNight() {
        return this.applyApplicationSpecificConfig(true);
    }

    @Override
    boolean applyAppLocales() {
        if (AppCompatDelegateImpl.isAutoStorageOptedIn(this.mContext) && AppCompatDelegateImpl.getRequestedAppLocales() != null && !AppCompatDelegateImpl.getRequestedAppLocales().equals((Object)AppCompatDelegateImpl.getStoredAppLocales())) {
            this.asyncExecuteSyncRequestedAndStoredLocales(this.mContext);
        }
        return this.applyApplicationSpecificConfig(true);
    }

    private boolean applyApplicationSpecificConfig(boolean allowRecreation) {
        return this.applyApplicationSpecificConfig(allowRecreation, true);
    }

    private boolean applyApplicationSpecificConfig(boolean allowRecreation, boolean isLocalesApplicationRequired) {
        if (this.mDestroyed) {
            return false;
        }
        int nightMode = this.calculateNightMode();
        int modeToApply = this.mapNightMode(this.mContext, nightMode);
        LocaleListCompat localesToBeApplied = null;
        if (Build.VERSION.SDK_INT < 33) {
            localesToBeApplied = this.calculateApplicationLocales(this.mContext);
        }
        if (!isLocalesApplicationRequired && localesToBeApplied != null) {
            localesToBeApplied = this.getConfigurationLocales(this.mContext.getResources().getConfiguration());
        }
        boolean applied = this.updateAppConfiguration(modeToApply, localesToBeApplied, allowRecreation);
        if (nightMode == 0) {
            this.getAutoTimeNightModeManager(this.mContext).setup();
        } else if (this.mAutoTimeNightModeManager != null) {
            this.mAutoTimeNightModeManager.cleanup();
        }
        if (nightMode == 3) {
            this.getAutoBatteryNightModeManager(this.mContext).setup();
        } else if (this.mAutoBatteryNightModeManager != null) {
            this.mAutoBatteryNightModeManager.cleanup();
        }
        return applied;
    }

    @Nullable
    LocaleListCompat calculateApplicationLocales(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 33) {
            return null;
        }
        LocaleListCompat requestedLocales = AppCompatDelegateImpl.getRequestedAppLocales();
        if (requestedLocales == null) {
            return null;
        }
        LocaleListCompat systemLocales = this.getConfigurationLocales(context.getApplicationContext().getResources().getConfiguration());
        LocaleListCompat localesToBeApplied = Build.VERSION.SDK_INT >= 24 ? LocaleOverlayHelper.combineLocalesIfOverlayExists(requestedLocales, systemLocales) : (requestedLocales.isEmpty() ? LocaleListCompat.getEmptyLocaleList() : (Build.VERSION.SDK_INT >= 21 ? LocaleListCompat.forLanguageTags((String)Api21Impl.toLanguageTag(requestedLocales.get(0))) : LocaleListCompat.forLanguageTags((String)requestedLocales.get(0).toString())));
        if (localesToBeApplied.isEmpty()) {
            localesToBeApplied = systemLocales;
        }
        return localesToBeApplied;
    }

    @Override
    public void setLocalNightMode(int mode) {
        if (this.mLocalNightMode != mode) {
            this.mLocalNightMode = mode;
            if (this.mBaseContextAttached) {
                this.applyDayNight();
            }
        }
    }

    @Override
    public int getLocalNightMode() {
        return this.mLocalNightMode;
    }

    int mapNightMode(@NonNull Context context, int mode) {
        switch (mode) {
            case -1: 
            case 1: 
            case 2: {
                return mode;
            }
            case 0: {
                UiModeManager uiModeManager;
                if (Build.VERSION.SDK_INT >= 23 && (uiModeManager = (UiModeManager)context.getApplicationContext().getSystemService("uimode")).getNightMode() == 0) {
                    return -1;
                }
                return this.getAutoTimeNightModeManager(context).getApplyableNightMode();
            }
            case 3: {
                return this.getAutoBatteryNightModeManager(context).getApplyableNightMode();
            }
            case -100: {
                return -1;
            }
        }
        throw new IllegalStateException("Unknown value set for night mode. Please use one of the MODE_NIGHT values from AppCompatDelegate.");
    }

    private int calculateNightMode() {
        return this.mLocalNightMode != -100 ? this.mLocalNightMode : AppCompatDelegateImpl.getDefaultNightMode();
    }

    void setConfigurationLocales(Configuration conf, @NonNull LocaleListCompat locales) {
        if (Build.VERSION.SDK_INT >= 24) {
            Api24Impl.setLocales(conf, locales);
        } else {
            conf.setLocale(locales.get(0));
            conf.setLayoutDirection(locales.get(0));
        }
    }

    LocaleListCompat getConfigurationLocales(Configuration conf) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Api24Impl.getLocales(conf);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return LocaleListCompat.forLanguageTags((String)Api21Impl.toLanguageTag(conf.locale));
        }
        return LocaleListCompat.create((Locale[])new Locale[]{conf.locale});
    }

    void setDefaultLocalesForLocaleList(LocaleListCompat locales) {
        if (Build.VERSION.SDK_INT >= 24) {
            Api24Impl.setDefaultLocales(locales);
        } else {
            Locale.setDefault(locales.get(0));
        }
    }

    @NonNull
    private Configuration createOverrideAppConfiguration(@NonNull Context context, int mode, @Nullable LocaleListCompat locales, @Nullable Configuration configOverlay, boolean ignoreFollowSystem) {
        int newNightMode;
        switch (mode) {
            case 2: {
                newNightMode = 32;
                break;
            }
            case 1: {
                newNightMode = 16;
                break;
            }
            default: {
                if (ignoreFollowSystem) {
                    newNightMode = 0;
                    break;
                }
                Configuration appConfig = context.getApplicationContext().getResources().getConfiguration();
                newNightMode = appConfig.uiMode & 0x30;
            }
        }
        Configuration overrideConf = new Configuration();
        overrideConf.fontScale = 0.0f;
        if (configOverlay != null) {
            overrideConf.setTo(configOverlay);
        }
        overrideConf.uiMode = newNightMode | overrideConf.uiMode & 0xFFFFFFCF;
        if (locales != null) {
            this.setConfigurationLocales(overrideConf, locales);
        }
        return overrideConf;
    }

    private boolean updateAppConfiguration(int nightMode, @Nullable LocaleListCompat locales, boolean allowRecreation) {
        boolean handled = false;
        Configuration overrideConfig = this.createOverrideAppConfiguration(this.mContext, nightMode, locales, null, false);
        int activityHandlingConfigChange = this.getActivityHandlesConfigChangesFlags(this.mContext);
        Configuration currentConfiguration = this.mEffectiveConfiguration == null ? this.mContext.getResources().getConfiguration() : this.mEffectiveConfiguration;
        int currentNightMode = currentConfiguration.uiMode & 0x30;
        int newNightMode = overrideConfig.uiMode & 0x30;
        LocaleListCompat currentLocales = this.getConfigurationLocales(currentConfiguration);
        LocaleListCompat newLocales = locales == null ? null : this.getConfigurationLocales(overrideConfig);
        int configChanges = 0;
        if (currentNightMode != newNightMode) {
            configChanges |= 0x200;
        }
        if (newLocales != null && !currentLocales.equals((Object)newLocales)) {
            configChanges |= 4;
            configChanges |= 0x2000;
        }
        if ((~activityHandlingConfigChange & configChanges) != 0 && allowRecreation && this.mBaseContextAttached && (sCanReturnDifferentContext || this.mCreated) && this.mHost instanceof Activity && !((Activity)this.mHost).isChild()) {
            if (Build.VERSION.SDK_INT >= 31 && (configChanges & 0x2000) != 0) {
                View view = ((Activity)this.mHost).getWindow().getDecorView();
                view.setLayoutDirection(overrideConfig.getLayoutDirection());
            }
            ActivityCompat.recreate((Activity)((Activity)this.mHost));
            handled = true;
        }
        if (!handled && configChanges != 0) {
            this.updateResourcesConfiguration(newNightMode, newLocales, (configChanges & activityHandlingConfigChange) == configChanges, null);
            handled = true;
        }
        if (handled && this.mHost instanceof AppCompatActivity) {
            if ((configChanges & 0x200) != 0) {
                ((AppCompatActivity)this.mHost).onNightModeChanged(nightMode);
            }
            if ((configChanges & 4) != 0) {
                ((AppCompatActivity)this.mHost).onLocalesChanged(locales);
            }
        }
        if (newLocales != null) {
            this.setDefaultLocalesForLocaleList(this.getConfigurationLocales(this.mContext.getResources().getConfiguration()));
        }
        return handled;
    }

    private void updateResourcesConfiguration(int uiModeNightModeValue, @Nullable LocaleListCompat locales, boolean callOnConfigChange, @Nullable Configuration configOverlay) {
        Resources res = this.mContext.getResources();
        Configuration conf = new Configuration(res.getConfiguration());
        if (configOverlay != null) {
            conf.updateFrom(configOverlay);
        }
        conf.uiMode = uiModeNightModeValue | res.getConfiguration().uiMode & 0xFFFFFFCF;
        if (locales != null) {
            this.setConfigurationLocales(conf, locales);
        }
        res.updateConfiguration(conf, null);
        if (Build.VERSION.SDK_INT < 26) {
            ResourcesFlusher.flush(res);
        }
        if (this.mThemeResId != 0) {
            this.mContext.setTheme(this.mThemeResId);
            if (Build.VERSION.SDK_INT >= 23) {
                this.mContext.getTheme().applyStyle(this.mThemeResId, true);
            }
        }
        if (callOnConfigChange && this.mHost instanceof Activity) {
            this.updateActivityConfiguration(conf);
        }
    }

    private void updateActivityConfiguration(Configuration conf) {
        Activity activity = (Activity)this.mHost;
        if (activity instanceof LifecycleOwner) {
            Lifecycle lifecycle = ((LifecycleOwner)activity).getLifecycle();
            if (lifecycle.getCurrentState().isAtLeast(Lifecycle.State.CREATED)) {
                activity.onConfigurationChanged(conf);
            }
        } else if (this.mCreated && !this.mDestroyed) {
            activity.onConfigurationChanged(conf);
        }
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    final AutoNightModeManager getAutoTimeNightModeManager() {
        return this.getAutoTimeNightModeManager(this.mContext);
    }

    private AutoNightModeManager getAutoTimeNightModeManager(@NonNull Context context) {
        if (this.mAutoTimeNightModeManager == null) {
            this.mAutoTimeNightModeManager = new AutoTimeNightModeManager(TwilightManager.getInstance(context));
        }
        return this.mAutoTimeNightModeManager;
    }

    private AutoNightModeManager getAutoBatteryNightModeManager(@NonNull Context context) {
        if (this.mAutoBatteryNightModeManager == null) {
            this.mAutoBatteryNightModeManager = new AutoBatteryNightModeManager(context);
        }
        return this.mAutoBatteryNightModeManager;
    }

    private int getActivityHandlesConfigChangesFlags(Context baseContext) {
        if (!this.mActivityHandlesConfigFlagsChecked && this.mHost instanceof Activity) {
            PackageManager pm = baseContext.getPackageManager();
            if (pm == null) {
                return 0;
            }
            try {
                int flags = 0;
                if (Build.VERSION.SDK_INT >= 29) {
                    flags = 0x100C0000;
                } else if (Build.VERSION.SDK_INT >= 24) {
                    flags = 786432;
                }
                ActivityInfo info = pm.getActivityInfo(new ComponentName(baseContext, this.mHost.getClass()), flags);
                if (info != null) {
                    this.mActivityHandlesConfigFlags = info.configChanges;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.d((String)"AppCompatDelegate", (String)"Exception while getting ActivityInfo", (Throwable)e);
                this.mActivityHandlesConfigFlags = 0;
            }
        }
        this.mActivityHandlesConfigFlagsChecked = true;
        return this.mActivityHandlesConfigFlags;
    }

    @Override
    public final ActionBarDrawerToggle.Delegate getDrawerToggleDelegate() {
        return new ActionBarDrawableToggleImpl();
    }

    @NonNull
    private static Configuration generateConfigDelta(@NonNull Configuration base, @Nullable Configuration change) {
        Configuration delta = new Configuration();
        delta.fontScale = 0.0f;
        if (change == null || base.diff(change) == 0) {
            return delta;
        }
        if (base.fontScale != change.fontScale) {
            delta.fontScale = change.fontScale;
        }
        if (base.mcc != change.mcc) {
            delta.mcc = change.mcc;
        }
        if (base.mnc != change.mnc) {
            delta.mnc = change.mnc;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            Api24Impl.generateConfigDelta_locale(base, change, delta);
        } else if (!ObjectsCompat.equals((Object)base.locale, (Object)change.locale)) {
            delta.locale = change.locale;
        }
        if (base.touchscreen != change.touchscreen) {
            delta.touchscreen = change.touchscreen;
        }
        if (base.keyboard != change.keyboard) {
            delta.keyboard = change.keyboard;
        }
        if (base.keyboardHidden != change.keyboardHidden) {
            delta.keyboardHidden = change.keyboardHidden;
        }
        if (base.navigation != change.navigation) {
            delta.navigation = change.navigation;
        }
        if (base.navigationHidden != change.navigationHidden) {
            delta.navigationHidden = change.navigationHidden;
        }
        if (base.orientation != change.orientation) {
            delta.orientation = change.orientation;
        }
        if ((base.screenLayout & 0xF) != (change.screenLayout & 0xF)) {
            delta.screenLayout |= change.screenLayout & 0xF;
        }
        if ((base.screenLayout & 0xC0) != (change.screenLayout & 0xC0)) {
            delta.screenLayout |= change.screenLayout & 0xC0;
        }
        if ((base.screenLayout & 0x30) != (change.screenLayout & 0x30)) {
            delta.screenLayout |= change.screenLayout & 0x30;
        }
        if ((base.screenLayout & 0x300) != (change.screenLayout & 0x300)) {
            delta.screenLayout |= change.screenLayout & 0x300;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.generateConfigDelta_colorMode(base, change, delta);
        }
        if ((base.uiMode & 0xF) != (change.uiMode & 0xF)) {
            delta.uiMode |= change.uiMode & 0xF;
        }
        if ((base.uiMode & 0x30) != (change.uiMode & 0x30)) {
            delta.uiMode |= change.uiMode & 0x30;
        }
        if (base.screenWidthDp != change.screenWidthDp) {
            delta.screenWidthDp = change.screenWidthDp;
        }
        if (base.screenHeightDp != change.screenHeightDp) {
            delta.screenHeightDp = change.screenHeightDp;
        }
        if (base.smallestScreenWidthDp != change.smallestScreenWidthDp) {
            delta.smallestScreenWidthDp = change.smallestScreenWidthDp;
        }
        if (base.densityDpi != change.densityDpi) {
            delta.densityDpi = change.densityDpi;
        }
        return delta;
    }

    static {
        boolean bl = sCanReturnDifferentContext = !"robolectric".equals(Build.FINGERPRINT);
        if (IS_PRE_LOLLIPOP && !sInstalledExceptionHandler) {
            final Thread.UncaughtExceptionHandler defHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
                    if (this.shouldWrapException(throwable)) {
                        Resources.NotFoundException wrapped = new Resources.NotFoundException(throwable.getMessage() + AppCompatDelegateImpl.EXCEPTION_HANDLER_MESSAGE_SUFFIX);
                        wrapped.initCause(throwable.getCause());
                        wrapped.setStackTrace(throwable.getStackTrace());
                        defHandler.uncaughtException(thread, (Throwable)wrapped);
                    } else {
                        defHandler.uncaughtException(thread, throwable);
                    }
                }

                private boolean shouldWrapException(Throwable throwable) {
                    if (throwable instanceof Resources.NotFoundException) {
                        String message = throwable.getMessage();
                        return message != null && (message.contains("drawable") || message.contains("Drawable"));
                    }
                    return false;
                }
            });
            sInstalledExceptionHandler = true;
        }
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        @DoNotInline
        static OnBackInvokedCallback registerOnBackPressedCallback(Object dispatcher, AppCompatDelegateImpl delegate) {
            OnBackInvokedCallback onBackInvokedCallback = delegate::onBackPressed;
            OnBackInvokedDispatcher typedDispatcher = (OnBackInvokedDispatcher)dispatcher;
            typedDispatcher.registerOnBackInvokedCallback(1000000, onBackInvokedCallback);
            return onBackInvokedCallback;
        }

        @DoNotInline
        static void unregisterOnBackInvokedCallback(Object dispatcher, Object callback) {
            OnBackInvokedCallback onBackInvokedCallback = (OnBackInvokedCallback)callback;
            OnBackInvokedDispatcher typedDispatcher = (OnBackInvokedDispatcher)dispatcher;
            typedDispatcher.unregisterOnBackInvokedCallback(onBackInvokedCallback);
        }

        @DoNotInline
        static OnBackInvokedDispatcher getOnBackInvokedDispatcher(Activity activity) {
            return activity.getOnBackInvokedDispatcher();
        }
    }

    class AppCompatWindowCallback
    extends WindowCallbackWrapper {
        private ActionBarMenuCallback mActionBarCallback;
        private boolean mOnContentChangedBypassEnabled;
        private boolean mDispatchKeyEventBypassEnabled;
        private boolean mOnPanelClosedBypassEnabled;

        AppCompatWindowCallback(Window.Callback callback) {
            super(callback);
        }

        void setActionBarCallback(@Nullable ActionBarMenuCallback callback) {
            this.mActionBarCallback = callback;
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent event) {
            if (this.mDispatchKeyEventBypassEnabled) {
                return this.getWrapped().dispatchKeyEvent(event);
            }
            return AppCompatDelegateImpl.this.dispatchKeyEvent(event) || super.dispatchKeyEvent(event);
        }

        @Override
        public boolean dispatchKeyShortcutEvent(KeyEvent event) {
            return super.dispatchKeyShortcutEvent(event) || AppCompatDelegateImpl.this.onKeyShortcut(event.getKeyCode(), event);
        }

        @Override
        public boolean onCreatePanelMenu(int featureId, Menu menu) {
            if (featureId == 0 && !(menu instanceof MenuBuilder)) {
                return false;
            }
            return super.onCreatePanelMenu(featureId, menu);
        }

        @Override
        public View onCreatePanelView(int featureId) {
            View created;
            if (this.mActionBarCallback != null && (created = this.mActionBarCallback.onCreatePanelView(featureId)) != null) {
                return created;
            }
            return super.onCreatePanelView(featureId);
        }

        @Override
        public void onContentChanged() {
            if (this.mOnContentChangedBypassEnabled) {
                this.getWrapped().onContentChanged();
                return;
            }
        }

        @Override
        public boolean onPreparePanel(int featureId, View view, Menu menu) {
            MenuBuilder mb;
            MenuBuilder menuBuilder = mb = menu instanceof MenuBuilder ? (MenuBuilder)menu : null;
            if (featureId == 0 && mb == null) {
                return false;
            }
            if (mb != null) {
                mb.setOverrideVisibleItems(true);
            }
            boolean handled = false;
            if (this.mActionBarCallback != null && this.mActionBarCallback.onPreparePanel(featureId)) {
                handled = true;
            }
            if (!handled) {
                handled = super.onPreparePanel(featureId, view, menu);
            }
            if (mb != null) {
                mb.setOverrideVisibleItems(false);
            }
            return handled;
        }

        @Override
        public boolean onMenuOpened(int featureId, Menu menu) {
            super.onMenuOpened(featureId, menu);
            AppCompatDelegateImpl.this.onMenuOpened(featureId);
            return true;
        }

        @Override
        public void onPanelClosed(int featureId, Menu menu) {
            if (this.mOnPanelClosedBypassEnabled) {
                this.getWrapped().onPanelClosed(featureId, menu);
                return;
            }
            super.onPanelClosed(featureId, menu);
            AppCompatDelegateImpl.this.onPanelClosed(featureId);
        }

        @Override
        public android.view.ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
            if (Build.VERSION.SDK_INT >= 23) {
                return null;
            }
            if (AppCompatDelegateImpl.this.isHandleNativeActionModesEnabled()) {
                return this.startAsSupportActionMode(callback);
            }
            return super.onWindowStartingActionMode(callback);
        }

        final android.view.ActionMode startAsSupportActionMode(ActionMode.Callback callback) {
            SupportActionModeWrapper.CallbackWrapper callbackWrapper = new SupportActionModeWrapper.CallbackWrapper(AppCompatDelegateImpl.this.mContext, callback);
            ActionMode supportActionMode = AppCompatDelegateImpl.this.startSupportActionMode(callbackWrapper);
            if (supportActionMode != null) {
                return callbackWrapper.getActionModeWrapper(supportActionMode);
            }
            return null;
        }

        @Override
        @RequiresApi(value=23)
        public android.view.ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int type) {
            if (AppCompatDelegateImpl.this.isHandleNativeActionModesEnabled()) {
                switch (type) {
                    case 0: {
                        return this.startAsSupportActionMode(callback);
                    }
                }
            }
            return super.onWindowStartingActionMode(callback, type);
        }

        @Override
        @RequiresApi(value=24)
        public void onProvideKeyboardShortcuts(List<KeyboardShortcutGroup> data, Menu menu, int deviceId) {
            PanelFeatureState panel = AppCompatDelegateImpl.this.getPanelState(0, true);
            if (panel != null && panel.menu != null) {
                super.onProvideKeyboardShortcuts(data, (Menu)panel.menu, deviceId);
            } else {
                super.onProvideKeyboardShortcuts(data, menu, deviceId);
            }
        }

        public void bypassOnContentChanged(Window.Callback c) {
            try {
                this.mOnContentChangedBypassEnabled = true;
                c.onContentChanged();
            }
            finally {
                this.mOnContentChangedBypassEnabled = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean bypassDispatchKeyEvent(Window.Callback c, KeyEvent e) {
            try {
                this.mDispatchKeyEventBypassEnabled = true;
                boolean bl = c.dispatchKeyEvent(e);
                return bl;
            }
            finally {
                this.mDispatchKeyEventBypassEnabled = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bypassOnPanelClosed(Window.Callback c, int featureId, Menu menu) {
            try {
                this.mOnPanelClosedBypassEnabled = true;
                c.onPanelClosed(featureId, menu);
            }
            finally {
                this.mOnPanelClosedBypassEnabled = false;
            }
        }
    }

    static interface ActionBarMenuCallback {
        public boolean onPreparePanel(int var1);

        @Nullable
        public View onCreatePanelView(int var1);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    abstract class AutoNightModeManager {
        private BroadcastReceiver mReceiver;

        AutoNightModeManager() {
        }

        abstract int getApplyableNightMode();

        abstract void onChange();

        void setup() {
            this.cleanup();
            IntentFilter filter = this.createIntentFilterForBroadcastReceiver();
            if (filter == null || filter.countActions() == 0) {
                return;
            }
            if (this.mReceiver == null) {
                this.mReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        AutoNightModeManager.this.onChange();
                    }
                };
            }
            AppCompatDelegateImpl.this.mContext.registerReceiver(this.mReceiver, filter);
        }

        @Nullable
        abstract IntentFilter createIntentFilterForBroadcastReceiver();

        void cleanup() {
            if (this.mReceiver != null) {
                try {
                    AppCompatDelegateImpl.this.mContext.unregisterReceiver(this.mReceiver);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.mReceiver = null;
            }
        }

        boolean isListening() {
            return this.mReceiver != null;
        }
    }

    protected static final class PanelFeatureState {
        int featureId;
        int background;
        int gravity;
        int x;
        int y;
        int windowAnimations;
        ViewGroup decorView;
        View shownPanelView;
        View createdPanelView;
        MenuBuilder menu;
        ListMenuPresenter listMenuPresenter;
        Context listPresenterContext;
        boolean isPrepared;
        boolean isHandled;
        boolean isOpen;
        public boolean qwertyMode;
        boolean refreshDecorView;
        boolean refreshMenuContent;
        boolean wasLastOpen;
        Bundle frozenMenuState;
        Bundle frozenActionViewState;

        PanelFeatureState(int featureId) {
            this.featureId = featureId;
            this.refreshDecorView = false;
        }

        public boolean hasPanelItems() {
            if (this.shownPanelView == null) {
                return false;
            }
            if (this.createdPanelView != null) {
                return true;
            }
            return this.listMenuPresenter.getAdapter().getCount() > 0;
        }

        public void clearMenuPresenters() {
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.listMenuPresenter = null;
        }

        void setStyle(Context context) {
            TypedValue outValue = new TypedValue();
            Resources.Theme widgetTheme = context.getResources().newTheme();
            widgetTheme.setTo(context.getTheme());
            widgetTheme.resolveAttribute(R.attr.actionBarPopupTheme, outValue, true);
            if (outValue.resourceId != 0) {
                widgetTheme.applyStyle(outValue.resourceId, true);
            }
            widgetTheme.resolveAttribute(R.attr.panelMenuListTheme, outValue, true);
            if (outValue.resourceId != 0) {
                widgetTheme.applyStyle(outValue.resourceId, true);
            } else {
                widgetTheme.applyStyle(R.style.Theme_AppCompat_CompactMenu, true);
            }
            context = new ContextThemeWrapper((Context)context, 0);
            context.getTheme().setTo(widgetTheme);
            this.listPresenterContext = context;
            TypedArray a = context.obtainStyledAttributes(R.styleable.AppCompatTheme);
            this.background = a.getResourceId(R.styleable.AppCompatTheme_panelBackground, 0);
            this.windowAnimations = a.getResourceId(R.styleable.AppCompatTheme_android_windowAnimationStyle, 0);
            a.recycle();
        }

        void setMenu(MenuBuilder menu) {
            if (menu == this.menu) {
                return;
            }
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.menu = menu;
            if (menu != null && this.listMenuPresenter != null) {
                menu.addMenuPresenter(this.listMenuPresenter);
            }
        }

        MenuView getListMenuView(MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (this.listMenuPresenter == null) {
                this.listMenuPresenter = new ListMenuPresenter(this.listPresenterContext, R.layout.abc_list_menu_item_layout);
                this.listMenuPresenter.setCallback(cb);
                this.menu.addMenuPresenter(this.listMenuPresenter);
            }
            MenuView result = this.listMenuPresenter.getMenuView(this.decorView);
            return result;
        }

        Parcelable onSaveInstanceState() {
            SavedState savedState = new SavedState();
            savedState.featureId = this.featureId;
            savedState.isOpen = this.isOpen;
            if (this.menu != null) {
                savedState.menuState = new Bundle();
                this.menu.savePresenterStates(savedState.menuState);
            }
            return savedState;
        }

        void onRestoreInstanceState(Parcelable state) {
            SavedState savedState = (SavedState)state;
            this.featureId = savedState.featureId;
            this.wasLastOpen = savedState.isOpen;
            this.frozenMenuState = savedState.menuState;
            this.shownPanelView = null;
            this.decorView = null;
        }

        void applyFrozenState() {
            if (this.menu != null && this.frozenMenuState != null) {
                this.menu.restorePresenterStates(this.frozenMenuState);
                this.frozenMenuState = null;
            }
        }

        @SuppressLint(value={"BanParcelableUsage"})
        private static class SavedState
        implements Parcelable {
            int featureId;
            boolean isOpen;
            Bundle menuState;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

                public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                    return SavedState.readFromParcel(in, loader);
                }

                public SavedState createFromParcel(Parcel in) {
                    return SavedState.readFromParcel(in, null);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            SavedState() {
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.featureId);
                dest.writeInt(this.isOpen ? 1 : 0);
                if (this.isOpen) {
                    dest.writeBundle(this.menuState);
                }
            }

            static SavedState readFromParcel(Parcel source, ClassLoader loader) {
                SavedState savedState = new SavedState();
                savedState.featureId = source.readInt();
                boolean bl = savedState.isOpen = source.readInt() == 1;
                if (savedState.isOpen) {
                    savedState.menuState = source.readBundle(loader);
                }
                return savedState;
            }
        }
    }

    class ActionModeCallbackWrapperV9
    implements ActionMode.Callback {
        private ActionMode.Callback mWrapped;

        public ActionModeCallbackWrapperV9(ActionMode.Callback wrapped) {
            this.mWrapped = wrapped;
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            return this.mWrapped.onCreateActionMode(mode, menu);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            ViewCompat.requestApplyInsets((View)AppCompatDelegateImpl.this.mSubDecor);
            return this.mWrapped.onPrepareActionMode(mode, menu);
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            if (AppCompatDelegateImpl.this.mActionModePopup != null) {
                AppCompatDelegateImpl.this.mWindow.getDecorView().removeCallbacks(AppCompatDelegateImpl.this.mShowActionModePopup);
            }
            if (AppCompatDelegateImpl.this.mActionModeView != null) {
                AppCompatDelegateImpl.this.endOnGoingFadeAnimation();
                AppCompatDelegateImpl.this.mFadeAnim = ViewCompat.animate((View)AppCompatDelegateImpl.this.mActionModeView).alpha(0.0f);
                AppCompatDelegateImpl.this.mFadeAnim.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                    public void onAnimationEnd(View view) {
                        AppCompatDelegateImpl.this.mActionModeView.setVisibility(8);
                        if (AppCompatDelegateImpl.this.mActionModePopup != null) {
                            AppCompatDelegateImpl.this.mActionModePopup.dismiss();
                        } else if (AppCompatDelegateImpl.this.mActionModeView.getParent() instanceof View) {
                            ViewCompat.requestApplyInsets((View)((View)AppCompatDelegateImpl.this.mActionModeView.getParent()));
                        }
                        AppCompatDelegateImpl.this.mActionModeView.killMode();
                        AppCompatDelegateImpl.this.mFadeAnim.setListener(null);
                        AppCompatDelegateImpl.this.mFadeAnim = null;
                        ViewCompat.requestApplyInsets((View)AppCompatDelegateImpl.this.mSubDecor);
                    }
                });
            }
            if (AppCompatDelegateImpl.this.mAppCompatCallback != null) {
                AppCompatDelegateImpl.this.mAppCompatCallback.onSupportActionModeFinished(AppCompatDelegateImpl.this.mActionMode);
            }
            AppCompatDelegateImpl.this.mActionMode = null;
            ViewCompat.requestApplyInsets((View)AppCompatDelegateImpl.this.mSubDecor);
            AppCompatDelegateImpl.this.updateBackInvokedCallbackState();
        }
    }

    private class ListMenuDecorView
    extends ContentFrameLayout {
        public ListMenuDecorView(Context context) {
            super(context);
        }

        public boolean dispatchKeyEvent(KeyEvent event) {
            return AppCompatDelegateImpl.this.dispatchKeyEvent(event) || super.dispatchKeyEvent(event);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            int y;
            int x;
            int action = event.getAction();
            if (action == 0 && this.isOutOfBounds(x = (int)event.getX(), y = (int)event.getY())) {
                AppCompatDelegateImpl.this.closePanel(0);
                return true;
            }
            return super.onInterceptTouchEvent(event);
        }

        public void setBackgroundResource(int resid) {
            this.setBackgroundDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)resid));
        }

        private boolean isOutOfBounds(int x, int y) {
            return x < -5 || y < -5 || x > this.getWidth() + 5 || y > this.getHeight() + 5;
        }
    }

    private final class PanelMenuPresenterCallback
    implements MenuPresenter.Callback {
        PanelMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(@NonNull MenuBuilder menu, boolean allMenusAreClosing) {
            MenuBuilder parentMenu = menu.getRootMenu();
            boolean isSubMenu = parentMenu != menu;
            PanelFeatureState panel = AppCompatDelegateImpl.this.findMenuPanel((Menu)(isSubMenu ? parentMenu : menu));
            if (panel != null) {
                if (isSubMenu) {
                    AppCompatDelegateImpl.this.callOnPanelClosed(panel.featureId, panel, (Menu)parentMenu);
                    AppCompatDelegateImpl.this.closePanel(panel, true);
                } else {
                    AppCompatDelegateImpl.this.closePanel(panel, allMenusAreClosing);
                }
            }
        }

        @Override
        public boolean onOpenSubMenu(@NonNull MenuBuilder subMenu) {
            Window.Callback cb;
            if (subMenu == subMenu.getRootMenu() && AppCompatDelegateImpl.this.mHasActionBar && (cb = AppCompatDelegateImpl.this.getWindowCallback()) != null && !AppCompatDelegateImpl.this.mDestroyed) {
                cb.onMenuOpened(108, (Menu)subMenu);
            }
            return true;
        }
    }

    private final class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        ActionMenuPresenterCallback() {
        }

        @Override
        public boolean onOpenSubMenu(@NonNull MenuBuilder subMenu) {
            Window.Callback cb = AppCompatDelegateImpl.this.getWindowCallback();
            if (cb != null) {
                cb.onMenuOpened(108, (Menu)subMenu);
            }
            return true;
        }

        @Override
        public void onCloseMenu(@NonNull MenuBuilder menu, boolean allMenusAreClosing) {
            AppCompatDelegateImpl.this.checkCloseActionMenu(menu);
        }
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static boolean isPowerSaveMode(PowerManager powerManager) {
            return powerManager.isPowerSaveMode();
        }

        @DoNotInline
        static String toLanguageTag(Locale locale) {
            return locale.toLanguageTag();
        }
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static void generateConfigDelta_locale(@NonNull Configuration base, @NonNull Configuration change, @NonNull Configuration delta) {
            LocaleList changeLocales;
            LocaleList baseLocales = base.getLocales();
            if (!baseLocales.equals((Object)(changeLocales = change.getLocales()))) {
                delta.setLocales(changeLocales);
                delta.locale = change.locale;
            }
        }

        @DoNotInline
        static LocaleListCompat getLocales(Configuration configuration) {
            return LocaleListCompat.forLanguageTags((String)configuration.getLocales().toLanguageTags());
        }

        @DoNotInline
        static void setLocales(Configuration configuration, LocaleListCompat locales) {
            configuration.setLocales(LocaleList.forLanguageTags((String)locales.toLanguageTags()));
        }

        @DoNotInline
        public static void setDefaultLocales(LocaleListCompat locales) {
            LocaleList.setDefault((LocaleList)LocaleList.forLanguageTags((String)locales.toLanguageTags()));
        }
    }

    private class AutoTimeNightModeManager
    extends AutoNightModeManager {
        private final TwilightManager mTwilightManager;

        AutoTimeNightModeManager(TwilightManager twilightManager) {
            this.mTwilightManager = twilightManager;
        }

        @Override
        public int getApplyableNightMode() {
            return this.mTwilightManager.isNight() ? 2 : 1;
        }

        @Override
        public void onChange() {
            AppCompatDelegateImpl.this.applyDayNight();
        }

        @Override
        IntentFilter createIntentFilterForBroadcastReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            filter.addAction("android.intent.action.TIME_TICK");
            return filter;
        }
    }

    private class AutoBatteryNightModeManager
    extends AutoNightModeManager {
        private final PowerManager mPowerManager;

        AutoBatteryNightModeManager(Context context) {
            this.mPowerManager = (PowerManager)context.getApplicationContext().getSystemService("power");
        }

        @Override
        public int getApplyableNightMode() {
            if (Build.VERSION.SDK_INT >= 21) {
                return Api21Impl.isPowerSaveMode(this.mPowerManager) ? 2 : 1;
            }
            return 1;
        }

        @Override
        public void onChange() {
            AppCompatDelegateImpl.this.applyDayNight();
        }

        @Override
        IntentFilter createIntentFilterForBroadcastReceiver() {
            if (Build.VERSION.SDK_INT >= 21) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
                return filter;
            }
            return null;
        }
    }

    private class ActionBarDrawableToggleImpl
    implements ActionBarDrawerToggle.Delegate {
        ActionBarDrawableToggleImpl() {
        }

        @Override
        public Drawable getThemeUpIndicator() {
            TintTypedArray a = TintTypedArray.obtainStyledAttributes(this.getActionBarThemedContext(), null, new int[]{R.attr.homeAsUpIndicator});
            Drawable result = a.getDrawable(0);
            a.recycle();
            return result;
        }

        @Override
        public Context getActionBarThemedContext() {
            return AppCompatDelegateImpl.this.getActionBarThemedContext();
        }

        @Override
        public boolean isNavigationVisible() {
            ActionBar ab = AppCompatDelegateImpl.this.getSupportActionBar();
            return ab != null && (ab.getDisplayOptions() & 4) != 0;
        }

        @Override
        public void setActionBarUpIndicator(Drawable upDrawable, int contentDescRes) {
            ActionBar ab = AppCompatDelegateImpl.this.getSupportActionBar();
            if (ab != null) {
                ab.setHomeAsUpIndicator(upDrawable);
                ab.setHomeActionContentDescription(contentDescRes);
            }
        }

        @Override
        public void setActionBarDescription(int contentDescRes) {
            ActionBar ab = AppCompatDelegateImpl.this.getSupportActionBar();
            if (ab != null) {
                ab.setHomeActionContentDescription(contentDescRes);
            }
        }
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        static void generateConfigDelta_colorMode(@NonNull Configuration base, @NonNull Configuration change, @NonNull Configuration delta) {
            if ((base.colorMode & 3) != (change.colorMode & 3)) {
                delta.colorMode |= change.colorMode & 3;
            }
            if ((base.colorMode & 0xC) != (change.colorMode & 0xC)) {
                delta.colorMode |= change.colorMode & 0xC;
            }
        }
    }
}

