/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.CompoundButtonCompat;

class AppCompatCompoundButtonHelper {
    @NonNull
    private final CompoundButton mView;
    private ColorStateList mButtonTintList = null;
    private PorterDuff.Mode mButtonTintMode = null;
    private boolean mHasButtonTint = false;
    private boolean mHasButtonTintMode = false;
    private boolean mSkipNextApply;

    AppCompatCompoundButtonHelper(@NonNull CompoundButton view) {
        this.mView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromAttributes(@Nullable AttributeSet attrs, int defStyleAttr) {
        TintTypedArray a = TintTypedArray.obtainStyledAttributes(this.mView.getContext(), attrs, R.styleable.CompoundButton, defStyleAttr, 0);
        ViewCompat.saveAttributeDataForStyleable((View)this.mView, (Context)this.mView.getContext(), (int[])R.styleable.CompoundButton, (AttributeSet)attrs, (TypedArray)a.getWrappedTypeArray(), (int)defStyleAttr, (int)0);
        try {
            int resourceId;
            boolean buttonDrawableLoaded = false;
            if (a.hasValue(R.styleable.CompoundButton_buttonCompat) && (resourceId = a.getResourceId(R.styleable.CompoundButton_buttonCompat, 0)) != 0) {
                try {
                    this.mView.setButtonDrawable(AppCompatResources.getDrawable((Context)this.mView.getContext(), (int)resourceId));
                    buttonDrawableLoaded = true;
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            if (!buttonDrawableLoaded && a.hasValue(R.styleable.CompoundButton_android_button) && (resourceId = a.getResourceId(R.styleable.CompoundButton_android_button, 0)) != 0) {
                this.mView.setButtonDrawable(AppCompatResources.getDrawable((Context)this.mView.getContext(), (int)resourceId));
            }
            if (a.hasValue(R.styleable.CompoundButton_buttonTint)) {
                CompoundButtonCompat.setButtonTintList((CompoundButton)this.mView, (ColorStateList)a.getColorStateList(R.styleable.CompoundButton_buttonTint));
            }
            if (a.hasValue(R.styleable.CompoundButton_buttonTintMode)) {
                CompoundButtonCompat.setButtonTintMode((CompoundButton)this.mView, (PorterDuff.Mode)DrawableUtils.parseTintMode((int)a.getInt(R.styleable.CompoundButton_buttonTintMode, -1), null));
            }
        }
        finally {
            a.recycle();
        }
    }

    void setSupportButtonTintList(ColorStateList tint) {
        this.mButtonTintList = tint;
        this.mHasButtonTint = true;
        this.applyButtonTint();
    }

    ColorStateList getSupportButtonTintList() {
        return this.mButtonTintList;
    }

    void setSupportButtonTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mButtonTintMode = tintMode;
        this.mHasButtonTintMode = true;
        this.applyButtonTint();
    }

    PorterDuff.Mode getSupportButtonTintMode() {
        return this.mButtonTintMode;
    }

    void onSetButtonDrawable() {
        if (this.mSkipNextApply) {
            this.mSkipNextApply = false;
            return;
        }
        this.mSkipNextApply = true;
        this.applyButtonTint();
    }

    void applyButtonTint() {
        Drawable buttonDrawable = CompoundButtonCompat.getButtonDrawable((CompoundButton)this.mView);
        if (buttonDrawable != null && (this.mHasButtonTint || this.mHasButtonTintMode)) {
            buttonDrawable = DrawableCompat.wrap((Drawable)buttonDrawable);
            buttonDrawable = buttonDrawable.mutate();
            if (this.mHasButtonTint) {
                DrawableCompat.setTintList((Drawable)buttonDrawable, (ColorStateList)this.mButtonTintList);
            }
            if (this.mHasButtonTintMode) {
                DrawableCompat.setTintMode((Drawable)buttonDrawable, (PorterDuff.Mode)this.mButtonTintMode);
            }
            if (buttonDrawable.isStateful()) {
                buttonDrawable.setState(this.mView.getDrawableState());
            }
            this.mView.setButtonDrawable(buttonDrawable);
        }
    }
}

