/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.WindowInsets;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class ViewUtils {
    private static final String TAG = "ViewUtils";
    private static boolean sInitComputeFitSystemWindowsMethod;
    private static Method sComputeFitSystemWindowsMethod;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @ChecksSdkIntAtLeast(api=27)
    static final boolean SDK_LEVEL_SUPPORTS_AUTOSIZE;

    private ViewUtils() {
    }

    public static boolean isLayoutRtl(View view) {
        return view.getLayoutDirection() == 1;
    }

    public static void computeFitSystemWindows(@NonNull View view, @NonNull Rect inoutInsets, @NonNull Rect outLocalInsets) {
        if (Build.VERSION.SDK_INT >= 29) {
            Api29Impl.computeFitSystemWindows(view, inoutInsets, outLocalInsets);
        } else {
            if (!sInitComputeFitSystemWindowsMethod) {
                sInitComputeFitSystemWindowsMethod = true;
                try {
                    sComputeFitSystemWindowsMethod = View.class.getDeclaredMethod("computeFitSystemWindows", Rect.class, Rect.class);
                    if (!sComputeFitSystemWindowsMethod.isAccessible()) {
                        sComputeFitSystemWindowsMethod.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException e) {
                    Log.d((String)TAG, (String)"Could not find method computeFitSystemWindows. Oh well.");
                }
            }
            if (sComputeFitSystemWindowsMethod != null) {
                try {
                    sComputeFitSystemWindowsMethod.invoke((Object)view, inoutInsets, outLocalInsets);
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)"Could not invoke computeFitSystemWindows", (Throwable)e);
                }
            }
        }
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    public static void makeOptionalFitsSystemWindows(View view) {
        try {
            Method method = view.getClass().getMethod("makeOptionalFitsSystemWindows", new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            method.invoke((Object)view, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Log.d((String)TAG, (String)"Could not find method makeOptionalFitsSystemWindows. Oh well...");
        }
        catch (InvocationTargetException e) {
            Log.d((String)TAG, (String)"Could not invoke makeOptionalFitsSystemWindows", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.d((String)TAG, (String)"Could not invoke makeOptionalFitsSystemWindows", (Throwable)e);
        }
    }

    static {
        SDK_LEVEL_SUPPORTS_AUTOSIZE = Build.VERSION.SDK_INT >= 27;
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static void computeFitSystemWindows(@NonNull View view, @NonNull Rect inoutInsets, @NonNull Rect outLocalInsets) {
            WindowInsets in = new WindowInsets.Builder().setSystemWindowInsets(Insets.of((Rect)inoutInsets)).build();
            WindowInsets innerInsets = view.computeSystemWindowInsets(in, outLocalInsets);
            Insets systemWindowInsets = innerInsets.getSystemWindowInsets();
            inoutInsets.set(systemWindowInsets.left, systemWindowInsets.top, systemWindowInsets.right, systemWindowInsets.bottom);
        }
    }
}

