/*
 * Decompiled with CFR 0.152.
 */
package androidx.versionedparcelable;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.versionedparcelable.ParcelImpl;
import androidx.versionedparcelable.VersionedParcelStream;
import androidx.versionedparcelable.VersionedParcelable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ParcelUtils {
    @NonNull
    private static final String INNER_BUNDLE_KEY = "a";

    private ParcelUtils() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NonNull
    public static Parcelable toParcelable(@Nullable VersionedParcelable obj) {
        return new ParcelImpl(obj);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public static <T extends VersionedParcelable> T fromParcelable(@NonNull Parcelable p) {
        if (!(p instanceof ParcelImpl)) {
            throw new IllegalArgumentException("Invalid parcel");
        }
        return ((ParcelImpl)p).getVersionedParcel();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void toOutputStream(@Nullable VersionedParcelable obj, @NonNull OutputStream output) {
        VersionedParcelStream stream = new VersionedParcelStream(null, output);
        stream.writeVersionedParcelable(obj);
        stream.closeField();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public static <T extends VersionedParcelable> T fromInputStream(@NonNull InputStream input) {
        VersionedParcelStream stream = new VersionedParcelStream(input, null);
        return stream.readVersionedParcelable();
    }

    public static void putVersionedParcelable(@NonNull Bundle b, @NonNull String key, @Nullable VersionedParcelable obj) {
        if (obj == null) {
            b.putParcelable(key, null);
        } else {
            Bundle innerBundle = new Bundle();
            innerBundle.putParcelable(INNER_BUNDLE_KEY, ParcelUtils.toParcelable(obj));
            b.putParcelable(key, (Parcelable)innerBundle);
        }
    }

    @Nullable
    public static <T extends VersionedParcelable> T getVersionedParcelable(@NonNull Bundle bundle, @NonNull String key) {
        try {
            Bundle innerBundle = (Bundle)bundle.getParcelable(key);
            if (innerBundle == null) {
                return null;
            }
            innerBundle.setClassLoader(ParcelUtils.class.getClassLoader());
            return ParcelUtils.fromParcelable(innerBundle.getParcelable(INNER_BUNDLE_KEY));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static void putVersionedParcelableList(@NonNull Bundle b, @NonNull String key, @NonNull List<? extends VersionedParcelable> list) {
        Bundle innerBundle = new Bundle();
        ArrayList<Parcelable> toWrite = new ArrayList<Parcelable>();
        for (VersionedParcelable versionedParcelable : list) {
            toWrite.add(ParcelUtils.toParcelable(versionedParcelable));
        }
        innerBundle.putParcelableArrayList(INNER_BUNDLE_KEY, toWrite);
        b.putParcelable(key, (Parcelable)innerBundle);
    }

    @NonNull
    public static <T extends VersionedParcelable> List<T> getVersionedParcelableList(@NonNull Bundle bundle, @Nullable String key) {
        ArrayList<T> resultList = new ArrayList<T>();
        try {
            Bundle innerBundle = (Bundle)bundle.getParcelable(key);
            innerBundle.setClassLoader(ParcelUtils.class.getClassLoader());
            ArrayList parcelableArrayList = innerBundle.getParcelableArrayList(INNER_BUNDLE_KEY);
            for (Parcelable parcelable : parcelableArrayList) {
                resultList.add(ParcelUtils.fromParcelable(parcelable));
            }
        }
        catch (RuntimeException e) {
            resultList.clear();
        }
        return resultList;
    }
}

