/*
 * Decompiled with CFR 0.152.
 */
package androidx.versionedparcelable;

import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.NetworkOnMainThreadException;
import android.os.Parcelable;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseBooleanArray;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import androidx.collection.SimpleArrayMap;
import androidx.versionedparcelable.VersionedParcelable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public abstract class VersionedParcel {
    @NonNull
    private static final String TAG = "VersionedParcel";
    private static final int EX_SECURITY = -1;
    private static final int EX_BAD_PARCELABLE = -2;
    private static final int EX_ILLEGAL_ARGUMENT = -3;
    private static final int EX_NULL_POINTER = -4;
    private static final int EX_ILLEGAL_STATE = -5;
    private static final int EX_NETWORK_MAIN_THREAD = -6;
    private static final int EX_UNSUPPORTED_OPERATION = -7;
    private static final int EX_PARCELABLE = -9;
    private static final int TYPE_VERSIONED_PARCELABLE = 1;
    private static final int TYPE_PARCELABLE = 2;
    private static final int TYPE_SERIALIZABLE = 3;
    private static final int TYPE_STRING = 4;
    private static final int TYPE_BINDER = 5;
    private static final int TYPE_INTEGER = 7;
    private static final int TYPE_FLOAT = 8;
    @NonNull
    final SimpleArrayMap<String, Method> mReadCache;
    @NonNull
    final SimpleArrayMap<String, Method> mWriteCache;
    @NonNull
    final SimpleArrayMap<String, Class<?>> mParcelizerCache;

    VersionedParcel(@NonNull SimpleArrayMap<String, Method> readCache, @NonNull SimpleArrayMap<String, Method> writeCache, @NonNull SimpleArrayMap<String, Class<?>> parcelizerCache) {
        this.mReadCache = readCache;
        this.mWriteCache = writeCache;
        this.mParcelizerCache = parcelizerCache;
    }

    public boolean isStream() {
        return false;
    }

    protected abstract void closeField();

    @NonNull
    protected abstract VersionedParcel createSubParcel();

    protected abstract void writeByteArray(@Nullable byte[] var1);

    protected abstract void writeByteArray(@Nullable byte[] var1, int var2, int var3);

    protected abstract void writeCharSequence(@Nullable CharSequence var1);

    protected abstract void writeInt(int var1);

    protected abstract void writeLong(long var1);

    protected abstract void writeFloat(float var1);

    protected abstract void writeDouble(double var1);

    protected abstract void writeString(@Nullable String var1);

    protected abstract void writeStrongBinder(@Nullable IBinder var1);

    protected abstract void writeParcelable(@Nullable Parcelable var1);

    protected abstract void writeBoolean(boolean var1);

    protected abstract void writeStrongInterface(@Nullable IInterface var1);

    protected abstract void writeBundle(@Nullable Bundle var1);

    protected abstract int readInt();

    protected abstract long readLong();

    protected abstract float readFloat();

    protected abstract double readDouble();

    @Nullable
    protected abstract String readString();

    @Nullable
    protected abstract IBinder readStrongBinder();

    @Nullable
    protected abstract byte[] readByteArray();

    @Nullable
    protected abstract CharSequence readCharSequence();

    @Nullable
    protected abstract <T extends Parcelable> T readParcelable();

    @Nullable
    protected abstract Bundle readBundle();

    protected abstract boolean readBoolean();

    protected abstract boolean readField(int var1);

    protected abstract void setOutputField(int var1);

    public void setSerializationFlags(boolean allowSerialization, boolean ignoreParcelables) {
    }

    public void writeStrongInterface(@Nullable IInterface val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeStrongInterface(val);
    }

    public void writeBundle(@Nullable Bundle val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeBundle(val);
    }

    public void writeBoolean(boolean val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeBoolean(val);
    }

    public void writeByteArray(@Nullable byte[] b, int fieldId) {
        this.setOutputField(fieldId);
        this.writeByteArray(b);
    }

    public void writeByteArray(@Nullable byte[] b, int offset, int len, int fieldId) {
        this.setOutputField(fieldId);
        this.writeByteArray(b, offset, len);
    }

    public void writeCharSequence(@Nullable CharSequence val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeCharSequence(val);
    }

    public void writeInt(int val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeInt(val);
    }

    public void writeLong(long val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeLong(val);
    }

    public void writeFloat(float val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeFloat(val);
    }

    public void writeDouble(double val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeDouble(val);
    }

    public void writeString(@Nullable String val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeString(val);
    }

    public void writeStrongBinder(@Nullable IBinder val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeStrongBinder(val);
    }

    public void writeParcelable(@Nullable Parcelable p, int fieldId) {
        this.setOutputField(fieldId);
        this.writeParcelable(p);
    }

    public boolean readBoolean(boolean def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readBoolean();
    }

    public int readInt(int def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readInt();
    }

    public long readLong(long def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readLong();
    }

    public float readFloat(float def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readFloat();
    }

    public double readDouble(double def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readDouble();
    }

    @Nullable
    public String readString(@Nullable String def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readString();
    }

    @Nullable
    public IBinder readStrongBinder(@Nullable IBinder def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readStrongBinder();
    }

    @Nullable
    public byte[] readByteArray(@Nullable byte[] def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readByteArray();
    }

    @Nullable
    public <T extends Parcelable> T readParcelable(@Nullable T def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readParcelable();
    }

    @Nullable
    public Bundle readBundle(@Nullable Bundle def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readBundle();
    }

    public void writeByte(byte val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeInt(val);
    }

    @RequiresApi(value=21)
    public void writeSize(@Nullable Size val, int fieldId) {
        this.setOutputField(fieldId);
        Api21Impl.writeSize(this, val);
    }

    @RequiresApi(value=21)
    public void writeSizeF(@Nullable SizeF val, int fieldId) {
        this.setOutputField(fieldId);
        Api21Impl.writeSizeF(this, val);
    }

    public void writeSparseBooleanArray(@Nullable SparseBooleanArray val, int fieldId) {
        this.setOutputField(fieldId);
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int n = val.size();
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeBoolean(val.valueAt(i));
        }
    }

    public void writeBooleanArray(@Nullable boolean[] val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeBooleanArray(val);
    }

    protected void writeBooleanArray(@Nullable boolean[] val) {
        if (val != null) {
            int n = val.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeInt(val[i] ? 1 : 0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    @Nullable
    public boolean[] readBooleanArray(@Nullable boolean[] def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readBooleanArray();
    }

    @Nullable
    protected boolean[] readBooleanArray() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        boolean[] val = new boolean[n];
        for (int i = 0; i < n; ++i) {
            val[i] = this.readInt() != 0;
        }
        return val;
    }

    public void writeCharArray(@Nullable char[] val, int fieldId) {
        this.setOutputField(fieldId);
        if (val != null) {
            int n = val.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    @Nullable
    public CharSequence readCharSequence(@Nullable CharSequence def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readCharSequence();
    }

    @Nullable
    public char[] readCharArray(@Nullable char[] def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        char[] val = new char[n];
        for (int i = 0; i < n; ++i) {
            val[i] = (char)this.readInt();
        }
        return val;
    }

    public void writeIntArray(@Nullable int[] val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeIntArray(val);
    }

    protected void writeIntArray(@Nullable int[] val) {
        if (val != null) {
            int n = val.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    @Nullable
    public int[] readIntArray(@Nullable int[] def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readIntArray();
    }

    @Nullable
    protected int[] readIntArray() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        int[] val = new int[n];
        for (int i = 0; i < n; ++i) {
            val[i] = this.readInt();
        }
        return val;
    }

    public void writeLongArray(@Nullable long[] val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeLongArray(val);
    }

    protected void writeLongArray(@Nullable long[] val) {
        if (val != null) {
            int n = val.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeLong(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    @Nullable
    public long[] readLongArray(@Nullable long[] def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readLongArray();
    }

    @Nullable
    protected long[] readLongArray() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        long[] val = new long[n];
        for (int i = 0; i < n; ++i) {
            val[i] = this.readLong();
        }
        return val;
    }

    public void writeFloatArray(@Nullable float[] val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeFloatArray(val);
    }

    protected void writeFloatArray(@Nullable float[] val) {
        if (val != null) {
            int n = val.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeFloat(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    @Nullable
    public float[] readFloatArray(@Nullable float[] def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readFloatArray();
    }

    @Nullable
    protected float[] readFloatArray() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        float[] val = new float[n];
        for (int i = 0; i < n; ++i) {
            val[i] = this.readFloat();
        }
        return val;
    }

    public void writeDoubleArray(@Nullable double[] val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeDoubleArray(val);
    }

    protected void writeDoubleArray(@Nullable double[] val) {
        if (val != null) {
            int n = val.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeDouble(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    @Nullable
    public double[] readDoubleArray(@Nullable double[] def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readDoubleArray();
    }

    @Nullable
    protected double[] readDoubleArray() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        double[] val = new double[n];
        for (int i = 0; i < n; ++i) {
            val[i] = this.readDouble();
        }
        return val;
    }

    public <T> void writeSet(@Nullable Set<T> val, int fieldId) {
        this.writeCollection(val, fieldId);
    }

    public <T> void writeList(@Nullable List<T> val, int fieldId) {
        this.writeCollection(val, fieldId);
    }

    public <K, V> void writeMap(@Nullable Map<K, V> val, int fieldId) {
        this.setOutputField(fieldId);
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int size = val.size();
        this.writeInt(size);
        if (size == 0) {
            return;
        }
        ArrayList<K> keySet = new ArrayList<K>(size);
        ArrayList<V> valueSet = new ArrayList<V>(size);
        for (Map.Entry<K, V> entry : val.entrySet()) {
            keySet.add(entry.getKey());
            valueSet.add(entry.getValue());
        }
        this.writeCollection(keySet);
        this.writeCollection(valueSet);
    }

    private <T> void writeCollection(@Nullable Collection<T> val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeCollection(val);
    }

    private <T> void writeCollection(@Nullable Collection<T> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int n = val.size();
        this.writeInt(n);
        if (n > 0) {
            int type = this.getType(val.iterator().next());
            this.writeInt(type);
            switch (type) {
                case 4: {
                    for (T v : val) {
                        this.writeString((String)v);
                    }
                    break;
                }
                case 2: {
                    for (T v : val) {
                        this.writeParcelable((Parcelable)v);
                    }
                    break;
                }
                case 1: {
                    for (T v : val) {
                        this.writeVersionedParcelable((VersionedParcelable)v);
                    }
                    break;
                }
                case 3: {
                    for (T v : val) {
                        this.writeSerializable((Serializable)v);
                    }
                    break;
                }
                case 5: {
                    for (T v : val) {
                        this.writeStrongBinder((IBinder)v);
                    }
                    break;
                }
                case 7: {
                    for (T v : val) {
                        this.writeInt((Integer)v);
                    }
                    break;
                }
                case 8: {
                    for (T v : val) {
                        this.writeFloat(((Float)v).floatValue());
                    }
                    break;
                }
            }
        }
    }

    public <T> void writeArray(@Nullable T[] val, int fieldId) {
        this.setOutputField(fieldId);
        this.writeArray(val);
    }

    protected <T> void writeArray(@Nullable T[] val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int n = val.length;
        this.writeInt(n);
        if (n > 0) {
            int type = this.getType(val[0]);
            this.writeInt(type);
            switch (type) {
                case 4: {
                    int i;
                    for (i = 0; i < n; ++i) {
                        this.writeString((String)val[i]);
                    }
                    break;
                }
                case 2: {
                    int i;
                    while (i < n) {
                        this.writeParcelable((Parcelable)val[i]);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    int i;
                    while (i < n) {
                        this.writeVersionedParcelable((VersionedParcelable)val[i]);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    int i;
                    while (i < n) {
                        this.writeSerializable((Serializable)val[i]);
                        ++i;
                    }
                    break;
                }
                case 5: {
                    int i;
                    while (i < n) {
                        this.writeStrongBinder((IBinder)val[i]);
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    private <T> int getType(@NonNull T t) {
        if (t instanceof String) {
            return 4;
        }
        if (t instanceof Parcelable) {
            return 2;
        }
        if (t instanceof VersionedParcelable) {
            return 1;
        }
        if (t instanceof Serializable) {
            return 3;
        }
        if (t instanceof IBinder) {
            return 5;
        }
        if (t instanceof Integer) {
            return 7;
        }
        if (t instanceof Float) {
            return 8;
        }
        throw new IllegalArgumentException(t.getClass().getName() + " cannot be VersionedParcelled");
    }

    public void writeVersionedParcelable(@Nullable VersionedParcelable p, int fieldId) {
        this.setOutputField(fieldId);
        this.writeVersionedParcelable(p);
    }

    protected void writeVersionedParcelable(@Nullable VersionedParcelable p) {
        if (p == null) {
            this.writeString(null);
            return;
        }
        this.writeVersionedParcelableCreator(p);
        VersionedParcel subParcel = this.createSubParcel();
        this.writeToParcel(p, subParcel);
        subParcel.closeField();
    }

    private void writeVersionedParcelableCreator(@NonNull VersionedParcelable p) {
        Class<?> name;
        try {
            name = this.findParcelClass(p.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(p.getClass().getSimpleName() + " does not have a Parcelizer", e);
        }
        this.writeString(name.getName());
    }

    public void writeSerializable(@Nullable Serializable s, int fieldId) {
        this.setOutputField(fieldId);
        this.writeSerializable(s);
    }

    private void writeSerializable(@Nullable Serializable s) {
        if (s == null) {
            this.writeString(null);
            return;
        }
        String name = s.getClass().getName();
        this.writeString(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(s);
            oos.close();
            this.writeByteArray(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException("VersionedParcelable encountered IOException writing serializable object (name = " + name + ")", ioe);
        }
    }

    public void writeException(@Nullable Exception e, int fieldId) {
        this.setOutputField(fieldId);
        if (e == null) {
            this.writeNoException();
            return;
        }
        int code = 0;
        if (e instanceof Parcelable && e.getClass().getClassLoader() == Parcelable.class.getClassLoader()) {
            code = -9;
        } else if (e instanceof SecurityException) {
            code = -1;
        } else if (e instanceof BadParcelableException) {
            code = -2;
        } else if (e instanceof IllegalArgumentException) {
            code = -3;
        } else if (e instanceof NullPointerException) {
            code = -4;
        } else if (e instanceof IllegalStateException) {
            code = -5;
        } else if (e instanceof NetworkOnMainThreadException) {
            code = -6;
        } else if (e instanceof UnsupportedOperationException) {
            code = -7;
        }
        this.writeInt(code);
        if (code == 0) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.writeString(e.getMessage());
        switch (code) {
            case -9: {
                this.writeParcelable((Parcelable)e);
            }
        }
    }

    protected void writeNoException() {
        this.writeInt(0);
    }

    @Nullable
    public Exception readException(@Nullable Exception def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        int code = this.readExceptionCode();
        if (code != 0) {
            String msg = this.readString();
            return this.createException(code, msg);
        }
        return def;
    }

    private int readExceptionCode() {
        int code = this.readInt();
        return code;
    }

    @NonNull
    protected static Throwable getRootCause(@NonNull Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    @NonNull
    private Exception createException(int code, String msg) {
        switch (code) {
            case -9: {
                return (Exception)this.readParcelable();
            }
            case -1: {
                return new SecurityException(msg);
            }
            case -2: {
                return new BadParcelableException(msg);
            }
            case -3: {
                return new IllegalArgumentException(msg);
            }
            case -4: {
                return new NullPointerException(msg);
            }
            case -5: {
                return new IllegalStateException(msg);
            }
            case -6: {
                return new NetworkOnMainThreadException();
            }
            case -7: {
                return new UnsupportedOperationException(msg);
            }
        }
        return new RuntimeException("Unknown exception code: " + code + " msg " + msg);
    }

    public byte readByte(byte def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return (byte)(this.readInt() & 0xFF);
    }

    @RequiresApi(value=21)
    @Nullable
    public Size readSize(@Nullable Size def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return Api21Impl.readSize(this);
    }

    @RequiresApi(value=21)
    @Nullable
    public SizeF readSizeF(@Nullable SizeF def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return Api21Impl.readSizeF(this);
    }

    @Nullable
    public SparseBooleanArray readSparseBooleanArray(@Nullable SparseBooleanArray def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        SparseBooleanArray sa = new SparseBooleanArray(n);
        for (int i = 0; i < n; ++i) {
            sa.put(this.readInt(), this.readBoolean());
        }
        return sa;
    }

    @Nullable
    public <T> Set<T> readSet(@Nullable Set<T> def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return (Set)this.readCollection(new ArraySet());
    }

    @Nullable
    public <T> List<T> readList(@Nullable List<T> def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readCollection(new ArrayList());
    }

    @Nullable
    private <T, S extends Collection<T>> S readCollection(@NonNull S list) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        if (n != 0) {
            int type = this.readInt();
            if (n < 0) {
                return null;
            }
            switch (type) {
                case 4: {
                    while (n > 0) {
                        list.add((String)this.readString());
                        --n;
                    }
                    break;
                }
                case 2: {
                    while (n > 0) {
                        list.add(this.readParcelable());
                        --n;
                    }
                    break;
                }
                case 1: {
                    while (n > 0) {
                        list.add(this.readVersionedParcelable());
                        --n;
                    }
                    break;
                }
                case 3: {
                    while (n > 0) {
                        list.add((Serializable)this.readSerializable());
                        --n;
                    }
                    break;
                }
                case 5: {
                    while (n > 0) {
                        list.add((IBinder)this.readStrongBinder());
                        --n;
                    }
                    break;
                }
            }
        }
        return list;
    }

    @Nullable
    public <K, V> Map<K, V> readMap(@Nullable Map<K, V> def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        int size = this.readInt();
        if (size < 0) {
            return null;
        }
        ArrayMap map = new ArrayMap(size);
        if (size == 0) {
            return map;
        }
        ArrayList keyList = new ArrayList(size);
        ArrayList valueList = new ArrayList(size);
        this.readCollection(keyList);
        this.readCollection(valueList);
        for (int i = 0; i < size; ++i) {
            map.put(keyList.get(i), valueList.get(i));
        }
        return map;
    }

    @Nullable
    public <T> T[] readArray(@Nullable T[] def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readArray(def);
    }

    @Nullable
    protected <T> T[] readArray(@Nullable T[] def) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(n);
        if (n != 0) {
            int type = this.readInt();
            if (n < 0) {
                return null;
            }
            switch (type) {
                case 4: {
                    while (n > 0) {
                        list.add(this.readString());
                        --n;
                    }
                    break;
                }
                case 2: {
                    while (n > 0) {
                        list.add(this.readParcelable());
                        --n;
                    }
                    break;
                }
                case 1: {
                    while (n > 0) {
                        list.add(this.readVersionedParcelable());
                        --n;
                    }
                    break;
                }
                case 3: {
                    while (n > 0) {
                        list.add(this.readSerializable());
                        --n;
                    }
                    break;
                }
                case 5: {
                    while (n > 0) {
                        list.add(this.readStrongBinder());
                        --n;
                    }
                    break;
                }
            }
        }
        return list.toArray(def);
    }

    @Nullable
    public <T extends VersionedParcelable> T readVersionedParcelable(@Nullable T def, int fieldId) {
        if (!this.readField(fieldId)) {
            return def;
        }
        return this.readVersionedParcelable();
    }

    @Nullable
    protected <T extends VersionedParcelable> T readVersionedParcelable() {
        String name = this.readString();
        if (name == null) {
            return null;
        }
        return this.readFromParcel(name, this.createSubParcel());
    }

    @Nullable
    protected Serializable readSerializable() {
        String name = this.readString();
        if (name == null) {
            return null;
        }
        byte[] serializedData = this.readByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedData);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
                    Class<?> c = Class.forName(osClass.getName(), false, this.getClass().getClassLoader());
                    if (c != null) {
                        return c;
                    }
                    return super.resolveClass(osClass);
                }
            };
            return (Serializable)ois.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to read Serializable object (name = " + name + ")", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Unable to read Serializable object (name = " + name + ")", cnfe);
        }
    }

    @NonNull
    protected <T extends VersionedParcelable> T readFromParcel(@NonNull String parcelCls, @NonNull VersionedParcel versionedParcel) {
        try {
            Method m = this.getReadMethod(parcelCls);
            return (T)((VersionedParcelable)m.invoke(null, versionedParcel));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T extends VersionedParcelable> void writeToParcel(@NonNull T val, @NonNull VersionedParcel versionedParcel) {
        try {
            Method m = this.getWriteMethod(val.getClass());
            m.invoke(null, val, versionedParcel);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    private Method getReadMethod(@NonNull String parcelCls) throws IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        Method m = (Method)this.mReadCache.get((Object)parcelCls);
        if (m == null) {
            Class<?> cls = Class.forName(parcelCls, true, VersionedParcel.class.getClassLoader());
            m = cls.getDeclaredMethod("read", VersionedParcel.class);
            this.mReadCache.put((Object)parcelCls, (Object)m);
        }
        return m;
    }

    @NonNull
    private Method getWriteMethod(@NonNull Class<?> baseCls) throws IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        Method m = (Method)this.mWriteCache.get((Object)baseCls.getName());
        if (m == null) {
            Class<?> cls = this.findParcelClass(baseCls);
            m = cls.getDeclaredMethod("write", baseCls, VersionedParcel.class);
            this.mWriteCache.put((Object)baseCls.getName(), (Object)m);
        }
        return m;
    }

    @NonNull
    private Class<?> findParcelClass(@NonNull Class<?> cls) throws ClassNotFoundException {
        Class<?> ret = (Class<?>)this.mParcelizerCache.get((Object)cls.getName());
        if (ret == null) {
            String pkg = cls.getPackage().getName();
            String c = String.format("%s.%sParcelizer", pkg, cls.getSimpleName());
            ret = Class.forName(c, false, cls.getClassLoader());
            this.mParcelizerCache.put((Object)cls.getName(), ret);
        }
        return ret;
    }

    @RequiresApi(value=21)
    private static final class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static void writeSize(@NonNull VersionedParcel self, @Nullable Size val) {
            self.writeBoolean(val != null);
            if (val != null) {
                self.writeInt(val.getWidth());
                self.writeInt(val.getHeight());
            }
        }

        @DoNotInline
        static void writeSizeF(@NonNull VersionedParcel self, @Nullable SizeF val) {
            self.writeBoolean(val != null);
            if (val != null) {
                self.writeFloat(val.getWidth());
                self.writeFloat(val.getHeight());
            }
        }

        @DoNotInline
        @Nullable
        static Size readSize(@NonNull VersionedParcel self) {
            if (self.readBoolean()) {
                int width = self.readInt();
                int height = self.readInt();
                return new Size(width, height);
            }
            return null;
        }

        @DoNotInline
        @Nullable
        static SizeF readSizeF(@NonNull VersionedParcel self) {
            if (self.readBoolean()) {
                float width = self.readFloat();
                float height = self.readFloat();
                return new SizeF(width, height);
            }
            return null;
        }
    }

    public static class ParcelException
    extends RuntimeException {
        public ParcelException(@Nullable Throwable source) {
            super(source);
        }
    }
}

