/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.io.Closeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CountDownLatch;

public final class PendingIntentCompat {
    @NonNull
    public static PendingIntent getActivities(@NonNull Context context, int requestCode, @NonNull @SuppressLint(value={"ArrayReturn"}) Intent[] intents, int flags, @Nullable Bundle options, boolean isMutable) {
        return PendingIntent.getActivities((Context)context, (int)requestCode, (Intent[])intents, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags), (Bundle)options);
    }

    @NonNull
    public static PendingIntent getActivities(@NonNull Context context, int requestCode, @NonNull @SuppressLint(value={"ArrayReturn"}) Intent[] intents, int flags, boolean isMutable) {
        return PendingIntent.getActivities((Context)context, (int)requestCode, (Intent[])intents, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @Nullable
    public static PendingIntent getActivity(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @Nullable
    public static PendingIntent getActivity(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, @Nullable Bundle options, boolean isMutable) {
        return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags), (Bundle)options);
    }

    @Nullable
    public static PendingIntent getBroadcast(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @RequiresApi(value=26)
    @NonNull
    public static PendingIntent getForegroundService(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        return Api26Impl.getForegroundService(context, requestCode, intent, PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @Nullable
    public static PendingIntent getService(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        return PendingIntent.getService((Context)context, (int)requestCode, (Intent)intent, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @SuppressLint(value={"LambdaLast"})
    public static void send(@NonNull PendingIntent pendingIntent, int code, @Nullable PendingIntent.OnFinished onFinished, @Nullable Handler handler) throws PendingIntent.CanceledException {
        try (GatedCallback gatedCallback = new GatedCallback(onFinished);){
            pendingIntent.send(code, gatedCallback.getCallback(), handler);
            gatedCallback.complete();
        }
    }

    @SuppressLint(value={"LambdaLast"})
    public static void send(@NonNull PendingIntent pendingIntent, @SuppressLint(value={"ContextFirst"}) @NonNull Context context, int code, @NonNull Intent intent, @Nullable PendingIntent.OnFinished onFinished, @Nullable Handler handler) throws PendingIntent.CanceledException {
        PendingIntentCompat.send(pendingIntent, context, code, intent, onFinished, handler, null, null);
    }

    @SuppressLint(value={"LambdaLast"})
    public static void send(@NonNull PendingIntent pendingIntent, @SuppressLint(value={"ContextFirst"}) @NonNull Context context, int code, @NonNull Intent intent, @Nullable PendingIntent.OnFinished onFinished, @Nullable Handler handler, @Nullable String requiredPermissions, @Nullable Bundle options) throws PendingIntent.CanceledException {
        try (GatedCallback gatedCallback = new GatedCallback(onFinished);){
            if (Build.VERSION.SDK_INT >= 23) {
                Api23Impl.send(pendingIntent, context, code, intent, onFinished, handler, requiredPermissions, options);
            } else {
                pendingIntent.send(context, code, intent, gatedCallback.getCallback(), handler, requiredPermissions);
            }
            gatedCallback.complete();
        }
    }

    private static int addMutabilityFlags(boolean isMutable, int flags) {
        if (isMutable) {
            if (Build.VERSION.SDK_INT >= 31) {
                flags |= 0x2000000;
            }
        } else if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        return flags;
    }

    private PendingIntentCompat() {
    }

    @RequiresApi(value=26)
    private static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        public static PendingIntent getForegroundService(Context context, int requestCode, Intent intent, int flags) {
            return PendingIntent.getForegroundService((Context)context, (int)requestCode, (Intent)intent, (int)flags);
        }
    }

    private static class GatedCallback
    implements Closeable {
        private final CountDownLatch mComplete = new CountDownLatch(1);
        @Nullable
        private PendingIntent.OnFinished mCallback;
        private boolean mSuccess;

        GatedCallback(@Nullable PendingIntent.OnFinished callback) {
            this.mCallback = callback;
            this.mSuccess = false;
        }

        @Nullable
        public PendingIntent.OnFinished getCallback() {
            if (this.mCallback == null) {
                return null;
            }
            return this::onSendFinished;
        }

        public void complete() {
            this.mSuccess = true;
        }

        @Override
        public void close() {
            if (!this.mSuccess) {
                this.mCallback = null;
            }
            this.mComplete.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            boolean interrupted = false;
            try {
                while (true) {
                    try {
                        this.mComplete.await();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.mCallback != null) {
                this.mCallback.onSendFinished(pendingIntent, intent, resultCode, resultData, resultExtras);
                this.mCallback = null;
            }
        }
    }

    @RequiresApi(value=23)
    private static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        public static void send(@NonNull PendingIntent pendingIntent, @NonNull Context context, int code, @NonNull Intent intent, @Nullable PendingIntent.OnFinished onFinished, @Nullable Handler handler, @Nullable String requiredPermission, @Nullable Bundle options) throws PendingIntent.CanceledException {
            pendingIntent.send(context, code, intent, onFinished, handler, requiredPermission, options);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface Flags {
    }
}

