/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Activity;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcelable;
import android.text.Html;
import android.text.Spanned;
import android.util.Log;
import android.view.ActionProvider;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ShareActionProvider;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.util.Preconditions;
import java.util.ArrayList;

public final class ShareCompat {
    public static final String EXTRA_CALLING_PACKAGE = "androidx.core.app.EXTRA_CALLING_PACKAGE";
    public static final String EXTRA_CALLING_PACKAGE_INTEROP = "android.support.v4.app.EXTRA_CALLING_PACKAGE";
    public static final String EXTRA_CALLING_ACTIVITY = "androidx.core.app.EXTRA_CALLING_ACTIVITY";
    public static final String EXTRA_CALLING_ACTIVITY_INTEROP = "android.support.v4.app.EXTRA_CALLING_ACTIVITY";
    private static final String HISTORY_FILENAME_PREFIX = ".sharecompat_";

    private ShareCompat() {
    }

    @Nullable
    public static String getCallingPackage(@NonNull Activity calledActivity) {
        Intent intent = calledActivity.getIntent();
        String result = calledActivity.getCallingPackage();
        if (result == null && intent != null) {
            result = ShareCompat.getCallingPackage(intent);
        }
        return result;
    }

    @Nullable
    static String getCallingPackage(@NonNull Intent intent) {
        String result = intent.getStringExtra(EXTRA_CALLING_PACKAGE);
        if (result == null) {
            result = intent.getStringExtra(EXTRA_CALLING_PACKAGE_INTEROP);
        }
        return result;
    }

    @Nullable
    public static ComponentName getCallingActivity(@NonNull Activity calledActivity) {
        Intent intent = calledActivity.getIntent();
        ComponentName result = calledActivity.getCallingActivity();
        if (result == null) {
            result = ShareCompat.getCallingActivity(intent);
        }
        return result;
    }

    @Nullable
    static ComponentName getCallingActivity(@NonNull Intent intent) {
        ComponentName result = (ComponentName)intent.getParcelableExtra(EXTRA_CALLING_ACTIVITY);
        if (result == null) {
            result = (ComponentName)intent.getParcelableExtra(EXTRA_CALLING_ACTIVITY_INTEROP);
        }
        return result;
    }

    @Deprecated
    public static void configureMenuItem(@NonNull MenuItem item, @NonNull IntentBuilder shareIntent) {
        ActionProvider itemProvider = item.getActionProvider();
        ShareActionProvider provider = !(itemProvider instanceof ShareActionProvider) ? new ShareActionProvider(shareIntent.getContext()) : (ShareActionProvider)itemProvider;
        provider.setShareHistoryFileName(HISTORY_FILENAME_PREFIX + shareIntent.getContext().getClass().getName());
        provider.setShareIntent(shareIntent.getIntent());
        item.setActionProvider((ActionProvider)provider);
    }

    @Deprecated
    public static void configureMenuItem(@NonNull Menu menu, @IdRes int menuItemId, @NonNull IntentBuilder shareIntent) {
        MenuItem item = menu.findItem(menuItemId);
        if (item == null) {
            throw new IllegalArgumentException("Could not find menu item with id " + menuItemId + " in the supplied menu");
        }
        ShareCompat.configureMenuItem(item, shareIntent);
    }

    static void migrateExtraStreamToClipData(@NonNull Intent intent, @NonNull ArrayList<Uri> streams) {
        CharSequence text = intent.getCharSequenceExtra("android.intent.extra.TEXT");
        String htmlText = intent.getStringExtra("android.intent.extra.HTML_TEXT");
        ClipData clipData = new ClipData(null, new String[]{intent.getType()}, new ClipData.Item(text, htmlText, null, streams.get(0)));
        int end = streams.size();
        for (int i = 1; i < end; ++i) {
            Uri uri = streams.get(i);
            clipData.addItem(new ClipData.Item(uri));
        }
        intent.setClipData(clipData);
        intent.addFlags(1);
    }

    public static class IntentBuilder {
        @NonNull
        private final Context mContext;
        @NonNull
        private final Intent mIntent;
        @Nullable
        private CharSequence mChooserTitle;
        @Nullable
        private ArrayList<String> mToAddresses;
        @Nullable
        private ArrayList<String> mCcAddresses;
        @Nullable
        private ArrayList<String> mBccAddresses;
        @Nullable
        private ArrayList<Uri> mStreams;

        @Deprecated
        @NonNull
        public static IntentBuilder from(@NonNull Activity launchingActivity) {
            return new IntentBuilder((Context)launchingActivity);
        }

        public IntentBuilder(@NonNull Context launchingContext) {
            this.mContext = Preconditions.checkNotNull(launchingContext);
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
            this.mIntent.putExtra(ShareCompat.EXTRA_CALLING_PACKAGE, launchingContext.getPackageName());
            this.mIntent.putExtra(ShareCompat.EXTRA_CALLING_PACKAGE_INTEROP, launchingContext.getPackageName());
            this.mIntent.addFlags(524288);
            Activity activity = null;
            Context context = launchingContext;
            while (context instanceof ContextWrapper) {
                if (context instanceof Activity) {
                    activity = (Activity)context;
                    break;
                }
                context = ((ContextWrapper)context).getBaseContext();
            }
            if (activity != null) {
                ComponentName componentName = activity.getComponentName();
                this.mIntent.putExtra(ShareCompat.EXTRA_CALLING_ACTIVITY, (Parcelable)componentName);
                this.mIntent.putExtra(ShareCompat.EXTRA_CALLING_ACTIVITY_INTEROP, (Parcelable)componentName);
            }
        }

        @NonNull
        public Intent getIntent() {
            boolean needsSendMultiple;
            if (this.mToAddresses != null) {
                this.combineArrayExtra("android.intent.extra.EMAIL", this.mToAddresses);
                this.mToAddresses = null;
            }
            if (this.mCcAddresses != null) {
                this.combineArrayExtra("android.intent.extra.CC", this.mCcAddresses);
                this.mCcAddresses = null;
            }
            if (this.mBccAddresses != null) {
                this.combineArrayExtra("android.intent.extra.BCC", this.mBccAddresses);
                this.mBccAddresses = null;
            }
            boolean bl = needsSendMultiple = this.mStreams != null && this.mStreams.size() > 1;
            if (!needsSendMultiple) {
                this.mIntent.setAction("android.intent.action.SEND");
                if (this.mStreams != null && !this.mStreams.isEmpty()) {
                    this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)this.mStreams.get(0));
                    ShareCompat.migrateExtraStreamToClipData(this.mIntent, this.mStreams);
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                    this.mIntent.setClipData(null);
                    this.mIntent.setFlags(this.mIntent.getFlags() & 0xFFFFFFFE);
                }
            } else {
                this.mIntent.setAction("android.intent.action.SEND_MULTIPLE");
                this.mIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.mStreams);
                ShareCompat.migrateExtraStreamToClipData(this.mIntent, this.mStreams);
            }
            return this.mIntent;
        }

        @NonNull
        Context getContext() {
            return this.mContext;
        }

        private void combineArrayExtra(String extra, ArrayList<String> add) {
            String[] currentAddresses = this.mIntent.getStringArrayExtra(extra);
            int currentLength = currentAddresses != null ? currentAddresses.length : 0;
            String[] finalAddresses = new String[currentLength + add.size()];
            add.toArray(finalAddresses);
            if (currentAddresses != null) {
                System.arraycopy(currentAddresses, 0, finalAddresses, add.size(), currentLength);
            }
            this.mIntent.putExtra(extra, finalAddresses);
        }

        private void combineArrayExtra(@Nullable String extra, @NonNull String[] add) {
            Intent intent = this.getIntent();
            String[] old = intent.getStringArrayExtra(extra);
            int oldLength = old != null ? old.length : 0;
            String[] result = new String[oldLength + add.length];
            if (old != null) {
                System.arraycopy(old, 0, result, 0, oldLength);
            }
            System.arraycopy(add, 0, result, oldLength, add.length);
            intent.putExtra(extra, result);
        }

        @NonNull
        public Intent createChooserIntent() {
            return Intent.createChooser((Intent)this.getIntent(), (CharSequence)this.mChooserTitle);
        }

        public void startChooser() {
            this.mContext.startActivity(this.createChooserIntent());
        }

        @NonNull
        public IntentBuilder setChooserTitle(@Nullable CharSequence title) {
            this.mChooserTitle = title;
            return this;
        }

        @NonNull
        public IntentBuilder setChooserTitle(@StringRes int resId) {
            return this.setChooserTitle(this.mContext.getText(resId));
        }

        @NonNull
        public IntentBuilder setType(@Nullable String mimeType) {
            this.mIntent.setType(mimeType);
            return this;
        }

        @NonNull
        public IntentBuilder setText(@Nullable CharSequence text) {
            this.mIntent.putExtra("android.intent.extra.TEXT", text);
            return this;
        }

        @NonNull
        public IntentBuilder setHtmlText(@Nullable String htmlText) {
            this.mIntent.putExtra("android.intent.extra.HTML_TEXT", htmlText);
            if (!this.mIntent.hasExtra("android.intent.extra.TEXT")) {
                this.setText((CharSequence)Html.fromHtml((String)htmlText));
            }
            return this;
        }

        @NonNull
        public IntentBuilder setStream(@Nullable Uri streamUri) {
            this.mStreams = null;
            if (streamUri != null) {
                this.addStream(streamUri);
            }
            return this;
        }

        @NonNull
        public IntentBuilder addStream(@NonNull Uri streamUri) {
            if (this.mStreams == null) {
                this.mStreams = new ArrayList();
            }
            this.mStreams.add(streamUri);
            return this;
        }

        @NonNull
        public IntentBuilder setEmailTo(@Nullable String[] addresses) {
            if (this.mToAddresses != null) {
                this.mToAddresses = null;
            }
            this.mIntent.putExtra("android.intent.extra.EMAIL", addresses);
            return this;
        }

        @NonNull
        public IntentBuilder addEmailTo(@NonNull String address) {
            if (this.mToAddresses == null) {
                this.mToAddresses = new ArrayList();
            }
            this.mToAddresses.add(address);
            return this;
        }

        @NonNull
        public IntentBuilder addEmailTo(@NonNull String[] addresses) {
            this.combineArrayExtra("android.intent.extra.EMAIL", addresses);
            return this;
        }

        @NonNull
        public IntentBuilder setEmailCc(@Nullable String[] addresses) {
            this.mIntent.putExtra("android.intent.extra.CC", addresses);
            return this;
        }

        @NonNull
        public IntentBuilder addEmailCc(@NonNull String address) {
            if (this.mCcAddresses == null) {
                this.mCcAddresses = new ArrayList();
            }
            this.mCcAddresses.add(address);
            return this;
        }

        @NonNull
        public IntentBuilder addEmailCc(@NonNull String[] addresses) {
            this.combineArrayExtra("android.intent.extra.CC", addresses);
            return this;
        }

        @NonNull
        public IntentBuilder setEmailBcc(@Nullable String[] addresses) {
            this.mIntent.putExtra("android.intent.extra.BCC", addresses);
            return this;
        }

        @NonNull
        public IntentBuilder addEmailBcc(@NonNull String address) {
            if (this.mBccAddresses == null) {
                this.mBccAddresses = new ArrayList();
            }
            this.mBccAddresses.add(address);
            return this;
        }

        @NonNull
        public IntentBuilder addEmailBcc(@NonNull String[] addresses) {
            this.combineArrayExtra("android.intent.extra.BCC", addresses);
            return this;
        }

        @NonNull
        public IntentBuilder setSubject(@Nullable String subject) {
            this.mIntent.putExtra("android.intent.extra.SUBJECT", subject);
            return this;
        }
    }

    public static class IntentReader {
        private static final String TAG = "IntentReader";
        @NonNull
        private final Context mContext;
        @NonNull
        private final Intent mIntent;
        @Nullable
        private final String mCallingPackage;
        @Nullable
        private final ComponentName mCallingActivity;
        @Nullable
        private ArrayList<Uri> mStreams;

        @Deprecated
        @NonNull
        public static IntentReader from(@NonNull Activity activity) {
            return new IntentReader(activity);
        }

        public IntentReader(@NonNull Activity activity) {
            this((Context)Preconditions.checkNotNull(activity), activity.getIntent());
        }

        public IntentReader(@NonNull Context context, @NonNull Intent intent) {
            this.mContext = Preconditions.checkNotNull(context);
            this.mIntent = Preconditions.checkNotNull(intent);
            this.mCallingPackage = ShareCompat.getCallingPackage(intent);
            this.mCallingActivity = ShareCompat.getCallingActivity(intent);
        }

        public boolean isShareIntent() {
            String action = this.mIntent.getAction();
            return "android.intent.action.SEND".equals(action) || "android.intent.action.SEND_MULTIPLE".equals(action);
        }

        public boolean isSingleShare() {
            return "android.intent.action.SEND".equals(this.mIntent.getAction());
        }

        public boolean isMultipleShare() {
            return "android.intent.action.SEND_MULTIPLE".equals(this.mIntent.getAction());
        }

        @Nullable
        public String getType() {
            return this.mIntent.getType();
        }

        @Nullable
        public CharSequence getText() {
            return this.mIntent.getCharSequenceExtra("android.intent.extra.TEXT");
        }

        @Nullable
        public String getHtmlText() {
            String result = this.mIntent.getStringExtra("android.intent.extra.HTML_TEXT");
            if (result == null) {
                CharSequence text = this.getText();
                if (text instanceof Spanned) {
                    result = Html.toHtml((Spanned)((Spanned)text));
                } else if (text != null) {
                    result = Html.escapeHtml((CharSequence)text);
                }
            }
            return result;
        }

        @Nullable
        public Uri getStream() {
            return (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
        }

        @Nullable
        public Uri getStream(int index) {
            if (this.mStreams == null && this.isMultipleShare()) {
                this.mStreams = this.mIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
            }
            if (this.mStreams != null) {
                return this.mStreams.get(index);
            }
            if (index == 0) {
                return (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
            }
            throw new IndexOutOfBoundsException("Stream items available: " + this.getStreamCount() + " index requested: " + index);
        }

        public int getStreamCount() {
            if (this.mStreams == null && this.isMultipleShare()) {
                this.mStreams = this.mIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
            }
            if (this.mStreams != null) {
                return this.mStreams.size();
            }
            return this.mIntent.hasExtra("android.intent.extra.STREAM") ? 1 : 0;
        }

        @Nullable
        public String[] getEmailTo() {
            return this.mIntent.getStringArrayExtra("android.intent.extra.EMAIL");
        }

        @Nullable
        public String[] getEmailCc() {
            return this.mIntent.getStringArrayExtra("android.intent.extra.CC");
        }

        @Nullable
        public String[] getEmailBcc() {
            return this.mIntent.getStringArrayExtra("android.intent.extra.BCC");
        }

        @Nullable
        public String getSubject() {
            return this.mIntent.getStringExtra("android.intent.extra.SUBJECT");
        }

        @Nullable
        public String getCallingPackage() {
            return this.mCallingPackage;
        }

        @Nullable
        public ComponentName getCallingActivity() {
            return this.mCallingActivity;
        }

        @Nullable
        public Drawable getCallingActivityIcon() {
            if (this.mCallingActivity == null) {
                return null;
            }
            PackageManager pm = this.mContext.getPackageManager();
            try {
                return pm.getActivityIcon(this.mCallingActivity);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)"Could not retrieve icon for calling activity", (Throwable)e);
                return null;
            }
        }

        @Nullable
        public Drawable getCallingApplicationIcon() {
            if (this.mCallingPackage == null) {
                return null;
            }
            PackageManager pm = this.mContext.getPackageManager();
            try {
                return pm.getApplicationIcon(this.mCallingPackage);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)"Could not retrieve icon for calling application", (Throwable)e);
                return null;
            }
        }

        @Nullable
        public CharSequence getCallingApplicationLabel() {
            if (this.mCallingPackage == null) {
                return null;
            }
            PackageManager pm = this.mContext.getPackageManager();
            try {
                return pm.getApplicationLabel(pm.getApplicationInfo(this.mCallingPackage, 0));
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)"Could not retrieve label for calling application", (Throwable)e);
                return null;
            }
        }
    }
}

