/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.PackageManagerCompat;
import androidx.core.util.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;

public final class IntentCompat {
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CREATE_REMINDER = "android.intent.action.CREATE_REMINDER";
    public static final String EXTRA_HTML_TEXT = "android.intent.extra.HTML_TEXT";
    public static final String EXTRA_START_PLAYBACK = "android.intent.extra.START_PLAYBACK";
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_TIME = "android.intent.extra.TIME";
    public static final String CATEGORY_LEANBACK_LAUNCHER = "android.intent.category.LEANBACK_LAUNCHER";

    private IntentCompat() {
    }

    @NonNull
    public static Intent makeMainSelectorActivity(@NonNull String selectorAction, @NonNull String selectorCategory) {
        return Intent.makeMainSelectorActivity((String)selectorAction, (String)selectorCategory);
    }

    @NonNull
    public static Intent createManageUnusedAppRestrictionsIntent(@NonNull Context context, @NonNull String packageName) {
        if (!PackageManagerCompat.areUnusedAppRestrictionsAvailable(context.getPackageManager())) {
            throw new UnsupportedOperationException("Unused App Restriction features are not available on this device");
        }
        if (Build.VERSION.SDK_INT >= 31) {
            return new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts((String)"package", (String)packageName, null));
        }
        Intent permissionRevocationSettingsIntent = new Intent("android.intent.action.AUTO_REVOKE_PERMISSIONS").setData(Uri.fromParts((String)"package", (String)packageName, null));
        if (Build.VERSION.SDK_INT >= 30) {
            return permissionRevocationSettingsIntent;
        }
        String verifierPackageName = PackageManagerCompat.getPermissionRevocationVerifierApp(context.getPackageManager());
        return permissionRevocationSettingsIntent.setPackage(Preconditions.checkNotNull(verifierPackageName));
    }

    @Nullable
    public static <T> T getParcelableExtra(@NonNull Intent in, @Nullable String name, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelableExtra(in, name, clazz);
        }
        Parcelable extra = in.getParcelableExtra(name);
        return (T)(clazz.isInstance(extra) ? extra : null);
    }

    @Nullable
    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    public static Parcelable[] getParcelableArrayExtra(@NonNull Intent in, @Nullable String name, @NonNull Class<? extends Parcelable> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelableArrayExtra(in, name, clazz);
        }
        return in.getParcelableArrayExtra(name);
    }

    @Nullable
    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    public static <T> ArrayList<T> getParcelableArrayListExtra(@NonNull Intent in, @Nullable String name, @NonNull Class<? extends T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelableArrayListExtra(in, name, clazz);
        }
        return in.getParcelableArrayListExtra(name);
    }

    @Nullable
    public static <T extends Serializable> T getSerializableExtra(@NonNull Intent in, @Nullable String key, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getSerializableExtra(in, key, clazz);
        }
        Serializable serializable = in.getSerializableExtra(key);
        return (T)(clazz.isInstance(serializable) ? serializable : null);
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        @DoNotInline
        static <T> T getParcelableExtra(@NonNull Intent in, @Nullable String name, @NonNull Class<T> clazz) {
            return (T)in.getParcelableExtra(name, clazz);
        }

        @DoNotInline
        static <T> T[] getParcelableArrayExtra(@NonNull Intent in, @Nullable String name, @NonNull Class<T> clazz) {
            return in.getParcelableArrayExtra(name, clazz);
        }

        @DoNotInline
        static <T> ArrayList<T> getParcelableArrayListExtra(@NonNull Intent in, @Nullable String name, @NonNull Class<? extends T> clazz) {
            return in.getParcelableArrayListExtra(name, clazz);
        }

        @DoNotInline
        static <T extends Serializable> T getSerializableExtra(@NonNull Intent in, @Nullable String name, @NonNull Class<T> clazz) {
            return (T)in.getSerializableExtra(name, clazz);
        }
    }
}

