/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import androidx.core.util.Predicate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IntentSanitizer {
    private static final String TAG = "IntentSanitizer";
    private int mAllowedFlags;
    private Predicate<String> mAllowedActions;
    private Predicate<Uri> mAllowedData;
    private Predicate<String> mAllowedTypes;
    private Predicate<String> mAllowedCategories;
    private Predicate<String> mAllowedPackages;
    private Predicate<ComponentName> mAllowedComponents;
    private boolean mAllowAnyComponent;
    private Map<String, Predicate<Object>> mAllowedExtras;
    private boolean mAllowClipDataText;
    private Predicate<Uri> mAllowedClipDataUri;
    private Predicate<ClipData> mAllowedClipData;
    private boolean mAllowIdentifier;
    private boolean mAllowSelector;
    private boolean mAllowSourceBounds;

    private IntentSanitizer() {
    }

    @NonNull
    public Intent sanitizeByFiltering(@NonNull Intent in) {
        return this.sanitize(in, msg -> {});
    }

    @NonNull
    public Intent sanitizeByThrowing(@NonNull Intent in) {
        return this.sanitize(in, msg -> {
            throw new SecurityException((String)msg);
        });
    }

    @NonNull
    public Intent sanitize(@NonNull Intent in, @NonNull Consumer<String> penalty) {
        Bundle extras;
        Intent intent = new Intent();
        ComponentName componentName = in.getComponent();
        if (this.mAllowAnyComponent && componentName == null || this.mAllowedComponents.test(componentName)) {
            intent.setComponent(componentName);
        } else {
            penalty.accept("Component is not allowed: " + componentName);
            intent.setComponent(new ComponentName("android", "java.lang.Void"));
        }
        String packageName = in.getPackage();
        if (packageName == null || this.mAllowedPackages.test(packageName)) {
            intent.setPackage(packageName);
        } else {
            penalty.accept("Package is not allowed: " + packageName);
        }
        if ((this.mAllowedFlags | in.getFlags()) == this.mAllowedFlags) {
            intent.setFlags(in.getFlags());
        } else {
            intent.setFlags(this.mAllowedFlags & in.getFlags());
            penalty.accept("The intent contains flags that are not allowed: 0x" + Integer.toHexString(in.getFlags() & ~this.mAllowedFlags));
        }
        String action = in.getAction();
        if (action == null || this.mAllowedActions.test(action)) {
            intent.setAction(action);
        } else {
            penalty.accept("Action is not allowed: " + action);
        }
        Uri data = in.getData();
        if (data == null || this.mAllowedData.test(data)) {
            intent.setData(data);
        } else {
            penalty.accept("Data is not allowed: " + data);
        }
        String type = in.getType();
        if (type == null || this.mAllowedTypes.test(type)) {
            intent.setDataAndType(intent.getData(), type);
        } else {
            penalty.accept("Type is not allowed: " + type);
        }
        Set categories = in.getCategories();
        if (categories != null) {
            for (String category : categories) {
                if (this.mAllowedCategories.test(category)) {
                    intent.addCategory(category);
                    continue;
                }
                penalty.accept("Category is not allowed: " + category);
            }
        }
        if ((extras = in.getExtras()) != null) {
            for (String key : extras.keySet()) {
                if (key.equals("android.intent.extra.STREAM") && (this.mAllowedFlags & 1) == 0) {
                    penalty.accept("Allowing Extra Stream requires also allowing at least  FLAG_GRANT_READ_URI_PERMISSION Flag.");
                    continue;
                }
                if (key.equals("output") && (~this.mAllowedFlags & 3) != 0) {
                    penalty.accept("Allowing Extra Output requires also allowing FLAG_GRANT_READ_URI_PERMISSION and FLAG_GRANT_WRITE_URI_PERMISSION Flags.");
                    continue;
                }
                Object value = extras.get(key);
                Predicate<Object> test = this.mAllowedExtras.get(key);
                if (test != null && test.test(value)) {
                    this.putExtra(intent, key, value);
                    continue;
                }
                penalty.accept("Extra is not allowed. Key: " + key + ". Value: " + value);
            }
        }
        IntentSanitizer.sanitizeClipData(in, intent, this.mAllowedClipData, this.mAllowClipDataText, this.mAllowedClipDataUri, penalty);
        if (Build.VERSION.SDK_INT >= 29) {
            if (this.mAllowIdentifier) {
                Api29Impl.setIdentifier(intent, Api29Impl.getIdentifier(in));
            } else if (Api29Impl.getIdentifier(in) != null) {
                penalty.accept("Identifier is not allowed: " + Api29Impl.getIdentifier(in));
            }
        }
        if (this.mAllowSelector) {
            intent.setSelector(in.getSelector());
        } else if (in.getSelector() != null) {
            penalty.accept("Selector is not allowed: " + in.getSelector());
        }
        if (this.mAllowSourceBounds) {
            intent.setSourceBounds(in.getSourceBounds());
        } else if (in.getSourceBounds() != null) {
            penalty.accept("SourceBounds is not allowed: " + in.getSourceBounds());
        }
        return intent;
    }

    private void putExtra(Intent intent, String key, Object value) {
        if (value == null) {
            intent.getExtras().putString(key, null);
        } else if (value instanceof Parcelable) {
            intent.putExtra(key, (Parcelable)value);
        } else if (value instanceof Parcelable[]) {
            intent.putExtra(key, (Parcelable[])value);
        } else if (value instanceof Serializable) {
            intent.putExtra(key, (Serializable)value);
        } else {
            throw new IllegalArgumentException("Unsupported type " + value.getClass());
        }
    }

    static void sanitizeClipData(@NonNull Intent in, Intent out, Predicate<ClipData> mAllowedClipData, boolean mAllowClipDataText, Predicate<Uri> mAllowedClipDataUri, Consumer<String> penalty) {
        ClipData clipData = in.getClipData();
        if (clipData == null) {
            return;
        }
        ClipData newClipData = null;
        if (mAllowedClipData != null && mAllowedClipData.test(clipData)) {
            out.setClipData(clipData);
        } else {
            for (int i = 0; i < clipData.getItemCount(); ++i) {
                ClipData.Item item = clipData.getItemAt(i);
                if (Build.VERSION.SDK_INT >= 31) {
                    Api31Impl.checkOtherMembers(i, item, penalty);
                } else {
                    IntentSanitizer.checkOtherMembers(i, item, penalty);
                }
                CharSequence itemText = null;
                if (mAllowClipDataText) {
                    itemText = item.getText();
                } else if (item.getText() != null) {
                    penalty.accept("Item text cannot contain value. Item position: " + i + ". Text: " + item.getText());
                }
                Uri itemUri = null;
                if (mAllowedClipDataUri == null) {
                    if (item.getUri() != null) {
                        penalty.accept("Item URI is not allowed. Item position: " + i + ". URI: " + item.getUri());
                    }
                } else if (item.getUri() == null || mAllowedClipDataUri.test(item.getUri())) {
                    itemUri = item.getUri();
                } else {
                    penalty.accept("Item URI is not allowed. Item position: " + i + ". URI: " + item.getUri());
                }
                if (itemText == null && itemUri == null) continue;
                if (newClipData == null) {
                    newClipData = new ClipData(clipData.getDescription(), new ClipData.Item(itemText, null, itemUri));
                    continue;
                }
                newClipData.addItem(new ClipData.Item(itemText, null, itemUri));
            }
            if (newClipData != null) {
                out.setClipData(newClipData);
            }
        }
    }

    private static void checkOtherMembers(int i, ClipData.Item item, Consumer<String> penalty) {
        if (item.getHtmlText() != null || item.getIntent() != null) {
            penalty.accept("ClipData item at position " + i + " contains htmlText, textLinks or intent: " + item);
        }
    }

    @RequiresApi(value=29)
    private static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static Intent setIdentifier(Intent intent, String identifier) {
            return intent.setIdentifier(identifier);
        }

        @DoNotInline
        static String getIdentifier(Intent intent) {
            return intent.getIdentifier();
        }
    }

    @RequiresApi(value=31)
    private static class Api31Impl {
        private Api31Impl() {
        }

        @DoNotInline
        static void checkOtherMembers(int i, ClipData.Item item, Consumer<String> penalty) {
            if (item.getHtmlText() != null || item.getIntent() != null || item.getTextLinks() != null) {
                penalty.accept("ClipData item at position " + i + " contains htmlText, textLinks or intent: " + item);
            }
        }
    }

    public static final class Builder {
        private static final int HISTORY_STACK_FLAGS = 2112614400;
        private static final int RECEIVER_FLAGS = 2015363072;
        private int mAllowedFlags;
        private Predicate<String> mAllowedActions = v -> false;
        private Predicate<Uri> mAllowedData = v -> false;
        private Predicate<String> mAllowedTypes = v -> false;
        private Predicate<String> mAllowedCategories = v -> false;
        private Predicate<String> mAllowedPackages = v -> false;
        private Predicate<ComponentName> mAllowedComponents = v -> false;
        private boolean mAllowAnyComponent;
        private boolean mAllowSomeComponents;
        private Map<String, Predicate<Object>> mAllowedExtras = new HashMap<String, Predicate<Object>>();
        private boolean mAllowClipDataText = false;
        private Predicate<Uri> mAllowedClipDataUri = v -> false;
        private Predicate<ClipData> mAllowedClipData = v -> false;
        private boolean mAllowIdentifier;
        private boolean mAllowSelector;
        private boolean mAllowSourceBounds;

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowFlags(int flags) {
            this.mAllowedFlags |= flags;
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowHistoryStackFlags() {
            this.mAllowedFlags |= 0x7DEBF000;
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowReceiverFlags() {
            this.mAllowedFlags |= 0x78200000;
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowAction(@NonNull String action) {
            Preconditions.checkNotNull(action);
            this.allowAction(action::equals);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowAction(@NonNull Predicate<String> filter) {
            Preconditions.checkNotNull(filter);
            this.mAllowedActions = this.mAllowedActions.or(filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowDataWithAuthority(@NonNull String authority) {
            Preconditions.checkNotNull(authority);
            this.allowData(v -> authority.equals(v.getAuthority()));
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowData(@NonNull Predicate<Uri> filter) {
            Preconditions.checkNotNull(filter);
            this.mAllowedData = this.mAllowedData.or(filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowType(@NonNull String type) {
            Preconditions.checkNotNull(type);
            return this.allowType(type::equals);
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowType(@NonNull Predicate<String> filter) {
            Preconditions.checkNotNull(filter);
            this.mAllowedTypes = this.mAllowedTypes.or(filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowCategory(@NonNull String category) {
            Preconditions.checkNotNull(category);
            return this.allowCategory(category::equals);
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowCategory(@NonNull Predicate<String> filter) {
            Preconditions.checkNotNull(filter);
            this.mAllowedCategories = this.mAllowedCategories.or(filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowPackage(@NonNull String packageName) {
            Preconditions.checkNotNull(packageName);
            return this.allowPackage(packageName::equals);
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowPackage(@NonNull Predicate<String> filter) {
            Preconditions.checkNotNull(filter);
            this.mAllowedPackages = this.mAllowedPackages.or(filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowComponent(@NonNull ComponentName component) {
            Preconditions.checkNotNull(component);
            return this.allowComponent(arg_0 -> ((ComponentName)component).equals(arg_0));
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowComponent(@NonNull Predicate<ComponentName> filter) {
            Preconditions.checkNotNull(filter);
            this.mAllowSomeComponents = true;
            this.mAllowedComponents = this.mAllowedComponents.or(filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowComponentWithPackage(@NonNull String packageName) {
            Preconditions.checkNotNull(packageName);
            return this.allowComponent((ComponentName v) -> packageName.equals(v.getPackageName()));
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowAnyComponent() {
            this.mAllowAnyComponent = true;
            this.mAllowedComponents = v -> true;
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowClipDataText() {
            this.mAllowClipDataText = true;
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowClipDataUriWithAuthority(@NonNull String authority) {
            Preconditions.checkNotNull(authority);
            return this.allowClipDataUri(v -> authority.equals(v.getAuthority()));
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowClipDataUri(@NonNull Predicate<Uri> filter) {
            Preconditions.checkNotNull(filter);
            this.mAllowedClipDataUri = this.mAllowedClipDataUri.or(filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowClipData(@NonNull Predicate<ClipData> filter) {
            Preconditions.checkNotNull(filter);
            this.mAllowedClipData = this.mAllowedClipData.or(filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowExtra(@NonNull String key, @NonNull Class<?> clazz) {
            return this.allowExtra(key, clazz, v -> true);
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public <T> Builder allowExtra(@NonNull String key, @NonNull Class<T> clazz, @NonNull Predicate<T> valueFilter) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(clazz);
            Preconditions.checkNotNull(valueFilter);
            return this.allowExtra(key, (Object v) -> clazz.isInstance(v) && valueFilter.test(clazz.cast(v)));
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowExtra(@NonNull String key, @NonNull Predicate<Object> filter) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(filter);
            Predicate<Object> allowedExtra = this.mAllowedExtras.get(key);
            if (allowedExtra == null) {
                allowedExtra = v -> false;
            }
            allowedExtra = allowedExtra.or(filter);
            this.mAllowedExtras.put(key, allowedExtra);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowExtraStreamUriWithAuthority(@NonNull String uriAuthority) {
            Preconditions.checkNotNull(uriAuthority);
            this.allowExtra("android.intent.extra.STREAM", Uri.class, v -> uriAuthority.equals(v.getAuthority()));
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowExtraStream(@NonNull Predicate<Uri> filter) {
            this.allowExtra("android.intent.extra.STREAM", Uri.class, filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowExtraOutput(@NonNull String uriAuthority) {
            this.allowExtra("output", Uri.class, v -> uriAuthority.equals(v.getAuthority()));
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowExtraOutput(@NonNull Predicate<Uri> filter) {
            this.allowExtra("output", Uri.class, filter);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowIdentifier() {
            this.mAllowIdentifier = true;
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowSelector() {
            this.mAllowSelector = true;
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowSourceBounds() {
            this.mAllowSourceBounds = true;
            return this;
        }

        @NonNull
        public IntentSanitizer build() {
            if (this.mAllowAnyComponent && this.mAllowSomeComponents || !this.mAllowAnyComponent && !this.mAllowSomeComponents) {
                throw new SecurityException("You must call either allowAnyComponent or one or more of the allowComponent methods; but not both.");
            }
            IntentSanitizer sanitizer = new IntentSanitizer();
            sanitizer.mAllowedFlags = this.mAllowedFlags;
            sanitizer.mAllowedActions = this.mAllowedActions;
            sanitizer.mAllowedData = this.mAllowedData;
            sanitizer.mAllowedTypes = this.mAllowedTypes;
            sanitizer.mAllowedCategories = this.mAllowedCategories;
            sanitizer.mAllowedPackages = this.mAllowedPackages;
            sanitizer.mAllowAnyComponent = this.mAllowAnyComponent;
            sanitizer.mAllowedComponents = this.mAllowedComponents;
            sanitizer.mAllowedExtras = this.mAllowedExtras;
            sanitizer.mAllowClipDataText = this.mAllowClipDataText;
            sanitizer.mAllowedClipDataUri = this.mAllowedClipDataUri;
            sanitizer.mAllowedClipData = this.mAllowedClipData;
            sanitizer.mAllowIdentifier = this.mAllowIdentifier;
            sanitizer.mAllowSelector = this.mAllowSelector;
            sanitizer.mAllowSourceBounds = this.mAllowSourceBounds;
            return sanitizer;
        }
    }
}

