/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.pm;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.Size;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PackageInfoCompat {
    public static long getLongVersionCode(@NonNull PackageInfo info) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.getLongVersionCode(info);
        }
        return info.versionCode;
    }

    @NonNull
    public static List<Signature> getSignatures(@NonNull PackageManager packageManager, @NonNull String packageName) throws PackageManager.NameNotFoundException {
        Signature[] array;
        if (Build.VERSION.SDK_INT >= 28) {
            PackageInfo pkgInfo = packageManager.getPackageInfo(packageName, 0x8000000);
            SigningInfo signingInfo = pkgInfo.signingInfo;
            array = Api28Impl.hasMultipleSigners(signingInfo) ? Api28Impl.getApkContentsSigners(signingInfo) : Api28Impl.getSigningCertificateHistory(signingInfo);
        } else {
            PackageInfo pkgInfo = packageManager.getPackageInfo(packageName, 64);
            array = pkgInfo.signatures;
        }
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static boolean hasSignatures(@NonNull PackageManager packageManager, @NonNull String packageName, @Size(min=1L) @NonNull Map<byte[], Integer> certificatesAndType, boolean matchExact) throws PackageManager.NameNotFoundException {
        Iterator<byte[]> iterator;
        if (certificatesAndType.isEmpty()) {
            return false;
        }
        Set<byte[]> expectedCertBytes = certificatesAndType.keySet();
        block7: for (Object bytes : expectedCertBytes) {
            if (bytes == null) {
                throw new IllegalArgumentException("Cert byte array cannot be null when verifying " + packageName);
            }
            Integer type = certificatesAndType.get(bytes);
            if (type == null) {
                throw new IllegalArgumentException("Type must be specified for cert when verifying " + packageName);
            }
            switch (type) {
                case 0: 
                case 1: {
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unsupported certificate type " + type + " when verifying " + packageName);
        }
        List<Signature> signers = PackageInfoCompat.getSignatures(packageManager, packageName);
        if (!matchExact && Build.VERSION.SDK_INT >= 28) {
            Object bytes;
            bytes = expectedCertBytes.iterator();
            while (bytes.hasNext()) {
                Integer type;
                byte[] bytes2 = (byte[])bytes.next();
                if (Api28Impl.hasSigningCertificate(packageManager, packageName, bytes2, type = certificatesAndType.get(bytes2))) continue;
                return false;
            }
            return true;
        }
        if (signers.size() == 0 || certificatesAndType.size() > signers.size() || matchExact && certificatesAndType.size() != signers.size()) {
            return false;
        }
        boolean hasSha256 = certificatesAndType.containsValue(1);
        byte[][] sha256Digests = null;
        if (hasSha256) {
            sha256Digests = new byte[signers.size()][];
            for (int index = 0; index < signers.size(); ++index) {
                sha256Digests[index] = PackageInfoCompat.computeSHA256Digest(signers.get(index).toByteArray());
            }
        }
        if ((iterator = expectedCertBytes.iterator()).hasNext()) {
            byte[] bytes = iterator.next();
            Integer type = certificatesAndType.get(bytes);
            switch (type) {
                case 0: {
                    Signature expectedSignature = new Signature(bytes);
                    if (signers.contains(expectedSignature)) break;
                    return false;
                }
                case 1: {
                    if (PackageInfoCompat.byteArrayContains(sha256Digests, bytes)) break;
                    return false;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported certificate type " + type);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean byteArrayContains(@NonNull byte[][] array, @NonNull byte[] expected) {
        for (byte[] item : array) {
            if (!Arrays.equals(expected, item)) continue;
            return true;
        }
        return false;
    }

    private static byte[] computeSHA256Digest(byte[] bytes) {
        try {
            return MessageDigest.getInstance("SHA256").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Device doesn't support SHA256 cert checking", e);
        }
    }

    private PackageInfoCompat() {
    }

    @RequiresApi(value=28)
    private static class Api28Impl {
        private Api28Impl() {
        }

        @DoNotInline
        static boolean hasSigningCertificate(@NonNull PackageManager packageManager, @NonNull String packageName, @NonNull byte[] bytes, int type) {
            return packageManager.hasSigningCertificate(packageName, bytes, type);
        }

        @DoNotInline
        static boolean hasMultipleSigners(@NonNull SigningInfo signingInfo) {
            return signingInfo.hasMultipleSigners();
        }

        @DoNotInline
        @Nullable
        static Signature[] getApkContentsSigners(@NonNull SigningInfo signingInfo) {
            return signingInfo.getApkContentsSigners();
        }

        @DoNotInline
        @Nullable
        static Signature[] getSigningCertificateHistory(@NonNull SigningInfo signingInfo) {
            return signingInfo.getSigningCertificateHistory();
        }

        @DoNotInline
        static long getLongVersionCode(PackageInfo packageInfo) {
            return packageInfo.getLongVersionCode();
        }
    }
}

