/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.InsetDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.ColorInt;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.drawable.TintAwareDrawable;
import androidx.core.graphics.drawable.WrappedDrawable;
import androidx.core.graphics.drawable.WrappedDrawableApi14;
import androidx.core.graphics.drawable.WrappedDrawableApi21;
import java.io.IOException;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class DrawableCompat {
    private static final String TAG = "DrawableCompat";
    private static Method sSetLayoutDirectionMethod;
    private static boolean sSetLayoutDirectionMethodFetched;
    private static Method sGetLayoutDirectionMethod;
    private static boolean sGetLayoutDirectionMethodFetched;

    @Deprecated
    public static void jumpToCurrentState(@NonNull Drawable drawable2) {
        drawable2.jumpToCurrentState();
    }

    public static void setAutoMirrored(@NonNull Drawable drawable2, boolean mirrored) {
        drawable2.setAutoMirrored(mirrored);
    }

    public static boolean isAutoMirrored(@NonNull Drawable drawable2) {
        return drawable2.isAutoMirrored();
    }

    public static void setHotspot(@NonNull Drawable drawable2, float x, float y) {
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.setHotspot(drawable2, x, y);
        }
    }

    public static void setHotspotBounds(@NonNull Drawable drawable2, int left, int top, int right, int bottom) {
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.setHotspotBounds(drawable2, left, top, right, bottom);
        }
    }

    public static void setTint(@NonNull Drawable drawable2, @ColorInt int tint) {
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.setTint(drawable2, tint);
        } else if (drawable2 instanceof TintAwareDrawable) {
            ((TintAwareDrawable)drawable2).setTint(tint);
        }
    }

    public static void setTintList(@NonNull Drawable drawable2, @Nullable ColorStateList tint) {
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.setTintList(drawable2, tint);
        } else if (drawable2 instanceof TintAwareDrawable) {
            ((TintAwareDrawable)drawable2).setTintList(tint);
        }
    }

    public static void setTintMode(@NonNull Drawable drawable2, @Nullable PorterDuff.Mode tintMode) {
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.setTintMode(drawable2, tintMode);
        } else if (drawable2 instanceof TintAwareDrawable) {
            ((TintAwareDrawable)drawable2).setTintMode(tintMode);
        }
    }

    public static int getAlpha(@NonNull Drawable drawable2) {
        return drawable2.getAlpha();
    }

    public static void applyTheme(@NonNull Drawable drawable2, @NonNull Resources.Theme theme) {
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.applyTheme(drawable2, theme);
        }
    }

    public static boolean canApplyTheme(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.canApplyTheme(drawable2);
        }
        return false;
    }

    @Nullable
    public static ColorFilter getColorFilter(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.getColorFilter(drawable2);
        }
        return null;
    }

    public static void clearColorFilter(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 23) {
            drawable2.clearColorFilter();
        } else if (Build.VERSION.SDK_INT >= 21) {
            DrawableContainer container;
            DrawableContainer.DrawableContainerState state;
            drawable2.clearColorFilter();
            if (drawable2 instanceof InsetDrawable) {
                DrawableCompat.clearColorFilter(((InsetDrawable)drawable2).getDrawable());
            } else if (drawable2 instanceof WrappedDrawable) {
                DrawableCompat.clearColorFilter(((WrappedDrawable)drawable2).getWrappedDrawable());
            } else if (drawable2 instanceof DrawableContainer && (state = (DrawableContainer.DrawableContainerState)(container = (DrawableContainer)drawable2).getConstantState()) != null) {
                int count = state.getChildCount();
                for (int i = 0; i < count; ++i) {
                    Drawable child = state.getChild(i);
                    if (child == null) continue;
                    DrawableCompat.clearColorFilter(child);
                }
            }
        } else {
            drawable2.clearColorFilter();
        }
    }

    public static void inflate(@NonNull Drawable drawable2, @NonNull Resources res, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.inflate(drawable2, res, parser, attrs, theme);
        } else {
            drawable2.inflate(res, parser, attrs);
        }
    }

    @NonNull
    public static Drawable wrap(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return drawable2;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (!(drawable2 instanceof TintAwareDrawable)) {
                return new WrappedDrawableApi21(drawable2);
            }
            return drawable2;
        }
        if (!(drawable2 instanceof TintAwareDrawable)) {
            return new WrappedDrawableApi14(drawable2);
        }
        return drawable2;
    }

    public static <T extends Drawable> T unwrap(@NonNull Drawable drawable2) {
        if (drawable2 instanceof WrappedDrawable) {
            return (T)((WrappedDrawable)drawable2).getWrappedDrawable();
        }
        return (T)drawable2;
    }

    public static boolean setLayoutDirection(@NonNull Drawable drawable2, int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.setLayoutDirection(drawable2, layoutDirection);
        }
        if (!sSetLayoutDirectionMethodFetched) {
            try {
                sSetLayoutDirectionMethod = Drawable.class.getDeclaredMethod("setLayoutDirection", Integer.TYPE);
                sSetLayoutDirectionMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve setLayoutDirection(int) method", (Throwable)e);
            }
            sSetLayoutDirectionMethodFetched = true;
        }
        if (sSetLayoutDirectionMethod != null) {
            try {
                sSetLayoutDirectionMethod.invoke((Object)drawable2, layoutDirection);
                return true;
            }
            catch (Exception e) {
                Log.i((String)TAG, (String)"Failed to invoke setLayoutDirection(int) via reflection", (Throwable)e);
                sSetLayoutDirectionMethod = null;
            }
        }
        return false;
    }

    public static int getLayoutDirection(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getLayoutDirection(drawable2);
        }
        if (!sGetLayoutDirectionMethodFetched) {
            try {
                sGetLayoutDirectionMethod = Drawable.class.getDeclaredMethod("getLayoutDirection", new Class[0]);
                sGetLayoutDirectionMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve getLayoutDirection() method", (Throwable)e);
            }
            sGetLayoutDirectionMethodFetched = true;
        }
        if (sGetLayoutDirectionMethod != null) {
            try {
                return (Integer)sGetLayoutDirectionMethod.invoke((Object)drawable2, new Object[0]);
            }
            catch (Exception e) {
                Log.i((String)TAG, (String)"Failed to invoke getLayoutDirection() via reflection", (Throwable)e);
                sGetLayoutDirectionMethod = null;
            }
        }
        return 0;
    }

    private DrawableCompat() {
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static void setHotspot(Drawable drawable2, float x, float y) {
            drawable2.setHotspot(x, y);
        }

        @DoNotInline
        static void setTint(Drawable drawable2, int tintColor) {
            drawable2.setTint(tintColor);
        }

        @DoNotInline
        static void setTintList(Drawable drawable2, ColorStateList tint) {
            drawable2.setTintList(tint);
        }

        @DoNotInline
        static void setTintMode(Drawable drawable2, PorterDuff.Mode tintMode) {
            drawable2.setTintMode(tintMode);
        }

        @DoNotInline
        static void applyTheme(Drawable drawable2, Resources.Theme t) {
            drawable2.applyTheme(t);
        }

        @DoNotInline
        static boolean canApplyTheme(Drawable drawable2) {
            return drawable2.canApplyTheme();
        }

        @DoNotInline
        static ColorFilter getColorFilter(Drawable drawable2) {
            return drawable2.getColorFilter();
        }

        @DoNotInline
        static void inflate(Drawable drawable2, Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
            drawable2.inflate(r, parser, attrs, theme);
        }

        @DoNotInline
        static void setHotspotBounds(Drawable drawable2, int left, int top, int right, int bottom) {
            drawable2.setHotspotBounds(left, top, right, bottom);
        }
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static boolean setLayoutDirection(Drawable drawable2, int layoutDirection) {
            return drawable2.setLayoutDirection(layoutDirection);
        }

        @DoNotInline
        static int getLayoutDirection(Drawable drawable2) {
            return drawable2.getLayoutDirection();
        }
    }
}

