/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.hardware.display;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public final class DisplayManagerCompat {
    public static final String DISPLAY_CATEGORY_PRESENTATION = "android.hardware.display.category.PRESENTATION";
    private final Context mContext;

    private DisplayManagerCompat(Context context) {
        this.mContext = context;
    }

    @NonNull
    public static DisplayManagerCompat getInstance(@NonNull Context context) {
        return new DisplayManagerCompat(context);
    }

    @Nullable
    public Display getDisplay(int displayId) {
        DisplayManager displayManager = (DisplayManager)this.mContext.getSystemService("display");
        return displayManager.getDisplay(displayId);
    }

    @NonNull
    public Display[] getDisplays() {
        return ((DisplayManager)this.mContext.getSystemService("display")).getDisplays();
    }

    @NonNull
    public Display[] getDisplays(@Nullable String category) {
        return ((DisplayManager)this.mContext.getSystemService("display")).getDisplays();
    }
}

