/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class HandlerCompat {
    private static final String TAG = "HandlerCompat";

    @NonNull
    public static Handler createAsync(@NonNull Looper looper) {
        ReflectiveOperationException wrappedException;
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.createAsync(looper);
        }
        try {
            return (Handler)Handler.class.getDeclaredConstructor(Looper.class, Handler.Callback.class, Boolean.TYPE).newInstance(looper, null, true);
        }
        catch (IllegalAccessException e) {
            wrappedException = e;
        }
        catch (InstantiationException e) {
            wrappedException = e;
        }
        catch (NoSuchMethodException e) {
            wrappedException = e;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        Log.w((String)TAG, (String)"Unable to invoke Handler(Looper, Callback, boolean) constructor", (Throwable)wrappedException);
        return new Handler(looper);
    }

    @NonNull
    public static Handler createAsync(@NonNull Looper looper, @NonNull Handler.Callback callback) {
        ReflectiveOperationException wrappedException;
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.createAsync(looper, callback);
        }
        try {
            return (Handler)Handler.class.getDeclaredConstructor(Looper.class, Handler.Callback.class, Boolean.TYPE).newInstance(looper, callback, true);
        }
        catch (IllegalAccessException e) {
            wrappedException = e;
        }
        catch (InstantiationException e) {
            wrappedException = e;
        }
        catch (NoSuchMethodException e) {
            wrappedException = e;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        Log.w((String)TAG, (String)"Unable to invoke Handler(Looper, Callback, boolean) constructor", (Throwable)wrappedException);
        return new Handler(looper, callback);
    }

    public static boolean postDelayed(@NonNull Handler handler, @NonNull Runnable r, @Nullable Object token, long delayMillis) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.postDelayed(handler, r, token, delayMillis);
        }
        Message message = Message.obtain((Handler)handler, (Runnable)r);
        message.obj = token;
        return handler.sendMessageDelayed(message, delayMillis);
    }

    public static boolean hasCallbacks(@NonNull Handler handler, @NonNull Runnable r) {
        Exception wrappedException = null;
        if (Build.VERSION.SDK_INT >= 29) {
            return Api29Impl.hasCallbacks(handler, r);
        }
        try {
            Method hasCallbacksMethod = Handler.class.getMethod("hasCallbacks", Runnable.class);
            return (Boolean)hasCallbacksMethod.invoke((Object)handler, r);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (IllegalAccessException e) {
            wrappedException = e;
        }
        catch (NoSuchMethodException e) {
            wrappedException = e;
        }
        catch (NullPointerException e) {
            wrappedException = e;
        }
        throw new UnsupportedOperationException("Failed to call Handler.hasCallbacks(), but there is no safe failure mode for this method. Raising exception.", wrappedException);
    }

    private HandlerCompat() {
    }

    @RequiresApi(value=28)
    private static class Api28Impl {
        private Api28Impl() {
        }

        public static Handler createAsync(Looper looper) {
            return Handler.createAsync((Looper)looper);
        }

        public static Handler createAsync(Looper looper, Handler.Callback callback) {
            return Handler.createAsync((Looper)looper, (Handler.Callback)callback);
        }

        public static boolean postDelayed(Handler handler, Runnable r, Object token, long delayMillis) {
            return handler.postDelayed(r, token, delayMillis);
        }
    }

    @RequiresApi(value=29)
    private static class Api29Impl {
        private Api29Impl() {
        }

        public static boolean hasCallbacks(Handler handler, Runnable r) {
            return handler.hasCallbacks(r);
        }
    }
}

