/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.service.quicksettings;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Build;
import android.service.quicksettings.TileService;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.service.quicksettings.PendingIntentActivityWrapper;

public class TileServiceCompat {
    private static TileServiceWrapper sTileServiceWrapper;

    public static void startActivityAndCollapse(@NonNull TileService tileService, @NonNull PendingIntentActivityWrapper wrapper) {
        if (Build.VERSION.SDK_INT >= 34) {
            if (sTileServiceWrapper != null) {
                sTileServiceWrapper.startActivityAndCollapse(wrapper.getPendingIntent());
            } else {
                Api34Impl.startActivityAndCollapse(tileService, wrapper.getPendingIntent());
            }
        } else if (Build.VERSION.SDK_INT >= 24) {
            if (sTileServiceWrapper != null) {
                sTileServiceWrapper.startActivityAndCollapse(wrapper.getIntent());
            } else {
                Api24Impl.startActivityAndCollapse(tileService, wrapper.getIntent());
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void setTileServiceWrapper(@NonNull TileServiceWrapper serviceWrapper) {
        sTileServiceWrapper = serviceWrapper;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void clearTileServiceWrapper() {
        sTileServiceWrapper = null;
    }

    private TileServiceCompat() {
    }

    static interface TileServiceWrapper {
        public void startActivityAndCollapse(PendingIntent var1);

        public void startActivityAndCollapse(Intent var1);
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        private Api34Impl() {
        }

        @DoNotInline
        static void startActivityAndCollapse(TileService service, PendingIntent pendingIntent) {
            service.startActivityAndCollapse(pendingIntent);
        }
    }

    @RequiresApi(value=24)
    private static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static void startActivityAndCollapse(TileService service, Intent intent) {
            service.startActivityAndCollapse(intent);
        }
    }
}

