/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.os.Build;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.view.VelocityTrackerFallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class VelocityTrackerCompat {
    private static Map<VelocityTracker, VelocityTrackerFallback> sFallbackTrackers = Collections.synchronizedMap(new WeakHashMap());

    @Deprecated
    public static float getXVelocity(VelocityTracker tracker, int pointerId) {
        return tracker.getXVelocity(pointerId);
    }

    @Deprecated
    public static float getYVelocity(VelocityTracker tracker, int pointerId) {
        return tracker.getYVelocity(pointerId);
    }

    public static boolean isAxisSupported(@NonNull VelocityTracker tracker, int axis) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api34Impl.isAxisSupported(tracker, axis);
        }
        return axis == 26 || axis == 0 || axis == 1;
    }

    public static float getAxisVelocity(@NonNull VelocityTracker tracker, int axis) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api34Impl.getAxisVelocity(tracker, axis);
        }
        if (axis == 0) {
            return tracker.getXVelocity();
        }
        if (axis == 1) {
            return tracker.getYVelocity();
        }
        VelocityTrackerFallback fallback = VelocityTrackerCompat.getFallbackTrackerOrNull(tracker);
        if (fallback != null) {
            return fallback.getAxisVelocity(axis);
        }
        return 0.0f;
    }

    public static float getAxisVelocity(@NonNull VelocityTracker tracker, int axis, int pointerId) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api34Impl.getAxisVelocity(tracker, axis, pointerId);
        }
        if (axis == 0) {
            return tracker.getXVelocity(pointerId);
        }
        if (axis == 1) {
            return tracker.getYVelocity(pointerId);
        }
        return 0.0f;
    }

    public static void clear(@NonNull VelocityTracker tracker) {
        tracker.clear();
        VelocityTrackerCompat.removeFallbackForTracker(tracker);
    }

    public static void recycle(@NonNull VelocityTracker tracker) {
        tracker.recycle();
        VelocityTrackerCompat.removeFallbackForTracker(tracker);
    }

    public static void computeCurrentVelocity(@NonNull VelocityTracker tracker, int units, float maxVelocity) {
        tracker.computeCurrentVelocity(units, maxVelocity);
        VelocityTrackerFallback fallback = VelocityTrackerCompat.getFallbackTrackerOrNull(tracker);
        if (fallback != null) {
            fallback.computeCurrentVelocity(units, maxVelocity);
        }
    }

    public static void computeCurrentVelocity(@NonNull VelocityTracker tracker, int units) {
        VelocityTrackerCompat.computeCurrentVelocity(tracker, units, Float.MAX_VALUE);
    }

    public static void addMovement(@NonNull VelocityTracker tracker, @NonNull MotionEvent event) {
        tracker.addMovement(event);
        if (Build.VERSION.SDK_INT >= 34) {
            return;
        }
        if (event.getSource() == 0x400000) {
            if (!sFallbackTrackers.containsKey(tracker)) {
                sFallbackTrackers.put(tracker, new VelocityTrackerFallback());
            }
            sFallbackTrackers.get(tracker).addMovement(event);
        }
    }

    private static void removeFallbackForTracker(VelocityTracker tracker) {
        sFallbackTrackers.remove(tracker);
    }

    @Nullable
    private static VelocityTrackerFallback getFallbackTrackerOrNull(VelocityTracker tracker) {
        return sFallbackTrackers.get(tracker);
    }

    private VelocityTrackerCompat() {
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        private Api34Impl() {
        }

        @DoNotInline
        static boolean isAxisSupported(VelocityTracker velocityTracker, int axis) {
            return velocityTracker.isAxisSupported(axis);
        }

        @DoNotInline
        static float getAxisVelocity(VelocityTracker velocityTracker, int axis, int id2) {
            return velocityTracker.getAxisVelocity(axis, id2);
        }

        @DoNotInline
        static float getAxisVelocity(VelocityTracker velocityTracker, int axis) {
            return velocityTracker.getAxisVelocity(axis);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface VelocityTrackableMotionEventAxis {
    }
}

