/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.annotation.SuppressLint;
import android.view.WindowInsetsAnimationController;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.Insets;

public final class WindowInsetsAnimationControllerCompat {
    private final Impl mImpl;

    @RequiresApi(value=30)
    WindowInsetsAnimationControllerCompat(@NonNull WindowInsetsAnimationController controller) {
        this.mImpl = new Impl30(controller);
    }

    @NonNull
    public Insets getHiddenStateInsets() {
        return this.mImpl.getHiddenStateInsets();
    }

    @NonNull
    public Insets getShownStateInsets() {
        return this.mImpl.getShownStateInsets();
    }

    @NonNull
    public Insets getCurrentInsets() {
        return this.mImpl.getCurrentInsets();
    }

    @FloatRange(from=0.0, to=1.0)
    public float getCurrentFraction() {
        return this.mImpl.getCurrentFraction();
    }

    public float getCurrentAlpha() {
        return this.mImpl.getCurrentAlpha();
    }

    public int getTypes() {
        return this.mImpl.getTypes();
    }

    public void setInsetsAndAlpha(@Nullable Insets insets, @FloatRange(from=0.0, to=1.0) float alpha, @FloatRange(from=0.0, to=1.0) float fraction) {
        this.mImpl.setInsetsAndAlpha(insets, alpha, fraction);
    }

    public void finish(boolean shown) {
        this.mImpl.finish(shown);
    }

    public boolean isReady() {
        return !this.isFinished() && !this.isCancelled();
    }

    public boolean isFinished() {
        return this.mImpl.isFinished();
    }

    public boolean isCancelled() {
        return this.mImpl.isCancelled();
    }

    @RequiresApi(value=30)
    private static class Impl30
    extends Impl {
        private final WindowInsetsAnimationController mController;

        Impl30(@NonNull WindowInsetsAnimationController controller) {
            this.mController = controller;
        }

        @Override
        @NonNull
        public Insets getHiddenStateInsets() {
            return Insets.toCompatInsets(this.mController.getHiddenStateInsets());
        }

        @Override
        @NonNull
        public Insets getShownStateInsets() {
            return Insets.toCompatInsets(this.mController.getShownStateInsets());
        }

        @Override
        @NonNull
        public Insets getCurrentInsets() {
            return Insets.toCompatInsets(this.mController.getCurrentInsets());
        }

        @Override
        public float getCurrentFraction() {
            return this.mController.getCurrentFraction();
        }

        @Override
        public float getCurrentAlpha() {
            return this.mController.getCurrentAlpha();
        }

        @Override
        @SuppressLint(value={"WrongConstant"})
        public int getTypes() {
            return this.mController.getTypes();
        }

        @Override
        public void setInsetsAndAlpha(@Nullable Insets insets, float alpha, float fraction) {
            this.mController.setInsetsAndAlpha(insets == null ? null : insets.toPlatformInsets(), alpha, fraction);
        }

        @Override
        void finish(boolean shown) {
            this.mController.finish(shown);
        }

        @Override
        boolean isFinished() {
            return this.mController.isFinished();
        }

        @Override
        boolean isCancelled() {
            return this.mController.isCancelled();
        }
    }

    private static class Impl {
        Impl() {
        }

        @NonNull
        public Insets getHiddenStateInsets() {
            return Insets.NONE;
        }

        @NonNull
        public Insets getShownStateInsets() {
            return Insets.NONE;
        }

        @NonNull
        public Insets getCurrentInsets() {
            return Insets.NONE;
        }

        @FloatRange(from=0.0, to=1.0)
        public float getCurrentFraction() {
            return 0.0f;
        }

        public float getCurrentAlpha() {
            return 0.0f;
        }

        public int getTypes() {
            return 0;
        }

        public void setInsetsAndAlpha(@Nullable Insets insets, @FloatRange(from=0.0, to=1.0) float alpha, @FloatRange(from=0.0, to=1.0) float fraction) {
        }

        void finish(boolean shown) {
        }

        boolean isFinished() {
            return false;
        }

        boolean isCancelled() {
            return true;
        }
    }
}

