/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.util.Log;
import android.view.View;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.GeneratedAppGlideModule;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.GlideExperiments;
import com.bumptech.glide.MemoryCategory;
import com.bumptech.glide.Registry;
import com.bumptech.glide.RegistryFactory;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.engine.Engine;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.prefill.BitmapPreFiller;
import com.bumptech.glide.load.engine.prefill.PreFillType;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.HardwareConfigState;
import com.bumptech.glide.manager.ConnectivityMonitorFactory;
import com.bumptech.glide.manager.RequestManagerRetriever;
import com.bumptech.glide.module.AppGlideModule;
import com.bumptech.glide.module.GlideModule;
import com.bumptech.glide.module.ManifestParser;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.ImageViewTargetFactory;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.util.GlideSuppliers;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Glide
implements ComponentCallbacks2 {
    private static final String DEFAULT_DISK_CACHE_DIR = "image_manager_disk_cache";
    private static final String DESTROYED_ACTIVITY_WARNING = "You cannot start a load on a not yet attached View or a Fragment where getActivity() returns null (which usually occurs when getActivity() is called before the Fragment is attached or after the Fragment is destroyed).";
    private static final String TAG = "Glide";
    @GuardedBy(value="Glide.class")
    private static volatile Glide glide;
    private static volatile boolean isInitializing;
    private final Engine engine;
    private final BitmapPool bitmapPool;
    private final MemoryCache memoryCache;
    private final GlideContext glideContext;
    private final ArrayPool arrayPool;
    private final RequestManagerRetriever requestManagerRetriever;
    private final ConnectivityMonitorFactory connectivityMonitorFactory;
    @GuardedBy(value="managers")
    private final List<RequestManager> managers = new ArrayList<RequestManager>();
    private final RequestOptionsFactory defaultRequestOptionsFactory;
    private MemoryCategory memoryCategory = MemoryCategory.NORMAL;
    @GuardedBy(value="this")
    @Nullable
    private BitmapPreFiller bitmapPreFiller;

    @Nullable
    public static File getPhotoCacheDir(@NonNull Context context) {
        return Glide.getPhotoCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    @Nullable
    public static File getPhotoCacheDir(@NonNull Context context, @NonNull String cacheName) {
        File cacheDir = context.getCacheDir();
        if (cacheDir != null) {
            File result = new File(cacheDir, cacheName);
            if (result.isDirectory() || result.mkdirs()) {
                return result;
            }
            return null;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static Glide get(@NonNull Context context) {
        if (glide != null) return glide;
        GeneratedAppGlideModule annotationGeneratedModule = Glide.getAnnotationGeneratedGlideModules(context.getApplicationContext());
        Class<Glide> clazz = Glide.class;
        synchronized (Glide.class) {
            if (glide != null) return glide;
            Glide.checkAndInitializeGlide(context, annotationGeneratedModule);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return glide;
        }
    }

    @GuardedBy(value="Glide.class")
    @VisibleForTesting
    static void checkAndInitializeGlide(@NonNull Context context, @Nullable GeneratedAppGlideModule generatedAppGlideModule) {
        if (isInitializing) {
            throw new IllegalStateException("Glide has been called recursively, this is probably an internal library error!");
        }
        isInitializing = true;
        try {
            Glide.initializeGlide(context, generatedAppGlideModule);
        }
        finally {
            isInitializing = false;
        }
    }

    @Deprecated
    @VisibleForTesting
    public static synchronized void init(Glide glide) {
        if (Glide.glide != null) {
            Glide.tearDown();
        }
        Glide.glide = glide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void init(@NonNull Context context, @NonNull GlideBuilder builder) {
        GeneratedAppGlideModule annotationGeneratedModule = Glide.getAnnotationGeneratedGlideModules(context);
        Class<Glide> clazz = Glide.class;
        synchronized (Glide.class) {
            if (glide != null) {
                Glide.tearDown();
            }
            Glide.initializeGlide(context, builder, annotationGeneratedModule);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    public static synchronized boolean isInitialized() {
        return glide != null;
    }

    @VisibleForTesting
    public static void enableHardwareBitmaps() {
        HardwareConfigState.getInstance().unblockHardwareBitmaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void tearDown() {
        Class<Glide> clazz = Glide.class;
        synchronized (Glide.class) {
            if (glide != null) {
                glide.getContext().getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)glide);
                Glide.glide.engine.shutdown();
            }
            glide = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @GuardedBy(value="Glide.class")
    private static void initializeGlide(@NonNull Context context, @Nullable GeneratedAppGlideModule generatedAppGlideModule) {
        Glide.initializeGlide(context, new GlideBuilder(), generatedAppGlideModule);
    }

    @GuardedBy(value="Glide.class")
    private static void initializeGlide(@NonNull Context context, @NonNull GlideBuilder builder, @Nullable GeneratedAppGlideModule annotationGeneratedModule) {
        Context applicationContext = context.getApplicationContext();
        List<Object> manifestModules = Collections.emptyList();
        if (annotationGeneratedModule == null || annotationGeneratedModule.isManifestParsingEnabled()) {
            manifestModules = new ManifestParser(applicationContext).parse();
        }
        if (annotationGeneratedModule != null && !annotationGeneratedModule.getExcludedModuleClasses().isEmpty()) {
            Set<Class<?>> excludedModuleClasses = annotationGeneratedModule.getExcludedModuleClasses();
            Iterator<Object> iterator = manifestModules.iterator();
            while (iterator.hasNext()) {
                GlideModule glideModule = (GlideModule)iterator.next();
                if (!excludedModuleClasses.contains(glideModule.getClass())) continue;
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("AppGlideModule excludes manifest GlideModule: " + glideModule));
                }
                iterator.remove();
            }
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            for (Object glideModule : manifestModules) {
                Log.d((String)TAG, (String)("Discovered GlideModule from manifest: " + glideModule.getClass()));
            }
        }
        RequestManagerRetriever.RequestManagerFactory factory = annotationGeneratedModule != null ? annotationGeneratedModule.getRequestManagerFactory() : null;
        builder.setRequestManagerFactory(factory);
        for (GlideModule glideModule : manifestModules) {
            glideModule.applyOptions(applicationContext, builder);
        }
        if (annotationGeneratedModule != null) {
            annotationGeneratedModule.applyOptions(applicationContext, builder);
        }
        Glide glide = builder.build(applicationContext, manifestModules, annotationGeneratedModule);
        applicationContext.registerComponentCallbacks((ComponentCallbacks)glide);
        Glide.glide = glide;
    }

    @Nullable
    private static GeneratedAppGlideModule getAnnotationGeneratedGlideModules(Context context) {
        GeneratedAppGlideModule result = null;
        try {
            Class<?> clazz = Class.forName("com.bumptech.glide.GeneratedAppGlideModuleImpl");
            result = (GeneratedAppGlideModule)clazz.getDeclaredConstructor(Context.class).newInstance(context.getApplicationContext());
        }
        catch (ClassNotFoundException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Failed to find GeneratedAppGlideModule. You should include an annotationProcessor compile dependency on com.github.bumptech.glide:compiler in your application and a @GlideModule annotated AppGlideModule implementation or LibraryGlideModules will be silently ignored");
            }
        }
        catch (InstantiationException e) {
            Glide.throwIncorrectGlideModule(e);
        }
        catch (IllegalAccessException e) {
            Glide.throwIncorrectGlideModule(e);
        }
        catch (NoSuchMethodException e) {
            Glide.throwIncorrectGlideModule(e);
        }
        catch (InvocationTargetException e) {
            Glide.throwIncorrectGlideModule(e);
        }
        return result;
    }

    private static void throwIncorrectGlideModule(Exception e) {
        throw new IllegalStateException("GeneratedAppGlideModuleImpl is implemented incorrectly. If you've manually implemented this class, remove your implementation. The Annotation processor will generate a correct implementation.", e);
    }

    Glide(@NonNull Context context, @NonNull Engine engine, @NonNull MemoryCache memoryCache, @NonNull BitmapPool bitmapPool, @NonNull ArrayPool arrayPool, @NonNull RequestManagerRetriever requestManagerRetriever, @NonNull ConnectivityMonitorFactory connectivityMonitorFactory, int logLevel, @NonNull RequestOptionsFactory defaultRequestOptionsFactory, @NonNull Map<Class<?>, TransitionOptions<?, ?>> defaultTransitionOptions, @NonNull List<RequestListener<Object>> defaultRequestListeners, @NonNull List<GlideModule> manifestModules, @Nullable AppGlideModule annotationGeneratedModule, @NonNull GlideExperiments experiments) {
        this.engine = engine;
        this.bitmapPool = bitmapPool;
        this.arrayPool = arrayPool;
        this.memoryCache = memoryCache;
        this.requestManagerRetriever = requestManagerRetriever;
        this.connectivityMonitorFactory = connectivityMonitorFactory;
        this.defaultRequestOptionsFactory = defaultRequestOptionsFactory;
        GlideSuppliers.GlideSupplier<Registry> registry = RegistryFactory.lazilyCreateAndInitializeRegistry(this, manifestModules, annotationGeneratedModule);
        ImageViewTargetFactory imageViewTargetFactory = new ImageViewTargetFactory();
        this.glideContext = new GlideContext(context, arrayPool, registry, imageViewTargetFactory, defaultRequestOptionsFactory, defaultTransitionOptions, defaultRequestListeners, engine, experiments, logLevel);
    }

    @NonNull
    public BitmapPool getBitmapPool() {
        return this.bitmapPool;
    }

    @NonNull
    public ArrayPool getArrayPool() {
        return this.arrayPool;
    }

    @NonNull
    public Context getContext() {
        return this.glideContext.getBaseContext();
    }

    ConnectivityMonitorFactory getConnectivityMonitorFactory() {
        return this.connectivityMonitorFactory;
    }

    @NonNull
    GlideContext getGlideContext() {
        return this.glideContext;
    }

    public synchronized void preFillBitmapPool(PreFillType.Builder ... bitmapAttributeBuilders) {
        if (this.bitmapPreFiller == null) {
            DecodeFormat decodeFormat = this.defaultRequestOptionsFactory.build().getOptions().get(Downsampler.DECODE_FORMAT);
            this.bitmapPreFiller = new BitmapPreFiller(this.memoryCache, this.bitmapPool, decodeFormat);
        }
        this.bitmapPreFiller.preFill(bitmapAttributeBuilders);
    }

    public void clearMemory() {
        Util.assertMainThread();
        this.memoryCache.clearMemory();
        this.bitmapPool.clearMemory();
        this.arrayPool.clearMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimMemory(int level) {
        Util.assertMainThread();
        List<RequestManager> list = this.managers;
        synchronized (list) {
            for (RequestManager manager : this.managers) {
                manager.onTrimMemory(level);
            }
        }
        this.memoryCache.trimMemory(level);
        this.bitmapPool.trimMemory(level);
        this.arrayPool.trimMemory(level);
    }

    public void clearDiskCache() {
        Util.assertBackgroundThread();
        this.engine.clearDiskCache();
    }

    @NonNull
    public RequestManagerRetriever getRequestManagerRetriever() {
        return this.requestManagerRetriever;
    }

    @NonNull
    public MemoryCategory setMemoryCategory(@NonNull MemoryCategory memoryCategory) {
        Util.assertMainThread();
        this.memoryCache.setSizeMultiplier(memoryCategory.getMultiplier());
        this.bitmapPool.setSizeMultiplier(memoryCategory.getMultiplier());
        MemoryCategory oldCategory = this.memoryCategory;
        this.memoryCategory = memoryCategory;
        return oldCategory;
    }

    @NonNull
    private static RequestManagerRetriever getRetriever(@Nullable Context context) {
        Preconditions.checkNotNull(context, DESTROYED_ACTIVITY_WARNING);
        return Glide.get(context).getRequestManagerRetriever();
    }

    @NonNull
    public static RequestManager with(@NonNull Context context) {
        return Glide.getRetriever(context).get(context);
    }

    @Deprecated
    @NonNull
    public static RequestManager with(@NonNull Activity activity) {
        return Glide.with(activity.getApplicationContext());
    }

    @NonNull
    public static RequestManager with(@NonNull FragmentActivity activity) {
        return Glide.getRetriever((Context)activity).get(activity);
    }

    @NonNull
    public static RequestManager with(@NonNull androidx.fragment.app.Fragment fragment) {
        return Glide.getRetriever(fragment.getContext()).get(fragment);
    }

    @Deprecated
    @NonNull
    public static RequestManager with(@NonNull Fragment fragment) {
        Activity activity = fragment.getActivity();
        Preconditions.checkNotNull(activity, DESTROYED_ACTIVITY_WARNING);
        return Glide.with(activity.getApplicationContext());
    }

    @NonNull
    public static RequestManager with(@NonNull View view) {
        return Glide.getRetriever(view.getContext()).get(view);
    }

    @NonNull
    public Registry getRegistry() {
        return this.glideContext.getRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFromManagers(@NonNull Target<?> target) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            for (RequestManager requestManager : this.managers) {
                if (!requestManager.untrack(target)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerRequestManager(RequestManager requestManager) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            if (this.managers.contains(requestManager)) {
                throw new IllegalStateException("Cannot register already registered manager");
            }
            this.managers.add(requestManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterRequestManager(RequestManager requestManager) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            if (!this.managers.contains(requestManager)) {
                throw new IllegalStateException("Cannot unregister not yet registered manager");
            }
            this.managers.remove(requestManager);
        }
    }

    public void onTrimMemory(int level) {
        this.trimMemory(level);
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
        this.clearMemory();
    }

    public static interface RequestOptionsFactory {
        @NonNull
        public RequestOptions build();
    }
}

