/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import androidx.annotation.CheckResult;
import androidx.annotation.DrawableRes;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import com.bumptech.glide.Glide;
import com.bumptech.glide.ModelTypes;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.manager.ConnectivityMonitor;
import com.bumptech.glide.manager.ConnectivityMonitorFactory;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.LifecycleListener;
import com.bumptech.glide.manager.RequestManagerTreeNode;
import com.bumptech.glide.manager.RequestTracker;
import com.bumptech.glide.manager.TargetTracker;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class RequestManager
implements ComponentCallbacks2,
LifecycleListener,
ModelTypes<RequestBuilder<Drawable>> {
    private static final RequestOptions DECODE_TYPE_BITMAP = (RequestOptions)RequestOptions.decodeTypeOf(Bitmap.class).lock();
    private static final RequestOptions DECODE_TYPE_GIF = (RequestOptions)RequestOptions.decodeTypeOf(GifDrawable.class).lock();
    private static final RequestOptions DOWNLOAD_ONLY_OPTIONS = (RequestOptions)((RequestOptions)RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.DATA).priority(Priority.LOW)).skipMemoryCache(true);
    protected final Glide glide;
    protected final Context context;
    final Lifecycle lifecycle;
    @GuardedBy(value="this")
    private final RequestTracker requestTracker;
    @GuardedBy(value="this")
    private final RequestManagerTreeNode treeNode;
    @GuardedBy(value="this")
    private final TargetTracker targetTracker = new TargetTracker();
    private final Runnable addSelfToLifecycle = new Runnable(){

        @Override
        public void run() {
            RequestManager.this.lifecycle.addListener(RequestManager.this);
        }
    };
    private final ConnectivityMonitor connectivityMonitor;
    private final CopyOnWriteArrayList<RequestListener<Object>> defaultRequestListeners;
    @GuardedBy(value="this")
    private RequestOptions requestOptions;
    private boolean pauseAllRequestsOnTrimMemoryModerate;
    private boolean clearOnStop;

    public RequestManager(@NonNull Glide glide, @NonNull Lifecycle lifecycle, @NonNull RequestManagerTreeNode treeNode, @NonNull Context context) {
        this(glide, lifecycle, treeNode, new RequestTracker(), glide.getConnectivityMonitorFactory(), context);
    }

    RequestManager(Glide glide, Lifecycle lifecycle, RequestManagerTreeNode treeNode, RequestTracker requestTracker, ConnectivityMonitorFactory factory, Context context) {
        this.glide = glide;
        this.lifecycle = lifecycle;
        this.treeNode = treeNode;
        this.requestTracker = requestTracker;
        this.context = context;
        this.connectivityMonitor = factory.build(context.getApplicationContext(), new RequestManagerConnectivityListener(requestTracker));
        glide.registerRequestManager(this);
        if (Util.isOnBackgroundThread()) {
            Util.postOnUiThread(this.addSelfToLifecycle);
        } else {
            lifecycle.addListener(this);
        }
        lifecycle.addListener(this.connectivityMonitor);
        this.defaultRequestListeners = new CopyOnWriteArrayList<RequestListener<Object>>(glide.getGlideContext().getDefaultRequestListeners());
        this.setRequestOptions(glide.getGlideContext().getDefaultRequestOptions());
    }

    protected synchronized void setRequestOptions(@NonNull RequestOptions toSet) {
        this.requestOptions = (RequestOptions)((RequestOptions)toSet.clone()).autoClone();
    }

    private synchronized void updateRequestOptions(@NonNull RequestOptions toUpdate) {
        this.requestOptions = (RequestOptions)this.requestOptions.apply(toUpdate);
    }

    @NonNull
    public synchronized RequestManager applyDefaultRequestOptions(@NonNull RequestOptions requestOptions) {
        this.updateRequestOptions(requestOptions);
        return this;
    }

    @NonNull
    public synchronized RequestManager setDefaultRequestOptions(@NonNull RequestOptions requestOptions) {
        this.setRequestOptions(requestOptions);
        return this;
    }

    @NonNull
    public synchronized RequestManager clearOnStop() {
        this.clearOnStop = true;
        return this;
    }

    public RequestManager addDefaultRequestListener(RequestListener<Object> requestListener) {
        this.defaultRequestListeners.add(requestListener);
        return this;
    }

    public void setPauseAllRequestsOnTrimMemoryModerate(boolean pauseAllOnTrim) {
        this.pauseAllRequestsOnTrimMemoryModerate = pauseAllOnTrim;
    }

    public synchronized boolean isPaused() {
        return this.requestTracker.isPaused();
    }

    public synchronized void pauseRequests() {
        this.requestTracker.pauseRequests();
    }

    public synchronized void pauseAllRequests() {
        this.requestTracker.pauseAllRequests();
    }

    public synchronized void pauseAllRequestsRecursive() {
        this.pauseAllRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.pauseAllRequests();
        }
    }

    public synchronized void pauseRequestsRecursive() {
        this.pauseRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.pauseRequests();
        }
    }

    public synchronized void resumeRequests() {
        this.requestTracker.resumeRequests();
    }

    public synchronized void resumeRequestsRecursive() {
        Util.assertMainThread();
        this.resumeRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.resumeRequests();
        }
    }

    @Override
    public synchronized void onStart() {
        this.resumeRequests();
        this.targetTracker.onStart();
    }

    @Override
    public synchronized void onStop() {
        this.targetTracker.onStop();
        if (this.clearOnStop) {
            this.clearRequests();
        } else {
            this.pauseRequests();
        }
    }

    @Override
    public synchronized void onDestroy() {
        this.targetTracker.onDestroy();
        this.clearRequests();
        this.requestTracker.clearRequests();
        this.lifecycle.removeListener(this);
        this.lifecycle.removeListener(this.connectivityMonitor);
        Util.removeCallbacksOnUiThread(this.addSelfToLifecycle);
        this.glide.unregisterRequestManager(this);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<Bitmap> asBitmap() {
        return this.as(Bitmap.class).apply((BaseRequestOptions)DECODE_TYPE_BITMAP);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<GifDrawable> asGif() {
        return this.as(GifDrawable.class).apply((BaseRequestOptions)DECODE_TYPE_GIF);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> asDrawable() {
        return this.as(Drawable.class);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable Bitmap bitmap) {
        return this.asDrawable().load(bitmap);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable Drawable drawable) {
        return this.asDrawable().load(drawable);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable String string) {
        return this.asDrawable().load(string);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable Uri uri) {
        return this.asDrawable().load(uri);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable File file) {
        return this.asDrawable().load(file);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@RawRes @DrawableRes @Nullable Integer resourceId) {
        return this.asDrawable().load(resourceId);
    }

    @Override
    @Deprecated
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable URL url) {
        return this.asDrawable().load(url);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable byte[] model) {
        return this.asDrawable().load(model);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable Object model) {
        return this.asDrawable().load(model);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<File> downloadOnly() {
        return this.as(File.class).apply((BaseRequestOptions)DOWNLOAD_ONLY_OPTIONS);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<File> download(@Nullable Object model) {
        return this.downloadOnly().load(model);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<File> asFile() {
        return this.as(File.class).apply((BaseRequestOptions)RequestOptions.skipMemoryCacheOf(true));
    }

    @NonNull
    @CheckResult
    public <ResourceType> RequestBuilder<ResourceType> as(@NonNull Class<ResourceType> resourceClass) {
        return new RequestBuilder<ResourceType>(this.glide, this, resourceClass, this.context);
    }

    public void clear(@NonNull View view) {
        this.clear(new ClearTarget(view));
    }

    public void clear(@Nullable Target<?> target) {
        if (target == null) {
            return;
        }
        this.untrackOrDelegate(target);
    }

    private void untrackOrDelegate(@NonNull Target<?> target) {
        boolean isOwnedByUs = this.untrack(target);
        Request request = target.getRequest();
        if (!isOwnedByUs && !this.glide.removeFromManagers(target) && request != null) {
            target.setRequest(null);
            request.clear();
        }
    }

    synchronized boolean untrack(@NonNull Target<?> target) {
        Request request = target.getRequest();
        if (request == null) {
            return true;
        }
        if (this.requestTracker.clearAndRemove(request)) {
            this.targetTracker.untrack(target);
            target.setRequest(null);
            return true;
        }
        return false;
    }

    synchronized void track(@NonNull Target<?> target, @NonNull Request request) {
        this.targetTracker.track(target);
        this.requestTracker.runRequest(request);
    }

    List<RequestListener<Object>> getDefaultRequestListeners() {
        return this.defaultRequestListeners;
    }

    synchronized RequestOptions getDefaultRequestOptions() {
        return this.requestOptions;
    }

    @NonNull
    <T> TransitionOptions<?, T> getDefaultTransitionOptions(Class<T> transcodeClass) {
        return this.glide.getGlideContext().getDefaultTransitionOptions(transcodeClass);
    }

    public synchronized String toString() {
        return super.toString() + "{tracker=" + this.requestTracker + ", treeNode=" + this.treeNode + "}";
    }

    public void onTrimMemory(int level) {
        if (level == 60 && this.pauseAllRequestsOnTrimMemoryModerate) {
            this.pauseAllRequestsRecursive();
        }
    }

    public void onLowMemory() {
    }

    private synchronized void clearRequests() {
        for (Target<?> target : this.targetTracker.getAll()) {
            this.clear(target);
        }
        this.targetTracker.clear();
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    private class RequestManagerConnectivityListener
    implements ConnectivityMonitor.ConnectivityListener {
        @GuardedBy(value="RequestManager.this")
        private final RequestTracker requestTracker;

        RequestManagerConnectivityListener(RequestTracker requestTracker) {
            this.requestTracker = requestTracker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectivityChanged(boolean isConnected) {
            if (isConnected) {
                RequestManager requestManager = RequestManager.this;
                synchronized (requestManager) {
                    this.requestTracker.restartRequests();
                }
            }
        }
    }

    private static class ClearTarget
    extends CustomViewTarget<View, Object> {
        ClearTarget(@NonNull View view) {
            super(view);
        }

        @Override
        protected void onResourceCleared(@Nullable Drawable placeholder) {
        }

        @Override
        public void onLoadFailed(@Nullable Drawable errorDrawable) {
        }

        @Override
        public void onResourceReady(@NonNull Object resource, @Nullable Transition<? super Object> transition) {
        }
    }
}

