/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import android.util.Log;
import com.bumptech.glide.disklrucache.DiskLruCache;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskCacheWriteLocker;
import com.bumptech.glide.load.engine.cache.SafeKeyGenerator;
import java.io.File;
import java.io.IOException;

public class DiskLruCacheWrapper
implements DiskCache {
    private static final String TAG = "DiskLruCacheWrapper";
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private static DiskLruCacheWrapper wrapper;
    private final SafeKeyGenerator safeKeyGenerator;
    private final File directory;
    private final long maxSize;
    private final DiskCacheWriteLocker writeLocker = new DiskCacheWriteLocker();
    private DiskLruCache diskLruCache;

    @Deprecated
    public static synchronized DiskCache get(File directory, long maxSize) {
        if (wrapper == null) {
            wrapper = new DiskLruCacheWrapper(directory, maxSize);
        }
        return wrapper;
    }

    public static DiskCache create(File directory, long maxSize) {
        return new DiskLruCacheWrapper(directory, maxSize);
    }

    @Deprecated
    protected DiskLruCacheWrapper(File directory, long maxSize) {
        this.directory = directory;
        this.maxSize = maxSize;
        this.safeKeyGenerator = new SafeKeyGenerator();
    }

    private synchronized DiskLruCache getDiskCache() throws IOException {
        if (this.diskLruCache == null) {
            this.diskLruCache = DiskLruCache.open((File)this.directory, (int)1, (int)1, (long)this.maxSize);
        }
        return this.diskLruCache;
    }

    @Override
    public File get(Key key) {
        File result;
        block4: {
            String safeKey = this.safeKeyGenerator.getSafeKey(key);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Get: Obtained: " + safeKey + " for for Key: " + key));
            }
            result = null;
            try {
                DiskLruCache.Value value = this.getDiskCache().get(safeKey);
                if (value != null) {
                    result = value.getFile(0);
                }
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block4;
                Log.w((String)TAG, (String)"Unable to get from disk cache", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Key key, DiskCache.Writer writer) {
        block15: {
            String safeKey = this.safeKeyGenerator.getSafeKey(key);
            this.writeLocker.acquire(safeKey);
            try {
                DiskLruCache diskCache;
                block14: {
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.v((String)TAG, (String)("Put: Obtained: " + safeKey + " for for Key: " + key));
                    }
                    try {
                        diskCache = this.getDiskCache();
                        DiskLruCache.Value current = diskCache.get(safeKey);
                        if (current == null) break block14;
                        return;
                    }
                    catch (IOException e) {
                        if (Log.isLoggable((String)TAG, (int)5)) {
                            Log.w((String)TAG, (String)"Unable to put to disk cache", (Throwable)e);
                        }
                        break block15;
                    }
                }
                DiskLruCache.Editor editor = diskCache.edit(safeKey);
                if (editor == null) {
                    throw new IllegalStateException("Had two simultaneous puts for: " + safeKey);
                }
                try {
                    File file = editor.getFile(0);
                    if (writer.write(file)) {
                        editor.commit();
                    }
                }
                finally {
                    editor.abortUnlessCommitted();
                }
            }
            finally {
                this.writeLocker.release(safeKey);
            }
        }
    }

    @Override
    public void delete(Key key) {
        block2: {
            String safeKey = this.safeKeyGenerator.getSafeKey(key);
            try {
                this.getDiskCache().remove(safeKey);
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block2;
                Log.w((String)TAG, (String)"Unable to delete from disk cache", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void clear() {
        try {
            this.getDiskCache().delete();
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Unable to clear disk cache or disk cache cleared externally", (Throwable)e);
            }
        }
        finally {
            this.resetDiskCache();
        }
    }

    private synchronized void resetDiskCache() {
        this.diskLruCache = null;
    }
}

