/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.executor;

import android.os.Process;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.load.engine.executor.RuntimeCompat;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public final class GlideExecutor
implements ExecutorService {
    static final String DEFAULT_SOURCE_EXECUTOR_NAME = "source";
    static final String DEFAULT_DISK_CACHE_EXECUTOR_NAME = "disk-cache";
    static final int DEFAULT_DISK_CACHE_EXECUTOR_THREADS = 1;
    private static final String TAG = "GlideExecutor";
    private static final String DEFAULT_SOURCE_UNLIMITED_EXECUTOR_NAME = "source-unlimited";
    static final String DEFAULT_ANIMATION_EXECUTOR_NAME = "animation";
    private static final long KEEP_ALIVE_TIME_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final int MAXIMUM_AUTOMATIC_THREAD_COUNT = 4;
    private static volatile int bestThreadCount;
    private final ExecutorService delegate;

    public static Builder newDiskCacheBuilder() {
        return new Builder(true).setThreadCount(1).setName(DEFAULT_DISK_CACHE_EXECUTOR_NAME);
    }

    public static GlideExecutor newDiskCacheExecutor() {
        return GlideExecutor.newDiskCacheBuilder().build();
    }

    @Deprecated
    public static GlideExecutor newDiskCacheExecutor(UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutor.newDiskCacheBuilder().setUncaughtThrowableStrategy(uncaughtThrowableStrategy).build();
    }

    @Deprecated
    public static GlideExecutor newDiskCacheExecutor(int threadCount, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutor.newDiskCacheBuilder().setThreadCount(threadCount).setName(name).setUncaughtThrowableStrategy(uncaughtThrowableStrategy).build();
    }

    public static Builder newSourceBuilder() {
        return new Builder(false).setThreadCount(GlideExecutor.calculateBestThreadCount()).setName(DEFAULT_SOURCE_EXECUTOR_NAME);
    }

    public static GlideExecutor newSourceExecutor() {
        return GlideExecutor.newSourceBuilder().build();
    }

    @Deprecated
    public static GlideExecutor newSourceExecutor(UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutor.newSourceBuilder().setUncaughtThrowableStrategy(uncaughtThrowableStrategy).build();
    }

    @Deprecated
    public static GlideExecutor newSourceExecutor(int threadCount, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutor.newSourceBuilder().setThreadCount(threadCount).setName(name).setUncaughtThrowableStrategy(uncaughtThrowableStrategy).build();
    }

    public static GlideExecutor newUnlimitedSourceExecutor() {
        return new GlideExecutor(new ThreadPoolExecutor(0, Integer.MAX_VALUE, KEEP_ALIVE_TIME_MS, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory(new DefaultPriorityThreadFactory(), DEFAULT_SOURCE_UNLIMITED_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT, false)));
    }

    public static Builder newAnimationBuilder() {
        int maximumPoolSize = GlideExecutor.calculateAnimationExecutorThreadCount();
        return new Builder(true).setThreadCount(maximumPoolSize).setName(DEFAULT_ANIMATION_EXECUTOR_NAME);
    }

    static int calculateAnimationExecutorThreadCount() {
        int bestThreadCount = GlideExecutor.calculateBestThreadCount();
        return bestThreadCount >= 4 ? 2 : 1;
    }

    public static GlideExecutor newAnimationExecutor() {
        return GlideExecutor.newAnimationBuilder().build();
    }

    @Deprecated
    public static GlideExecutor newAnimationExecutor(int threadCount, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutor.newAnimationBuilder().setThreadCount(threadCount).setUncaughtThrowableStrategy(uncaughtThrowableStrategy).build();
    }

    @VisibleForTesting
    GlideExecutor(ExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        this.delegate.execute(command);
    }

    @Override
    @NonNull
    public Future<?> submit(@NonNull Runnable task) {
        return this.delegate.submit(task);
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    @NonNull
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    @NonNull
    public <T> Future<T> submit(@NonNull Runnable task, T result) {
        return this.delegate.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(@NonNull Callable<T> task) {
        return this.delegate.submit(task);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    @NonNull
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static int calculateBestThreadCount() {
        if (bestThreadCount == 0) {
            bestThreadCount = Math.min(4, RuntimeCompat.availableProcessors());
        }
        return bestThreadCount;
    }

    public static final class Builder {
        public static final long NO_THREAD_TIMEOUT = 0L;
        private final boolean preventNetworkOperations;
        private int corePoolSize;
        private int maximumPoolSize;
        @NonNull
        private ThreadFactory threadFactory = new DefaultPriorityThreadFactory();
        @NonNull
        private UncaughtThrowableStrategy uncaughtThrowableStrategy = UncaughtThrowableStrategy.DEFAULT;
        private String name;
        private long threadTimeoutMillis;

        Builder(boolean preventNetworkOperations) {
            this.preventNetworkOperations = preventNetworkOperations;
        }

        public Builder setThreadTimeoutMillis(long threadTimeoutMillis) {
            this.threadTimeoutMillis = threadTimeoutMillis;
            return this;
        }

        public Builder setThreadCount(@IntRange(from=1L) int threadCount) {
            this.corePoolSize = threadCount;
            this.maximumPoolSize = threadCount;
            return this;
        }

        @Deprecated
        public Builder setThreadFactory(@NonNull ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setUncaughtThrowableStrategy(@NonNull UncaughtThrowableStrategy strategy) {
            this.uncaughtThrowableStrategy = strategy;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public GlideExecutor build() {
            if (TextUtils.isEmpty((CharSequence)this.name)) {
                throw new IllegalArgumentException("Name must be non-null and non-empty, but given: " + this.name);
            }
            ThreadPoolExecutor executor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.threadTimeoutMillis, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new DefaultThreadFactory(this.threadFactory, this.name, this.uncaughtThrowableStrategy, this.preventNetworkOperations));
            if (this.threadTimeoutMillis != 0L) {
                executor.allowCoreThreadTimeOut(true);
            }
            return new GlideExecutor(executor);
        }
    }

    public static interface UncaughtThrowableStrategy {
        public static final UncaughtThrowableStrategy IGNORE = new UncaughtThrowableStrategy(){

            @Override
            public void handle(Throwable t) {
            }
        };
        public static final UncaughtThrowableStrategy LOG = new UncaughtThrowableStrategy(){

            @Override
            public void handle(Throwable t) {
                if (t != null && Log.isLoggable((String)GlideExecutor.TAG, (int)6)) {
                    Log.e((String)GlideExecutor.TAG, (String)"Request threw uncaught throwable", (Throwable)t);
                }
            }
        };
        public static final UncaughtThrowableStrategy THROW = new UncaughtThrowableStrategy(){

            @Override
            public void handle(Throwable t) {
                if (t != null) {
                    throw new RuntimeException("Request threw uncaught throwable", t);
                }
            }
        };
        public static final UncaughtThrowableStrategy DEFAULT = LOG;

        public void handle(Throwable var1);
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final ThreadFactory delegate;
        private final String name;
        final UncaughtThrowableStrategy uncaughtThrowableStrategy;
        final boolean preventNetworkOperations;
        private final AtomicInteger threadNum = new AtomicInteger();

        DefaultThreadFactory(ThreadFactory delegate, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy, boolean preventNetworkOperations) {
            this.delegate = delegate;
            this.name = name;
            this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
            this.preventNetworkOperations = preventNetworkOperations;
        }

        @Override
        public Thread newThread(final @NonNull Runnable runnable) {
            Thread newThread = this.delegate.newThread(new Runnable(){

                @Override
                public void run() {
                    if (DefaultThreadFactory.this.preventNetworkOperations) {
                        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectNetwork().penaltyDeath().build());
                    }
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        DefaultThreadFactory.this.uncaughtThrowableStrategy.handle(t);
                    }
                }
            });
            newThread.setName("glide-" + this.name + "-thread-" + this.threadNum.getAndIncrement());
            return newThread;
        }
    }

    private static final class DefaultPriorityThreadFactory
    implements ThreadFactory {
        private static final int DEFAULT_PRIORITY = 9;

        private DefaultPriorityThreadFactory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            return new Thread(runnable){

                @Override
                public void run() {
                    Process.setThreadPriority((int)9);
                    super.run();
                }
            };
        }
    }
}

