/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.MediaDataSource;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class VideoDecoder<T>
implements ResourceDecoder<T, Bitmap> {
    private static final String TAG = "VideoDecoder";
    public static final long DEFAULT_FRAME = -1L;
    @VisibleForTesting
    static final int DEFAULT_FRAME_OPTION = 2;
    public static final Option<Long> TARGET_FRAME = Option.disk("com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.TargetFrame", -1L, new Option.CacheKeyUpdater<Long>(){
        private final ByteBuffer buffer = ByteBuffer.allocate(8);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NonNull byte[] keyBytes, @NonNull Long value, @NonNull MessageDigest messageDigest) {
            messageDigest.update(keyBytes);
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                this.buffer.position(0);
                messageDigest.update(this.buffer.putLong(value).array());
            }
        }
    });
    public static final Option<Integer> FRAME_OPTION = Option.disk("com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.FrameOption", 2, new Option.CacheKeyUpdater<Integer>(){
        private final ByteBuffer buffer = ByteBuffer.allocate(4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NonNull byte[] keyBytes, @NonNull Integer value, @NonNull MessageDigest messageDigest) {
            if (value == null) {
                return;
            }
            messageDigest.update(keyBytes);
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                this.buffer.position(0);
                messageDigest.update(this.buffer.putInt(value).array());
            }
        }
    });
    private static final MediaMetadataRetrieverFactory DEFAULT_FACTORY = new MediaMetadataRetrieverFactory();
    private static final List<String> PIXEL_T_BUILD_ID_PREFIXES_REQUIRING_HDR_180_ROTATION_FIX = Collections.unmodifiableList(Arrays.asList("TP1A", "TD1A.220804.031"));
    private static final String WEBM_MIME_TYPE = "video/webm";
    private final MediaInitializer<T> initializer;
    private final BitmapPool bitmapPool;
    private final MediaMetadataRetrieverFactory factory;

    @RequiresApi(value=16)
    public static ResourceDecoder<AssetFileDescriptor, Bitmap> asset(BitmapPool bitmapPool) {
        return new VideoDecoder<AssetFileDescriptor>(bitmapPool, new AssetFileDescriptorInitializer());
    }

    public static ResourceDecoder<ParcelFileDescriptor, Bitmap> parcel(BitmapPool bitmapPool) {
        return new VideoDecoder<ParcelFileDescriptor>(bitmapPool, new ParcelFileDescriptorInitializer());
    }

    @RequiresApi(api=23)
    public static ResourceDecoder<ByteBuffer, Bitmap> byteBuffer(BitmapPool bitmapPool) {
        return new VideoDecoder<ByteBuffer>(bitmapPool, new ByteBufferInitializer());
    }

    VideoDecoder(BitmapPool bitmapPool, MediaInitializer<T> initializer) {
        this(bitmapPool, initializer, DEFAULT_FACTORY);
    }

    @VisibleForTesting
    VideoDecoder(BitmapPool bitmapPool, MediaInitializer<T> initializer, MediaMetadataRetrieverFactory factory) {
        this.bitmapPool = bitmapPool;
        this.initializer = initializer;
        this.factory = factory;
    }

    @Override
    public boolean handles(@NonNull T data, @NonNull Options options) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource<Bitmap> decode(@NonNull T resource, int outWidth, int outHeight, @NonNull Options options) throws IOException {
        Bitmap result;
        DownsampleStrategy downsampleStrategy;
        long frameTimeMicros = options.get(TARGET_FRAME);
        if (frameTimeMicros < 0L && frameTimeMicros != -1L) {
            throw new IllegalArgumentException("Requested frame must be non-negative, or DEFAULT_FRAME, given: " + frameTimeMicros);
        }
        Integer frameOption = options.get(FRAME_OPTION);
        if (frameOption == null) {
            frameOption = 2;
        }
        if ((downsampleStrategy = options.get(DownsampleStrategy.OPTION)) == null) {
            downsampleStrategy = DownsampleStrategy.DEFAULT;
        }
        MediaMetadataRetriever mediaMetadataRetriever = this.factory.build();
        try {
            this.initializer.initializeRetriever(mediaMetadataRetriever, resource);
            result = this.decodeFrame(resource, mediaMetadataRetriever, frameTimeMicros, frameOption, outWidth, outHeight, downsampleStrategy);
        }
        finally {
            if (Build.VERSION.SDK_INT >= 29) {
                mediaMetadataRetriever.close();
            } else {
                mediaMetadataRetriever.release();
            }
        }
        return BitmapResource.obtain(result, this.bitmapPool);
    }

    @Nullable
    private Bitmap decodeFrame(@NonNull T resource, MediaMetadataRetriever mediaMetadataRetriever, long frameTimeMicros, int frameOption, int outWidth, int outHeight, DownsampleStrategy strategy) {
        if (this.isUnsupportedFormat(resource, mediaMetadataRetriever)) {
            throw new IllegalStateException("Cannot decode VP8 video on CrOS.");
        }
        Bitmap result = null;
        if (Build.VERSION.SDK_INT >= 27 && outWidth != Integer.MIN_VALUE && outHeight != Integer.MIN_VALUE && strategy != DownsampleStrategy.NONE) {
            result = VideoDecoder.decodeScaledFrame(mediaMetadataRetriever, frameTimeMicros, frameOption, outWidth, outHeight, strategy);
        }
        if (result == null) {
            result = VideoDecoder.decodeOriginalFrame(mediaMetadataRetriever, frameTimeMicros, frameOption);
        }
        if ((result = VideoDecoder.correctHdr180DegVideoFrameOrientation(mediaMetadataRetriever, result)) == null) {
            throw new VideoDecoderException();
        }
        return result;
    }

    @TargetApi(value=30)
    private static Bitmap correctHdr180DegVideoFrameOrientation(MediaMetadataRetriever mediaMetadataRetriever, Bitmap frame) {
        boolean requiresHdr180RotationFix;
        block6: {
            if (!VideoDecoder.isHdr180RotationFixRequired()) {
                return frame;
            }
            requiresHdr180RotationFix = false;
            try {
                if (VideoDecoder.isHDR(mediaMetadataRetriever)) {
                    String rotationString = mediaMetadataRetriever.extractMetadata(24);
                    int rotation = Integer.parseInt(rotationString);
                    requiresHdr180RotationFix = Math.abs(rotation) == 180;
                }
            }
            catch (NumberFormatException e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block6;
                Log.d((String)TAG, (String)"Exception trying to extract HDR transfer function or rotation");
            }
        }
        if (!requiresHdr180RotationFix) {
            return frame;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Applying HDR 180 deg thumbnail correction");
        }
        Matrix rotationMatrix = new Matrix();
        rotationMatrix.postRotate(180.0f, (float)frame.getWidth() / 2.0f, (float)frame.getHeight() / 2.0f);
        return Bitmap.createBitmap((Bitmap)frame, (int)0, (int)0, (int)frame.getWidth(), (int)frame.getHeight(), (Matrix)rotationMatrix, (boolean)true);
    }

    @RequiresApi(value=30)
    private static boolean isHDR(MediaMetadataRetriever mediaMetadataRetriever) throws NumberFormatException {
        String colorTransferString = mediaMetadataRetriever.extractMetadata(36);
        String colorStandardString = mediaMetadataRetriever.extractMetadata(35);
        int colorTransfer = Integer.parseInt(colorTransferString);
        int colorStandard = Integer.parseInt(colorStandardString);
        return (colorTransfer == 7 || colorTransfer == 6) && colorStandard == 6;
    }

    @VisibleForTesting
    static boolean isHdr180RotationFixRequired() {
        if (Build.MODEL.startsWith("Pixel") && Build.VERSION.SDK_INT == 33) {
            return VideoDecoder.isTBuildRequiringRotationFix();
        }
        return Build.VERSION.SDK_INT >= 30 && Build.VERSION.SDK_INT < 33;
    }

    private static boolean isTBuildRequiringRotationFix() {
        for (String buildId : PIXEL_T_BUILD_ID_PREFIXES_REQUIRING_HDR_180_ROTATION_FIX) {
            if (!Build.ID.startsWith(buildId)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    @TargetApi(value=27)
    private static Bitmap decodeScaledFrame(MediaMetadataRetriever mediaMetadataRetriever, long frameTimeMicros, int frameOption, int outWidth, int outHeight, DownsampleStrategy strategy) {
        try {
            int originalWidth = Integer.parseInt(mediaMetadataRetriever.extractMetadata(18));
            int originalHeight = Integer.parseInt(mediaMetadataRetriever.extractMetadata(19));
            int orientation = Integer.parseInt(mediaMetadataRetriever.extractMetadata(24));
            if (orientation == 90 || orientation == 270) {
                int temp = originalWidth;
                originalWidth = originalHeight;
                originalHeight = temp;
            }
            float scaleFactor = strategy.getScaleFactor(originalWidth, originalHeight, outWidth, outHeight);
            int decodeWidth = Math.round(scaleFactor * (float)originalWidth);
            int decodeHeight = Math.round(scaleFactor * (float)originalHeight);
            return mediaMetadataRetriever.getScaledFrameAtTime(frameTimeMicros, frameOption, decodeWidth, decodeHeight);
        }
        catch (Throwable t) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Exception trying to decode a scaled frame on oreo+, falling back to a fullsize frame", (Throwable)t);
            }
            return null;
        }
    }

    private static Bitmap decodeOriginalFrame(MediaMetadataRetriever mediaMetadataRetriever, long frameTimeMicros, int frameOption) {
        return mediaMetadataRetriever.getFrameAtTime(frameTimeMicros, frameOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUnsupportedFormat(@NonNull T resource, MediaMetadataRetriever mediaMetadataRetriever) {
        boolean isArc;
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        boolean bl = isArc = Build.DEVICE != null && Build.DEVICE.matches(".+_cheets|cheets_.+");
        if (!isArc) {
            return false;
        }
        MediaExtractor mediaExtractor = null;
        try {
            String mimeType = mediaMetadataRetriever.extractMetadata(12);
            if (!WEBM_MIME_TYPE.equals(mimeType)) {
                boolean bl2 = false;
                return bl2;
            }
            mediaExtractor = new MediaExtractor();
            this.initializer.initializeExtractor(mediaExtractor, resource);
            int numTracks = mediaExtractor.getTrackCount();
            for (int i = 0; i < numTracks; ++i) {
                MediaFormat mediaformat = mediaExtractor.getTrackFormat(i);
                String trackMimeType = mediaformat.getString("mime");
                if (!"video/x-vnd.on2.vp8".equals(trackMimeType)) continue;
                boolean bl3 = true;
                return bl3;
            }
        }
        catch (Throwable t) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Exception trying to extract track info for a webm video on CrOS.", (Throwable)t);
            }
        }
        finally {
            if (mediaExtractor != null) {
                mediaExtractor.release();
            }
        }
        return false;
    }

    @RequiresApi(value=16)
    private static final class AssetFileDescriptorInitializer
    implements MediaInitializer<AssetFileDescriptor> {
        private AssetFileDescriptorInitializer() {
        }

        @Override
        public void initializeRetriever(MediaMetadataRetriever retriever, AssetFileDescriptor data) {
            retriever.setDataSource(data.getFileDescriptor(), data.getStartOffset(), data.getLength());
        }

        @Override
        public void initializeExtractor(MediaExtractor extractor, AssetFileDescriptor data) throws IOException {
            extractor.setDataSource(data.getFileDescriptor(), data.getStartOffset(), data.getLength());
        }
    }

    @VisibleForTesting
    static interface MediaInitializer<T> {
        public void initializeRetriever(MediaMetadataRetriever var1, T var2);

        @RequiresApi(value=16)
        public void initializeExtractor(MediaExtractor var1, T var2) throws IOException;
    }

    static final class ParcelFileDescriptorInitializer
    implements MediaInitializer<ParcelFileDescriptor> {
        ParcelFileDescriptorInitializer() {
        }

        @Override
        public void initializeRetriever(MediaMetadataRetriever retriever, ParcelFileDescriptor data) {
            retriever.setDataSource(data.getFileDescriptor());
        }

        @Override
        @RequiresApi(value=16)
        public void initializeExtractor(MediaExtractor extractor, ParcelFileDescriptor data) throws IOException {
            extractor.setDataSource(data.getFileDescriptor());
        }
    }

    @RequiresApi(value=23)
    static final class ByteBufferInitializer
    implements MediaInitializer<ByteBuffer> {
        ByteBufferInitializer() {
        }

        @Override
        public void initializeRetriever(MediaMetadataRetriever retriever, ByteBuffer data) {
            retriever.setDataSource(this.getMediaDataSource(data));
        }

        @Override
        public void initializeExtractor(MediaExtractor extractor, ByteBuffer data) throws IOException {
            extractor.setDataSource(this.getMediaDataSource(data));
        }

        private MediaDataSource getMediaDataSource(final ByteBuffer data) {
            return new MediaDataSource(){

                public int readAt(long position, byte[] buffer, int offset, int size) {
                    if (position >= (long)data.limit()) {
                        return -1;
                    }
                    data.position((int)position);
                    int numBytesRead = Math.min(size, data.remaining());
                    data.get(buffer, offset, numBytesRead);
                    return numBytesRead;
                }

                public long getSize() {
                    return data.limit();
                }

                public void close() {
                }
            };
        }
    }

    @VisibleForTesting
    static class MediaMetadataRetrieverFactory {
        MediaMetadataRetrieverFactory() {
        }

        public MediaMetadataRetriever build() {
            return new MediaMetadataRetriever();
        }
    }

    private static final class VideoDecoderException
    extends RuntimeException {
        private static final long serialVersionUID = -2556382523004027815L;

        VideoDecoderException() {
            super("MediaMetadataRetriever failed to retrieve a frame without throwing, check the adb logs for .*MetadataRetriever.* prior to this exception for details");
        }
    }
}

