/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.gif;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;

public final class GifBitmapProvider
implements GifDecoder.BitmapProvider {
    private final BitmapPool bitmapPool;
    @Nullable
    private final ArrayPool arrayPool;

    public GifBitmapProvider(BitmapPool bitmapPool) {
        this(bitmapPool, null);
    }

    public GifBitmapProvider(BitmapPool bitmapPool, @Nullable ArrayPool arrayPool) {
        this.bitmapPool = bitmapPool;
        this.arrayPool = arrayPool;
    }

    @NonNull
    public Bitmap obtain(int width, int height, @NonNull Bitmap.Config config) {
        return this.bitmapPool.getDirty(width, height, config);
    }

    public void release(@NonNull Bitmap bitmap) {
        this.bitmapPool.put(bitmap);
    }

    @NonNull
    public byte[] obtainByteArray(int size) {
        if (this.arrayPool == null) {
            return new byte[size];
        }
        return this.arrayPool.get(size, byte[].class);
    }

    public void release(@NonNull byte[] bytes) {
        if (this.arrayPool == null) {
            return;
        }
        this.arrayPool.put(bytes);
    }

    @NonNull
    public int[] obtainIntArray(int size) {
        if (this.arrayPool == null) {
            return new int[size];
        }
        return this.arrayPool.get(size, int[].class);
    }

    public void release(@NonNull int[] array) {
        if (this.arrayPool == null) {
            return;
        }
        this.arrayPool.put(array);
    }
}

