/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.app.Activity;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.resource.bitmap.HardwareConfigState;
import com.bumptech.glide.manager.FrameWaiter;
import com.bumptech.glide.util.Util;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

@RequiresApi(value=26)
final class FirstFrameWaiter
implements FrameWaiter {
    final Set<Activity> pendingActivities = Collections.newSetFromMap(new WeakHashMap());
    volatile boolean isFirstFrameSet;

    FirstFrameWaiter() {
    }

    @Override
    public void registerSelf(Activity activity) {
        if (this.isFirstFrameSet) {
            return;
        }
        if (!this.pendingActivities.add(activity)) {
            return;
        }
        final View view = activity.getWindow().getDecorView();
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        viewTreeObserver.addOnDrawListener(new ViewTreeObserver.OnDrawListener(){

            public void onDraw() {
                final 1 listener = this;
                Util.postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        HardwareConfigState.getInstance().unblockHardwareBitmaps();
                        FirstFrameWaiter.this.isFirstFrameSet = true;
                        FirstFrameWaiter.removeListener(view, listener);
                        FirstFrameWaiter.this.pendingActivities.clear();
                    }
                });
            }
        });
    }

    static void removeListener(View view, ViewTreeObserver.OnDrawListener listener) {
        ViewTreeObserver currentViewTreeObserver = view.getViewTreeObserver();
        currentViewTreeObserver.removeOnDrawListener(listener);
    }
}

