/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;

public final class ErrorRequestCoordinator
implements RequestCoordinator,
Request {
    private final Object requestLock;
    @Nullable
    private final RequestCoordinator parent;
    private volatile Request primary;
    private volatile Request error;
    @GuardedBy(value="requestLock")
    private RequestCoordinator.RequestState primaryState = RequestCoordinator.RequestState.CLEARED;
    @GuardedBy(value="requestLock")
    private RequestCoordinator.RequestState errorState = RequestCoordinator.RequestState.CLEARED;

    public ErrorRequestCoordinator(Object requestLock, @Nullable RequestCoordinator parent) {
        this.requestLock = requestLock;
        this.parent = parent;
    }

    public void setRequests(Request primary, Request error) {
        this.primary = primary;
        this.error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.primaryState != RequestCoordinator.RequestState.RUNNING) {
                this.primaryState = RequestCoordinator.RequestState.RUNNING;
                this.primary.begin();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.requestLock;
        synchronized (object) {
            this.primaryState = RequestCoordinator.RequestState.CLEARED;
            this.primary.clear();
            if (this.errorState != RequestCoordinator.RequestState.CLEARED) {
                this.errorState = RequestCoordinator.RequestState.CLEARED;
                this.error.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.primaryState == RequestCoordinator.RequestState.RUNNING) {
                this.primaryState = RequestCoordinator.RequestState.PAUSED;
                this.primary.pause();
            }
            if (this.errorState == RequestCoordinator.RequestState.RUNNING) {
                this.errorState = RequestCoordinator.RequestState.PAUSED;
                this.error.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.primaryState == RequestCoordinator.RequestState.RUNNING || this.errorState == RequestCoordinator.RequestState.RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.primaryState == RequestCoordinator.RequestState.SUCCESS || this.errorState == RequestCoordinator.RequestState.SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCleared() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.primaryState == RequestCoordinator.RequestState.CLEARED && this.errorState == RequestCoordinator.RequestState.CLEARED;
        }
    }

    @Override
    public boolean isEquivalentTo(Request o) {
        if (o instanceof ErrorRequestCoordinator) {
            ErrorRequestCoordinator other = (ErrorRequestCoordinator)o;
            return this.primary.isEquivalentTo(other.primary) && this.error.isEquivalentTo(other.error);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSetImage(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.parentCanSetImage();
        }
    }

    @GuardedBy(value="requestLock")
    private boolean parentCanSetImage() {
        return this.parent == null || this.parent.canSetImage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canNotifyStatusChanged(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.parentCanNotifyStatusChanged() && this.isValidRequestForStatusChanged(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canNotifyCleared(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.parentCanNotifyCleared() && request.equals(this.primary);
        }
    }

    @GuardedBy(value="requestLock")
    private boolean parentCanNotifyCleared() {
        return this.parent == null || this.parent.canNotifyCleared(this);
    }

    @GuardedBy(value="requestLock")
    private boolean parentCanNotifyStatusChanged() {
        return this.parent == null || this.parent.canNotifyStatusChanged(this);
    }

    @GuardedBy(value="requestLock")
    private boolean isValidRequestForStatusChanged(Request request) {
        if (this.primaryState != RequestCoordinator.RequestState.FAILED) {
            return request.equals(this.primary);
        }
        return request.equals(this.error) && (this.errorState == RequestCoordinator.RequestState.SUCCESS || this.errorState == RequestCoordinator.RequestState.FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAnyResourceSet() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.primary.isAnyResourceSet() || this.error.isAnyResourceSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequestSuccess(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            if (request.equals(this.primary)) {
                this.primaryState = RequestCoordinator.RequestState.SUCCESS;
            } else if (request.equals(this.error)) {
                this.errorState = RequestCoordinator.RequestState.SUCCESS;
            }
            if (this.parent != null) {
                this.parent.onRequestSuccess(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequestFailed(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            if (!request.equals(this.error)) {
                this.primaryState = RequestCoordinator.RequestState.FAILED;
                if (this.errorState != RequestCoordinator.RequestState.RUNNING) {
                    this.errorState = RequestCoordinator.RequestState.RUNNING;
                    this.error.begin();
                }
                return;
            }
            this.errorState = RequestCoordinator.RequestState.FAILED;
            if (this.parent != null) {
                this.parent.onRequestFailed(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestCoordinator getRoot() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.parent != null ? this.parent.getRoot() : this;
        }
    }
}

