/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui;

import android.content.Context;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.NonNull;

public class PlatformFontSpan
extends MetricAffectingSpan {
    private Float letterSpacing;
    private Float textSize;
    private Typeface typeface;

    public PlatformFontSpan(float letterSpacing) {
        this.letterSpacing = Float.valueOf(letterSpacing);
    }

    public PlatformFontSpan(@NonNull Context context, Typeface typeface, boolean autoScalingEnabled, float fontSize) {
        this.typeface = typeface;
        this.textSize = Float.valueOf(TypedValue.applyDimension((int)(autoScalingEnabled ? 2 : 1), (float)fontSize, (DisplayMetrics)context.getResources().getDisplayMetrics()));
    }

    public void updateDrawState(TextPaint textPaint) {
        if (textPaint != null) {
            this.apply(textPaint);
        }
    }

    public void updateMeasureState(@NonNull TextPaint textPaint) {
        this.apply(textPaint);
    }

    void apply(TextPaint textPaint) {
        if (this.typeface != null) {
            textPaint.setTypeface(this.typeface);
        }
        if (this.textSize != null) {
            textPaint.setTextSize(this.textSize.floatValue());
        }
        if (this.letterSpacing != null) {
            textPaint.setLetterSpacing(this.letterSpacing.floatValue());
        }
    }
}

