/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class ConcurrencyHelpers {
    private static final int FONT_LOAD_TIMEOUT_SECONDS = 15;

    private ConcurrencyHelpers() {
    }

    static ThreadPoolExecutor createBackgroundPriorityExecutor(@NonNull String name) {
        ThreadFactory threadFactory = runnable -> {
            Thread t = new Thread(runnable, name);
            t.setPriority(10);
            return t;
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 15L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), threadFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    static Handler mainHandlerAsync() {
        if (Build.VERSION.SDK_INT >= 28) {
            return Handler28Impl.createAsync(Looper.getMainLooper());
        }
        return new Handler(Looper.getMainLooper());
    }

    static Executor mainThreadExecutor() {
        return ConcurrencyHelpers.convertHandlerToExecutor(ConcurrencyHelpers.mainHandlerAsync());
    }

    @NonNull
    static Executor convertHandlerToExecutor(@NonNull Handler handler) {
        return arg_0 -> ((Handler)handler).post(arg_0);
    }

    @RequiresApi(value=28)
    static class Handler28Impl {
        private Handler28Impl() {
        }

        public static Handler createAsync(Looper looper) {
            return Handler.createAsync((Looper)looper);
        }
    }
}

