/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.annotation.SuppressLint;
import android.graphics.Paint;
import android.text.style.ReplacementSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.emoji2.text.TypefaceEmojiRasterizer;

public abstract class EmojiSpan
extends ReplacementSpan {
    private final Paint.FontMetricsInt mTmpFontMetrics = new Paint.FontMetricsInt();
    @NonNull
    private final TypefaceEmojiRasterizer mRasterizer;
    private short mWidth = (short)-1;
    private short mHeight = (short)-1;
    private float mRatio = 1.0f;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    EmojiSpan(@NonNull TypefaceEmojiRasterizer rasterizer) {
        Preconditions.checkNotNull((Object)rasterizer, (Object)"rasterizer cannot be null");
        this.mRasterizer = rasterizer;
    }

    public int getSize(@NonNull Paint paint, @SuppressLint(value={"UnknownNullness"}) CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        paint.getFontMetricsInt(this.mTmpFontMetrics);
        int fontHeight = Math.abs(this.mTmpFontMetrics.descent - this.mTmpFontMetrics.ascent);
        this.mRatio = (float)fontHeight * 1.0f / (float)this.mRasterizer.getHeight();
        this.mHeight = (short)((float)this.mRasterizer.getHeight() * this.mRatio);
        this.mWidth = (short)((float)this.mRasterizer.getWidth() * this.mRatio);
        if (fm != null) {
            fm.ascent = this.mTmpFontMetrics.ascent;
            fm.descent = this.mTmpFontMetrics.descent;
            fm.top = this.mTmpFontMetrics.top;
            fm.bottom = this.mTmpFontMetrics.bottom;
        }
        return this.mWidth;
    }

    @NonNull
    public final TypefaceEmojiRasterizer getTypefaceRasterizer() {
        return this.mRasterizer;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    final int getWidth() {
        return this.mWidth;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    public final int getHeight() {
        return this.mHeight;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    final float getRatio() {
        return this.mRatio;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    public final int getId() {
        return this.getTypefaceRasterizer().getId();
    }
}

