/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.core.graphics.TypefaceCompatUtil;
import androidx.core.os.TraceCompat;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import androidx.core.util.Preconditions;
import androidx.emoji2.text.ConcurrencyHelpers;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.text.MetadataRepo;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

public class FontRequestEmojiCompatConfig
extends EmojiCompat.Config {
    private static final FontProviderHelper DEFAULT_FONTS_CONTRACT = new FontProviderHelper();

    public FontRequestEmojiCompatConfig(@NonNull Context context, @NonNull FontRequest request) {
        super(new FontRequestMetadataLoader(context, request, DEFAULT_FONTS_CONTRACT));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public FontRequestEmojiCompatConfig(@NonNull Context context, @NonNull FontRequest request, @NonNull FontProviderHelper fontProviderHelper) {
        super(new FontRequestMetadataLoader(context, request, fontProviderHelper));
    }

    @NonNull
    public FontRequestEmojiCompatConfig setLoadingExecutor(@NonNull Executor executor) {
        ((FontRequestMetadataLoader)this.getMetadataRepoLoader()).setExecutor(executor);
        return this;
    }

    @Deprecated
    @NonNull
    public FontRequestEmojiCompatConfig setHandler(@Nullable Handler handler) {
        if (handler == null) {
            return this;
        }
        this.setLoadingExecutor(ConcurrencyHelpers.convertHandlerToExecutor(handler));
        return this;
    }

    @NonNull
    public FontRequestEmojiCompatConfig setRetryPolicy(@Nullable RetryPolicy policy) {
        ((FontRequestMetadataLoader)this.getMetadataRepoLoader()).setRetryPolicy(policy);
        return this;
    }

    private static class FontRequestMetadataLoader
    implements EmojiCompat.MetadataRepoLoader {
        private static final String S_TRACE_BUILD_TYPEFACE = "EmojiCompat.FontRequestEmojiCompatConfig.buildTypeface";
        @NonNull
        private final Context mContext;
        @NonNull
        private final FontRequest mRequest;
        @NonNull
        private final FontProviderHelper mFontProviderHelper;
        @NonNull
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        @Nullable
        private Handler mMainHandler;
        @GuardedBy(value="mLock")
        @Nullable
        private Executor mExecutor;
        @GuardedBy(value="mLock")
        @Nullable
        private ThreadPoolExecutor mMyThreadPoolExecutor;
        @GuardedBy(value="mLock")
        @Nullable
        private RetryPolicy mRetryPolicy;
        @GuardedBy(value="mLock")
        @Nullable
        EmojiCompat.MetadataRepoLoaderCallback mCallback;
        @GuardedBy(value="mLock")
        @Nullable
        private ContentObserver mObserver;
        @GuardedBy(value="mLock")
        @Nullable
        private Runnable mMainHandlerLoadCallback;

        FontRequestMetadataLoader(@NonNull Context context, @NonNull FontRequest request, @NonNull FontProviderHelper fontProviderHelper) {
            Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null");
            Preconditions.checkNotNull((Object)request, (Object)"FontRequest cannot be null");
            this.mContext = context.getApplicationContext();
            this.mRequest = request;
            this.mFontProviderHelper = fontProviderHelper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExecutor(@NonNull Executor executor) {
            Object object = this.mLock;
            synchronized (object) {
                this.mExecutor = executor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRetryPolicy(@Nullable RetryPolicy policy) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRetryPolicy = policy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(@NonNull EmojiCompat.MetadataRepoLoaderCallback loaderCallback) {
            Preconditions.checkNotNull((Object)loaderCallback, (Object)"LoaderCallback cannot be null");
            Object object = this.mLock;
            synchronized (object) {
                this.mCallback = loaderCallback;
            }
            this.loadInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadInternal() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCallback == null) {
                    return;
                }
                if (this.mExecutor == null) {
                    this.mMyThreadPoolExecutor = ConcurrencyHelpers.createBackgroundPriorityExecutor("emojiCompat");
                    this.mExecutor = this.mMyThreadPoolExecutor;
                }
                this.mExecutor.execute(this::createMetadata);
            }
        }

        @WorkerThread
        private FontsContractCompat.FontInfo retrieveFontInfo() {
            FontsContractCompat.FontFamilyResult result;
            try {
                result = this.mFontProviderHelper.fetchFonts(this.mContext, this.mRequest);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException("provider not found", e);
            }
            if (result.getStatusCode() != 0) {
                throw new RuntimeException("fetchFonts failed (" + result.getStatusCode() + ")");
            }
            FontsContractCompat.FontInfo[] fonts = result.getFonts();
            if (fonts == null || fonts.length == 0) {
                throw new RuntimeException("fetchFonts failed (empty result)");
            }
            return fonts[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private void scheduleRetry(Uri uri, long waitMs) {
            Object object = this.mLock;
            synchronized (object) {
                Handler handler = this.mMainHandler;
                if (handler == null) {
                    this.mMainHandler = handler = ConcurrencyHelpers.mainHandlerAsync();
                }
                if (this.mObserver == null) {
                    this.mObserver = new ContentObserver(handler){

                        public void onChange(boolean selfChange, Uri uri) {
                            this.loadInternal();
                        }
                    };
                    this.mFontProviderHelper.registerObserver(this.mContext, uri, this.mObserver);
                }
                if (this.mMainHandlerLoadCallback == null) {
                    this.mMainHandlerLoadCallback = this::loadInternal;
                }
                handler.postDelayed(this.mMainHandlerLoadCallback, waitMs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp() {
            Object object = this.mLock;
            synchronized (object) {
                this.mCallback = null;
                if (this.mObserver != null) {
                    this.mFontProviderHelper.unregisterObserver(this.mContext, this.mObserver);
                    this.mObserver = null;
                }
                if (this.mMainHandler != null) {
                    this.mMainHandler.removeCallbacks(this.mMainHandlerLoadCallback);
                }
                this.mMainHandler = null;
                if (this.mMyThreadPoolExecutor != null) {
                    this.mMyThreadPoolExecutor.shutdown();
                }
                this.mExecutor = null;
                this.mMyThreadPoolExecutor = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        void createMetadata() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCallback == null) {
                    return;
                }
            }
            try {
                MetadataRepo metadataRepo;
                FontsContractCompat.FontInfo font = this.retrieveFontInfo();
                int resultCode = font.getResultCode();
                if (resultCode == 2) {
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        long delayMs;
                        if (this.mRetryPolicy != null && (delayMs = this.mRetryPolicy.getRetryDelay()) >= 0L) {
                            this.scheduleRetry(font.getUri(), delayMs);
                            return;
                        }
                    }
                }
                if (resultCode != 0) {
                    throw new RuntimeException("fetchFonts result is not OK. (" + resultCode + ")");
                }
                try {
                    TraceCompat.beginSection((String)S_TRACE_BUILD_TYPEFACE);
                    Typeface typeface = this.mFontProviderHelper.buildTypeface(this.mContext, font);
                    ByteBuffer buffer = TypefaceCompatUtil.mmap((Context)this.mContext, null, (Uri)font.getUri());
                    if (buffer == null || typeface == null) {
                        throw new RuntimeException("Unable to open file.");
                    }
                    metadataRepo = MetadataRepo.create(typeface, buffer);
                }
                finally {
                    TraceCompat.endSection();
                }
                Object object3 = this.mLock;
                synchronized (object3) {
                    if (this.mCallback != null) {
                        this.mCallback.onLoaded(metadataRepo);
                    }
                }
                this.cleanUp();
            }
            catch (Throwable t) {
                Object object4 = this.mLock;
                synchronized (object4) {
                    if (this.mCallback != null) {
                        this.mCallback.onFailed(t);
                    }
                }
                this.cleanUp();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class FontProviderHelper {
        @NonNull
        public FontsContractCompat.FontFamilyResult fetchFonts(@NonNull Context context, @NonNull FontRequest request) throws PackageManager.NameNotFoundException {
            return FontsContractCompat.fetchFonts((Context)context, null, (FontRequest)request);
        }

        @Nullable
        public Typeface buildTypeface(@NonNull Context context, @NonNull FontsContractCompat.FontInfo font) throws PackageManager.NameNotFoundException {
            return FontsContractCompat.buildTypeface((Context)context, null, (FontsContractCompat.FontInfo[])new FontsContractCompat.FontInfo[]{font});
        }

        public void registerObserver(@NonNull Context context, @NonNull Uri uri, @NonNull ContentObserver observer) {
            context.getContentResolver().registerContentObserver(uri, false, observer);
        }

        public void unregisterObserver(@NonNull Context context, @NonNull ContentObserver observer) {
            context.getContentResolver().unregisterContentObserver(observer);
        }
    }

    public static abstract class RetryPolicy {
        public abstract long getRetryDelay();
    }

    public static class ExponentialBackoffRetryPolicy
    extends RetryPolicy {
        private final long mTotalMs;
        private long mRetryOrigin;

        public ExponentialBackoffRetryPolicy(long totalMs) {
            this.mTotalMs = totalMs;
        }

        @Override
        public long getRetryDelay() {
            if (this.mRetryOrigin == 0L) {
                this.mRetryOrigin = SystemClock.uptimeMillis();
                return 0L;
            }
            long elapsedMillis = SystemClock.uptimeMillis() - this.mRetryOrigin;
            if (elapsedMillis > this.mTotalMs) {
                return -1L;
            }
            return Math.min(Math.max(elapsedMillis, 1000L), this.mTotalMs - elapsedMillis);
        }
    }
}

