/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.text.style.MetricAffectingSpan;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.text.EmojiSpan;
import androidx.emoji2.text.TypefaceEmojiRasterizer;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TypefaceEmojiSpan
extends EmojiSpan {
    @Nullable
    private static Paint sDebugPaint;
    @Nullable
    private TextPaint mWorkingPaint;

    public TypefaceEmojiSpan(@NonNull TypefaceEmojiRasterizer metadata) {
        super(metadata);
    }

    public void draw(@NonNull Canvas canvas, @SuppressLint(value={"UnknownNullness"}) CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        TextPaint textPaint = this.applyCharacterSpanStyles(text, start, end, paint);
        if (textPaint != null && textPaint.bgColor != 0) {
            this.drawBackground(canvas, textPaint, x, x + (float)this.getWidth(), top, bottom);
        }
        if (EmojiCompat.get().isEmojiSpanIndicatorEnabled()) {
            canvas.drawRect(x, (float)top, x + (float)this.getWidth(), (float)bottom, TypefaceEmojiSpan.getDebugPaint());
        }
        this.getTypefaceRasterizer().draw(canvas, x, y, (Paint)(textPaint != null ? textPaint : paint));
    }

    void drawBackground(Canvas c, TextPaint textPaint, float leftX, float rightX, float top, float bottom) {
        int previousColor = textPaint.getColor();
        Paint.Style previousStyle = textPaint.getStyle();
        textPaint.setColor(textPaint.bgColor);
        textPaint.setStyle(Paint.Style.FILL);
        c.drawRect(leftX, top, rightX, bottom, (Paint)textPaint);
        textPaint.setStyle(previousStyle);
        textPaint.setColor(previousColor);
    }

    @Nullable
    private TextPaint applyCharacterSpanStyles(@Nullable CharSequence text, int start, int end, Paint paint) {
        if (text instanceof Spanned) {
            Spanned spanned = (Spanned)text;
            CharacterStyle[] spans = (CharacterStyle[])spanned.getSpans(start, end, CharacterStyle.class);
            if (spans.length == 0 || spans.length == 1 && spans[0] == this) {
                if (paint instanceof TextPaint) {
                    return (TextPaint)paint;
                }
                return null;
            }
            TextPaint wp = this.mWorkingPaint;
            if (wp == null) {
                this.mWorkingPaint = wp = new TextPaint();
            }
            wp.set(paint);
            for (int pos = 0; pos < spans.length; ++pos) {
                if (spans[pos] instanceof MetricAffectingSpan) continue;
                spans[pos].updateDrawState(wp);
            }
            return wp;
        }
        if (paint instanceof TextPaint) {
            return (TextPaint)paint;
        }
        return null;
    }

    @NonNull
    private static Paint getDebugPaint() {
        if (sDebugPaint == null) {
            sDebugPaint = new TextPaint();
            sDebugPaint.setColor(EmojiCompat.get().getEmojiSpanIndicatorColor());
            sDebugPaint.setStyle(Paint.Style.FILL);
        }
        return sDebugPaint;
    }
}

