/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.math.MathUtils;
import androidx.core.util.ObjectsCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.appbar.HeaderBehavior;
import com.google.android.material.appbar.HeaderScrollingViewBehavior;
import com.google.android.material.appbar.ViewUtilsLollipop;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class AppBarLayout
extends LinearLayout
implements CoordinatorLayout.AttachedBehavior {
    static final int PENDING_ACTION_NONE = 0;
    static final int PENDING_ACTION_EXPANDED = 1;
    static final int PENDING_ACTION_COLLAPSED = 2;
    static final int PENDING_ACTION_ANIMATE_ENABLED = 4;
    static final int PENDING_ACTION_FORCE = 8;
    private static final int DEF_STYLE_RES = R.style.Widget_Design_AppBarLayout;
    private static final int INVALID_SCROLL_RANGE = -1;
    private int currentOffset;
    private int totalScrollRange = -1;
    private int downPreScrollRange = -1;
    private int downScrollRange = -1;
    private boolean haveChildWithInterpolator;
    private int pendingAction = 0;
    @Nullable
    private WindowInsetsCompat lastInsets;
    private List<BaseOnOffsetChangedListener> listeners;
    private boolean liftableOverride;
    private boolean liftable;
    private boolean lifted;
    private boolean liftOnScroll;
    @IdRes
    private int liftOnScrollTargetViewId;
    @Nullable
    private WeakReference<View> liftOnScrollTargetView;
    private final boolean hasLiftOnScrollColor;
    @Nullable
    private ValueAnimator liftOnScrollColorAnimator;
    @Nullable
    private ValueAnimator.AnimatorUpdateListener liftOnScrollColorUpdateListener;
    private final List<LiftOnScrollListener> liftOnScrollListeners = new ArrayList<LiftOnScrollListener>();
    private final long liftOnScrollColorDuration;
    private final TimeInterpolator liftOnScrollColorInterpolator;
    private int[] tmpStatesArray;
    @Nullable
    private Drawable statusBarForeground;
    @Nullable
    private Integer statusBarForegroundOriginalColor;
    private final float appBarElevation;
    private Behavior behavior;

    public AppBarLayout(@NonNull Context context) {
        this(context, null);
    }

    public AppBarLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.appBarLayoutStyle);
    }

    public AppBarLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.setOrientation(1);
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.getOutlineProvider() == ViewOutlineProvider.BACKGROUND) {
                ViewUtilsLollipop.setBoundsViewOutlineProvider((View)this);
            }
            ViewUtilsLollipop.setStateListAnimatorFromAttrs((View)this, attrs, defStyleAttr, DEF_STYLE_RES);
        }
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.AppBarLayout, defStyleAttr, DEF_STYLE_RES, new int[0]);
        ViewCompat.setBackground((View)this, (Drawable)a.getDrawable(R.styleable.AppBarLayout_android_background));
        ColorStateList liftOnScrollColor = MaterialResources.getColorStateList(context, a, R.styleable.AppBarLayout_liftOnScrollColor);
        this.hasLiftOnScrollColor = liftOnScrollColor != null;
        ColorStateList originalBackgroundColor = DrawableUtils.getColorStateListOrNull(this.getBackground());
        if (originalBackgroundColor != null) {
            MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable();
            materialShapeDrawable.setFillColor(originalBackgroundColor);
            if (liftOnScrollColor != null) {
                this.initializeLiftOnScrollWithColor(materialShapeDrawable, originalBackgroundColor, liftOnScrollColor);
            } else {
                this.initializeLiftOnScrollWithElevation(context, materialShapeDrawable);
            }
        }
        this.liftOnScrollColorDuration = MotionUtils.resolveThemeDuration(context, R.attr.motionDurationMedium2, this.getResources().getInteger(R.integer.app_bar_elevation_anim_duration));
        this.liftOnScrollColorInterpolator = MotionUtils.resolveThemeInterpolator(context, R.attr.motionEasingStandardInterpolator, AnimationUtils.LINEAR_INTERPOLATOR);
        if (a.hasValue(R.styleable.AppBarLayout_expanded)) {
            this.setExpanded(a.getBoolean(R.styleable.AppBarLayout_expanded, false), false, false);
        }
        if (Build.VERSION.SDK_INT >= 21 && a.hasValue(R.styleable.AppBarLayout_elevation)) {
            ViewUtilsLollipop.setDefaultAppBarLayoutStateListAnimator((View)this, a.getDimensionPixelSize(R.styleable.AppBarLayout_elevation, 0));
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (a.hasValue(R.styleable.AppBarLayout_android_keyboardNavigationCluster)) {
                this.setKeyboardNavigationCluster(a.getBoolean(R.styleable.AppBarLayout_android_keyboardNavigationCluster, false));
            }
            if (a.hasValue(R.styleable.AppBarLayout_android_touchscreenBlocksFocus)) {
                this.setTouchscreenBlocksFocus(a.getBoolean(R.styleable.AppBarLayout_android_touchscreenBlocksFocus, false));
            }
        }
        this.appBarElevation = this.getResources().getDimension(R.dimen.design_appbar_elevation);
        this.liftOnScroll = a.getBoolean(R.styleable.AppBarLayout_liftOnScroll, false);
        this.liftOnScrollTargetViewId = a.getResourceId(R.styleable.AppBarLayout_liftOnScrollTargetViewId, -1);
        this.setStatusBarForeground(a.getDrawable(R.styleable.AppBarLayout_statusBarForeground));
        a.recycle();
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                return AppBarLayout.this.onWindowInsetChanged(insets);
            }
        });
    }

    private void initializeLiftOnScrollWithColor(MaterialShapeDrawable background, @NonNull ColorStateList originalBackgroundColor, @NonNull ColorStateList liftOnScrollColor) {
        Integer colorSurface = MaterialColors.getColorOrNull(this.getContext(), R.attr.colorSurface);
        this.liftOnScrollColorUpdateListener = valueAnimator -> {
            float liftProgress = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            int mixedColor = MaterialColors.layer(originalBackgroundColor.getDefaultColor(), liftOnScrollColor.getDefaultColor(), liftProgress);
            background.setFillColor(ColorStateList.valueOf((int)mixedColor));
            if (this.statusBarForeground != null && this.statusBarForegroundOriginalColor != null && this.statusBarForegroundOriginalColor.equals(colorSurface)) {
                DrawableCompat.setTint((Drawable)this.statusBarForeground, (int)mixedColor);
            }
            if (!this.liftOnScrollListeners.isEmpty()) {
                for (LiftOnScrollListener liftOnScrollListener : this.liftOnScrollListeners) {
                    if (background.getFillColor() == null) continue;
                    liftOnScrollListener.onUpdate(0.0f, mixedColor);
                }
            }
        };
        ViewCompat.setBackground((View)this, (Drawable)background);
    }

    private void initializeLiftOnScrollWithElevation(Context context, MaterialShapeDrawable background) {
        background.initializeElevationOverlay(context);
        this.liftOnScrollColorUpdateListener = valueAnimator -> {
            float elevation = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            background.setElevation(elevation);
            if (this.statusBarForeground instanceof MaterialShapeDrawable) {
                ((MaterialShapeDrawable)this.statusBarForeground).setElevation(elevation);
            }
            for (LiftOnScrollListener liftOnScrollListener : this.liftOnScrollListeners) {
                liftOnScrollListener.onUpdate(elevation, background.getResolvedTintColor());
            }
        };
        ViewCompat.setBackground((View)this, (Drawable)background);
    }

    public void addOnOffsetChangedListener(@Nullable BaseOnOffsetChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BaseOnOffsetChangedListener>();
        }
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addOnOffsetChangedListener(OnOffsetChangedListener listener) {
        this.addOnOffsetChangedListener((BaseOnOffsetChangedListener)listener);
    }

    public void removeOnOffsetChangedListener(@Nullable BaseOnOffsetChangedListener listener) {
        if (this.listeners != null && listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void removeOnOffsetChangedListener(OnOffsetChangedListener listener) {
        this.removeOnOffsetChangedListener((BaseOnOffsetChangedListener)listener);
    }

    public void addLiftOnScrollListener(@NonNull LiftOnScrollListener liftOnScrollListener) {
        this.liftOnScrollListeners.add(liftOnScrollListener);
    }

    public boolean removeLiftOnScrollListener(@NonNull LiftOnScrollListener liftOnScrollListener) {
        return this.liftOnScrollListeners.remove(liftOnScrollListener);
    }

    public void clearLiftOnScrollListener() {
        this.liftOnScrollListeners.clear();
    }

    public void setStatusBarForeground(@Nullable Drawable drawable) {
        if (this.statusBarForeground != drawable) {
            if (this.statusBarForeground != null) {
                this.statusBarForeground.setCallback(null);
            }
            this.statusBarForeground = drawable != null ? drawable.mutate() : null;
            this.statusBarForegroundOriginalColor = this.extractStatusBarForegroundColor();
            if (this.statusBarForeground != null) {
                if (this.statusBarForeground.isStateful()) {
                    this.statusBarForeground.setState(this.getDrawableState());
                }
                DrawableCompat.setLayoutDirection((Drawable)this.statusBarForeground, (int)ViewCompat.getLayoutDirection((View)this));
                this.statusBarForeground.setVisible(this.getVisibility() == 0, false);
                this.statusBarForeground.setCallback((Drawable.Callback)this);
            }
            this.updateWillNotDraw();
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setStatusBarForegroundColor(@ColorInt int color) {
        this.setStatusBarForeground((Drawable)new ColorDrawable(color));
    }

    public void setStatusBarForegroundResource(@DrawableRes int resId) {
        this.setStatusBarForeground(AppCompatResources.getDrawable((Context)this.getContext(), (int)resId));
    }

    @Nullable
    public Drawable getStatusBarForeground() {
        return this.statusBarForeground;
    }

    @Nullable
    private Integer extractStatusBarForegroundColor() {
        if (this.statusBarForeground instanceof MaterialShapeDrawable) {
            return ((MaterialShapeDrawable)this.statusBarForeground).getResolvedTintColor();
        }
        ColorStateList statusBarForegroundColorStateList = DrawableUtils.getColorStateListOrNull(this.statusBarForeground);
        if (statusBarForegroundColorStateList != null) {
            return statusBarForegroundColorStateList.getDefaultColor();
        }
        return null;
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.shouldDrawStatusBarForeground()) {
            int saveCount = canvas.save();
            canvas.translate(0.0f, (float)(-this.currentOffset));
            this.statusBarForeground.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        Drawable d = this.statusBarForeground;
        if (d != null && d.isStateful() && d.setState(state)) {
            this.invalidateDrawable(d);
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.statusBarForeground;
    }

    public void setVisibility(int visibility) {
        boolean visible;
        super.setVisibility(visibility);
        boolean bl = visible = visibility == 0;
        if (this.statusBarForeground != null) {
            this.statusBarForeground.setVisible(visible, false);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode != 0x40000000 && ViewCompat.getFitsSystemWindows((View)this) && this.shouldOffsetFirstChild()) {
            int newHeight = this.getMeasuredHeight();
            switch (heightMode) {
                case -2147483648: {
                    newHeight = MathUtils.clamp((int)(this.getMeasuredHeight() + this.getTopInset()), (int)0, (int)View.MeasureSpec.getSize((int)heightMeasureSpec));
                    break;
                }
                case 0: {
                    newHeight += this.getTopInset();
                    break;
                }
            }
            this.setMeasuredDimension(this.getMeasuredWidth(), newHeight);
        }
        this.invalidateScrollRanges();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int z;
        super.onLayout(changed, l, t, r, b);
        if (ViewCompat.getFitsSystemWindows((View)this) && this.shouldOffsetFirstChild()) {
            int topInset = this.getTopInset();
            for (z = this.getChildCount() - 1; z >= 0; --z) {
                ViewCompat.offsetTopAndBottom((View)this.getChildAt(z), (int)topInset);
            }
        }
        this.invalidateScrollRanges();
        this.haveChildWithInterpolator = false;
        z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams childLp = (LayoutParams)child.getLayoutParams();
            Interpolator interpolator = childLp.getScrollInterpolator();
            if (interpolator == null) continue;
            this.haveChildWithInterpolator = true;
            break;
        }
        if (this.statusBarForeground != null) {
            this.statusBarForeground.setBounds(0, 0, this.getWidth(), this.getTopInset());
        }
        if (!this.liftableOverride) {
            this.setLiftableState(this.liftOnScroll || this.hasCollapsibleChild());
        }
    }

    private void updateWillNotDraw() {
        this.setWillNotDraw(!this.shouldDrawStatusBarForeground());
    }

    private boolean shouldDrawStatusBarForeground() {
        return this.statusBarForeground != null && this.getTopInset() > 0;
    }

    private boolean hasCollapsibleChild() {
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            if (!((LayoutParams)this.getChildAt(i).getLayoutParams()).isCollapsible()) continue;
            return true;
        }
        return false;
    }

    private void invalidateScrollRanges() {
        BaseBehavior.SavedState savedState = this.behavior == null || this.totalScrollRange == -1 || this.pendingAction != 0 ? null : this.behavior.saveScrollState((Parcelable)AbsSavedState.EMPTY_STATE, this);
        this.totalScrollRange = -1;
        this.downPreScrollRange = -1;
        this.downScrollRange = -1;
        if (savedState != null) {
            this.behavior.restoreScrollState(savedState, false);
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 1) {
            throw new IllegalArgumentException("AppBarLayout is always vertical and does not support horizontal orientation");
        }
        super.setOrientation(orientation);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    @NonNull
    public CoordinatorLayout.Behavior<AppBarLayout> getBehavior() {
        this.behavior = new Behavior();
        return this.behavior;
    }

    @Nullable
    public MaterialShapeDrawable getMaterialShapeBackground() {
        Drawable background = this.getBackground();
        return background instanceof MaterialShapeDrawable ? (MaterialShapeDrawable)background : null;
    }

    @RequiresApi(value=21)
    public void setElevation(float elevation) {
        super.setElevation(elevation);
        MaterialShapeUtils.setElevation((View)this, elevation);
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, ViewCompat.isLaidOut((View)this));
    }

    public void setExpanded(boolean expanded, boolean animate) {
        this.setExpanded(expanded, animate, true);
    }

    private void setExpanded(boolean expanded, boolean animate, boolean force) {
        this.pendingAction = (expanded ? 1 : 2) | (animate ? 4 : 0) | (force ? 8 : 0);
        this.requestLayout();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (Build.VERSION.SDK_INT >= 19 && p instanceof LinearLayout.LayoutParams) {
            return new LayoutParams((LinearLayout.LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearLiftOnScrollTargetView();
    }

    boolean hasChildWithInterpolator() {
        return this.haveChildWithInterpolator;
    }

    public final int getTotalScrollRange() {
        if (this.totalScrollRange != -1) {
            return this.totalScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int flags = lp.scrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight + lp.topMargin + lp.bottomMargin;
            if (i == 0 && ViewCompat.getFitsSystemWindows((View)child)) {
                range -= this.getTopInset();
            }
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child);
            break;
        }
        this.totalScrollRange = Math.max(0, range);
        return this.totalScrollRange;
    }

    boolean hasScrollableChildren() {
        return this.getTotalScrollRange() != 0;
    }

    int getUpNestedPreScrollRange() {
        return this.getTotalScrollRange();
    }

    int getDownNestedPreScrollRange() {
        if (this.downPreScrollRange != -1) {
            return this.downPreScrollRange;
        }
        int range = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int flags = lp.scrollFlags;
            if ((flags & 5) == 5) {
                int childRange = lp.topMargin + lp.bottomMargin;
                childRange = (flags & 8) != 0 ? (childRange += ViewCompat.getMinimumHeight((View)child)) : ((flags & 2) != 0 ? (childRange += childHeight - ViewCompat.getMinimumHeight((View)child)) : (childRange += childHeight));
                if (i == 0 && ViewCompat.getFitsSystemWindows((View)child)) {
                    childRange = Math.min(childRange, childHeight - this.getTopInset());
                }
                range += childRange;
                continue;
            }
            if (range > 0) break;
        }
        this.downPreScrollRange = Math.max(0, range);
        return this.downPreScrollRange;
    }

    int getDownNestedScrollRange() {
        if (this.downScrollRange != -1) {
            return this.downScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            childHeight += lp.topMargin + lp.bottomMargin;
            int flags = lp.scrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight;
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child);
            break;
        }
        this.downScrollRange = Math.max(0, range);
        return this.downScrollRange;
    }

    void onOffsetChanged(int offset) {
        this.currentOffset = offset;
        if (!this.willNotDraw()) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        if (this.listeners != null) {
            int z = this.listeners.size();
            for (int i = 0; i < z; ++i) {
                BaseOnOffsetChangedListener listener = this.listeners.get(i);
                if (listener == null) continue;
                listener.onOffsetChanged(this, offset);
            }
        }
    }

    public final int getMinimumHeightForVisibleOverlappingContent() {
        int lastChildMinHeight;
        int topInset = this.getTopInset();
        int minHeight = ViewCompat.getMinimumHeight((View)this);
        if (minHeight != 0) {
            return minHeight * 2 + topInset;
        }
        int childCount = this.getChildCount();
        int n = lastChildMinHeight = childCount >= 1 ? ViewCompat.getMinimumHeight((View)this.getChildAt(childCount - 1)) : 0;
        if (lastChildMinHeight != 0) {
            return lastChildMinHeight * 2 + topInset;
        }
        return this.getHeight() / 3;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.tmpStatesArray == null) {
            this.tmpStatesArray = new int[4];
        }
        int[] extraStates = this.tmpStatesArray;
        int[] states = super.onCreateDrawableState(extraSpace + extraStates.length);
        extraStates[0] = this.liftable ? R.attr.state_liftable : -R.attr.state_liftable;
        extraStates[1] = this.liftable && this.lifted ? R.attr.state_lifted : -R.attr.state_lifted;
        extraStates[2] = this.liftable ? R.attr.state_collapsible : -R.attr.state_collapsible;
        extraStates[3] = this.liftable && this.lifted ? R.attr.state_collapsed : -R.attr.state_collapsed;
        return AppBarLayout.mergeDrawableStates((int[])states, (int[])extraStates);
    }

    public boolean setLiftable(boolean liftable) {
        this.liftableOverride = true;
        return this.setLiftableState(liftable);
    }

    public void setLiftableOverrideEnabled(boolean enabled) {
        this.liftableOverride = enabled;
    }

    private boolean setLiftableState(boolean liftable) {
        if (this.liftable != liftable) {
            this.liftable = liftable;
            this.refreshDrawableState();
            return true;
        }
        return false;
    }

    public boolean setLifted(boolean lifted) {
        return this.setLiftedState(lifted, true);
    }

    public boolean isLifted() {
        return this.lifted;
    }

    boolean setLiftedState(boolean lifted) {
        return this.setLiftedState(lifted, !this.liftableOverride);
    }

    boolean setLiftedState(boolean lifted, boolean force) {
        if (force && this.lifted != lifted) {
            this.lifted = lifted;
            this.refreshDrawableState();
            if (this.isLiftOnScrollCompatibleBackground()) {
                if (this.hasLiftOnScrollColor) {
                    this.startLiftOnScrollColorAnimation(lifted ? 0.0f : 1.0f, lifted ? 1.0f : 0.0f);
                } else if (this.liftOnScroll) {
                    this.startLiftOnScrollColorAnimation(lifted ? 0.0f : this.appBarElevation, lifted ? this.appBarElevation : 0.0f);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isLiftOnScrollCompatibleBackground() {
        return this.getBackground() instanceof MaterialShapeDrawable;
    }

    private void startLiftOnScrollColorAnimation(float fromValue, float toValue) {
        if (this.liftOnScrollColorAnimator != null) {
            this.liftOnScrollColorAnimator.cancel();
        }
        this.liftOnScrollColorAnimator = ValueAnimator.ofFloat((float[])new float[]{fromValue, toValue});
        this.liftOnScrollColorAnimator.setDuration(this.liftOnScrollColorDuration);
        this.liftOnScrollColorAnimator.setInterpolator(this.liftOnScrollColorInterpolator);
        if (this.liftOnScrollColorUpdateListener != null) {
            this.liftOnScrollColorAnimator.addUpdateListener(this.liftOnScrollColorUpdateListener);
        }
        this.liftOnScrollColorAnimator.start();
    }

    public void setLiftOnScroll(boolean liftOnScroll) {
        this.liftOnScroll = liftOnScroll;
    }

    public boolean isLiftOnScroll() {
        return this.liftOnScroll;
    }

    public void setLiftOnScrollTargetView(@Nullable View liftOnScrollTargetView) {
        this.liftOnScrollTargetViewId = -1;
        if (liftOnScrollTargetView == null) {
            this.clearLiftOnScrollTargetView();
        } else {
            this.liftOnScrollTargetView = new WeakReference<View>(liftOnScrollTargetView);
        }
    }

    public void setLiftOnScrollTargetViewId(@IdRes int liftOnScrollTargetViewId) {
        this.liftOnScrollTargetViewId = liftOnScrollTargetViewId;
        this.clearLiftOnScrollTargetView();
    }

    @IdRes
    public int getLiftOnScrollTargetViewId() {
        return this.liftOnScrollTargetViewId;
    }

    boolean shouldLift(@Nullable View defaultScrollingView) {
        View scrollingView = this.findLiftOnScrollTargetView(defaultScrollingView);
        if (scrollingView == null) {
            scrollingView = defaultScrollingView;
        }
        return scrollingView != null && (scrollingView.canScrollVertically(-1) || scrollingView.getScrollY() > 0);
    }

    @Nullable
    private View findLiftOnScrollTargetView(@Nullable View defaultScrollingView) {
        if (this.liftOnScrollTargetView == null && this.liftOnScrollTargetViewId != -1) {
            View targetView = null;
            if (defaultScrollingView != null) {
                targetView = defaultScrollingView.findViewById(this.liftOnScrollTargetViewId);
            }
            if (targetView == null && this.getParent() instanceof ViewGroup) {
                targetView = ((ViewGroup)this.getParent()).findViewById(this.liftOnScrollTargetViewId);
            }
            if (targetView != null) {
                this.liftOnScrollTargetView = new WeakReference<View>(targetView);
            }
        }
        return this.liftOnScrollTargetView != null ? (View)this.liftOnScrollTargetView.get() : null;
    }

    private void clearLiftOnScrollTargetView() {
        if (this.liftOnScrollTargetView != null) {
            this.liftOnScrollTargetView.clear();
        }
        this.liftOnScrollTargetView = null;
    }

    @Deprecated
    public void setTargetElevation(float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewUtilsLollipop.setDefaultAppBarLayoutStateListAnimator((View)this, elevation);
        }
    }

    @Deprecated
    public float getTargetElevation() {
        return 0.0f;
    }

    int getPendingAction() {
        return this.pendingAction;
    }

    void resetPendingAction() {
        this.pendingAction = 0;
    }

    @VisibleForTesting
    final int getTopInset() {
        return this.lastInsets != null ? this.lastInsets.getSystemWindowInsetTop() : 0;
    }

    private boolean shouldOffsetFirstChild() {
        if (this.getChildCount() > 0) {
            View firstChild = this.getChildAt(0);
            return firstChild.getVisibility() != 8 && !ViewCompat.getFitsSystemWindows((View)firstChild);
        }
        return false;
    }

    WindowInsetsCompat onWindowInsetChanged(WindowInsetsCompat insets) {
        WindowInsetsCompat newInsets = null;
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            newInsets = insets;
        }
        if (!ObjectsCompat.equals((Object)this.lastInsets, (Object)newInsets)) {
            this.lastInsets = newInsets;
            this.updateWillNotDraw();
            this.requestLayout();
        }
        return insets;
    }

    public static class CompressChildScrollEffect
    extends ChildScrollEffect {
        private static final float COMPRESS_DISTANCE_FACTOR = 0.3f;
        private final Rect relativeRect = new Rect();
        private final Rect ghostRect = new Rect();

        private static void updateRelativeRect(Rect rect, AppBarLayout appBarLayout, View child) {
            child.getDrawingRect(rect);
            appBarLayout.offsetDescendantRectToMyCoords(child, rect);
            rect.offset(0, -appBarLayout.getTopInset());
        }

        @Override
        public void onOffsetChanged(@NonNull AppBarLayout appBarLayout, @NonNull View child, float offset) {
            CompressChildScrollEffect.updateRelativeRect(this.relativeRect, appBarLayout, child);
            float distanceFromCeiling = (float)this.relativeRect.top - Math.abs(offset);
            if (distanceFromCeiling <= 0.0f) {
                float p = MathUtils.clamp((float)Math.abs(distanceFromCeiling / (float)this.relativeRect.height()), (float)0.0f, (float)1.0f);
                float offsetY = -distanceFromCeiling;
                float easeOutQuad = 1.0f - (1.0f - p) * (1.0f - p);
                float distance = (float)this.relativeRect.height() * 0.3f;
                child.setTranslationY(offsetY -= distance * easeOutQuad);
                child.getDrawingRect(this.ghostRect);
                this.ghostRect.offset(0, (int)(-offsetY));
                ViewCompat.setClipBounds((View)child, (Rect)this.ghostRect);
            } else {
                ViewCompat.setClipBounds((View)child, null);
                child.setTranslationY(0.0f);
            }
        }
    }

    public static abstract class ChildScrollEffect {
        public abstract void onOffsetChanged(@NonNull AppBarLayout var1, @NonNull View var2, float var3);
    }

    public static class ScrollingViewBehavior
    extends HeaderScrollingViewBehavior {
        public ScrollingViewBehavior() {
        }

        public ScrollingViewBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScrollingViewBehavior_Layout);
            this.setOverlayTop(a.getDimensionPixelSize(R.styleable.ScrollingViewBehavior_Layout_behavior_overlapTop, 0));
            a.recycle();
        }

        public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
            return dependency instanceof AppBarLayout;
        }

        public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
            this.offsetChildAsNeeded(child, dependency);
            this.updateLiftedStateIfNeeded(child, dependency);
            return false;
        }

        public void onDependentViewRemoved(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
            if (dependency instanceof AppBarLayout) {
                ViewCompat.removeAccessibilityAction((View)parent, (int)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId());
                ViewCompat.removeAccessibilityAction((View)parent, (int)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId());
                ViewCompat.setAccessibilityDelegate((View)parent, null);
            }
        }

        public boolean onRequestChildRectangleOnScreen(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull Rect rectangle, boolean immediate) {
            AppBarLayout header = this.findFirstDependency((List<View>)parent.getDependencies(child));
            if (header != null) {
                Rect offsetRect = new Rect(rectangle);
                offsetRect.offset(child.getLeft(), child.getTop());
                Rect parentRect = this.tempRect1;
                parentRect.set(0, 0, parent.getWidth(), parent.getHeight());
                if (!parentRect.contains(offsetRect)) {
                    header.setExpanded(false, !immediate);
                    return true;
                }
            }
            return false;
        }

        private void offsetChildAsNeeded(@NonNull View child, @NonNull View dependency) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)dependency.getLayoutParams()).getBehavior();
            if (behavior instanceof BaseBehavior) {
                BaseBehavior ablBehavior = (BaseBehavior)behavior;
                ViewCompat.offsetTopAndBottom((View)child, (int)(dependency.getBottom() - child.getTop() + ablBehavior.offsetDelta + this.getVerticalLayoutGap() - this.getOverlapPixelsForOffset(dependency)));
            }
        }

        @Override
        float getOverlapRatioForOffset(View header) {
            if (header instanceof AppBarLayout) {
                AppBarLayout abl = (AppBarLayout)header;
                int totalScrollRange = abl.getTotalScrollRange();
                int preScrollDown = abl.getDownNestedPreScrollRange();
                int offset = ScrollingViewBehavior.getAppBarLayoutOffset(abl);
                if (preScrollDown != 0 && totalScrollRange + offset <= preScrollDown) {
                    return 0.0f;
                }
                int availScrollRange = totalScrollRange - preScrollDown;
                if (availScrollRange != 0) {
                    return 1.0f + (float)offset / (float)availScrollRange;
                }
            }
            return 0.0f;
        }

        private static int getAppBarLayoutOffset(@NonNull AppBarLayout abl) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)abl.getLayoutParams()).getBehavior();
            if (behavior instanceof BaseBehavior) {
                return ((BaseBehavior)behavior).getTopBottomOffsetForScrollingSibling();
            }
            return 0;
        }

        @Nullable
        AppBarLayout findFirstDependency(@NonNull List<View> views) {
            int z = views.size();
            for (int i = 0; i < z; ++i) {
                View view = views.get(i);
                if (!(view instanceof AppBarLayout)) continue;
                return (AppBarLayout)view;
            }
            return null;
        }

        @Override
        int getScrollRange(View v) {
            if (v instanceof AppBarLayout) {
                return ((AppBarLayout)v).getTotalScrollRange();
            }
            return super.getScrollRange(v);
        }

        private void updateLiftedStateIfNeeded(View child, View dependency) {
            AppBarLayout appBarLayout;
            if (dependency instanceof AppBarLayout && (appBarLayout = (AppBarLayout)dependency).isLiftOnScroll()) {
                appBarLayout.setLiftedState(appBarLayout.shouldLift(child));
            }
        }
    }

    protected static class BaseBehavior<T extends AppBarLayout>
    extends HeaderBehavior<T> {
        private static final int MAX_OFFSET_ANIMATION_DURATION = 600;
        private int offsetDelta;
        private int lastStartedType;
        private ValueAnimator offsetAnimator;
        private SavedState savedState;
        @Nullable
        private WeakReference<View> lastNestedScrollingChildRef;
        private BaseDragCallback onDragCallback;
        private boolean coordinatorLayoutA11yScrollable;

        public BaseBehavior() {
        }

        public BaseBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public boolean onStartNestedScroll(@NonNull CoordinatorLayout parent, @NonNull T child, @NonNull View directTargetChild, View target, int nestedScrollAxes, int type) {
            boolean started;
            boolean bl = started = (nestedScrollAxes & 2) != 0 && (((AppBarLayout)((Object)child)).isLiftOnScroll() || this.canScrollChildren(parent, child, directTargetChild));
            if (started && this.offsetAnimator != null) {
                this.offsetAnimator.cancel();
            }
            this.lastNestedScrollingChildRef = null;
            this.lastStartedType = type;
            return started;
        }

        private boolean canScrollChildren(@NonNull CoordinatorLayout parent, @NonNull T child, @NonNull View directTargetChild) {
            return ((AppBarLayout)((Object)child)).hasScrollableChildren() && parent.getHeight() - directTargetChild.getHeight() <= child.getHeight();
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, @NonNull T child, View target, int dx, int dy, int[] consumed, int type) {
            if (dy != 0) {
                int max;
                int min;
                if (dy < 0) {
                    min = -((AppBarLayout)((Object)child)).getTotalScrollRange();
                    max = min + ((AppBarLayout)((Object)child)).getDownNestedPreScrollRange();
                } else {
                    min = -((AppBarLayout)((Object)child)).getUpNestedPreScrollRange();
                    max = 0;
                }
                if (min != max) {
                    consumed[1] = this.scroll(coordinatorLayout, child, dy, min, max);
                }
            }
            if (((AppBarLayout)((Object)child)).isLiftOnScroll()) {
                ((AppBarLayout)((Object)child)).setLiftedState(((AppBarLayout)((Object)child)).shouldLift(target));
            }
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, @NonNull T child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, int[] consumed) {
            if (dyUnconsumed < 0) {
                consumed[1] = this.scroll(coordinatorLayout, child, dyUnconsumed, -((AppBarLayout)((Object)child)).getDownNestedScrollRange(), 0);
            }
            if (dyUnconsumed == 0) {
                this.updateAccessibilityActions(coordinatorLayout, child);
            }
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, @NonNull T abl, View target, int type) {
            if (this.lastStartedType == 0 || type == 1) {
                this.snapToChildIfNeeded(coordinatorLayout, abl);
                if (((AppBarLayout)((Object)abl)).isLiftOnScroll()) {
                    ((AppBarLayout)((Object)abl)).setLiftedState(((AppBarLayout)((Object)abl)).shouldLift(target));
                }
            }
            this.lastNestedScrollingChildRef = new WeakReference<View>(target);
        }

        public void setDragCallback(@Nullable BaseDragCallback callback) {
            this.onDragCallback = callback;
        }

        private void animateOffsetTo(CoordinatorLayout coordinatorLayout, @NonNull T child, int offset, float velocity) {
            int duration;
            int distance = Math.abs(this.getTopBottomOffsetForScrollingSibling() - offset);
            if ((velocity = Math.abs(velocity)) > 0.0f) {
                duration = 3 * Math.round(1000.0f * ((float)distance / velocity));
            } else {
                float distanceRatio = (float)distance / (float)child.getHeight();
                duration = (int)((distanceRatio + 1.0f) * 150.0f);
            }
            this.animateOffsetWithDuration(coordinatorLayout, child, offset, duration);
        }

        private void animateOffsetWithDuration(final CoordinatorLayout coordinatorLayout, T child, int offset, int duration) {
            int currentOffset = this.getTopBottomOffsetForScrollingSibling();
            if (currentOffset == offset) {
                if (this.offsetAnimator != null && this.offsetAnimator.isRunning()) {
                    this.offsetAnimator.cancel();
                }
                return;
            }
            if (this.offsetAnimator == null) {
                this.offsetAnimator = new ValueAnimator();
                this.offsetAnimator.setInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
                this.offsetAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((AppBarLayout)((Object)child)){
                    final /* synthetic */ AppBarLayout val$child;
                    {
                        this.val$child = appBarLayout;
                    }

                    public void onAnimationUpdate(@NonNull ValueAnimator animator) {
                        this.setHeaderTopBottomOffset(coordinatorLayout, this.val$child, (Integer)animator.getAnimatedValue());
                    }
                });
            } else {
                this.offsetAnimator.cancel();
            }
            this.offsetAnimator.setDuration((long)Math.min(duration, 600));
            this.offsetAnimator.setIntValues(new int[]{currentOffset, offset});
            this.offsetAnimator.start();
        }

        private int getChildIndexOnOffset(@NonNull T abl, int offset) {
            int count = abl.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = abl.getChildAt(i);
                int top = child.getTop();
                int bottom = child.getBottom();
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (BaseBehavior.checkFlag(lp.getScrollFlags(), 32)) {
                    top -= lp.topMargin;
                    bottom += lp.bottomMargin;
                }
                if (top > -offset || bottom < -offset) continue;
                return i;
            }
            return -1;
        }

        private void snapToChildIfNeeded(CoordinatorLayout coordinatorLayout, @NonNull T abl) {
            View offsetChild;
            LayoutParams lp;
            int flags;
            int topInset = ((AppBarLayout)((Object)abl)).getTopInset() + abl.getPaddingTop();
            int offset = this.getTopBottomOffsetForScrollingSibling() - topInset;
            int offsetChildIndex = this.getChildIndexOnOffset(abl, offset);
            if (offsetChildIndex >= 0 && ((flags = (lp = (LayoutParams)(offsetChild = abl.getChildAt(offsetChildIndex)).getLayoutParams()).getScrollFlags()) & 0x11) == 17) {
                int snapTop = -offsetChild.getTop();
                int snapBottom = -offsetChild.getBottom();
                if (offsetChildIndex == 0 && ViewCompat.getFitsSystemWindows(abl) && ViewCompat.getFitsSystemWindows((View)offsetChild)) {
                    snapTop -= ((AppBarLayout)((Object)abl)).getTopInset();
                }
                if (BaseBehavior.checkFlag(flags, 2)) {
                    snapBottom += ViewCompat.getMinimumHeight((View)offsetChild);
                } else if (BaseBehavior.checkFlag(flags, 5)) {
                    int seam = snapBottom + ViewCompat.getMinimumHeight((View)offsetChild);
                    if (offset < seam) {
                        snapTop = seam;
                    } else {
                        snapBottom = seam;
                    }
                }
                if (BaseBehavior.checkFlag(flags, 32)) {
                    snapTop += lp.topMargin;
                    snapBottom -= lp.bottomMargin;
                }
                int newOffset = this.calculateSnapOffset(offset, snapBottom, snapTop) + topInset;
                this.animateOffsetTo(coordinatorLayout, abl, MathUtils.clamp((int)newOffset, (int)(-((AppBarLayout)((Object)abl)).getTotalScrollRange()), (int)0), 0.0f);
            }
        }

        private int calculateSnapOffset(int value, int bottom, int top) {
            return value < (bottom + top) / 2 ? bottom : top;
        }

        private static boolean checkFlag(int flags, int check) {
            return (flags & check) == check;
        }

        public boolean onMeasureChild(@NonNull CoordinatorLayout parent, @NonNull T child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (lp.height == -2) {
                parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, View.MeasureSpec.makeMeasureSpec((int)0, (int)0), heightUsed);
                return true;
            }
            return super.onMeasureChild(parent, child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
        }

        @Override
        public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull T abl, int layoutDirection) {
            boolean handled = super.onLayoutChild(parent, abl, layoutDirection);
            int pendingAction = ((AppBarLayout)((Object)abl)).getPendingAction();
            if (this.savedState != null && (pendingAction & 8) == 0) {
                if (this.savedState.fullyScrolled) {
                    this.setHeaderTopBottomOffset(parent, abl, -((AppBarLayout)((Object)abl)).getTotalScrollRange());
                } else if (this.savedState.fullyExpanded) {
                    this.setHeaderTopBottomOffset(parent, abl, 0);
                } else {
                    View child = abl.getChildAt(this.savedState.firstVisibleChildIndex);
                    int offset = -child.getBottom();
                    offset = this.savedState.firstVisibleChildAtMinimumHeight ? (offset += ViewCompat.getMinimumHeight((View)child) + ((AppBarLayout)((Object)abl)).getTopInset()) : (offset += Math.round((float)child.getHeight() * this.savedState.firstVisibleChildPercentageShown));
                    this.setHeaderTopBottomOffset(parent, abl, offset);
                }
            } else if (pendingAction != 0) {
                boolean animate;
                boolean bl = animate = (pendingAction & 4) != 0;
                if ((pendingAction & 2) != 0) {
                    int offset = -((AppBarLayout)((Object)abl)).getUpNestedPreScrollRange();
                    if (animate) {
                        this.animateOffsetTo(parent, abl, offset, 0.0f);
                    } else {
                        this.setHeaderTopBottomOffset(parent, abl, offset);
                    }
                } else if ((pendingAction & 1) != 0) {
                    if (animate) {
                        this.animateOffsetTo(parent, abl, 0, 0.0f);
                    } else {
                        this.setHeaderTopBottomOffset(parent, abl, 0);
                    }
                }
            }
            ((AppBarLayout)((Object)abl)).resetPendingAction();
            this.savedState = null;
            this.setTopAndBottomOffset(MathUtils.clamp((int)this.getTopAndBottomOffset(), (int)(-((AppBarLayout)((Object)abl)).getTotalScrollRange()), (int)0));
            this.updateAppBarLayoutDrawableState(parent, abl, this.getTopAndBottomOffset(), 0, true);
            ((AppBarLayout)((Object)abl)).onOffsetChanged(this.getTopAndBottomOffset());
            this.updateAccessibilityActions(parent, abl);
            return handled;
        }

        private void updateAccessibilityActions(CoordinatorLayout coordinatorLayout, @NonNull T appBarLayout) {
            ViewCompat.removeAccessibilityAction((View)coordinatorLayout, (int)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId());
            ViewCompat.removeAccessibilityAction((View)coordinatorLayout, (int)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId());
            if (((AppBarLayout)((Object)appBarLayout)).getTotalScrollRange() == 0) {
                return;
            }
            View scrollingView = this.getChildWithScrollingBehavior(coordinatorLayout);
            if (scrollingView == null) {
                return;
            }
            if (!this.childrenHaveScrollFlags((AppBarLayout)((Object)appBarLayout))) {
                return;
            }
            if (!ViewCompat.hasAccessibilityDelegate((View)coordinatorLayout)) {
                ViewCompat.setAccessibilityDelegate((View)coordinatorLayout, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                    public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
                        super.onInitializeAccessibilityNodeInfo(host, info);
                        info.setScrollable(coordinatorLayoutA11yScrollable);
                        info.setClassName((CharSequence)ScrollView.class.getName());
                    }
                });
            }
            this.coordinatorLayoutA11yScrollable = this.addAccessibilityScrollActions(coordinatorLayout, appBarLayout, scrollingView);
        }

        @Nullable
        private View getChildWithScrollingBehavior(CoordinatorLayout coordinatorLayout) {
            int childCount = coordinatorLayout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = coordinatorLayout.getChildAt(i);
                CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
                if (!(lp.getBehavior() instanceof ScrollingViewBehavior)) continue;
                return child;
            }
            return null;
        }

        private boolean childrenHaveScrollFlags(AppBarLayout appBarLayout) {
            int childCount = appBarLayout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = appBarLayout.getChildAt(i);
                LayoutParams childLp = (LayoutParams)child.getLayoutParams();
                int flags = childLp.scrollFlags;
                if (flags == 0) continue;
                return true;
            }
            return false;
        }

        private boolean addAccessibilityScrollActions(final CoordinatorLayout coordinatorLayout, @NonNull T appBarLayout, @NonNull View scrollingView) {
            boolean a11yScrollable = false;
            if (this.getTopBottomOffsetForScrollingSibling() != -((AppBarLayout)((Object)appBarLayout)).getTotalScrollRange()) {
                this.addActionToExpand(coordinatorLayout, appBarLayout, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD, false);
                a11yScrollable = true;
            }
            if (this.getTopBottomOffsetForScrollingSibling() != 0) {
                if (scrollingView.canScrollVertically(-1)) {
                    int dy = -((AppBarLayout)((Object)appBarLayout)).getDownNestedPreScrollRange();
                    if (dy != 0) {
                        ViewCompat.replaceAccessibilityAction((View)coordinatorLayout, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD, null, (AccessibilityViewCommand)new AccessibilityViewCommand((AppBarLayout)((Object)appBarLayout), scrollingView, dy){
                            final /* synthetic */ AppBarLayout val$appBarLayout;
                            final /* synthetic */ View val$scrollingView;
                            final /* synthetic */ int val$dy;
                            {
                                this.val$appBarLayout = appBarLayout;
                                this.val$scrollingView = view;
                                this.val$dy = n;
                            }

                            public boolean perform(@NonNull View view, @Nullable AccessibilityViewCommand.CommandArguments arguments) {
                                this.onNestedPreScroll(coordinatorLayout, this.val$appBarLayout, this.val$scrollingView, 0, this.val$dy, new int[]{0, 0}, 1);
                                return true;
                            }
                        });
                        a11yScrollable = true;
                    }
                } else {
                    this.addActionToExpand(coordinatorLayout, appBarLayout, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD, true);
                    a11yScrollable = true;
                }
            }
            return a11yScrollable;
        }

        private void addActionToExpand(CoordinatorLayout parent, @NonNull T appBarLayout, @NonNull AccessibilityNodeInfoCompat.AccessibilityActionCompat action, boolean expand) {
            ViewCompat.replaceAccessibilityAction((View)parent, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)action, null, (AccessibilityViewCommand)new AccessibilityViewCommand((AppBarLayout)((Object)appBarLayout), expand){
                final /* synthetic */ AppBarLayout val$appBarLayout;
                final /* synthetic */ boolean val$expand;
                {
                    this.val$appBarLayout = appBarLayout;
                    this.val$expand = bl;
                }

                public boolean perform(@NonNull View view, @Nullable AccessibilityViewCommand.CommandArguments arguments) {
                    this.val$appBarLayout.setExpanded(this.val$expand);
                    return true;
                }
            });
        }

        @Override
        boolean canDragView(T view) {
            if (this.onDragCallback != null) {
                return this.onDragCallback.canDrag(view);
            }
            if (this.lastNestedScrollingChildRef != null) {
                View scrollingView = (View)this.lastNestedScrollingChildRef.get();
                return scrollingView != null && scrollingView.isShown() && !scrollingView.canScrollVertically(-1);
            }
            return true;
        }

        @Override
        void onFlingFinished(@NonNull CoordinatorLayout parent, @NonNull T layout) {
            this.snapToChildIfNeeded(parent, layout);
            if (((AppBarLayout)((Object)layout)).isLiftOnScroll()) {
                ((AppBarLayout)((Object)layout)).setLiftedState(((AppBarLayout)((Object)layout)).shouldLift(this.findFirstScrollingChild(parent)));
            }
        }

        @Override
        int getMaxDragOffset(@NonNull T view) {
            return -((AppBarLayout)((Object)view)).getDownNestedScrollRange() + ((AppBarLayout)((Object)view)).getTopInset();
        }

        @Override
        int getScrollRangeForDragFling(@NonNull T view) {
            return ((AppBarLayout)((Object)view)).getTotalScrollRange();
        }

        @Override
        int setHeaderTopBottomOffset(@NonNull CoordinatorLayout coordinatorLayout, @NonNull T appBarLayout, int newOffset, int minOffset, int maxOffset) {
            int curOffset = this.getTopBottomOffsetForScrollingSibling();
            int consumed = 0;
            if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset) {
                if (curOffset != (newOffset = MathUtils.clamp((int)newOffset, (int)minOffset, (int)maxOffset))) {
                    int interpolatedOffset = ((AppBarLayout)((Object)appBarLayout)).hasChildWithInterpolator() ? this.interpolateOffset(appBarLayout, newOffset) : newOffset;
                    boolean offsetChanged = this.setTopAndBottomOffset(interpolatedOffset);
                    consumed = curOffset - newOffset;
                    this.offsetDelta = newOffset - interpolatedOffset;
                    if (offsetChanged) {
                        for (int i = 0; i < appBarLayout.getChildCount(); ++i) {
                            LayoutParams params = (LayoutParams)appBarLayout.getChildAt(i).getLayoutParams();
                            ChildScrollEffect scrollEffect = params.getScrollEffect();
                            if (scrollEffect == null || (params.getScrollFlags() & 1) == 0) continue;
                            scrollEffect.onOffsetChanged((AppBarLayout)((Object)appBarLayout), appBarLayout.getChildAt(i), this.getTopAndBottomOffset());
                        }
                    }
                    if (!offsetChanged && ((AppBarLayout)((Object)appBarLayout)).hasChildWithInterpolator()) {
                        coordinatorLayout.dispatchDependentViewsChanged(appBarLayout);
                    }
                    ((AppBarLayout)((Object)appBarLayout)).onOffsetChanged(this.getTopAndBottomOffset());
                    this.updateAppBarLayoutDrawableState(coordinatorLayout, appBarLayout, newOffset, newOffset < curOffset ? -1 : 1, false);
                }
            } else {
                this.offsetDelta = 0;
            }
            this.updateAccessibilityActions(coordinatorLayout, appBarLayout);
            return consumed;
        }

        @VisibleForTesting
        boolean isOffsetAnimatorRunning() {
            return this.offsetAnimator != null && this.offsetAnimator.isRunning();
        }

        private int interpolateOffset(@NonNull T layout, int offset) {
            int absOffset = Math.abs(offset);
            int z = layout.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = layout.getChildAt(i);
                LayoutParams childLp = (LayoutParams)child.getLayoutParams();
                Interpolator interpolator = childLp.getScrollInterpolator();
                if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
                if (interpolator == null) break;
                int childScrollableHeight = 0;
                int flags = childLp.getScrollFlags();
                if ((flags & 1) != 0) {
                    childScrollableHeight += child.getHeight() + childLp.topMargin + childLp.bottomMargin;
                    if ((flags & 2) != 0) {
                        childScrollableHeight -= ViewCompat.getMinimumHeight((View)child);
                    }
                }
                if (ViewCompat.getFitsSystemWindows((View)child)) {
                    childScrollableHeight -= ((AppBarLayout)((Object)layout)).getTopInset();
                }
                if (childScrollableHeight <= 0) break;
                int offsetForView = absOffset - child.getTop();
                int interpolatedDiff = Math.round((float)childScrollableHeight * interpolator.getInterpolation((float)offsetForView / (float)childScrollableHeight));
                return Integer.signum(offset) * (child.getTop() + interpolatedDiff);
            }
            return offset;
        }

        private void updateAppBarLayoutDrawableState(@NonNull CoordinatorLayout parent, @NonNull T layout, int offset, int direction, boolean forceJump) {
            LayoutParams childLp;
            int flags;
            View child = BaseBehavior.getAppBarChildOnOffset(layout, offset);
            boolean lifted = false;
            if (child != null && ((flags = (childLp = (LayoutParams)child.getLayoutParams()).getScrollFlags()) & 1) != 0) {
                int minHeight = ViewCompat.getMinimumHeight((View)child);
                if (direction > 0 && (flags & 0xC) != 0) {
                    lifted = -offset >= child.getBottom() - minHeight - ((AppBarLayout)((Object)layout)).getTopInset();
                } else if ((flags & 2) != 0) {
                    boolean bl = lifted = -offset >= child.getBottom() - minHeight - ((AppBarLayout)((Object)layout)).getTopInset();
                }
            }
            if (((AppBarLayout)((Object)layout)).isLiftOnScroll()) {
                lifted = ((AppBarLayout)((Object)layout)).shouldLift(this.findFirstScrollingChild(parent));
            }
            boolean changed = ((AppBarLayout)((Object)layout)).setLiftedState(lifted);
            if (forceJump || changed && this.shouldJumpElevationState(parent, layout)) {
                if (layout.getBackground() != null) {
                    layout.getBackground().jumpToCurrentState();
                }
                if (Build.VERSION.SDK_INT >= 23 && layout.getForeground() != null) {
                    layout.getForeground().jumpToCurrentState();
                }
                if (Build.VERSION.SDK_INT >= 21 && layout.getStateListAnimator() != null) {
                    layout.getStateListAnimator().jumpToCurrentState();
                }
            }
        }

        private boolean shouldJumpElevationState(@NonNull CoordinatorLayout parent, @NonNull T layout) {
            List dependencies = parent.getDependents(layout);
            int size = dependencies.size();
            for (int i = 0; i < size; ++i) {
                View dependency = (View)dependencies.get(i);
                CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)dependency.getLayoutParams();
                CoordinatorLayout.Behavior behavior = lp.getBehavior();
                if (!(behavior instanceof ScrollingViewBehavior)) continue;
                return ((ScrollingViewBehavior)behavior).getOverlayTop() != 0;
            }
            return false;
        }

        @Nullable
        private static View getAppBarChildOnOffset(@NonNull AppBarLayout layout, int offset) {
            int absOffset = Math.abs(offset);
            int z = layout.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = layout.getChildAt(i);
                if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
                return child;
            }
            return null;
        }

        @Nullable
        private View findFirstScrollingChild(@NonNull CoordinatorLayout parent) {
            int z = parent.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = parent.getChildAt(i);
                if (!(child instanceof NestedScrollingChild) && !(child instanceof AbsListView) && !(child instanceof ScrollView)) continue;
                return child;
            }
            return null;
        }

        @Override
        int getTopBottomOffsetForScrollingSibling() {
            return this.getTopAndBottomOffset() + this.offsetDelta;
        }

        public Parcelable onSaveInstanceState(@NonNull CoordinatorLayout parent, @NonNull T abl) {
            Parcelable superState = super.onSaveInstanceState(parent, abl);
            SavedState scrollState = this.saveScrollState(superState, abl);
            return scrollState == null ? superState : scrollState;
        }

        public void onRestoreInstanceState(@NonNull CoordinatorLayout parent, @NonNull T appBarLayout, Parcelable state) {
            if (state instanceof SavedState) {
                this.restoreScrollState((SavedState)state, true);
                super.onRestoreInstanceState(parent, appBarLayout, this.savedState.getSuperState());
            } else {
                super.onRestoreInstanceState(parent, appBarLayout, state);
                this.savedState = null;
            }
        }

        @Nullable
        SavedState saveScrollState(@Nullable Parcelable superState, @NonNull T abl) {
            int offset = this.getTopAndBottomOffset();
            int count = abl.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = abl.getChildAt(i);
                int visBottom = child.getBottom() + offset;
                if (child.getTop() + offset > 0 || visBottom < 0) continue;
                SavedState ss = new SavedState((Parcelable)(superState == null ? AbsSavedState.EMPTY_STATE : superState));
                ss.fullyExpanded = offset == 0;
                ss.fullyScrolled = !ss.fullyExpanded && -offset >= ((AppBarLayout)((Object)abl)).getTotalScrollRange();
                ss.firstVisibleChildIndex = i;
                ss.firstVisibleChildAtMinimumHeight = visBottom == ViewCompat.getMinimumHeight((View)child) + ((AppBarLayout)((Object)abl)).getTopInset();
                ss.firstVisibleChildPercentageShown = (float)visBottom / (float)child.getHeight();
                return ss;
            }
            return null;
        }

        void restoreScrollState(@Nullable SavedState state, boolean force) {
            if (this.savedState == null || force) {
                this.savedState = state;
            }
        }

        protected static class SavedState
        extends AbsSavedState {
            boolean fullyScrolled;
            boolean fullyExpanded;
            int firstVisibleChildIndex;
            float firstVisibleChildPercentageShown;
            boolean firstVisibleChildAtMinimumHeight;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

                @NonNull
                public SavedState createFromParcel(@NonNull Parcel source, ClassLoader loader) {
                    return new SavedState(source, loader);
                }

                @Nullable
                public SavedState createFromParcel(@NonNull Parcel source) {
                    return new SavedState(source, null);
                }

                @NonNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            public SavedState(@NonNull Parcel source, ClassLoader loader) {
                super(source, loader);
                this.fullyScrolled = source.readByte() != 0;
                this.fullyExpanded = source.readByte() != 0;
                this.firstVisibleChildIndex = source.readInt();
                this.firstVisibleChildPercentageShown = source.readFloat();
                this.firstVisibleChildAtMinimumHeight = source.readByte() != 0;
            }

            public SavedState(Parcelable superState) {
                super(superState);
            }

            public void writeToParcel(@NonNull Parcel dest, int flags) {
                super.writeToParcel(dest, flags);
                dest.writeByte((byte)(this.fullyScrolled ? 1 : 0));
                dest.writeByte((byte)(this.fullyExpanded ? 1 : 0));
                dest.writeInt(this.firstVisibleChildIndex);
                dest.writeFloat(this.firstVisibleChildPercentageShown);
                dest.writeByte((byte)(this.firstVisibleChildAtMinimumHeight ? 1 : 0));
            }
        }

        public static abstract class BaseDragCallback<T extends AppBarLayout> {
            public abstract boolean canDrag(@NonNull T var1);
        }
    }

    public static class Behavior
    extends BaseBehavior<AppBarLayout> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public static abstract class DragCallback
        extends BaseBehavior.BaseDragCallback<AppBarLayout> {
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public static final int SCROLL_FLAG_NO_SCROLL = 0;
        public static final int SCROLL_FLAG_SCROLL = 1;
        public static final int SCROLL_FLAG_EXIT_UNTIL_COLLAPSED = 2;
        public static final int SCROLL_FLAG_ENTER_ALWAYS = 4;
        public static final int SCROLL_FLAG_ENTER_ALWAYS_COLLAPSED = 8;
        public static final int SCROLL_FLAG_SNAP = 16;
        public static final int SCROLL_FLAG_SNAP_MARGINS = 32;
        static final int FLAG_QUICK_RETURN = 5;
        static final int FLAG_SNAP = 17;
        static final int COLLAPSIBLE_FLAGS = 10;
        int scrollFlags = 1;
        public static final int SCROLL_EFFECT_NONE = 0;
        public static final int SCROLL_EFFECT_COMPRESS = 1;
        private ChildScrollEffect scrollEffect;
        Interpolator scrollInterpolator;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.AppBarLayout_Layout);
            this.scrollFlags = a.getInt(R.styleable.AppBarLayout_Layout_layout_scrollFlags, 0);
            int scrollEffectInt = a.getInt(R.styleable.AppBarLayout_Layout_layout_scrollEffect, 0);
            this.setScrollEffect(scrollEffectInt);
            if (a.hasValue(R.styleable.AppBarLayout_Layout_layout_scrollInterpolator)) {
                int resId = a.getResourceId(R.styleable.AppBarLayout_Layout_layout_scrollInterpolator, 0);
                this.scrollInterpolator = android.view.animation.AnimationUtils.loadInterpolator((Context)c, (int)resId);
            }
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height, weight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        @RequiresApi(value=19)
        public LayoutParams(LinearLayout.LayoutParams source) {
            super(source);
        }

        @RequiresApi(value=19)
        public LayoutParams(@NonNull LayoutParams source) {
            super((LinearLayout.LayoutParams)source);
            this.scrollFlags = source.scrollFlags;
            this.scrollEffect = source.scrollEffect;
            this.scrollInterpolator = source.scrollInterpolator;
        }

        public void setScrollFlags(int flags) {
            this.scrollFlags = flags;
        }

        public int getScrollFlags() {
            return this.scrollFlags;
        }

        @Nullable
        private ChildScrollEffect createScrollEffectFromInt(int scrollEffectInt) {
            switch (scrollEffectInt) {
                case 1: {
                    return new CompressChildScrollEffect();
                }
            }
            return null;
        }

        @Nullable
        public ChildScrollEffect getScrollEffect() {
            return this.scrollEffect;
        }

        public void setScrollEffect(@Nullable ChildScrollEffect scrollEffect) {
            this.scrollEffect = scrollEffect;
        }

        public void setScrollEffect(int scrollEffect) {
            this.scrollEffect = this.createScrollEffectFromInt(scrollEffect);
        }

        public void setScrollInterpolator(Interpolator interpolator) {
            this.scrollInterpolator = interpolator;
        }

        public Interpolator getScrollInterpolator() {
            return this.scrollInterpolator;
        }

        boolean isCollapsible() {
            return (this.scrollFlags & 1) == 1 && (this.scrollFlags & 0xA) != 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface ScrollEffect {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface ScrollFlags {
        }
    }

    public static interface LiftOnScrollListener {
        public void onUpdate(@Dimension float var1, @ColorInt int var2);
    }

    public static interface OnOffsetChangedListener
    extends BaseOnOffsetChangedListener<AppBarLayout> {
        @Override
        public void onOffsetChanged(AppBarLayout var1, int var2);
    }

    public static interface BaseOnOffsetChangedListener<T extends AppBarLayout> {
        public void onOffsetChanged(T var1, int var2);
    }
}

