/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.badge;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.PluralsRes;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.XmlRes;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.badge.BadgeState;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.internal.TextDrawableHelper;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;
import java.util.Locale;

public class BadgeDrawable
extends Drawable
implements TextDrawableHelper.TextDrawableDelegate {
    private static final String TAG = "Badge";
    public static final int TOP_END = 8388661;
    public static final int TOP_START = 0x800033;
    @Deprecated
    public static final int BOTTOM_END = 0x800055;
    @Deprecated
    public static final int BOTTOM_START = 8388691;
    @StyleRes
    private static final int DEFAULT_STYLE = R.style.Widget_MaterialComponents_Badge;
    @AttrRes
    private static final int DEFAULT_THEME_ATTR = R.attr.badgeStyle;
    static final String DEFAULT_EXCEED_MAX_BADGE_NUMBER_SUFFIX = "+";
    static final String DEFAULT_EXCEED_MAX_BADGE_TEXT_SUFFIX = "\u2026";
    static final int OFFSET_ALIGNMENT_MODE_EDGE = 0;
    static final int OFFSET_ALIGNMENT_MODE_LEGACY = 1;
    static final int BADGE_RADIUS_NOT_SPECIFIED = -1;
    public static final int BADGE_CONTENT_NOT_TRUNCATED = -2;
    private static final float FONT_SCALE_THRESHOLD = 0.3f;
    @NonNull
    private final WeakReference<Context> contextRef;
    @NonNull
    private final MaterialShapeDrawable shapeDrawable;
    @NonNull
    private final TextDrawableHelper textDrawableHelper;
    @NonNull
    private final Rect badgeBounds;
    @NonNull
    private final BadgeState state;
    private float badgeCenterX;
    private float badgeCenterY;
    private int maxBadgeNumber;
    private float cornerRadius;
    private float halfBadgeWidth;
    private float halfBadgeHeight;
    @Nullable
    private WeakReference<View> anchorViewRef;
    @Nullable
    private WeakReference<FrameLayout> customBadgeParentRef;

    @NonNull
    BadgeState.State getSavedState() {
        return this.state.getOverridingState();
    }

    @NonNull
    static BadgeDrawable createFromSavedState(@NonNull Context context, @NonNull BadgeState.State savedState) {
        return new BadgeDrawable(context, 0, DEFAULT_THEME_ATTR, DEFAULT_STYLE, savedState);
    }

    @NonNull
    public static BadgeDrawable create(@NonNull Context context) {
        return new BadgeDrawable(context, 0, DEFAULT_THEME_ATTR, DEFAULT_STYLE, null);
    }

    @NonNull
    public static BadgeDrawable createFromResource(@NonNull Context context, @XmlRes int id2) {
        return new BadgeDrawable(context, id2, DEFAULT_THEME_ATTR, DEFAULT_STYLE, null);
    }

    public void setVisible(boolean visible) {
        this.state.setVisible(visible);
        this.onVisibilityUpdated();
    }

    private void onVisibilityUpdated() {
        boolean visible = this.state.isVisible();
        this.setVisible(visible, false);
        if (BadgeUtils.USE_COMPAT_PARENT && this.getCustomBadgeParent() != null && !visible) {
            ((ViewGroup)this.getCustomBadgeParent().getParent()).invalidate();
        }
    }

    private void restoreState() {
        this.onBadgeShapeAppearanceUpdated();
        this.onBadgeTextAppearanceUpdated();
        this.onMaxBadgeLengthUpdated();
        this.onBadgeContentUpdated();
        this.onAlphaUpdated();
        this.onBackgroundColorUpdated();
        this.onBadgeTextColorUpdated();
        this.onBadgeGravityUpdated();
        this.updateCenterAndBounds();
        this.onVisibilityUpdated();
    }

    private BadgeDrawable(@NonNull Context context, @XmlRes int badgeResId, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, @Nullable BadgeState.State savedState) {
        this.contextRef = new WeakReference<Context>(context);
        ThemeEnforcement.checkMaterialTheme(context);
        this.badgeBounds = new Rect();
        this.textDrawableHelper = new TextDrawableHelper(this);
        this.textDrawableHelper.getTextPaint().setTextAlign(Paint.Align.CENTER);
        this.state = new BadgeState(context, badgeResId, defStyleAttr, defStyleRes, savedState);
        this.shapeDrawable = new MaterialShapeDrawable(ShapeAppearanceModel.builder(context, this.hasBadgeContent() ? this.state.getBadgeWithTextShapeAppearanceResId() : this.state.getBadgeShapeAppearanceResId(), this.hasBadgeContent() ? this.state.getBadgeWithTextShapeAppearanceOverlayResId() : this.state.getBadgeShapeAppearanceOverlayResId()).build());
        this.restoreState();
    }

    @Deprecated
    public void updateBadgeCoordinates(@NonNull View anchorView, @Nullable ViewGroup customBadgeParent) {
        if (!(customBadgeParent instanceof FrameLayout)) {
            throw new IllegalArgumentException("customBadgeParent must be a FrameLayout");
        }
        this.updateBadgeCoordinates(anchorView, (FrameLayout)customBadgeParent);
    }

    public void updateBadgeCoordinates(@NonNull View anchorView) {
        this.updateBadgeCoordinates(anchorView, (FrameLayout)null);
    }

    public void updateBadgeCoordinates(@NonNull View anchorView, @Nullable FrameLayout customBadgeParent) {
        this.anchorViewRef = new WeakReference<View>(anchorView);
        if (BadgeUtils.USE_COMPAT_PARENT && customBadgeParent == null) {
            this.tryWrapAnchorInCompatParent(anchorView);
        } else {
            this.customBadgeParentRef = new WeakReference<FrameLayout>(customBadgeParent);
        }
        if (!BadgeUtils.USE_COMPAT_PARENT) {
            BadgeDrawable.updateAnchorParentToNotClip(anchorView);
        }
        this.updateCenterAndBounds();
        this.invalidateSelf();
    }

    private boolean isAnchorViewWrappedInCompatParent() {
        FrameLayout customBadgeAnchorParent = this.getCustomBadgeParent();
        return customBadgeAnchorParent != null && customBadgeAnchorParent.getId() == R.id.mtrl_anchor_parent;
    }

    @Nullable
    public FrameLayout getCustomBadgeParent() {
        return this.customBadgeParentRef != null ? (FrameLayout)this.customBadgeParentRef.get() : null;
    }

    private void tryWrapAnchorInCompatParent(final View anchorView) {
        ViewGroup anchorViewParent = (ViewGroup)anchorView.getParent();
        if (anchorViewParent != null && anchorViewParent.getId() == R.id.mtrl_anchor_parent || this.customBadgeParentRef != null && this.customBadgeParentRef.get() == anchorViewParent) {
            return;
        }
        BadgeDrawable.updateAnchorParentToNotClip(anchorView);
        final FrameLayout frameLayout = new FrameLayout(anchorView.getContext());
        frameLayout.setId(R.id.mtrl_anchor_parent);
        frameLayout.setClipChildren(false);
        frameLayout.setClipToPadding(false);
        frameLayout.setLayoutParams(anchorView.getLayoutParams());
        frameLayout.setMinimumWidth(anchorView.getWidth());
        frameLayout.setMinimumHeight(anchorView.getHeight());
        int anchorIndex = anchorViewParent.indexOfChild(anchorView);
        anchorViewParent.removeViewAt(anchorIndex);
        anchorView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        frameLayout.addView(anchorView);
        anchorViewParent.addView((View)frameLayout, anchorIndex);
        this.customBadgeParentRef = new WeakReference<FrameLayout>(frameLayout);
        frameLayout.post(new Runnable(){

            @Override
            public void run() {
                BadgeDrawable.this.updateBadgeCoordinates(anchorView, frameLayout);
            }
        });
    }

    private static void updateAnchorParentToNotClip(View anchorView) {
        ViewGroup anchorViewParent = (ViewGroup)anchorView.getParent();
        anchorViewParent.setClipChildren(false);
        anchorViewParent.setClipToPadding(false);
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.shapeDrawable.getFillColor().getDefaultColor();
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.state.setBackgroundColor(backgroundColor);
        this.onBackgroundColorUpdated();
    }

    private void onBackgroundColorUpdated() {
        ColorStateList backgroundColorStateList = ColorStateList.valueOf((int)this.state.getBackgroundColor());
        if (this.shapeDrawable.getFillColor() != backgroundColorStateList) {
            this.shapeDrawable.setFillColor(backgroundColorStateList);
            this.invalidateSelf();
        }
    }

    @ColorInt
    public int getBadgeTextColor() {
        return this.textDrawableHelper.getTextPaint().getColor();
    }

    public void setBadgeTextColor(@ColorInt int badgeTextColor) {
        if (this.textDrawableHelper.getTextPaint().getColor() != badgeTextColor) {
            this.state.setBadgeTextColor(badgeTextColor);
            this.onBadgeTextColorUpdated();
        }
    }

    private void onBadgeTextColorUpdated() {
        this.textDrawableHelper.getTextPaint().setColor(this.state.getBadgeTextColor());
        this.invalidateSelf();
    }

    @NonNull
    public Locale getBadgeNumberLocale() {
        return this.state.getNumberLocale();
    }

    public void setBadgeNumberLocale(@NonNull Locale locale) {
        if (!locale.equals(this.state.getNumberLocale())) {
            this.state.setNumberLocale(locale);
            this.invalidateSelf();
        }
    }

    public boolean hasNumber() {
        return !this.state.hasText() && this.state.hasNumber();
    }

    public int getNumber() {
        return this.state.hasNumber() ? this.state.getNumber() : 0;
    }

    public void setNumber(int number) {
        number = Math.max(0, number);
        if (this.state.getNumber() != number) {
            this.state.setNumber(number);
            this.onNumberUpdated();
        }
    }

    public void clearNumber() {
        if (this.state.hasNumber()) {
            this.state.clearNumber();
            this.onNumberUpdated();
        }
    }

    private void onNumberUpdated() {
        if (!this.hasText()) {
            this.onBadgeContentUpdated();
        }
    }

    public boolean hasText() {
        return this.state.hasText();
    }

    @Nullable
    public String getText() {
        return this.state.getText();
    }

    public void setText(@Nullable String text) {
        if (!TextUtils.equals((CharSequence)this.state.getText(), (CharSequence)text)) {
            this.state.setText(text);
            this.onTextUpdated();
        }
    }

    public void clearText() {
        if (this.state.hasText()) {
            this.state.clearText();
            this.onTextUpdated();
        }
    }

    private void onTextUpdated() {
        this.onBadgeContentUpdated();
    }

    public int getMaxCharacterCount() {
        return this.state.getMaxCharacterCount();
    }

    public void setMaxCharacterCount(int maxCharacterCount) {
        if (this.state.getMaxCharacterCount() != maxCharacterCount) {
            this.state.setMaxCharacterCount(maxCharacterCount);
            this.onMaxBadgeLengthUpdated();
        }
    }

    public int getMaxNumber() {
        return this.state.getMaxNumber();
    }

    public void setMaxNumber(int maxNumber) {
        if (this.state.getMaxNumber() != maxNumber) {
            this.state.setMaxNumber(maxNumber);
            this.onMaxBadgeLengthUpdated();
        }
    }

    private void onMaxBadgeLengthUpdated() {
        this.updateMaxBadgeNumber();
        this.textDrawableHelper.setTextSizeDirty(true);
        this.updateCenterAndBounds();
        this.invalidateSelf();
    }

    public int getBadgeGravity() {
        return this.state.getBadgeGravity();
    }

    public void setBadgeGravity(int gravity) {
        if (gravity == 8388691 || gravity == 0x800055) {
            Log.w((String)TAG, (String)"Bottom badge gravities are deprecated; please use a top gravity instead.");
        }
        if (this.state.getBadgeGravity() != gravity) {
            this.state.setBadgeGravity(gravity);
            this.onBadgeGravityUpdated();
        }
    }

    private void onBadgeGravityUpdated() {
        if (this.anchorViewRef != null && this.anchorViewRef.get() != null) {
            this.updateBadgeCoordinates((View)this.anchorViewRef.get(), this.customBadgeParentRef != null ? (FrameLayout)this.customBadgeParentRef.get() : null);
        }
    }

    public boolean isStateful() {
        return false;
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getAlpha() {
        return this.state.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.state.setAlpha(alpha);
        this.onAlphaUpdated();
    }

    private void onAlphaUpdated() {
        this.textDrawableHelper.getTextPaint().setAlpha(this.getAlpha());
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicHeight() {
        return this.badgeBounds.height();
    }

    public int getIntrinsicWidth() {
        return this.badgeBounds.width();
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        if (bounds.isEmpty() || this.getAlpha() == 0 || !this.isVisible()) {
            return;
        }
        this.shapeDrawable.draw(canvas);
        if (this.hasBadgeContent()) {
            this.drawBadgeContent(canvas);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onTextSizeChange() {
        this.invalidateSelf();
    }

    @Override
    public boolean onStateChange(int[] state) {
        return super.onStateChange(state);
    }

    public void setContentDescriptionForText(@Nullable CharSequence charSequence) {
        this.state.setContentDescriptionForText(charSequence);
    }

    public void setContentDescriptionNumberless(CharSequence charSequence) {
        this.state.setContentDescriptionNumberless(charSequence);
    }

    public void setContentDescriptionQuantityStringsResource(@PluralsRes int stringsResource) {
        this.state.setContentDescriptionQuantityStringsResource(stringsResource);
    }

    public void setContentDescriptionExceedsMaxBadgeNumberStringResource(@StringRes int stringsResource) {
        this.state.setContentDescriptionExceedsMaxBadgeNumberStringResource(stringsResource);
    }

    @Nullable
    public CharSequence getContentDescription() {
        if (!this.isVisible()) {
            return null;
        }
        if (this.hasText()) {
            return this.getTextContentDescription();
        }
        if (this.hasNumber()) {
            return this.getNumberContentDescription();
        }
        return this.getEmptyContentDescription();
    }

    @Nullable
    private String getNumberContentDescription() {
        if (this.state.getContentDescriptionQuantityStrings() != 0) {
            Context context = (Context)this.contextRef.get();
            if (context == null) {
                return null;
            }
            if (this.maxBadgeNumber == -2 || this.getNumber() <= this.maxBadgeNumber) {
                return context.getResources().getQuantityString(this.state.getContentDescriptionQuantityStrings(), this.getNumber(), new Object[]{this.getNumber()});
            }
            return context.getString(this.state.getContentDescriptionExceedsMaxBadgeNumberStringResource(), new Object[]{this.maxBadgeNumber});
        }
        return null;
    }

    @Nullable
    private CharSequence getTextContentDescription() {
        CharSequence contentDescription = this.state.getContentDescriptionForText();
        if (contentDescription != null) {
            return contentDescription;
        }
        return this.getText();
    }

    private CharSequence getEmptyContentDescription() {
        return this.state.getContentDescriptionNumberless();
    }

    public void setHorizontalPadding(@Px int horizontalPadding) {
        if (horizontalPadding != this.state.getBadgeHorizontalPadding()) {
            this.state.setBadgeHorizontalPadding(horizontalPadding);
            this.updateCenterAndBounds();
        }
    }

    @Px
    public int getHorizontalPadding() {
        return this.state.getBadgeHorizontalPadding();
    }

    public void setVerticalPadding(@Px int verticalPadding) {
        if (verticalPadding != this.state.getBadgeVerticalPadding()) {
            this.state.setBadgeVerticalPadding(verticalPadding);
            this.updateCenterAndBounds();
        }
    }

    @Px
    public int getVerticalPadding() {
        return this.state.getBadgeVerticalPadding();
    }

    public void setHorizontalOffset(int px) {
        this.setHorizontalOffsetWithoutText(px);
        this.setHorizontalOffsetWithText(px);
    }

    public int getHorizontalOffset() {
        return this.state.getHorizontalOffsetWithoutText();
    }

    public void setHorizontalOffsetWithoutText(@Px int px) {
        this.state.setHorizontalOffsetWithoutText(px);
        this.updateCenterAndBounds();
    }

    @Px
    public int getHorizontalOffsetWithoutText() {
        return this.state.getHorizontalOffsetWithoutText();
    }

    public void setHorizontalOffsetWithText(@Px int px) {
        this.state.setHorizontalOffsetWithText(px);
        this.updateCenterAndBounds();
    }

    @Px
    public int getHorizontalOffsetWithText() {
        return this.state.getHorizontalOffsetWithText();
    }

    void setAdditionalHorizontalOffset(int px) {
        this.state.setAdditionalHorizontalOffset(px);
        this.updateCenterAndBounds();
    }

    int getAdditionalHorizontalOffset() {
        return this.state.getAdditionalHorizontalOffset();
    }

    public void setVerticalOffset(int px) {
        this.setVerticalOffsetWithoutText(px);
        this.setVerticalOffsetWithText(px);
    }

    public int getVerticalOffset() {
        return this.state.getVerticalOffsetWithoutText();
    }

    public void setVerticalOffsetWithoutText(@Px int px) {
        this.state.setVerticalOffsetWithoutText(px);
        this.updateCenterAndBounds();
    }

    @Px
    public int getVerticalOffsetWithoutText() {
        return this.state.getVerticalOffsetWithoutText();
    }

    public void setVerticalOffsetWithText(@Px int px) {
        this.state.setVerticalOffsetWithText(px);
        this.updateCenterAndBounds();
    }

    @Px
    public int getVerticalOffsetWithText() {
        return this.state.getVerticalOffsetWithText();
    }

    public void setLargeFontVerticalOffsetAdjustment(@Px int px) {
        this.state.setLargeFontVerticalOffsetAdjustment(px);
        this.updateCenterAndBounds();
    }

    @Px
    public int getLargeFontVerticalOffsetAdjustment() {
        return this.state.getLargeFontVerticalOffsetAdjustment();
    }

    void setAdditionalVerticalOffset(@Px int px) {
        this.state.setAdditionalVerticalOffset(px);
        this.updateCenterAndBounds();
    }

    @Px
    int getAdditionalVerticalOffset() {
        return this.state.getAdditionalVerticalOffset();
    }

    public void setAutoAdjustToWithinGrandparentBounds(boolean autoAdjustToWithinGrandparentBounds) {
        if (this.state.isAutoAdjustedToGrandparentBounds() == autoAdjustToWithinGrandparentBounds) {
            return;
        }
        this.state.setAutoAdjustToGrandparentBounds(autoAdjustToWithinGrandparentBounds);
        if (this.anchorViewRef != null && this.anchorViewRef.get() != null) {
            this.autoAdjustWithinGrandparentBounds((View)this.anchorViewRef.get());
        }
    }

    public void setTextAppearance(@StyleRes int id2) {
        this.state.setTextAppearanceResId(id2);
        this.onBadgeTextAppearanceUpdated();
    }

    private void onBadgeTextAppearanceUpdated() {
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return;
        }
        TextAppearance textAppearance = new TextAppearance(context, this.state.getTextAppearanceResId());
        if (this.textDrawableHelper.getTextAppearance() == textAppearance) {
            return;
        }
        this.textDrawableHelper.setTextAppearance(textAppearance, context);
        this.onBadgeTextColorUpdated();
        this.updateCenterAndBounds();
        this.invalidateSelf();
    }

    public void setBadgeWithoutTextShapeAppearance(@StyleRes int id2) {
        this.state.setBadgeShapeAppearanceResId(id2);
        this.onBadgeShapeAppearanceUpdated();
    }

    public void setBadgeWithoutTextShapeAppearanceOverlay(@StyleRes int id2) {
        this.state.setBadgeShapeAppearanceOverlayResId(id2);
        this.onBadgeShapeAppearanceUpdated();
    }

    public void setBadgeWithTextShapeAppearance(@StyleRes int id2) {
        this.state.setBadgeWithTextShapeAppearanceResId(id2);
        this.onBadgeShapeAppearanceUpdated();
    }

    public void setBadgeWithTextShapeAppearanceOverlay(@StyleRes int id2) {
        this.state.setBadgeWithTextShapeAppearanceOverlayResId(id2);
        this.onBadgeShapeAppearanceUpdated();
    }

    private void onBadgeShapeAppearanceUpdated() {
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return;
        }
        this.shapeDrawable.setShapeAppearanceModel(ShapeAppearanceModel.builder(context, this.hasBadgeContent() ? this.state.getBadgeWithTextShapeAppearanceResId() : this.state.getBadgeShapeAppearanceResId(), this.hasBadgeContent() ? this.state.getBadgeWithTextShapeAppearanceOverlayResId() : this.state.getBadgeShapeAppearanceOverlayResId()).build());
        this.invalidateSelf();
    }

    private void updateCenterAndBounds() {
        ViewGroup customBadgeParent;
        View anchorView;
        Context context = (Context)this.contextRef.get();
        View view = anchorView = this.anchorViewRef != null ? (View)this.anchorViewRef.get() : null;
        if (context == null || anchorView == null) {
            return;
        }
        Rect tmpRect = new Rect();
        tmpRect.set(this.badgeBounds);
        Rect anchorRect = new Rect();
        anchorView.getDrawingRect(anchorRect);
        ViewGroup viewGroup = customBadgeParent = this.customBadgeParentRef != null ? (ViewGroup)this.customBadgeParentRef.get() : null;
        if (customBadgeParent != null || BadgeUtils.USE_COMPAT_PARENT) {
            ViewGroup viewGroup2 = customBadgeParent == null ? (ViewGroup)anchorView.getParent() : customBadgeParent;
            viewGroup2.offsetDescendantRectToMyCoords(anchorView, anchorRect);
        }
        this.calculateCenterAndBounds(anchorRect, anchorView);
        BadgeUtils.updateBadgeBounds(this.badgeBounds, this.badgeCenterX, this.badgeCenterY, this.halfBadgeWidth, this.halfBadgeHeight);
        if (this.cornerRadius != -1.0f) {
            this.shapeDrawable.setCornerSize(this.cornerRadius);
        }
        if (!tmpRect.equals((Object)this.badgeBounds)) {
            this.shapeDrawable.setBounds(this.badgeBounds);
        }
    }

    private int getTotalVerticalOffsetForState() {
        int vOffset = this.state.getVerticalOffsetWithoutText();
        if (this.hasBadgeContent()) {
            vOffset = this.state.getVerticalOffsetWithText();
            Context context = (Context)this.contextRef.get();
            if (context != null) {
                float progress = AnimationUtils.lerp(0.0f, 1.0f, 0.3f, 1.0f, MaterialResources.getFontScale(context) - 1.0f);
                vOffset = AnimationUtils.lerp(vOffset, vOffset - this.state.getLargeFontVerticalOffsetAdjustment(), progress);
            }
        }
        if (this.state.offsetAlignmentMode == 0) {
            vOffset -= Math.round(this.halfBadgeHeight);
        }
        return vOffset + this.state.getAdditionalVerticalOffset();
    }

    private int getTotalHorizontalOffsetForState() {
        int hOffset;
        int n = hOffset = this.hasBadgeContent() ? this.state.getHorizontalOffsetWithText() : this.state.getHorizontalOffsetWithoutText();
        if (this.state.offsetAlignmentMode == 1) {
            hOffset += this.hasBadgeContent() ? this.state.horizontalInsetWithText : this.state.horizontalInset;
        }
        return hOffset + this.state.getAdditionalHorizontalOffset();
    }

    private void calculateCenterAndBounds(@NonNull Rect anchorRect, @NonNull View anchorView) {
        float f = this.cornerRadius = this.hasBadgeContent() ? this.state.badgeWithTextRadius : this.state.badgeRadius;
        if (this.cornerRadius != -1.0f) {
            this.halfBadgeWidth = this.cornerRadius;
            this.halfBadgeHeight = this.cornerRadius;
        } else {
            this.halfBadgeWidth = Math.round(this.hasBadgeContent() ? this.state.badgeWithTextWidth / 2.0f : this.state.badgeWidth / 2.0f);
            this.halfBadgeHeight = Math.round(this.hasBadgeContent() ? this.state.badgeWithTextHeight / 2.0f : this.state.badgeHeight / 2.0f);
        }
        if (this.hasBadgeContent()) {
            String badgeContent = this.getBadgeContent();
            this.halfBadgeWidth = Math.max(this.halfBadgeWidth, this.textDrawableHelper.getTextWidth(badgeContent) / 2.0f + (float)this.state.getBadgeHorizontalPadding());
            this.halfBadgeHeight = Math.max(this.halfBadgeHeight, this.textDrawableHelper.getTextHeight(badgeContent) / 2.0f + (float)this.state.getBadgeVerticalPadding());
            this.halfBadgeWidth = Math.max(this.halfBadgeWidth, this.halfBadgeHeight);
        }
        int totalVerticalOffset = this.getTotalVerticalOffsetForState();
        switch (this.state.getBadgeGravity()) {
            case 8388691: 
            case 0x800055: {
                this.badgeCenterY = anchorRect.bottom - totalVerticalOffset;
                break;
            }
            default: {
                this.badgeCenterY = anchorRect.top + totalVerticalOffset;
            }
        }
        int totalHorizontalOffset = this.getTotalHorizontalOffsetForState();
        switch (this.state.getBadgeGravity()) {
            case 0x800033: 
            case 8388691: {
                this.badgeCenterX = ViewCompat.getLayoutDirection((View)anchorView) == 0 ? (float)anchorRect.left - this.halfBadgeWidth + (float)totalHorizontalOffset : (float)anchorRect.right + this.halfBadgeWidth - (float)totalHorizontalOffset;
                break;
            }
            default: {
                float f2 = this.badgeCenterX = ViewCompat.getLayoutDirection((View)anchorView) == 0 ? (float)anchorRect.right + this.halfBadgeWidth - (float)totalHorizontalOffset : (float)anchorRect.left - this.halfBadgeWidth + (float)totalHorizontalOffset;
            }
        }
        if (this.state.isAutoAdjustedToGrandparentBounds()) {
            this.autoAdjustWithinGrandparentBounds(anchorView);
        }
    }

    private void autoAdjustWithinGrandparentBounds(@NonNull View anchorView) {
        FrameLayout anchorParent;
        float anchorXOffset;
        float anchorYOffset;
        FrameLayout customAnchorParent = this.getCustomBadgeParent();
        if (customAnchorParent == null) {
            if (!(anchorView.getParent() instanceof View)) {
                return;
            }
            anchorYOffset = anchorView.getY();
            anchorXOffset = anchorView.getX();
            anchorParent = (View)anchorView.getParent();
        } else if (this.isAnchorViewWrappedInCompatParent()) {
            if (!(customAnchorParent.getParent() instanceof View)) {
                return;
            }
            anchorYOffset = customAnchorParent.getY();
            anchorXOffset = customAnchorParent.getX();
            anchorParent = (View)customAnchorParent.getParent();
        } else {
            anchorYOffset = 0.0f;
            anchorXOffset = 0.0f;
            anchorParent = customAnchorParent;
        }
        float topCutOff = this.getTopCutOff((View)anchorParent, anchorYOffset);
        float leftCutOff = this.getLeftCutOff((View)anchorParent, anchorXOffset);
        float bottomCutOff = this.getBottomCutOff((View)anchorParent, anchorYOffset);
        float rightCutOff = this.getRightCutoff((View)anchorParent, anchorXOffset);
        if (topCutOff < 0.0f) {
            this.badgeCenterY += Math.abs(topCutOff);
        }
        if (leftCutOff < 0.0f) {
            this.badgeCenterX += Math.abs(leftCutOff);
        }
        if (bottomCutOff > 0.0f) {
            this.badgeCenterY -= Math.abs(bottomCutOff);
        }
        if (rightCutOff > 0.0f) {
            this.badgeCenterX -= Math.abs(rightCutOff);
        }
    }

    private float getTopCutOff(View anchorParent, float anchorViewOffset) {
        return this.badgeCenterY - this.halfBadgeHeight + anchorParent.getY() + anchorViewOffset;
    }

    private float getLeftCutOff(View anchorParent, float anchorViewOffset) {
        return this.badgeCenterX - this.halfBadgeWidth + anchorParent.getX() + anchorViewOffset;
    }

    private float getBottomCutOff(View anchorParent, float anchorViewOffset) {
        float bottomCutOff = 0.0f;
        if (anchorParent.getParent() instanceof View) {
            View anchorGrandparent = (View)anchorParent.getParent();
            bottomCutOff = this.badgeCenterY + this.halfBadgeHeight - ((float)anchorGrandparent.getHeight() - anchorParent.getY()) + anchorViewOffset;
        }
        return bottomCutOff;
    }

    private float getRightCutoff(View anchorParent, float anchorViewOffset) {
        float rightCutOff = 0.0f;
        if (anchorParent.getParent() instanceof View) {
            View anchorGrandparent = (View)anchorParent.getParent();
            rightCutOff = this.badgeCenterX + this.halfBadgeWidth - ((float)anchorGrandparent.getWidth() - anchorParent.getX()) + anchorViewOffset;
        }
        return rightCutOff;
    }

    private void drawBadgeContent(Canvas canvas) {
        String badgeContent = this.getBadgeContent();
        if (badgeContent != null) {
            Rect textBounds = new Rect();
            this.textDrawableHelper.getTextPaint().getTextBounds(badgeContent, 0, badgeContent.length(), textBounds);
            float exactCenterY = this.badgeCenterY - textBounds.exactCenterY();
            canvas.drawText(badgeContent, this.badgeCenterX, textBounds.bottom <= 0 ? (float)((int)exactCenterY) : (float)Math.round(exactCenterY), (Paint)this.textDrawableHelper.getTextPaint());
        }
    }

    private boolean hasBadgeContent() {
        return this.hasText() || this.hasNumber();
    }

    @Nullable
    private String getBadgeContent() {
        if (this.hasText()) {
            return this.getTextBadgeText();
        }
        if (this.hasNumber()) {
            return this.getNumberBadgeText();
        }
        return null;
    }

    @Nullable
    private String getTextBadgeText() {
        String text = this.getText();
        int maxCharacterCount = this.getMaxCharacterCount();
        if (maxCharacterCount == -2) {
            return text;
        }
        if (text != null && text.length() > maxCharacterCount) {
            Context context = (Context)this.contextRef.get();
            if (context == null) {
                return "";
            }
            text = text.substring(0, maxCharacterCount - 1);
            return String.format(context.getString(R.string.m3_exceed_max_badge_text_suffix), text, DEFAULT_EXCEED_MAX_BADGE_TEXT_SUFFIX);
        }
        return text;
    }

    @NonNull
    private String getNumberBadgeText() {
        if (this.maxBadgeNumber == -2 || this.getNumber() <= this.maxBadgeNumber) {
            return NumberFormat.getInstance(this.state.getNumberLocale()).format(this.getNumber());
        }
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return "";
        }
        return String.format(this.state.getNumberLocale(), context.getString(R.string.mtrl_exceed_max_badge_number_suffix), this.maxBadgeNumber, DEFAULT_EXCEED_MAX_BADGE_NUMBER_SUFFIX);
    }

    private void onBadgeContentUpdated() {
        this.textDrawableHelper.setTextSizeDirty(true);
        this.onBadgeShapeAppearanceUpdated();
        this.updateCenterAndBounds();
        this.invalidateSelf();
    }

    private void updateMaxBadgeNumber() {
        this.maxBadgeNumber = this.getMaxCharacterCount() != -2 ? (int)Math.pow(10.0, (double)this.getMaxCharacterCount() - 1.0) - 1 : this.getMaxNumber();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BadgeGravity {
    }
}

