/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.button;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.ToggleButton;
import androidx.annotation.BoolRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class MaterialButtonToggleGroup
extends LinearLayout {
    private static final String LOG_TAG = "MButtonToggleGroup";
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_MaterialButtonToggleGroup;
    private final List<CornerData> originalCornerData = new ArrayList<CornerData>();
    private final PressedStateTracker pressedStateTracker = new PressedStateTracker();
    private final LinkedHashSet<OnButtonCheckedListener> onButtonCheckedListeners = new LinkedHashSet();
    private final Comparator<MaterialButton> childOrderComparator = new Comparator<MaterialButton>(){

        @Override
        public int compare(MaterialButton v1, MaterialButton v2) {
            int checked = Boolean.valueOf(v1.isChecked()).compareTo(v2.isChecked());
            if (checked != 0) {
                return checked;
            }
            int stateful = Boolean.valueOf(v1.isPressed()).compareTo(v2.isPressed());
            if (stateful != 0) {
                return stateful;
            }
            return Integer.valueOf(MaterialButtonToggleGroup.this.indexOfChild((View)v1)).compareTo(MaterialButtonToggleGroup.this.indexOfChild((View)v2));
        }
    };
    private Integer[] childOrder;
    private boolean skipCheckedStateTracker = false;
    private boolean singleSelection;
    private boolean selectionRequired;
    @IdRes
    private final int defaultCheckId;
    private Set<Integer> checkedIds = new HashSet<Integer>();

    public MaterialButtonToggleGroup(@NonNull Context context) {
        this(context, null);
    }

    public MaterialButtonToggleGroup(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.materialButtonToggleGroupStyle);
    }

    public MaterialButtonToggleGroup(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.MaterialButtonToggleGroup, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.setSingleSelection(attributes.getBoolean(R.styleable.MaterialButtonToggleGroup_singleSelection, false));
        this.defaultCheckId = attributes.getResourceId(R.styleable.MaterialButtonToggleGroup_checkedButton, -1);
        this.selectionRequired = attributes.getBoolean(R.styleable.MaterialButtonToggleGroup_selectionRequired, false);
        this.setChildrenDrawingOrderEnabled(true);
        this.setEnabled(attributes.getBoolean(R.styleable.MaterialButtonToggleGroup_android_enabled, true));
        attributes.recycle();
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.defaultCheckId != -1) {
            this.updateCheckedIds(Collections.singleton(this.defaultCheckId));
        }
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        this.updateChildOrder();
        super.dispatchDraw(canvas);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!(child instanceof MaterialButton)) {
            Log.e((String)LOG_TAG, (String)"Child views must be of type MaterialButton.");
            return;
        }
        super.addView(child, index, params);
        MaterialButton buttonChild = (MaterialButton)child;
        this.setGeneratedIdIfNeeded(buttonChild);
        this.setupButtonChild(buttonChild);
        this.checkInternal(buttonChild.getId(), buttonChild.isChecked());
        ShapeAppearanceModel shapeAppearanceModel = buttonChild.getShapeAppearanceModel();
        this.originalCornerData.add(new CornerData(shapeAppearanceModel.getTopLeftCornerSize(), shapeAppearanceModel.getBottomLeftCornerSize(), shapeAppearanceModel.getTopRightCornerSize(), shapeAppearanceModel.getBottomRightCornerSize()));
        buttonChild.setEnabled(this.isEnabled());
        ViewCompat.setAccessibilityDelegate((View)buttonChild, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)MaterialButtonToggleGroup.this.getIndexWithinVisibleButtons(host), (int)1, (boolean)false, (boolean)((MaterialButton)host).isChecked()));
            }
        });
    }

    public void onViewRemoved(View child) {
        int indexOfChild;
        super.onViewRemoved(child);
        if (child instanceof MaterialButton) {
            ((MaterialButton)child).setOnPressedChangeListenerInternal(null);
        }
        if ((indexOfChild = this.indexOfChild(child)) >= 0) {
            this.originalCornerData.remove(indexOfChild);
        }
        this.updateChildShapes();
        this.adjustChildMarginsAndUpdateLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.updateChildShapes();
        this.adjustChildMarginsAndUpdateLayout();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info);
        infoCompat.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)1, (int)this.getVisibleButtonCount(), (boolean)false, (int)(this.isSingleSelection() ? 1 : 2)));
    }

    public void check(@IdRes int id2) {
        this.checkInternal(id2, true);
    }

    public void uncheck(@IdRes int id2) {
        this.checkInternal(id2, false);
    }

    public void clearChecked() {
        this.updateCheckedIds(new HashSet<Integer>());
    }

    @IdRes
    public int getCheckedButtonId() {
        return this.singleSelection && !this.checkedIds.isEmpty() ? this.checkedIds.iterator().next() : -1;
    }

    @NonNull
    public List<Integer> getCheckedButtonIds() {
        ArrayList<Integer> orderedCheckedIds = new ArrayList<Integer>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childId = this.getChildButton(i).getId();
            if (!this.checkedIds.contains(childId)) continue;
            orderedCheckedIds.add(childId);
        }
        return orderedCheckedIds;
    }

    public void addOnButtonCheckedListener(@NonNull OnButtonCheckedListener listener) {
        this.onButtonCheckedListeners.add(listener);
    }

    public void removeOnButtonCheckedListener(@NonNull OnButtonCheckedListener listener) {
        this.onButtonCheckedListeners.remove(listener);
    }

    public void clearOnButtonCheckedListeners() {
        this.onButtonCheckedListeners.clear();
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setSingleSelection(boolean singleSelection) {
        if (this.singleSelection != singleSelection) {
            this.singleSelection = singleSelection;
            this.clearChecked();
        }
        this.updateChildrenA11yClassName();
    }

    private void updateChildrenA11yClassName() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            String className = this.singleSelection ? RadioButton.class.getName() : ToggleButton.class.getName();
            this.getChildButton(i).setA11yClassName(className);
        }
    }

    public void setSelectionRequired(boolean selectionRequired) {
        this.selectionRequired = selectionRequired;
    }

    public boolean isSelectionRequired() {
        return this.selectionRequired;
    }

    public void setSingleSelection(@BoolRes int id2) {
        this.setSingleSelection(this.getResources().getBoolean(id2));
    }

    private void setCheckedStateForView(@IdRes int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView instanceof MaterialButton) {
            this.skipCheckedStateTracker = true;
            ((MaterialButton)checkedView).setChecked(checked);
            this.skipCheckedStateTracker = false;
        }
    }

    private void adjustChildMarginsAndUpdateLayout() {
        int firstVisibleChildIndex = this.getFirstVisibleChildIndex();
        if (firstVisibleChildIndex == -1) {
            return;
        }
        for (int i = firstVisibleChildIndex + 1; i < this.getChildCount(); ++i) {
            MaterialButton currentButton = this.getChildButton(i);
            MaterialButton previousButton = this.getChildButton(i - 1);
            int smallestStrokeWidth = Math.min(currentButton.getStrokeWidth(), previousButton.getStrokeWidth());
            LinearLayout.LayoutParams params = this.buildLayoutParams((View)currentButton);
            if (this.getOrientation() == 0) {
                MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)params, (int)0);
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)(-smallestStrokeWidth));
                params.topMargin = 0;
            } else {
                params.bottomMargin = 0;
                params.topMargin = -smallestStrokeWidth;
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)0);
            }
            currentButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.resetChildMargins(firstVisibleChildIndex);
    }

    private MaterialButton getChildButton(int index) {
        return (MaterialButton)this.getChildAt(index);
    }

    private void resetChildMargins(int childIndex) {
        if (this.getChildCount() == 0 || childIndex == -1) {
            return;
        }
        MaterialButton currentButton = this.getChildButton(childIndex);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)currentButton.getLayoutParams();
        if (this.getOrientation() == 1) {
            params.topMargin = 0;
            params.bottomMargin = 0;
            return;
        }
        MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)params, (int)0);
        MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)0);
        params.leftMargin = 0;
        params.rightMargin = 0;
    }

    @VisibleForTesting
    void updateChildShapes() {
        int childCount = this.getChildCount();
        int firstVisibleChildIndex = this.getFirstVisibleChildIndex();
        int lastVisibleChildIndex = this.getLastVisibleChildIndex();
        for (int i = 0; i < childCount; ++i) {
            MaterialButton button = this.getChildButton(i);
            if (button.getVisibility() == 8) continue;
            ShapeAppearanceModel.Builder builder = button.getShapeAppearanceModel().toBuilder();
            CornerData newCornerData = this.getNewCornerData(i, firstVisibleChildIndex, lastVisibleChildIndex);
            MaterialButtonToggleGroup.updateBuilderWithCornerData(builder, newCornerData);
            button.setShapeAppearanceModel(builder.build());
        }
    }

    private int getFirstVisibleChildIndex() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!this.isChildVisible(i)) continue;
            return i;
        }
        return -1;
    }

    private int getLastVisibleChildIndex() {
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            if (!this.isChildVisible(i)) continue;
            return i;
        }
        return -1;
    }

    private boolean isChildVisible(int i) {
        View child = this.getChildAt(i);
        return child.getVisibility() != 8;
    }

    private int getVisibleButtonCount() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!(this.getChildAt(i) instanceof MaterialButton) || !this.isChildVisible(i)) continue;
            ++count;
        }
        return count;
    }

    private int getIndexWithinVisibleButtons(@Nullable View child) {
        if (!(child instanceof MaterialButton)) {
            return -1;
        }
        int index = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChildAt(i) == child) {
                return index;
            }
            if (!(this.getChildAt(i) instanceof MaterialButton) || !this.isChildVisible(i)) continue;
            ++index;
        }
        return -1;
    }

    @Nullable
    private CornerData getNewCornerData(int index, int firstVisibleChildIndex, int lastVisibleChildIndex) {
        boolean isHorizontal;
        CornerData cornerData = this.originalCornerData.get(index);
        if (firstVisibleChildIndex == lastVisibleChildIndex) {
            return cornerData;
        }
        boolean bl = isHorizontal = this.getOrientation() == 0;
        if (index == firstVisibleChildIndex) {
            return isHorizontal ? CornerData.start(cornerData, (View)this) : CornerData.top(cornerData);
        }
        if (index == lastVisibleChildIndex) {
            return isHorizontal ? CornerData.end(cornerData, (View)this) : CornerData.bottom(cornerData);
        }
        return null;
    }

    private static void updateBuilderWithCornerData(ShapeAppearanceModel.Builder shapeAppearanceModelBuilder, @Nullable CornerData cornerData) {
        if (cornerData == null) {
            shapeAppearanceModelBuilder.setAllCornerSizes(0.0f);
            return;
        }
        shapeAppearanceModelBuilder.setTopLeftCornerSize(cornerData.topLeft).setBottomLeftCornerSize(cornerData.bottomLeft).setTopRightCornerSize(cornerData.topRight).setBottomRightCornerSize(cornerData.bottomRight);
    }

    private void checkInternal(@IdRes int buttonId, boolean checked) {
        if (buttonId == -1) {
            Log.e((String)LOG_TAG, (String)("Button ID is not valid: " + buttonId));
            return;
        }
        HashSet<Integer> checkedIds = new HashSet<Integer>(this.checkedIds);
        if (checked && !checkedIds.contains(buttonId)) {
            if (this.singleSelection && !checkedIds.isEmpty()) {
                checkedIds.clear();
            }
            checkedIds.add(buttonId);
        } else if (!checked && checkedIds.contains(buttonId)) {
            if (!this.selectionRequired || checkedIds.size() > 1) {
                checkedIds.remove(buttonId);
            }
        } else {
            return;
        }
        this.updateCheckedIds(checkedIds);
    }

    private void updateCheckedIds(Set<Integer> checkedIds) {
        Set<Integer> previousCheckedIds = this.checkedIds;
        this.checkedIds = new HashSet<Integer>(checkedIds);
        for (int i = 0; i < this.getChildCount(); ++i) {
            int buttonId = this.getChildButton(i).getId();
            this.setCheckedStateForView(buttonId, checkedIds.contains(buttonId));
            if (previousCheckedIds.contains(buttonId) == checkedIds.contains(buttonId)) continue;
            this.dispatchOnButtonChecked(buttonId, checkedIds.contains(buttonId));
        }
        this.invalidate();
    }

    private void dispatchOnButtonChecked(@IdRes int buttonId, boolean checked) {
        for (OnButtonCheckedListener listener : this.onButtonCheckedListeners) {
            listener.onButtonChecked(this, buttonId, checked);
        }
    }

    private void setGeneratedIdIfNeeded(@NonNull MaterialButton materialButton) {
        if (materialButton.getId() == -1) {
            materialButton.setId(ViewCompat.generateViewId());
        }
    }

    private void setupButtonChild(@NonNull MaterialButton buttonChild) {
        buttonChild.setMaxLines(1);
        buttonChild.setEllipsize(TextUtils.TruncateAt.END);
        buttonChild.setCheckable(true);
        buttonChild.setOnPressedChangeListenerInternal(this.pressedStateTracker);
        buttonChild.setShouldDrawSurfaceColorStroke(true);
    }

    @NonNull
    private LinearLayout.LayoutParams buildLayoutParams(@NonNull View child) {
        ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
        if (layoutParams instanceof LinearLayout.LayoutParams) {
            return (LinearLayout.LayoutParams)layoutParams;
        }
        return new LinearLayout.LayoutParams(layoutParams.width, layoutParams.height);
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.childOrder == null || i >= this.childOrder.length) {
            Log.w((String)LOG_TAG, (String)"Child order wasn't updated");
            return i;
        }
        return this.childOrder[i];
    }

    private void updateChildOrder() {
        TreeMap<MaterialButton, Integer> viewToIndexMap = new TreeMap<MaterialButton, Integer>(this.childOrderComparator);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            viewToIndexMap.put(this.getChildButton(i), i);
        }
        this.childOrder = viewToIndexMap.values().toArray(new Integer[0]);
    }

    void onButtonCheckedStateChanged(@NonNull MaterialButton button, boolean isChecked) {
        if (this.skipCheckedStateTracker) {
            return;
        }
        this.checkInternal(button.getId(), isChecked);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getChildCount(); ++i) {
            MaterialButton childButton = this.getChildButton(i);
            childButton.setEnabled(enabled);
        }
    }

    private static class CornerData {
        private static final CornerSize noCorner = new AbsoluteCornerSize(0.0f);
        CornerSize topLeft;
        CornerSize topRight;
        CornerSize bottomRight;
        CornerSize bottomLeft;

        CornerData(CornerSize topLeft, CornerSize bottomLeft, CornerSize topRight, CornerSize bottomRight) {
            this.topLeft = topLeft;
            this.topRight = topRight;
            this.bottomRight = bottomRight;
            this.bottomLeft = bottomLeft;
        }

        public static CornerData start(CornerData orig, View view) {
            return ViewUtils.isLayoutRtl(view) ? CornerData.right(orig) : CornerData.left(orig);
        }

        public static CornerData end(CornerData orig, View view) {
            return ViewUtils.isLayoutRtl(view) ? CornerData.left(orig) : CornerData.right(orig);
        }

        public static CornerData left(CornerData orig) {
            return new CornerData(orig.topLeft, orig.bottomLeft, noCorner, noCorner);
        }

        public static CornerData right(CornerData orig) {
            return new CornerData(noCorner, noCorner, orig.topRight, orig.bottomRight);
        }

        public static CornerData top(CornerData orig) {
            return new CornerData(orig.topLeft, noCorner, orig.topRight, noCorner);
        }

        public static CornerData bottom(CornerData orig) {
            return new CornerData(noCorner, orig.bottomLeft, noCorner, orig.bottomRight);
        }
    }

    private class PressedStateTracker
    implements MaterialButton.OnPressedChangeListener {
        private PressedStateTracker() {
        }

        @Override
        public void onPressedChanged(@NonNull MaterialButton button, boolean isPressed) {
            MaterialButtonToggleGroup.this.invalidate();
        }
    }

    public static interface OnButtonCheckedListener {
        public void onButtonChecked(MaterialButtonToggleGroup var1, @IdRes int var2, boolean var3);
    }
}

