/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import androidx.annotation.NonNull;
import androidx.core.math.MathUtils;

final class Arrangement {
    private static final float MEDIUM_ITEM_FLEX_PERCENTAGE = 0.1f;
    final int priority;
    float smallSize;
    int smallCount;
    int mediumCount;
    float mediumSize;
    float largeSize;
    final int largeCount;
    final float cost;

    Arrangement(int priority, float targetSmallSize, float minSmallSize, float maxSmallSize, int smallCount, float targetMediumSize, int mediumCount, float targetLargeSize, int largeCount, float availableSpace) {
        this.priority = priority;
        this.smallSize = MathUtils.clamp((float)targetSmallSize, (float)minSmallSize, (float)maxSmallSize);
        this.smallCount = smallCount;
        this.mediumSize = targetMediumSize;
        this.mediumCount = mediumCount;
        this.largeSize = targetLargeSize;
        this.largeCount = largeCount;
        this.fit(availableSpace, minSmallSize, maxSmallSize, targetLargeSize);
        this.cost = this.cost(targetLargeSize);
    }

    @NonNull
    public String toString() {
        return "Arrangement [priority=" + this.priority + ", smallCount=" + this.smallCount + ", smallSize=" + this.smallSize + ", mediumCount=" + this.mediumCount + ", mediumSize=" + this.mediumSize + ", largeCount=" + this.largeCount + ", largeSize=" + this.largeSize + ", cost=" + this.cost + "]";
    }

    private float getSpace() {
        return this.largeSize * (float)this.largeCount + this.mediumSize * (float)this.mediumCount + this.smallSize * (float)this.smallCount;
    }

    private void fit(float availableSpace, float minSmallSize, float maxSmallSize, float targetLargeSize) {
        float delta = availableSpace - this.getSpace();
        if (this.smallCount > 0 && delta > 0.0f) {
            this.smallSize += Math.min(delta / (float)this.smallCount, maxSmallSize - this.smallSize);
        } else if (this.smallCount > 0 && delta < 0.0f) {
            this.smallSize += Math.max(delta / (float)this.smallCount, minSmallSize - this.smallSize);
        }
        this.smallSize = this.smallCount > 0 ? this.smallSize : 0.0f;
        this.largeSize = this.calculateLargeSize(availableSpace, this.smallCount, this.smallSize, this.mediumCount, this.largeCount);
        this.mediumSize = (this.largeSize + this.smallSize) / 2.0f;
        if (this.mediumCount > 0 && this.largeSize != targetLargeSize) {
            float targetAdjustment = (targetLargeSize - this.largeSize) * (float)this.largeCount;
            float availableMediumFlex = this.mediumSize * 0.1f * (float)this.mediumCount;
            float distribute = Math.min(Math.abs(targetAdjustment), availableMediumFlex);
            if (targetAdjustment > 0.0f) {
                this.mediumSize -= distribute / (float)this.mediumCount;
                this.largeSize += distribute / (float)this.largeCount;
            } else {
                this.mediumSize += distribute / (float)this.mediumCount;
                this.largeSize -= distribute / (float)this.largeCount;
            }
        }
    }

    private float calculateLargeSize(float availableSpace, int smallCount, float smallSize, int mediumCount, int largeCount) {
        smallSize = smallCount > 0 ? smallSize : 0.0f;
        return (availableSpace - ((float)smallCount + (float)mediumCount / 2.0f) * smallSize) / ((float)largeCount + (float)mediumCount / 2.0f);
    }

    private boolean isValid() {
        if (this.largeCount > 0 && this.smallCount > 0 && this.mediumCount > 0) {
            return this.largeSize > this.mediumSize && this.mediumSize > this.smallSize;
        }
        if (this.largeCount > 0 && this.smallCount > 0) {
            return this.largeSize > this.smallSize;
        }
        return true;
    }

    private float cost(float targetLargeSize) {
        if (!this.isValid()) {
            return Float.MAX_VALUE;
        }
        return Math.abs(targetLargeSize - this.largeSize) * (float)this.priority;
    }

    static Arrangement findLowestCostArrangement(float availableSpace, float targetSmallSize, float minSmallSize, float maxSmallSize, int[] smallCounts, float targetMediumSize, int[] mediumCounts, float targetLargeSize, int[] largeCounts) {
        Arrangement lowestCostArrangement = null;
        int priority = 1;
        for (int largeCount : largeCounts) {
            for (int mediumCount : mediumCounts) {
                for (int smallCount : smallCounts) {
                    Arrangement arrangement = new Arrangement(priority, targetSmallSize, minSmallSize, maxSmallSize, smallCount, targetMediumSize, mediumCount, targetLargeSize, largeCount, availableSpace);
                    if (lowestCostArrangement == null || arrangement.cost < lowestCostArrangement.cost) {
                        lowestCostArrangement = arrangement;
                        if (lowestCostArrangement.cost == 0.0f) {
                            return lowestCostArrangement;
                        }
                    }
                    ++priority;
                }
            }
        }
        return lowestCostArrangement;
    }

    int getItemCount() {
        return this.smallCount + this.mediumCount + this.largeCount;
    }
}

