/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.graphics.ColorUtils;
import androidx.core.math.MathUtils;
import androidx.core.util.Preconditions;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselOrientationHelper;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.KeylineState;
import com.google.android.material.carousel.KeylineStateList;
import com.google.android.material.carousel.Maskable;
import com.google.android.material.carousel.MultiBrowseCarouselStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CarouselLayoutManager
extends RecyclerView.LayoutManager
implements Carousel,
RecyclerView.SmoothScroller.ScrollVectorProvider {
    private static final String TAG = "CarouselLayoutManager";
    @VisibleForTesting
    int scrollOffset;
    @VisibleForTesting
    int minScroll;
    @VisibleForTesting
    int maxScroll;
    private boolean isDebuggingEnabled = false;
    private final DebugItemDecoration debugItemDecoration = new DebugItemDecoration();
    @NonNull
    private CarouselStrategy carouselStrategy;
    @Nullable
    private KeylineStateList keylineStateList;
    @Nullable
    private KeylineState currentKeylineState;
    private int currentFillStartPosition = 0;
    @Nullable
    private Map<Integer, KeylineState> keylineStatePositionMap;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private CarouselOrientationHelper orientationHelper;
    private final View.OnLayoutChangeListener recyclerViewSizeChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
        if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
            v.post(this::refreshKeylineState);
        }
    };
    public static final int ALIGNMENT_START = 0;
    public static final int ALIGNMENT_CENTER = 1;
    private int lastItemCount;
    private int currentEstimatedPosition = -1;
    private int carouselAlignment = 0;

    public CarouselLayoutManager() {
        this(new MultiBrowseCarouselStrategy());
    }

    public CarouselLayoutManager(@NonNull CarouselStrategy strategy) {
        this(strategy, 0);
    }

    public CarouselLayoutManager(@NonNull CarouselStrategy strategy, int orientation) {
        this.setCarouselStrategy(strategy);
        this.setOrientation(orientation);
    }

    @SuppressLint(value={"UnknownNullness"})
    public CarouselLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setCarouselStrategy(new MultiBrowseCarouselStrategy());
        this.setCarouselAttributes(context, attrs);
    }

    private void setCarouselAttributes(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Carousel);
            this.setCarouselAlignment(a.getInt(R.styleable.Carousel_carousel_alignment, 0));
            this.setOrientation(a.getInt(R.styleable.RecyclerView_android_orientation, 0));
            a.recycle();
        }
    }

    public void setCarouselAlignment(int alignment) {
        this.carouselAlignment = alignment;
        this.refreshKeylineState();
    }

    @Override
    public int getCarouselAlignment() {
        return this.carouselAlignment;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public void setCarouselStrategy(@NonNull CarouselStrategy carouselStrategy) {
        this.carouselStrategy = carouselStrategy;
        this.refreshKeylineState();
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.refreshKeylineState();
        view.addOnLayoutChangeListener(this.recyclerViewSizeChangeListener);
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        view.removeOnLayoutChangeListener(this.recyclerViewSizeChangeListener);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        boolean isInitialLoad;
        if (state.getItemCount() <= 0 || (float)this.getContainerSize() <= 0.0f) {
            this.removeAndRecycleAllViews(recycler);
            this.currentFillStartPosition = 0;
            return;
        }
        boolean isRtl = this.isLayoutRtl();
        boolean bl = isInitialLoad = this.keylineStateList == null;
        if (isInitialLoad) {
            this.recalculateKeylineStateList(recycler);
        }
        int startScroll = this.calculateStartScroll(this.keylineStateList);
        int endScroll = this.calculateEndScroll(state, this.keylineStateList);
        this.minScroll = isRtl ? endScroll : startScroll;
        int n = this.maxScroll = isRtl ? startScroll : endScroll;
        if (isInitialLoad) {
            this.scrollOffset = startScroll;
            this.keylineStatePositionMap = this.keylineStateList.getKeylineStateForPositionMap(this.getItemCount(), this.minScroll, this.maxScroll, this.isLayoutRtl());
            if (this.currentEstimatedPosition != -1) {
                this.scrollOffset = this.getScrollOffsetForPosition(this.currentEstimatedPosition, this.getKeylineStateForPosition(this.currentEstimatedPosition));
            }
        }
        this.scrollOffset += CarouselLayoutManager.calculateShouldScrollBy(0, this.scrollOffset, this.minScroll, this.maxScroll);
        this.currentFillStartPosition = MathUtils.clamp((int)this.currentFillStartPosition, (int)0, (int)state.getItemCount());
        this.updateCurrentKeylineStateForScrollOffset(this.keylineStateList);
        this.detachAndScrapAttachedViews(recycler);
        this.fill(recycler, state);
        this.lastItemCount = this.getItemCount();
    }

    private void recalculateKeylineStateList(RecyclerView.Recycler recycler) {
        View firstChild = recycler.getViewForPosition(0);
        this.measureChildWithMargins(firstChild, 0, 0);
        KeylineState keylineState = this.carouselStrategy.onFirstChildMeasuredWithMargins(this, firstChild);
        this.keylineStateList = KeylineStateList.from(this, this.isLayoutRtl() ? KeylineState.reverse(keylineState, this.getContainerSize()) : keylineState);
    }

    private void refreshKeylineState() {
        this.keylineStateList = null;
        this.requestLayout();
    }

    private void fill(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.removeAndRecycleOutOfBoundsViews(recycler);
        if (this.getChildCount() == 0) {
            this.addViewsStart(recycler, this.currentFillStartPosition - 1);
            this.addViewsEnd(recycler, state, this.currentFillStartPosition);
        } else {
            int firstPosition = this.getPosition(this.getChildAt(0));
            int lastPosition = this.getPosition(this.getChildAt(this.getChildCount() - 1));
            this.addViewsStart(recycler, firstPosition - 1);
            this.addViewsEnd(recycler, state, lastPosition + 1);
        }
        this.validateChildOrderIfDebugging();
    }

    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.currentFillStartPosition = this.getChildCount() == 0 ? 0 : this.getPosition(this.getChildAt(0));
        this.validateChildOrderIfDebugging();
    }

    private void addViewsStart(RecyclerView.Recycler recycler, int startPosition) {
        float start = this.calculateChildStartForFill(startPosition);
        for (int i = startPosition; i >= 0; --i) {
            ChildCalculations calculations = this.makeChildCalculations(recycler, start, i);
            if (this.isLocOffsetOutOfFillBoundsStart(calculations.offsetCenter, calculations.range)) break;
            start = this.addStart(start, this.currentKeylineState.getItemSize());
            if (this.isLocOffsetOutOfFillBoundsEnd(calculations.offsetCenter, calculations.range)) continue;
            this.addAndLayoutView(calculations.child, 0, calculations);
        }
    }

    private void addViewAtPosition(@NonNull RecyclerView.Recycler recycler, int startPosition, int childIndex) {
        if (startPosition < 0 || startPosition >= this.getItemCount()) {
            return;
        }
        float start = this.calculateChildStartForFill(startPosition);
        ChildCalculations calculations = this.makeChildCalculations(recycler, start, startPosition);
        this.addAndLayoutView(calculations.child, childIndex, calculations);
    }

    private void addViewsEnd(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition) {
        float start = this.calculateChildStartForFill(startPosition);
        for (int i = startPosition; i < state.getItemCount(); ++i) {
            ChildCalculations calculations = this.makeChildCalculations(recycler, start, i);
            if (this.isLocOffsetOutOfFillBoundsEnd(calculations.offsetCenter, calculations.range)) break;
            start = this.addEnd(start, this.currentKeylineState.getItemSize());
            if (this.isLocOffsetOutOfFillBoundsStart(calculations.offsetCenter, calculations.range)) continue;
            this.addAndLayoutView(calculations.child, -1, calculations);
        }
    }

    private void logChildrenIfDebugging() {
        if (!this.isDebuggingEnabled) {
            return;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"internal representation of views on the screen");
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                float center = this.getDecoratedCenterWithMargins(child);
                Log.d((String)TAG, (String)("item position " + this.getPosition(child) + ", center:" + center + ", child index:" + i));
            }
            Log.d((String)TAG, (String)"==============");
        }
    }

    private void validateChildOrderIfDebugging() {
        if (!this.isDebuggingEnabled || this.getChildCount() < 1) {
            return;
        }
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            int nextPos;
            int currPos = this.getPosition(this.getChildAt(i));
            if (currPos <= (nextPos = this.getPosition(this.getChildAt(i + 1)))) continue;
            this.logChildrenIfDebugging();
            throw new IllegalStateException("Detected invalid child order. Child at index [" + i + "] had adapter position [" + currPos + "] and child at index [" + (i + 1) + "] had adapter position [" + nextPos + "].");
        }
    }

    private ChildCalculations makeChildCalculations(RecyclerView.Recycler recycler, float start, int position) {
        View child = recycler.getViewForPosition(position);
        this.measureChildWithMargins(child, 0, 0);
        float center = this.addEnd(start, this.currentKeylineState.getItemSize() / 2.0f);
        KeylineRange range = CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), center, false);
        float offsetCenter = this.calculateChildOffsetCenterForLocation(child, center, range);
        return new ChildCalculations(child, center, offsetCenter, range);
    }

    private void addAndLayoutView(View child, int index, ChildCalculations calculations) {
        float halfItemSize = this.currentKeylineState.getItemSize() / 2.0f;
        this.addView(child, index);
        int start = (int)(calculations.offsetCenter - halfItemSize);
        int end = (int)(calculations.offsetCenter + halfItemSize);
        this.orientationHelper.layoutDecoratedWithMargins(child, start, end);
        this.updateChildMaskForLocation(child, calculations.center, calculations.range);
    }

    private boolean isLocOffsetOutOfFillBoundsStart(float locOffset, KeylineRange range) {
        float maskedSize = this.getMaskedItemSizeForLocOffset(locOffset, range);
        float maskedEnd = this.addEnd(locOffset, maskedSize / 2.0f);
        return this.isLayoutRtl() ? maskedEnd > (float)this.getContainerSize() : maskedEnd < 0.0f;
    }

    @Override
    public boolean isHorizontal() {
        return this.orientationHelper.orientation == 0;
    }

    private boolean isLocOffsetOutOfFillBoundsEnd(float locOffset, KeylineRange range) {
        float maskedSize = this.getMaskedItemSizeForLocOffset(locOffset, range);
        float maskedStart = this.addStart(locOffset, maskedSize / 2.0f);
        return this.isLayoutRtl() ? maskedStart < 0.0f : maskedStart > (float)this.getContainerSize();
    }

    public void getDecoratedBoundsWithMargins(@NonNull View view, @NonNull Rect outBounds) {
        super.getDecoratedBoundsWithMargins(view, outBounds);
        float center = outBounds.centerY();
        if (this.isHorizontal()) {
            center = outBounds.centerX();
        }
        float maskedSize = this.getMaskedItemSizeForLocOffset(center, CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), center, true));
        float deltaX = this.isHorizontal() ? ((float)outBounds.width() - maskedSize) / 2.0f : 0.0f;
        float deltaY = this.isHorizontal() ? 0.0f : ((float)outBounds.height() - maskedSize) / 2.0f;
        outBounds.set((int)((float)outBounds.left + deltaX), (int)((float)outBounds.top + deltaY), (int)((float)outBounds.right - deltaX), (int)((float)outBounds.bottom - deltaY));
    }

    private float getDecoratedCenterWithMargins(View child) {
        Rect bounds = new Rect();
        super.getDecoratedBoundsWithMargins(child, bounds);
        if (this.isHorizontal()) {
            return bounds.centerX();
        }
        return bounds.centerY();
    }

    private void removeAndRecycleOutOfBoundsViews(RecyclerView.Recycler recycler) {
        KeylineRange range;
        View child;
        float center;
        while (this.getChildCount() > 0 && this.isLocOffsetOutOfFillBoundsStart(center = this.getDecoratedCenterWithMargins(child = this.getChildAt(0)), range = CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), center, true))) {
            this.removeAndRecycleView(child, recycler);
        }
        while (this.getChildCount() - 1 >= 0 && this.isLocOffsetOutOfFillBoundsEnd(center = this.getDecoratedCenterWithMargins(child = this.getChildAt(this.getChildCount() - 1)), range = CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), center, true))) {
            this.removeAndRecycleView(child, recycler);
        }
    }

    private static KeylineRange getSurroundingKeylineRange(List<KeylineState.Keyline> keylines, float location, boolean isOffset) {
        int startMinDistanceIndex = -1;
        float startMinDistance = Float.MAX_VALUE;
        int startMostIndex = -1;
        float startMostX = Float.MAX_VALUE;
        int endMinDistanceIndex = -1;
        float endMinDistance = Float.MAX_VALUE;
        int endMostIndex = -1;
        float endMostX = -3.4028235E38f;
        for (int i = 0; i < keylines.size(); ++i) {
            KeylineState.Keyline keyline = keylines.get(i);
            float currentLoc = isOffset ? keyline.locOffset : keyline.loc;
            float delta = Math.abs(currentLoc - location);
            if (currentLoc <= location && delta <= startMinDistance) {
                startMinDistance = delta;
                startMinDistanceIndex = i;
            }
            if (currentLoc > location && delta <= endMinDistance) {
                endMinDistance = delta;
                endMinDistanceIndex = i;
            }
            if (currentLoc <= startMostX) {
                startMostIndex = i;
                startMostX = currentLoc;
            }
            if (!(currentLoc > endMostX)) continue;
            endMostIndex = i;
            endMostX = currentLoc;
        }
        if (startMinDistanceIndex == -1) {
            startMinDistanceIndex = startMostIndex;
        }
        if (endMinDistanceIndex == -1) {
            endMinDistanceIndex = endMostIndex;
        }
        return new KeylineRange(keylines.get(startMinDistanceIndex), keylines.get(endMinDistanceIndex));
    }

    private void updateCurrentKeylineStateForScrollOffset(@NonNull KeylineStateList keylineStateList) {
        this.currentKeylineState = this.maxScroll <= this.minScroll ? (this.isLayoutRtl() ? keylineStateList.getEndState() : keylineStateList.getStartState()) : keylineStateList.getShiftedState(this.scrollOffset, this.minScroll, this.maxScroll);
        this.debugItemDecoration.setKeylines(this.currentKeylineState.getKeylines());
    }

    private static int calculateShouldScrollBy(int delta, int currentScroll, int minScroll, int maxScroll) {
        int targetScroll = currentScroll + delta;
        if (targetScroll < minScroll) {
            return minScroll - currentScroll;
        }
        if (targetScroll > maxScroll) {
            return maxScroll - currentScroll;
        }
        return delta;
    }

    private int calculateStartScroll(@NonNull KeylineStateList stateList) {
        boolean isRtl = this.isLayoutRtl();
        KeylineState startState = isRtl ? stateList.getEndState() : stateList.getStartState();
        KeylineState.Keyline startFocalKeyline = isRtl ? startState.getLastFocalKeyline() : startState.getFirstFocalKeyline();
        float firstItemDistanceFromStart = this.getPaddingStart() * (isRtl ? 1 : -1);
        float firstItemStart = this.addStart(startFocalKeyline.loc, startState.getItemSize() / 2.0f);
        return (int)(firstItemDistanceFromStart + (float)this.getParentStart() - firstItemStart);
    }

    private int calculateEndScroll(RecyclerView.State state, KeylineStateList stateList) {
        boolean isRtl = this.isLayoutRtl();
        KeylineState endState = isRtl ? stateList.getStartState() : stateList.getEndState();
        KeylineState.Keyline endFocalKeyline = isRtl ? endState.getFirstFocalKeyline() : endState.getLastFocalKeyline();
        float lastItemDistanceFromFirstItem = ((float)(state.getItemCount() - 1) * endState.getItemSize() + (float)this.getPaddingEnd()) * (isRtl ? -1.0f : 1.0f);
        float endFocalLocDistanceFromStart = endFocalKeyline.loc - (float)this.getParentStart();
        float endFocalLocDistanceFromEnd = (float)this.getParentEnd() - endFocalKeyline.loc;
        int endScroll = (int)(lastItemDistanceFromFirstItem - endFocalLocDistanceFromStart + endFocalLocDistanceFromEnd);
        return isRtl ? Math.min(0, endScroll) : Math.max(0, endScroll);
    }

    private float calculateChildStartForFill(int startPosition) {
        float childScrollOffset = this.getParentStart() - this.scrollOffset;
        float positionOffset = this.currentKeylineState.getItemSize() * (float)startPosition;
        return this.addEnd(childScrollOffset, positionOffset);
    }

    private float calculateChildOffsetCenterForLocation(View child, float childCenterLocation, KeylineRange range) {
        float offsetCenter = AnimationUtils.lerp(range.leftOrTop.locOffset, range.rightOrBottom.locOffset, range.leftOrTop.loc, range.rightOrBottom.loc, childCenterLocation);
        if (range.rightOrBottom == this.currentKeylineState.getFirstKeyline() || range.leftOrTop == this.currentKeylineState.getLastKeyline()) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
            float marginMask = this.orientationHelper.getMaskMargins(lp) / this.currentKeylineState.getItemSize();
            float outOfBoundOffset = (childCenterLocation - range.rightOrBottom.loc) * (1.0f - range.rightOrBottom.mask + marginMask);
            offsetCenter += outOfBoundOffset;
        }
        return offsetCenter;
    }

    private float getMaskedItemSizeForLocOffset(float locOffset, KeylineRange range) {
        return AnimationUtils.lerp(range.leftOrTop.maskedItemSize, range.rightOrBottom.maskedItemSize, range.leftOrTop.locOffset, range.rightOrBottom.locOffset, locOffset);
    }

    private void updateChildMaskForLocation(View child, float childCenterLocation, KeylineRange range) {
        if (!(child instanceof Maskable)) {
            return;
        }
        float maskProgress = AnimationUtils.lerp(range.leftOrTop.mask, range.rightOrBottom.mask, range.leftOrTop.loc, range.rightOrBottom.loc, childCenterLocation);
        float childHeight = child.getHeight();
        float childWidth = child.getWidth();
        float maskWidth = AnimationUtils.lerp(0.0f, childWidth / 2.0f, 0.0f, 1.0f, maskProgress);
        float maskHeight = AnimationUtils.lerp(0.0f, childHeight / 2.0f, 0.0f, 1.0f, maskProgress);
        RectF maskRect = this.orientationHelper.getMaskRect(childHeight, childWidth, maskHeight, maskWidth);
        float offsetCenter = this.calculateChildOffsetCenterForLocation(child, childCenterLocation, range);
        float maskedTop = offsetCenter - maskRect.height() / 2.0f;
        float maskedBottom = offsetCenter + maskRect.height() / 2.0f;
        float maskedLeft = offsetCenter - maskRect.width() / 2.0f;
        float maskedRight = offsetCenter + maskRect.width() / 2.0f;
        RectF offsetMaskRect = new RectF(maskedLeft, maskedTop, maskedRight, maskedBottom);
        RectF parentBoundsRect = new RectF((float)this.getParentLeft(), (float)this.getParentTop(), (float)this.getParentRight(), (float)this.getParentBottom());
        if (this.carouselStrategy.isContained()) {
            this.orientationHelper.containMaskWithinBounds(maskRect, offsetMaskRect, parentBoundsRect);
        }
        this.orientationHelper.moveMaskOnEdgeOutsideBounds(maskRect, offsetMaskRect, parentBoundsRect);
        ((Maskable)child).setMaskRectF(maskRect);
    }

    public void measureChildWithMargins(@NonNull View child, int widthUsed, int heightUsed) {
        if (!(child instanceof Maskable)) {
            throw new IllegalStateException("All children of a RecyclerView using CarouselLayoutManager must use MaskableFrameLayout as their root ViewGroup.");
        }
        RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
        Rect insets = new Rect();
        this.calculateItemDecorationsForChild(child, insets);
        float childWidthDimension = this.keylineStateList != null && this.orientationHelper.orientation == 0 ? this.keylineStateList.getDefaultState().getItemSize() : (float)lp.width;
        float childHeightDimension = this.keylineStateList != null && this.orientationHelper.orientation == 1 ? this.keylineStateList.getDefaultState().getItemSize() : (float)lp.height;
        int widthSpec = CarouselLayoutManager.getChildMeasureSpec((int)this.getWidth(), (int)this.getWidthMode(), (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + (widthUsed += insets.left + insets.right)), (int)((int)childWidthDimension), (boolean)this.canScrollHorizontally());
        int heightSpec = CarouselLayoutManager.getChildMeasureSpec((int)this.getHeight(), (int)this.getHeightMode(), (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + (heightUsed += insets.top + insets.bottom)), (int)((int)childHeightDimension), (boolean)this.canScrollVertically());
        child.measure(widthSpec, heightSpec);
    }

    private int getParentLeft() {
        return this.orientationHelper.getParentLeft();
    }

    private int getParentStart() {
        return this.orientationHelper.getParentStart();
    }

    private int getParentRight() {
        return this.orientationHelper.getParentRight();
    }

    private int getParentEnd() {
        return this.orientationHelper.getParentEnd();
    }

    private int getParentTop() {
        return this.orientationHelper.getParentTop();
    }

    private int getParentBottom() {
        return this.orientationHelper.getParentBottom();
    }

    @Override
    public int getContainerWidth() {
        return this.getWidth();
    }

    @Override
    public int getContainerHeight() {
        return this.getHeight();
    }

    private int getContainerSize() {
        if (this.isHorizontal()) {
            return this.getContainerWidth();
        }
        return this.getContainerHeight();
    }

    boolean isLayoutRtl() {
        return this.isHorizontal() && this.getLayoutDirection() == 1;
    }

    private float addStart(float value, float amount) {
        return this.isLayoutRtl() ? value + amount : value - amount;
    }

    private float addEnd(float value, float amount) {
        return this.isLayoutRtl() ? value - amount : value + amount;
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (this.getChildCount() > 0) {
            event.setFromIndex(this.getPosition(this.getChildAt(0)));
            event.setToIndex(this.getPosition(this.getChildAt(this.getChildCount() - 1)));
        }
    }

    private int getScrollOffsetForPosition(int position, KeylineState keylineState) {
        if (this.isLayoutRtl()) {
            return (int)((float)this.getContainerSize() - keylineState.getLastFocalKeyline().loc - (float)position * keylineState.getItemSize() - keylineState.getItemSize() / 2.0f);
        }
        return (int)((float)position * keylineState.getItemSize() - keylineState.getFirstFocalKeyline().loc + keylineState.getItemSize() / 2.0f);
    }

    private int getSmallestScrollOffsetToFocalKeyline(int position, @NonNull KeylineState keylineState) {
        int smallestScrollOffset = Integer.MAX_VALUE;
        for (KeylineState.Keyline keyline : keylineState.getFocalKeylines()) {
            int positionOffsetDistanceFromKeyline;
            float offsetWithoutKeylines = (float)position * keylineState.getItemSize();
            float halfFocalKeylineSize = keylineState.getItemSize() / 2.0f;
            float offsetWithKeylines = offsetWithoutKeylines + halfFocalKeylineSize;
            int n = positionOffsetDistanceFromKeyline = this.isLayoutRtl() ? (int)((float)this.getContainerSize() - keyline.loc - offsetWithKeylines) : (int)(offsetWithKeylines - keyline.loc);
            if (Math.abs(smallestScrollOffset) <= Math.abs(positionOffsetDistanceFromKeyline -= this.scrollOffset)) continue;
            smallestScrollOffset = positionOffsetDistanceFromKeyline;
        }
        return smallestScrollOffset;
    }

    @Nullable
    public PointF computeScrollVectorForPosition(int targetPosition) {
        if (this.keylineStateList == null) {
            return null;
        }
        KeylineState keylineForScroll = this.getKeylineStateForPosition(targetPosition);
        int offset = this.getOffsetToScrollToPosition(targetPosition, keylineForScroll);
        if (this.isHorizontal()) {
            return new PointF((float)offset, 0.0f);
        }
        return new PointF(0.0f, (float)offset);
    }

    int getOffsetToScrollToPosition(int position, @NonNull KeylineState keylineState) {
        int targetScrollOffset = this.getScrollOffsetForPosition(position, keylineState);
        return targetScrollOffset - this.scrollOffset;
    }

    int getOffsetToScrollToPositionForSnap(int position, boolean partialSnap) {
        int targetSnapOffset;
        KeylineState targetKeylineStateForSnap = this.keylineStateList.getShiftedState(this.scrollOffset, this.minScroll, this.maxScroll, true);
        int positionOffset = targetSnapOffset = this.getOffsetToScrollToPosition(position, targetKeylineStateForSnap);
        if (this.keylineStatePositionMap != null) {
            positionOffset = this.getOffsetToScrollToPosition(position, this.getKeylineStateForPosition(position));
        }
        if (partialSnap) {
            return Math.abs(positionOffset) < Math.abs(targetSnapOffset) ? positionOffset : targetSnapOffset;
        }
        return targetSnapOffset;
    }

    private KeylineState getKeylineStateForPosition(int position) {
        KeylineState keylineState;
        if (this.keylineStatePositionMap != null && (keylineState = this.keylineStatePositionMap.get(MathUtils.clamp((int)position, (int)0, (int)Math.max(0, this.getItemCount() - 1)))) != null) {
            return keylineState;
        }
        return this.keylineStateList.getDefaultState();
    }

    public void scrollToPosition(int position) {
        this.currentEstimatedPosition = position;
        if (this.keylineStateList == null) {
            return;
        }
        this.scrollOffset = this.getScrollOffsetForPosition(position, this.getKeylineStateForPosition(position));
        this.currentFillStartPosition = MathUtils.clamp((int)position, (int)0, (int)Math.max(0, this.getItemCount() - 1));
        this.updateCurrentKeylineStateForScrollOffset(this.keylineStateList);
        this.requestLayout();
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

            @Nullable
            public PointF computeScrollVectorForPosition(int targetPosition) {
                return CarouselLayoutManager.this.computeScrollVectorForPosition(targetPosition);
            }

            public int calculateDxToMakeVisible(View view, int snapPreference) {
                if (CarouselLayoutManager.this.keylineStateList == null || !CarouselLayoutManager.this.isHorizontal()) {
                    return 0;
                }
                return CarouselLayoutManager.this.calculateScrollDeltaToMakePositionVisible(CarouselLayoutManager.this.getPosition(view));
            }

            public int calculateDyToMakeVisible(View view, int snapPreference) {
                if (CarouselLayoutManager.this.keylineStateList == null || CarouselLayoutManager.this.isHorizontal()) {
                    return 0;
                }
                return CarouselLayoutManager.this.calculateScrollDeltaToMakePositionVisible(CarouselLayoutManager.this.getPosition(view));
            }
        };
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
    }

    int calculateScrollDeltaToMakePositionVisible(int position) {
        KeylineState scrollToKeyline = this.getKeylineStateForPosition(position);
        float targetScrollOffset = this.getScrollOffsetForPosition(position, scrollToKeyline);
        return (int)((float)this.scrollOffset - targetScrollOffset);
    }

    public boolean canScrollHorizontally() {
        return this.isHorizontal();
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.canScrollHorizontally() ? this.scrollBy(dx, recycler, state) : 0;
    }

    public boolean canScrollVertically() {
        return !this.isHorizontal();
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.canScrollVertically() ? this.scrollBy(dy, recycler, state) : 0;
    }

    private int convertFocusDirectionToLayoutDirection(int focusDirection) {
        int orientation = this.getOrientation();
        switch (focusDirection) {
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
            case 33: {
                return orientation == 1 ? -1 : Integer.MIN_VALUE;
            }
            case 130: {
                return orientation == 1 ? 1 : Integer.MIN_VALUE;
            }
            case 17: {
                if (orientation == 0) {
                    return this.isLayoutRtl() ? 1 : -1;
                }
                return Integer.MIN_VALUE;
            }
            case 66: {
                if (orientation == 0) {
                    return this.isLayoutRtl() ? -1 : 1;
                }
                return Integer.MIN_VALUE;
            }
        }
        Log.d((String)TAG, (String)("Unknown focus request:" + focusDirection));
        return Integer.MIN_VALUE;
    }

    @Nullable
    public View onFocusSearchFailed(@NonNull View focused, int focusDirection, @NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state) {
        View nextFocus;
        if (this.getChildCount() == 0) {
            return null;
        }
        int layoutDir = this.convertFocusDirectionToLayoutDirection(focusDirection);
        if (layoutDir == Integer.MIN_VALUE) {
            return null;
        }
        if (layoutDir == -1) {
            if (this.getPosition(focused) == 0) {
                return null;
            }
            int firstPosition = this.getPosition(this.getChildAt(0));
            this.addViewAtPosition(recycler, firstPosition - 1, 0);
            nextFocus = this.getChildClosestToStart();
        } else {
            if (this.getPosition(focused) == this.getItemCount() - 1) {
                return null;
            }
            int lastPosition = this.getPosition(this.getChildAt(this.getChildCount() - 1));
            this.addViewAtPosition(recycler, lastPosition + 1, -1);
            nextFocus = this.getChildClosestToEnd();
        }
        return nextFocus;
    }

    private View getChildClosestToStart() {
        return this.getChildAt(this.isLayoutRtl() ? this.getChildCount() - 1 : 0);
    }

    private View getChildClosestToEnd() {
        return this.getChildAt(this.isLayoutRtl() ? 0 : this.getChildCount() - 1);
    }

    public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate, boolean focusedChildVisible) {
        if (this.keylineStateList == null) {
            return false;
        }
        int delta = this.getSmallestScrollOffsetToFocalKeyline(this.getPosition(child), this.getKeylineStateForPosition(this.getPosition(child)));
        if (delta == 0) {
            return false;
        }
        int realDelta = CarouselLayoutManager.calculateShouldScrollBy(delta, this.scrollOffset, this.minScroll, this.maxScroll);
        KeylineState scrolledKeylineState = this.keylineStateList.getShiftedState(this.scrollOffset + realDelta, this.minScroll, this.maxScroll);
        delta = this.getSmallestScrollOffsetToFocalKeyline(this.getPosition(child), scrolledKeylineState);
        this.scrollBy(parent, delta);
        return true;
    }

    private void scrollBy(RecyclerView recyclerView, int delta) {
        if (this.isHorizontal()) {
            recyclerView.scrollBy(delta, 0);
        } else {
            recyclerView.scrollBy(0, delta);
        }
    }

    private int scrollBy(int distance, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || distance == 0) {
            return 0;
        }
        if (this.keylineStateList == null) {
            this.recalculateKeylineStateList(recycler);
        }
        int scrolledBy = CarouselLayoutManager.calculateShouldScrollBy(distance, this.scrollOffset, this.minScroll, this.maxScroll);
        this.scrollOffset += scrolledBy;
        this.updateCurrentKeylineStateForScrollOffset(this.keylineStateList);
        float halfItemSize = this.currentKeylineState.getItemSize() / 2.0f;
        int startPosition = this.getPosition(this.getChildAt(0));
        float start = this.calculateChildStartForFill(startPosition);
        Rect boundsRect = new Rect();
        float firstFocalKeylineLoc = this.isLayoutRtl() ? this.currentKeylineState.getLastFocalKeyline().locOffset : this.currentKeylineState.getFirstFocalKeyline().locOffset;
        float absDistanceToFirstFocal = Float.MAX_VALUE;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            float offsetCenter = this.offsetChild(child, start, halfItemSize, boundsRect);
            float distanceToFirstFocal = Math.abs(firstFocalKeylineLoc - offsetCenter);
            if (child != null && distanceToFirstFocal < absDistanceToFirstFocal) {
                absDistanceToFirstFocal = distanceToFirstFocal;
                this.currentEstimatedPosition = this.getPosition(child);
            }
            start = this.addEnd(start, this.currentKeylineState.getItemSize());
        }
        this.fill(recycler, state);
        return scrolledBy;
    }

    private float offsetChild(View child, float startOffset, float halfItemSize, Rect boundsRect) {
        float center = this.addEnd(startOffset, halfItemSize);
        KeylineRange range = CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), center, false);
        float offsetCenter = this.calculateChildOffsetCenterForLocation(child, center, range);
        super.getDecoratedBoundsWithMargins(child, boundsRect);
        this.updateChildMaskForLocation(child, center, range);
        this.orientationHelper.offsetChild(child, boundsRect, halfItemSize, offsetCenter);
        return offsetCenter;
    }

    public int computeHorizontalScrollOffset(@NonNull RecyclerView.State state) {
        return this.scrollOffset;
    }

    public int computeHorizontalScrollExtent(@NonNull RecyclerView.State state) {
        if (this.getChildCount() == 0 || this.keylineStateList == null || this.getItemCount() <= 1) {
            return 0;
        }
        float itemRatio = this.keylineStateList.getDefaultState().getItemSize() / (float)this.computeHorizontalScrollRange(state);
        return (int)((float)this.getWidth() * itemRatio);
    }

    public int computeHorizontalScrollRange(@NonNull RecyclerView.State state) {
        return this.maxScroll - this.minScroll;
    }

    public int computeVerticalScrollOffset(@NonNull RecyclerView.State state) {
        return this.scrollOffset;
    }

    public int computeVerticalScrollExtent(@NonNull RecyclerView.State state) {
        if (this.getChildCount() == 0 || this.keylineStateList == null || this.getItemCount() <= 1) {
            return 0;
        }
        float itemRatio = this.keylineStateList.getDefaultState().getItemSize() / (float)this.computeVerticalScrollRange(state);
        return (int)((float)this.getHeight() * itemRatio);
    }

    public int computeVerticalScrollRange(@NonNull RecyclerView.State state) {
        return this.maxScroll - this.minScroll;
    }

    public int getOrientation() {
        return this.orientationHelper.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation:" + orientation);
        }
        this.assertNotInLayoutOrScroll(null);
        if (this.orientationHelper == null || orientation != this.orientationHelper.orientation) {
            this.orientationHelper = CarouselOrientationHelper.createOrientationHelper(this, orientation);
            this.refreshKeylineState();
        }
    }

    public void onItemsAdded(@NonNull RecyclerView recyclerView, int positionStart, int itemCount) {
        super.onItemsAdded(recyclerView, positionStart, itemCount);
        this.updateItemCount();
    }

    public void onItemsRemoved(@NonNull RecyclerView recyclerView, int positionStart, int itemCount) {
        super.onItemsRemoved(recyclerView, positionStart, itemCount);
        this.updateItemCount();
    }

    private void updateItemCount() {
        int newItemCount = this.getItemCount();
        if (newItemCount == this.lastItemCount || this.keylineStateList == null) {
            return;
        }
        if (this.carouselStrategy.shouldRefreshKeylineState(this, this.lastItemCount)) {
            this.refreshKeylineState();
        }
        this.lastItemCount = newItemCount;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setDebuggingEnabled(@NonNull RecyclerView recyclerView, boolean enabled) {
        this.isDebuggingEnabled = enabled;
        recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.debugItemDecoration);
        if (enabled) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.debugItemDecoration);
        }
        recyclerView.invalidateItemDecorations();
    }

    private static class DebugItemDecoration
    extends RecyclerView.ItemDecoration {
        private final Paint linePaint = new Paint();
        private List<KeylineState.Keyline> keylines = Collections.unmodifiableList(new ArrayList());

        DebugItemDecoration() {
            this.linePaint.setStrokeWidth(5.0f);
            this.linePaint.setColor(-65281);
        }

        void setKeylines(List<KeylineState.Keyline> keylines) {
            this.keylines = Collections.unmodifiableList(keylines);
        }

        public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            super.onDrawOver(c, parent, state);
            this.linePaint.setStrokeWidth(parent.getResources().getDimension(R.dimen.m3_carousel_debug_keyline_width));
            for (KeylineState.Keyline keyline : this.keylines) {
                this.linePaint.setColor(ColorUtils.blendARGB((int)-65281, (int)-16776961, (float)keyline.mask));
                if (((CarouselLayoutManager)parent.getLayoutManager()).isHorizontal()) {
                    c.drawLine(keyline.locOffset, (float)((CarouselLayoutManager)parent.getLayoutManager()).getParentTop(), keyline.locOffset, (float)((CarouselLayoutManager)parent.getLayoutManager()).getParentBottom(), this.linePaint);
                    continue;
                }
                c.drawLine((float)((CarouselLayoutManager)parent.getLayoutManager()).getParentLeft(), keyline.locOffset, (float)((CarouselLayoutManager)parent.getLayoutManager()).getParentRight(), keyline.locOffset, this.linePaint);
            }
        }
    }

    private static class KeylineRange {
        final KeylineState.Keyline leftOrTop;
        final KeylineState.Keyline rightOrBottom;

        KeylineRange(KeylineState.Keyline leftOrTop, KeylineState.Keyline rightOrBottom) {
            Preconditions.checkArgument((leftOrTop.loc <= rightOrBottom.loc ? 1 : 0) != 0);
            this.leftOrTop = leftOrTop;
            this.rightOrBottom = rightOrBottom;
        }
    }

    private static class LayoutDirection {
        private static final int LAYOUT_START = -1;
        private static final int LAYOUT_END = 1;
        private static final int INVALID_LAYOUT = Integer.MIN_VALUE;

        private LayoutDirection() {
        }
    }

    private static final class ChildCalculations {
        final View child;
        final float center;
        final float offsetCenter;
        final KeylineRange range;

        ChildCalculations(View child, float center, float offsetCenter, KeylineRange range) {
            this.child = child;
            this.center = center;
            this.offsetCenter = offsetCenter;
            this.range = range;
        }
    }
}

