/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.view.View;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.KeylineState;

public abstract class CarouselStrategy {
    abstract KeylineState onFirstChildMeasuredWithMargins(@NonNull Carousel var1, @NonNull View var2);

    @FloatRange(from=0.0, to=1.0)
    static float getChildMaskPercentage(float maskedSize, float unmaskedSize, float childMargins) {
        return 1.0f - (maskedSize - childMargins) / (unmaskedSize - childMargins);
    }

    static int[] doubleCounts(int[] count) {
        int[] doubledCount = new int[count.length];
        for (int i = 0; i < doubledCount.length; ++i) {
            doubledCount[i] = count[i] * 2;
        }
        return doubledCount;
    }

    boolean isContained() {
        return true;
    }

    boolean shouldRefreshKeylineState(Carousel carousel, int oldItemCount) {
        return false;
    }
}

