/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.android.material.R;
import com.google.android.material.carousel.Arrangement;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.KeylineState;

final class CarouselStrategyHelper {
    private CarouselStrategyHelper() {
    }

    static float getExtraSmallSize(@NonNull Context context) {
        return context.getResources().getDimension(R.dimen.m3_carousel_gone_size);
    }

    static float getSmallSizeMin(@NonNull Context context) {
        return context.getResources().getDimension(R.dimen.m3_carousel_small_item_size_min);
    }

    static float getSmallSizeMax(@NonNull Context context) {
        return context.getResources().getDimension(R.dimen.m3_carousel_small_item_size_max);
    }

    static KeylineState createKeylineState(@NonNull Context context, float childMargins, float availableSpace, @NonNull Arrangement arrangement, int alignment) {
        if (alignment == 1) {
            return CarouselStrategyHelper.createCenterAlignedKeylineState(context, childMargins, availableSpace, arrangement);
        }
        return CarouselStrategyHelper.createLeftAlignedKeylineState(context, childMargins, availableSpace, arrangement);
    }

    static KeylineState createLeftAlignedKeylineState(@NonNull Context context, float childHorizontalMargins, float availableSpace, @NonNull Arrangement arrangement) {
        float extraSmallChildWidth = Math.min(CarouselStrategyHelper.getExtraSmallSize(context) + childHorizontalMargins, arrangement.largeSize);
        float start = 0.0f;
        float extraSmallHeadCenterX = start - extraSmallChildWidth / 2.0f;
        float largeStartCenterX = CarouselStrategyHelper.addStart(start, arrangement.largeSize, arrangement.largeCount);
        float largeEndCenterX = CarouselStrategyHelper.addEnd(largeStartCenterX, arrangement.largeSize, arrangement.largeCount);
        start = CarouselStrategyHelper.updateCurPosition(start, largeEndCenterX, arrangement.largeSize, arrangement.largeCount);
        float mediumCenterX = CarouselStrategyHelper.addStart(start, arrangement.mediumSize, arrangement.mediumCount);
        start = CarouselStrategyHelper.updateCurPosition(start, mediumCenterX, arrangement.mediumSize, arrangement.mediumCount);
        float smallStartCenterX = CarouselStrategyHelper.addStart(start, arrangement.smallSize, arrangement.smallCount);
        float extraSmallTailCenterX = availableSpace + extraSmallChildWidth / 2.0f;
        float extraSmallMask = CarouselStrategy.getChildMaskPercentage(extraSmallChildWidth, arrangement.largeSize, childHorizontalMargins);
        float smallMask = CarouselStrategy.getChildMaskPercentage(arrangement.smallSize, arrangement.largeSize, childHorizontalMargins);
        float mediumMask = CarouselStrategy.getChildMaskPercentage(arrangement.mediumSize, arrangement.largeSize, childHorizontalMargins);
        float largeMask = 0.0f;
        KeylineState.Builder builder = new KeylineState.Builder(arrangement.largeSize, availableSpace).addAnchorKeyline(extraSmallHeadCenterX, extraSmallMask, extraSmallChildWidth).addKeylineRange(largeStartCenterX, largeMask, arrangement.largeSize, arrangement.largeCount, true);
        if (arrangement.mediumCount > 0) {
            builder.addKeyline(mediumCenterX, mediumMask, arrangement.mediumSize);
        }
        if (arrangement.smallCount > 0) {
            builder.addKeylineRange(smallStartCenterX, smallMask, arrangement.smallSize, arrangement.smallCount);
        }
        builder.addAnchorKeyline(extraSmallTailCenterX, extraSmallMask, extraSmallChildWidth);
        return builder.build();
    }

    static KeylineState createCenterAlignedKeylineState(@NonNull Context context, float childHorizontalMargins, float availableSpace, @NonNull Arrangement arrangement) {
        float extraSmallChildWidth = Math.min(CarouselStrategyHelper.getExtraSmallSize(context) + childHorizontalMargins, arrangement.largeSize);
        float start = 0.0f;
        float extraSmallHeadCenterX = start - extraSmallChildWidth / 2.0f;
        float halfSmallStartCenterX = CarouselStrategyHelper.addStart(start, arrangement.smallSize, arrangement.smallCount);
        float halfSmallEndCenterX = CarouselStrategyHelper.addEnd(halfSmallStartCenterX, arrangement.smallSize, (int)Math.floor((float)arrangement.smallCount / 2.0f));
        start = CarouselStrategyHelper.updateCurPosition(start, halfSmallEndCenterX, arrangement.smallSize, arrangement.smallCount);
        float halfMediumStartCenterX = CarouselStrategyHelper.addStart(start, arrangement.mediumSize, arrangement.mediumCount);
        float halfMediumEndCenterX = CarouselStrategyHelper.addEnd(halfMediumStartCenterX, arrangement.mediumSize, (int)Math.floor((float)arrangement.mediumCount / 2.0f));
        start = CarouselStrategyHelper.updateCurPosition(start, halfMediumEndCenterX, arrangement.mediumSize, arrangement.mediumCount);
        float largeStartCenterX = CarouselStrategyHelper.addStart(start, arrangement.largeSize, arrangement.largeCount);
        float largeEndCenterX = CarouselStrategyHelper.addEnd(largeStartCenterX, arrangement.largeSize, arrangement.largeCount);
        start = CarouselStrategyHelper.updateCurPosition(start, largeEndCenterX, arrangement.largeSize, arrangement.largeCount);
        float secondHalfMediumStartCenterX = CarouselStrategyHelper.addStart(start, arrangement.mediumSize, arrangement.mediumCount);
        float secondHalfMediumEndCenterX = CarouselStrategyHelper.addEnd(secondHalfMediumStartCenterX, arrangement.mediumSize, (int)Math.ceil((float)arrangement.mediumCount / 2.0f));
        start = CarouselStrategyHelper.updateCurPosition(start, secondHalfMediumEndCenterX, arrangement.mediumSize, arrangement.mediumCount);
        float secondHalfSmallStartCenterX = CarouselStrategyHelper.addStart(start, arrangement.smallSize, arrangement.smallCount);
        float extraSmallTailCenterX = availableSpace + extraSmallChildWidth / 2.0f;
        float extraSmallMask = CarouselStrategy.getChildMaskPercentage(extraSmallChildWidth, arrangement.largeSize, childHorizontalMargins);
        float smallMask = CarouselStrategy.getChildMaskPercentage(arrangement.smallSize, arrangement.largeSize, childHorizontalMargins);
        float mediumMask = CarouselStrategy.getChildMaskPercentage(arrangement.mediumSize, arrangement.largeSize, childHorizontalMargins);
        float largeMask = 0.0f;
        KeylineState.Builder builder = new KeylineState.Builder(arrangement.largeSize, availableSpace).addAnchorKeyline(extraSmallHeadCenterX, extraSmallMask, extraSmallChildWidth);
        if (arrangement.smallCount > 0) {
            builder.addKeylineRange(halfSmallStartCenterX, smallMask, arrangement.smallSize, (int)Math.floor((float)arrangement.smallCount / 2.0f));
        }
        if (arrangement.mediumCount > 0) {
            builder.addKeylineRange(halfMediumStartCenterX, mediumMask, arrangement.mediumSize, (int)Math.floor((float)arrangement.mediumCount / 2.0f));
        }
        builder.addKeylineRange(largeStartCenterX, largeMask, arrangement.largeSize, arrangement.largeCount, true);
        if (arrangement.mediumCount > 0) {
            builder.addKeylineRange(secondHalfMediumStartCenterX, mediumMask, arrangement.mediumSize, (int)Math.ceil((float)arrangement.mediumCount / 2.0f));
        }
        if (arrangement.smallCount > 0) {
            builder.addKeylineRange(secondHalfSmallStartCenterX, smallMask, arrangement.smallSize, (int)Math.ceil((float)arrangement.smallCount / 2.0f));
        }
        builder.addAnchorKeyline(extraSmallTailCenterX, extraSmallMask, extraSmallChildWidth);
        return builder.build();
    }

    static int maxValue(int[] array) {
        int largest = Integer.MIN_VALUE;
        for (int j : array) {
            if (j <= largest) continue;
            largest = j;
        }
        return largest;
    }

    static float addStart(float start, float itemSize, int count) {
        if (count > 0) {
            return start + itemSize / 2.0f;
        }
        return start;
    }

    static float addEnd(float startKeylinePos, float itemSize, int count) {
        return startKeylinePos + (float)Math.max(0, count - 1) * itemSize;
    }

    static float updateCurPosition(float curPosition, float lastEndKeyline, float itemSize, int count) {
        if (count > 0) {
            return lastEndKeyline + itemSize / 2.0f;
        }
        return curPosition;
    }
}

