/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.carousel.Arrangement;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.CarouselStrategyHelper;
import com.google.android.material.carousel.KeylineState;

public class FullScreenCarouselStrategy
extends CarouselStrategy {
    @Override
    @NonNull
    KeylineState onFirstChildMeasuredWithMargins(@NonNull Carousel carousel, @NonNull View child) {
        float childMargins;
        float availableSpace;
        RecyclerView.LayoutParams childLayoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
        if (carousel.isHorizontal()) {
            availableSpace = carousel.getContainerWidth();
            childMargins = childLayoutParams.leftMargin + childLayoutParams.rightMargin;
        } else {
            availableSpace = carousel.getContainerHeight();
            childMargins = childLayoutParams.topMargin + childLayoutParams.bottomMargin;
        }
        float targetChildSize = Math.min(availableSpace + childMargins, availableSpace);
        Arrangement arrangement = new Arrangement(0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0, targetChildSize, 1, availableSpace);
        return CarouselStrategyHelper.createLeftAlignedKeylineState(child.getContext(), childMargins, availableSpace, arrangement);
    }
}

