/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.math.MathUtils;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.carousel.Arrangement;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.CarouselStrategyHelper;
import com.google.android.material.carousel.KeylineState;

public final class MultiBrowseCarouselStrategy
extends CarouselStrategy {
    private static final int[] SMALL_COUNTS = new int[]{1};
    private static final int[] MEDIUM_COUNTS = new int[]{1, 0};
    private int keylineCount = 0;

    @Override
    @NonNull
    KeylineState onFirstChildMeasuredWithMargins(@NonNull Carousel carousel, @NonNull View child) {
        float availableSpace = carousel.getContainerHeight();
        if (carousel.isHorizontal()) {
            availableSpace = carousel.getContainerWidth();
        }
        RecyclerView.LayoutParams childLayoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
        float childMargins = childLayoutParams.topMargin + childLayoutParams.bottomMargin;
        float measuredChildSize = child.getMeasuredHeight();
        if (carousel.isHorizontal()) {
            childMargins = childLayoutParams.leftMargin + childLayoutParams.rightMargin;
            measuredChildSize = child.getMeasuredWidth();
        }
        float smallChildSizeMin = CarouselStrategyHelper.getSmallSizeMin(child.getContext()) + childMargins;
        float smallChildSizeMax = CarouselStrategyHelper.getSmallSizeMax(child.getContext()) + childMargins;
        float targetLargeChildSize = Math.min(measuredChildSize + childMargins, availableSpace);
        float targetSmallChildSize = MathUtils.clamp((float)(measuredChildSize / 3.0f + childMargins), (float)(CarouselStrategyHelper.getSmallSizeMin(child.getContext()) + childMargins), (float)(CarouselStrategyHelper.getSmallSizeMax(child.getContext()) + childMargins));
        float targetMediumChildSize = (targetLargeChildSize + targetSmallChildSize) / 2.0f;
        int[] smallCounts = SMALL_COUNTS;
        if (availableSpace < smallChildSizeMin * 2.0f) {
            smallCounts = new int[]{0};
        }
        int[] mediumCounts = MEDIUM_COUNTS;
        if (carousel.getCarouselAlignment() == 1) {
            smallCounts = MultiBrowseCarouselStrategy.doubleCounts(smallCounts);
            mediumCounts = MultiBrowseCarouselStrategy.doubleCounts(mediumCounts);
        }
        float minAvailableLargeSpace = availableSpace - targetMediumChildSize * (float)CarouselStrategyHelper.maxValue(mediumCounts) - smallChildSizeMax * (float)CarouselStrategyHelper.maxValue(smallCounts);
        int largeCountMin = (int)Math.max(1.0, Math.floor(minAvailableLargeSpace / targetLargeChildSize));
        int largeCountMax = (int)Math.ceil(availableSpace / targetLargeChildSize);
        int[] largeCounts = new int[largeCountMax - largeCountMin + 1];
        for (int i = 0; i < largeCounts.length; ++i) {
            largeCounts[i] = largeCountMax - i;
        }
        Arrangement arrangement = Arrangement.findLowestCostArrangement(availableSpace, targetSmallChildSize, smallChildSizeMin, smallChildSizeMax, smallCounts, targetMediumChildSize, mediumCounts, targetLargeChildSize, largeCounts);
        this.keylineCount = arrangement.getItemCount();
        if (this.ensureArrangementFitsItemCount(arrangement, carousel.getItemCount())) {
            arrangement = Arrangement.findLowestCostArrangement(availableSpace, targetSmallChildSize, smallChildSizeMin, smallChildSizeMax, new int[]{arrangement.smallCount}, targetMediumChildSize, new int[]{arrangement.mediumCount}, targetLargeChildSize, new int[]{arrangement.largeCount});
        }
        return CarouselStrategyHelper.createKeylineState(child.getContext(), childMargins, availableSpace, arrangement, carousel.getCarouselAlignment());
    }

    boolean ensureArrangementFitsItemCount(Arrangement arrangement, int carouselItemCount) {
        boolean changed;
        int keylineSurplus = arrangement.getItemCount() - carouselItemCount;
        boolean bl = changed = keylineSurplus > 0 && (arrangement.smallCount > 0 || arrangement.mediumCount > 1);
        while (keylineSurplus > 0) {
            if (arrangement.smallCount > 0) {
                --arrangement.smallCount;
            } else if (arrangement.mediumCount > 1) {
                --arrangement.mediumCount;
            }
            --keylineSurplus;
        }
        return changed;
    }

    @Override
    boolean shouldRefreshKeylineState(Carousel carousel, int oldItemCount) {
        return oldItemCount < this.keylineCount && carousel.getItemCount() >= this.keylineCount || oldItemCount >= this.keylineCount && carousel.getItemCount() < this.keylineCount;
    }
}

