/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.CarouselStrategyHelper;
import com.google.android.material.carousel.KeylineState;

public final class UncontainedCarouselStrategy
extends CarouselStrategy {
    private static final float MEDIUM_LARGE_ITEM_PERCENTAGE_THRESHOLD = 0.85f;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UncontainedCarouselStrategy() {
    }

    @Override
    @NonNull
    KeylineState onFirstChildMeasuredWithMargins(@NonNull Carousel carousel, @NonNull View child) {
        boolean isCenter;
        float availableSpace = carousel.isHorizontal() ? (float)carousel.getContainerWidth() : (float)carousel.getContainerHeight();
        RecyclerView.LayoutParams childLayoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
        float childMargins = childLayoutParams.topMargin + childLayoutParams.bottomMargin;
        float measuredChildSize = child.getMeasuredHeight();
        if (carousel.isHorizontal()) {
            childMargins = childLayoutParams.leftMargin + childLayoutParams.rightMargin;
            measuredChildSize = child.getMeasuredWidth();
        }
        float largeChildSize = measuredChildSize + childMargins;
        float mediumChildSize = CarouselStrategyHelper.getExtraSmallSize(child.getContext()) + childMargins;
        float xSmallChildSize = CarouselStrategyHelper.getExtraSmallSize(child.getContext()) + childMargins;
        int largeCount = Math.max(1, (int)Math.floor(availableSpace / largeChildSize));
        float remainingSpace = availableSpace - (float)largeCount * largeChildSize;
        boolean bl = isCenter = carousel.getCarouselAlignment() == 1;
        if (isCenter) {
            float smallChildSizeMin = CarouselStrategyHelper.getSmallSizeMin(child.getContext()) + childMargins;
            mediumChildSize = Math.min(3.0f * (remainingSpace /= 2.0f), largeChildSize);
            mediumChildSize = Math.max(mediumChildSize, smallChildSizeMin);
            return this.createCenterAlignedKeylineState(availableSpace, childMargins, largeChildSize, largeCount, mediumChildSize, xSmallChildSize, remainingSpace);
        }
        int mediumCount = 0;
        if (remainingSpace > 0.0f) {
            mediumCount = 1;
        }
        mediumChildSize = this.calculateMediumChildSize(mediumChildSize, largeChildSize, remainingSpace);
        return this.createLeftAlignedKeylineState(child.getContext(), childMargins, availableSpace, largeChildSize, largeCount, mediumChildSize, mediumCount, xSmallChildSize);
    }

    private float calculateMediumChildSize(float mediumChildSize, float largeChildSize, float remainingSpace) {
        float largeItemThreshold;
        if ((mediumChildSize = Math.max(remainingSpace * 1.5f, mediumChildSize)) > (largeItemThreshold = largeChildSize * 0.85f)) {
            mediumChildSize = Math.max(largeItemThreshold, remainingSpace * 1.2f);
        }
        mediumChildSize = Math.min(largeChildSize, mediumChildSize);
        return mediumChildSize;
    }

    private KeylineState createCenterAlignedKeylineState(float availableSpace, float childMargins, float largeSize, int largeCount, float mediumSize, float xSmallSize, float remainingSpace) {
        xSmallSize = Math.min(xSmallSize, largeSize);
        float extraSmallMask = UncontainedCarouselStrategy.getChildMaskPercentage(xSmallSize, largeSize, childMargins);
        float mediumMask = UncontainedCarouselStrategy.getChildMaskPercentage(mediumSize, largeSize, childMargins);
        float largeMask = 0.0f;
        float start = 0.0f;
        float firstMediumCenterX = start + remainingSpace - mediumSize / 2.0f;
        start = firstMediumCenterX + mediumSize / 2.0f;
        float extraSmallHeadCenterX = firstMediumCenterX - mediumSize / 2.0f - xSmallSize / 2.0f;
        float largeStartCenterX = start + largeSize / 2.0f;
        KeylineState.Builder builder = new KeylineState.Builder(largeSize, availableSpace).addAnchorKeyline(extraSmallHeadCenterX, extraSmallMask, xSmallSize).addKeyline(firstMediumCenterX, mediumMask, mediumSize, false).addKeylineRange(largeStartCenterX, largeMask, largeSize, largeCount, true);
        float secondMediumCenterX = (start += (float)largeCount * largeSize) + mediumSize / 2.0f;
        builder.addKeyline(secondMediumCenterX, mediumMask, mediumSize, false);
        float xSmallCenterX = (start += mediumSize) + xSmallSize / 2.0f;
        builder.addAnchorKeyline(xSmallCenterX, extraSmallMask, xSmallSize);
        return builder.build();
    }

    private KeylineState createLeftAlignedKeylineState(Context context, float childMargins, float availableSpace, float largeSize, int largeCount, float mediumSize, int mediumCount, float xSmallSize) {
        xSmallSize = Math.min(xSmallSize, largeSize);
        float leftAnchorSize = Math.max(xSmallSize, mediumSize * 0.5f);
        float leftAnchorMask = UncontainedCarouselStrategy.getChildMaskPercentage(leftAnchorSize, largeSize, childMargins);
        float extraSmallMask = UncontainedCarouselStrategy.getChildMaskPercentage(xSmallSize, largeSize, childMargins);
        float mediumMask = UncontainedCarouselStrategy.getChildMaskPercentage(mediumSize, largeSize, childMargins);
        float largeMask = 0.0f;
        float start = 0.0f;
        float leftAnchorCenterX = start - leftAnchorSize / 2.0f;
        float largeStartCenterX = largeSize / 2.0f;
        start += (float)largeCount * largeSize;
        KeylineState.Builder builder = new KeylineState.Builder(largeSize, availableSpace).addAnchorKeyline(leftAnchorCenterX, leftAnchorMask, leftAnchorSize).addKeylineRange(largeStartCenterX, largeMask, largeSize, largeCount, true);
        if (mediumCount > 0) {
            float mediumCenterX = start + mediumSize / 2.0f;
            start += mediumSize;
            builder.addKeyline(mediumCenterX, mediumMask, mediumSize, false);
        }
        float xSmallCenterX = start + CarouselStrategyHelper.getExtraSmallSize(context) / 2.0f;
        builder.addAnchorKeyline(xSmallCenterX, extraSmallMask, xSmallSize);
        return builder.build();
    }

    @Override
    boolean isContained() {
        return false;
    }
}

