/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.R;
import com.google.android.material.color.ColorRoles;
import com.google.android.material.color.utilities.Blend;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.resources.MaterialAttributes;

public class MaterialColors {
    public static final float ALPHA_FULL = 1.0f;
    public static final float ALPHA_MEDIUM = 0.54f;
    public static final float ALPHA_DISABLED = 0.38f;
    public static final float ALPHA_LOW = 0.32f;
    public static final float ALPHA_DISABLED_LOW = 0.12f;
    private static final int TONE_ACCENT_LIGHT = 40;
    private static final int TONE_ON_ACCENT_LIGHT = 100;
    private static final int TONE_ACCENT_CONTAINER_LIGHT = 90;
    private static final int TONE_ON_ACCENT_CONTAINER_LIGHT = 10;
    private static final int TONE_SURFACE_CONTAINER_LIGHT = 94;
    private static final int TONE_SURFACE_CONTAINER_HIGH_LIGHT = 92;
    private static final int TONE_ACCENT_DARK = 80;
    private static final int TONE_ON_ACCENT_DARK = 20;
    private static final int TONE_ACCENT_CONTAINER_DARK = 30;
    private static final int TONE_ON_ACCENT_CONTAINER_DARK = 90;
    private static final int TONE_SURFACE_CONTAINER_DARK = 12;
    private static final int TONE_SURFACE_CONTAINER_HIGH_DARK = 17;
    private static final int CHROMA_NEUTRAL = 6;

    private MaterialColors() {
    }

    @ColorInt
    public static int getColor(@NonNull View view, @AttrRes int colorAttributeResId) {
        return MaterialColors.resolveColor(view.getContext(), MaterialAttributes.resolveTypedValueOrThrow(view, colorAttributeResId));
    }

    @ColorInt
    public static int getColor(Context context, @AttrRes int colorAttributeResId, String errorMessageComponent) {
        return MaterialColors.resolveColor(context, MaterialAttributes.resolveTypedValueOrThrow(context, colorAttributeResId, errorMessageComponent));
    }

    @ColorInt
    public static int getColor(@NonNull View view, @AttrRes int colorAttributeResId, @ColorInt int defaultValue) {
        return MaterialColors.getColor(view.getContext(), colorAttributeResId, defaultValue);
    }

    @ColorInt
    public static int getColor(@NonNull Context context, @AttrRes int colorAttributeResId, @ColorInt int defaultValue) {
        Integer color2 = MaterialColors.getColorOrNull(context, colorAttributeResId);
        return color2 != null ? color2 : defaultValue;
    }

    @Nullable
    @ColorInt
    public static Integer getColorOrNull(@NonNull Context context, @AttrRes int colorAttributeResId) {
        TypedValue typedValue = MaterialAttributes.resolve(context, colorAttributeResId);
        return typedValue != null ? Integer.valueOf(MaterialColors.resolveColor(context, typedValue)) : null;
    }

    @NonNull
    public static ColorStateList getColorStateList(@NonNull Context context, @AttrRes int colorAttributeResId, @NonNull ColorStateList defaultValue) {
        ColorStateList resolvedColor = null;
        TypedValue typedValue = MaterialAttributes.resolve(context, colorAttributeResId);
        if (typedValue != null) {
            resolvedColor = MaterialColors.resolveColorStateList(context, typedValue);
        }
        return resolvedColor == null ? defaultValue : resolvedColor;
    }

    @Nullable
    public static ColorStateList getColorStateListOrNull(@NonNull Context context, @AttrRes int colorAttributeResId) {
        TypedValue typedValue = MaterialAttributes.resolve(context, colorAttributeResId);
        if (typedValue == null) {
            return null;
        }
        if (typedValue.resourceId != 0) {
            return ContextCompat.getColorStateList((Context)context, (int)typedValue.resourceId);
        }
        if (typedValue.data != 0) {
            return ColorStateList.valueOf((int)typedValue.data);
        }
        return null;
    }

    private static int resolveColor(@NonNull Context context, @NonNull TypedValue typedValue) {
        if (typedValue.resourceId != 0) {
            return ContextCompat.getColor((Context)context, (int)typedValue.resourceId);
        }
        return typedValue.data;
    }

    private static ColorStateList resolveColorStateList(@NonNull Context context, @NonNull TypedValue typedValue) {
        if (typedValue.resourceId != 0) {
            return ContextCompat.getColorStateList((Context)context, (int)typedValue.resourceId);
        }
        return ColorStateList.valueOf((int)typedValue.data);
    }

    @ColorInt
    public static int layer(@NonNull View view, @AttrRes int backgroundColorAttributeResId, @AttrRes int overlayColorAttributeResId) {
        return MaterialColors.layer(view, backgroundColorAttributeResId, overlayColorAttributeResId, 1.0f);
    }

    @ColorInt
    public static int layer(@NonNull View view, @AttrRes int backgroundColorAttributeResId, @AttrRes int overlayColorAttributeResId, @FloatRange(from=0.0, to=1.0) float overlayAlpha) {
        int backgroundColor = MaterialColors.getColor(view, backgroundColorAttributeResId);
        int overlayColor = MaterialColors.getColor(view, overlayColorAttributeResId);
        return MaterialColors.layer(backgroundColor, overlayColor, overlayAlpha);
    }

    @ColorInt
    public static int layer(@ColorInt int backgroundColor, @ColorInt int overlayColor, @FloatRange(from=0.0, to=1.0) float overlayAlpha) {
        int computedAlpha = Math.round((float)Color.alpha((int)overlayColor) * overlayAlpha);
        int computedOverlayColor = ColorUtils.setAlphaComponent((int)overlayColor, (int)computedAlpha);
        return MaterialColors.layer(backgroundColor, computedOverlayColor);
    }

    @ColorInt
    public static int layer(@ColorInt int backgroundColor, @ColorInt int overlayColor) {
        return ColorUtils.compositeColors((int)overlayColor, (int)backgroundColor);
    }

    @ColorInt
    public static int compositeARGBWithAlpha(@ColorInt int originalARGB, @IntRange(from=0L, to=255L) int alpha) {
        alpha = Color.alpha((int)originalARGB) * alpha / 255;
        return ColorUtils.setAlphaComponent((int)originalARGB, (int)alpha);
    }

    public static boolean isColorLight(@ColorInt int color2) {
        return color2 != 0 && ColorUtils.calculateLuminance((int)color2) > 0.5;
    }

    @ColorInt
    public static int harmonizeWithPrimary(@NonNull Context context, @ColorInt int colorToHarmonize) {
        return MaterialColors.harmonize(colorToHarmonize, MaterialColors.getColor(context, R.attr.colorPrimary, MaterialColors.class.getCanonicalName()));
    }

    @ColorInt
    public static int harmonize(@ColorInt int colorToHarmonize, @ColorInt int colorToHarmonizeWith) {
        return Blend.harmonize(colorToHarmonize, colorToHarmonizeWith);
    }

    @NonNull
    public static ColorRoles getColorRoles(@NonNull Context context, @ColorInt int color2) {
        return MaterialColors.getColorRoles(color2, MaterialColors.isLightTheme(context));
    }

    @NonNull
    public static ColorRoles getColorRoles(@ColorInt int color2, boolean isLightTheme) {
        return isLightTheme ? new ColorRoles(MaterialColors.getColorRole(color2, 40), MaterialColors.getColorRole(color2, 100), MaterialColors.getColorRole(color2, 90), MaterialColors.getColorRole(color2, 10)) : new ColorRoles(MaterialColors.getColorRole(color2, 80), MaterialColors.getColorRole(color2, 20), MaterialColors.getColorRole(color2, 30), MaterialColors.getColorRole(color2, 90));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ColorInt
    public static int getSurfaceContainerFromSeed(@NonNull Context context, @ColorInt int seedColor) {
        int tone = MaterialColors.isLightTheme(context) ? 94 : 12;
        return MaterialColors.getColorRole(seedColor, tone, 6);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ColorInt
    public static int getSurfaceContainerHighFromSeed(@NonNull Context context, @ColorInt int seedColor) {
        int tone = MaterialColors.isLightTheme(context) ? 92 : 17;
        return MaterialColors.getColorRole(seedColor, tone, 6);
    }

    static boolean isLightTheme(@NonNull Context context) {
        return MaterialAttributes.resolveBoolean(context, R.attr.isLightTheme, true);
    }

    @ColorInt
    private static int getColorRole(@ColorInt int color2, @IntRange(from=0L, to=100L) int tone) {
        Hct hctColor = Hct.fromInt(color2);
        hctColor.setTone(tone);
        return hctColor.toInt();
    }

    @ColorInt
    private static int getColorRole(@ColorInt int color2, @IntRange(from=0L, to=100L) int tone, int chroma) {
        Hct hctColor = Hct.fromInt(MaterialColors.getColorRole(color2, tone));
        hctColor.setChroma(chroma);
        return hctColor.toInt();
    }
}

