/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.content.Context;
import android.content.res.Configuration;
import android.view.ContextThemeWrapper;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.google.android.material.R;
import com.google.android.material.color.ColorResourcesOverride;
import com.google.android.material.color.ResourcesLoaderUtils;
import com.google.android.material.color.ThemeUtils;
import java.util.Map;

@RequiresApi(api=30)
class ResourcesLoaderColorResourcesOverride
implements ColorResourcesOverride {
    private ResourcesLoaderColorResourcesOverride() {
    }

    @Override
    public boolean applyIfPossible(Context context, Map<Integer, Integer> colorResourceIdsToColorValues) {
        if (ResourcesLoaderUtils.addResourcesLoaderToContext(context, colorResourceIdsToColorValues)) {
            ThemeUtils.applyThemeOverlay(context, R.style.ThemeOverlay_Material3_PersonalizedColors);
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public Context wrapContextIfPossible(Context context, Map<Integer, Integer> colorResourceIdsToColorValues) {
        ContextThemeWrapper themeWrapper = new ContextThemeWrapper(context, R.style.ThemeOverlay_Material3_PersonalizedColors);
        themeWrapper.applyOverrideConfiguration(new Configuration());
        return ResourcesLoaderUtils.addResourcesLoaderToContext((Context)themeWrapper, colorResourceIdsToColorValues) ? themeWrapper : context;
    }

    static ColorResourcesOverride getInstance() {
        return ResourcesLoaderColorResourcesOverrideSingleton.INSTANCE;
    }

    private static class ResourcesLoaderColorResourcesOverrideSingleton {
        private static final ResourcesLoaderColorResourcesOverride INSTANCE = new ResourcesLoaderColorResourcesOverride();

        private ResourcesLoaderColorResourcesOverrideSingleton() {
        }
    }
}

