/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Cam16;
import com.google.android.material.color.utilities.ColorUtils;
import com.google.android.material.color.utilities.HctSolver;
import com.google.android.material.color.utilities.ViewingConditions;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Hct {
    private double hue;
    private double chroma;
    private double tone;
    private int argb;

    public static Hct from(double hue, double chroma, double tone) {
        int argb = HctSolver.solveToInt(hue, chroma, tone);
        return new Hct(argb);
    }

    public static Hct fromInt(int argb) {
        return new Hct(argb);
    }

    private Hct(int argb) {
        this.setInternalState(argb);
    }

    public double getHue() {
        return this.hue;
    }

    public double getChroma() {
        return this.chroma;
    }

    public double getTone() {
        return this.tone;
    }

    public int toInt() {
        return this.argb;
    }

    public void setHue(double newHue) {
        this.setInternalState(HctSolver.solveToInt(newHue, this.chroma, this.tone));
    }

    public void setChroma(double newChroma) {
        this.setInternalState(HctSolver.solveToInt(this.hue, newChroma, this.tone));
    }

    public void setTone(double newTone) {
        this.setInternalState(HctSolver.solveToInt(this.hue, this.chroma, newTone));
    }

    public Hct inViewingConditions(ViewingConditions vc) {
        Cam16 cam16 = Cam16.fromInt(this.toInt());
        double[] viewedInVc = cam16.xyzInViewingConditions(vc, null);
        Cam16 recastInVc = Cam16.fromXyzInViewingConditions(viewedInVc[0], viewedInVc[1], viewedInVc[2], ViewingConditions.DEFAULT);
        return Hct.from(recastInVc.getHue(), recastInVc.getChroma(), ColorUtils.lstarFromY(viewedInVc[1]));
    }

    private void setInternalState(int argb) {
        this.argb = argb;
        Cam16 cam = Cam16.fromInt(argb);
        this.hue = cam.getHue();
        this.chroma = cam.getChroma();
        this.tone = ColorUtils.lstarFromArgb(argb);
    }
}

