/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.PointProviderLab;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class QuantizerWsmeans {
    private static final int MAX_ITERATIONS = 10;
    private static final double MIN_MOVEMENT_DISTANCE = 3.0;

    private QuantizerWsmeans() {
    }

    public static Map<Integer, Integer> quantize(int[] inputPixels, int[] startingClusters, int maxColors) {
        int i;
        Random random = new Random(272008L);
        LinkedHashMap<Integer, Integer> pixelToCount = new LinkedHashMap<Integer, Integer>();
        double[][] points = new double[inputPixels.length][];
        int[] pixels = new int[inputPixels.length];
        PointProviderLab pointProvider = new PointProviderLab();
        int pointCount = 0;
        for (int i2 = 0; i2 < inputPixels.length; ++i2) {
            int inputPixel = inputPixels[i2];
            Integer pixelCount = (Integer)pixelToCount.get(inputPixel);
            if (pixelCount == null) {
                points[pointCount] = pointProvider.fromInt(inputPixel);
                pixels[pointCount] = inputPixel;
                ++pointCount;
                pixelToCount.put(inputPixel, 1);
                continue;
            }
            pixelToCount.put(inputPixel, pixelCount + 1);
        }
        int[] counts = new int[pointCount];
        for (int i3 = 0; i3 < pointCount; ++i3) {
            int count;
            int pixel = pixels[i3];
            counts[i3] = count = ((Integer)pixelToCount.get(pixel)).intValue();
        }
        int clusterCount = Math.min(maxColors, pointCount);
        if (startingClusters.length != 0) {
            clusterCount = Math.min(clusterCount, startingClusters.length);
        }
        double[][] clusters = new double[clusterCount][];
        int clustersCreated = 0;
        for (int i4 = 0; i4 < startingClusters.length; ++i4) {
            clusters[i4] = pointProvider.fromInt(startingClusters[i4]);
            ++clustersCreated;
        }
        int additionalClustersNeeded = clusterCount - clustersCreated;
        if (additionalClustersNeeded > 0) {
            for (int i5 = 0; i5 < additionalClustersNeeded; ++i5) {
            }
        }
        int[] clusterIndices = new int[pointCount];
        for (int i6 = 0; i6 < pointCount; ++i6) {
            clusterIndices[i6] = random.nextInt(clusterCount);
        }
        int[][] indexMatrix = new int[clusterCount][];
        for (int i7 = 0; i7 < clusterCount; ++i7) {
            indexMatrix[i7] = new int[clusterCount];
        }
        Distance[][] distanceToIndexMatrix = new Distance[clusterCount][];
        for (int i8 = 0; i8 < clusterCount; ++i8) {
            distanceToIndexMatrix[i8] = new Distance[clusterCount];
            for (int j = 0; j < clusterCount; ++j) {
                distanceToIndexMatrix[i8][j] = new Distance();
            }
        }
        int[] pixelCountSums = new int[clusterCount];
        for (int iteration = 0; iteration < 10; ++iteration) {
            int i9;
            for (i = 0; i < clusterCount; ++i) {
                int j;
                for (j = i + 1; j < clusterCount; ++j) {
                    double distance;
                    distanceToIndexMatrix[j][i].distance = distance = pointProvider.distance(clusters[i], clusters[j]);
                    distanceToIndexMatrix[j][i].index = i;
                    distanceToIndexMatrix[i][j].distance = distance;
                    distanceToIndexMatrix[i][j].index = j;
                }
                Arrays.sort(distanceToIndexMatrix[i]);
                for (j = 0; j < clusterCount; ++j) {
                    indexMatrix[i][j] = distanceToIndexMatrix[i][j].index;
                }
            }
            int pointsMoved = 0;
            for (int i10 = 0; i10 < pointCount; ++i10) {
                double distanceChange;
                double previousDistance;
                double[] point = points[i10];
                int previousClusterIndex = clusterIndices[i10];
                double[] previousCluster = clusters[previousClusterIndex];
                double minimumDistance = previousDistance = pointProvider.distance(point, previousCluster);
                int newClusterIndex = -1;
                for (int j = 0; j < clusterCount; ++j) {
                    double distance;
                    if (distanceToIndexMatrix[previousClusterIndex][j].distance >= 4.0 * previousDistance || !((distance = pointProvider.distance(point, clusters[j])) < minimumDistance)) continue;
                    minimumDistance = distance;
                    newClusterIndex = j;
                }
                if (newClusterIndex == -1 || !((distanceChange = Math.abs(Math.sqrt(minimumDistance) - Math.sqrt(previousDistance))) > 3.0)) continue;
                ++pointsMoved;
                clusterIndices[i10] = newClusterIndex;
            }
            if (pointsMoved == 0 && iteration != 0) break;
            double[] componentASums = new double[clusterCount];
            double[] componentBSums = new double[clusterCount];
            double[] componentCSums = new double[clusterCount];
            Arrays.fill(pixelCountSums, 0);
            for (i9 = 0; i9 < pointCount; ++i9) {
                int clusterIndex = clusterIndices[i9];
                double[] point = points[i9];
                int count = counts[i9];
                int n = clusterIndex;
                pixelCountSums[n] = pixelCountSums[n] + count;
                int n2 = clusterIndex;
                componentASums[n2] = componentASums[n2] + point[0] * (double)count;
                int n3 = clusterIndex;
                componentBSums[n3] = componentBSums[n3] + point[1] * (double)count;
                int n4 = clusterIndex;
                componentCSums[n4] = componentCSums[n4] + point[2] * (double)count;
            }
            for (i9 = 0; i9 < clusterCount; ++i9) {
                int count = pixelCountSums[i9];
                if (count == 0) {
                    clusters[i9] = new double[]{0.0, 0.0, 0.0};
                    continue;
                }
                double a = componentASums[i9] / (double)count;
                double b = componentBSums[i9] / (double)count;
                double c = componentCSums[i9] / (double)count;
                clusters[i9][0] = a;
                clusters[i9][1] = b;
                clusters[i9][2] = c;
            }
        }
        LinkedHashMap<Integer, Integer> argbToPopulation = new LinkedHashMap<Integer, Integer>();
        for (i = 0; i < clusterCount; ++i) {
            int possibleNewCluster;
            int count = pixelCountSums[i];
            if (count == 0 || argbToPopulation.containsKey(possibleNewCluster = pointProvider.toInt(clusters[i]))) continue;
            argbToPopulation.put(possibleNewCluster, count);
        }
        return argbToPopulation;
    }

    private static final class Distance
    implements Comparable<Distance> {
        int index = -1;
        double distance = -1.0;

        Distance() {
        }

        @Override
        public int compareTo(Distance other) {
            return Double.valueOf(this.distance).compareTo(other.distance);
        }
    }
}

