/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.util.Pair;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentTransaction;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DayViewDecorator;
import com.google.android.material.datepicker.MaterialCalendar;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.datepicker.MaterialTextInputPicker;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.PickerFragment;
import com.google.android.material.datepicker.RangeDateSelector;
import com.google.android.material.datepicker.SingleDateSelector;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.dialog.InsetDialogOnTouchListener;
import com.google.android.material.internal.CheckableImageButton;
import com.google.android.material.internal.EdgeToEdgeUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.SimpleDateFormat;
import java.util.LinkedHashSet;

public final class MaterialDatePicker<S>
extends DialogFragment {
    private static final String OVERRIDE_THEME_RES_ID = "OVERRIDE_THEME_RES_ID";
    private static final String DATE_SELECTOR_KEY = "DATE_SELECTOR_KEY";
    private static final String CALENDAR_CONSTRAINTS_KEY = "CALENDAR_CONSTRAINTS_KEY";
    private static final String DAY_VIEW_DECORATOR_KEY = "DAY_VIEW_DECORATOR_KEY";
    private static final String TITLE_TEXT_RES_ID_KEY = "TITLE_TEXT_RES_ID_KEY";
    private static final String TITLE_TEXT_KEY = "TITLE_TEXT_KEY";
    private static final String POSITIVE_BUTTON_TEXT_RES_ID_KEY = "POSITIVE_BUTTON_TEXT_RES_ID_KEY";
    private static final String POSITIVE_BUTTON_TEXT_KEY = "POSITIVE_BUTTON_TEXT_KEY";
    private static final String POSITIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY = "POSITIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY";
    private static final String POSITIVE_BUTTON_CONTENT_DESCRIPTION_KEY = "POSITIVE_BUTTON_CONTENT_DESCRIPTION_KEY";
    private static final String NEGATIVE_BUTTON_TEXT_RES_ID_KEY = "NEGATIVE_BUTTON_TEXT_RES_ID_KEY";
    private static final String NEGATIVE_BUTTON_TEXT_KEY = "NEGATIVE_BUTTON_TEXT_KEY";
    private static final String NEGATIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY = "NEGATIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY";
    private static final String NEGATIVE_BUTTON_CONTENT_DESCRIPTION_KEY = "NEGATIVE_BUTTON_CONTENT_DESCRIPTION_KEY";
    private static final String INPUT_MODE_KEY = "INPUT_MODE_KEY";
    static final Object CONFIRM_BUTTON_TAG = "CONFIRM_BUTTON_TAG";
    static final Object CANCEL_BUTTON_TAG = "CANCEL_BUTTON_TAG";
    static final Object TOGGLE_BUTTON_TAG = "TOGGLE_BUTTON_TAG";
    public static final int INPUT_MODE_CALENDAR = 0;
    public static final int INPUT_MODE_TEXT = 1;
    private final LinkedHashSet<MaterialPickerOnPositiveButtonClickListener<? super S>> onPositiveButtonClickListeners = new LinkedHashSet();
    private final LinkedHashSet<View.OnClickListener> onNegativeButtonClickListeners = new LinkedHashSet();
    private final LinkedHashSet<DialogInterface.OnCancelListener> onCancelListeners = new LinkedHashSet();
    private final LinkedHashSet<DialogInterface.OnDismissListener> onDismissListeners = new LinkedHashSet();
    @StyleRes
    private int overrideThemeResId;
    @Nullable
    private DateSelector<S> dateSelector;
    private PickerFragment<S> pickerFragment;
    @Nullable
    private CalendarConstraints calendarConstraints;
    @Nullable
    private DayViewDecorator dayViewDecorator;
    private MaterialCalendar<S> calendar;
    @StringRes
    private int titleTextResId;
    private CharSequence titleText;
    private boolean fullscreen;
    private int inputMode;
    @StringRes
    private int positiveButtonTextResId;
    private CharSequence positiveButtonText;
    @StringRes
    private int positiveButtonContentDescriptionResId;
    private CharSequence positiveButtonContentDescription;
    @StringRes
    private int negativeButtonTextResId;
    private CharSequence negativeButtonText;
    @StringRes
    private int negativeButtonContentDescriptionResId;
    private CharSequence negativeButtonContentDescription;
    private TextView headerTitleTextView;
    private TextView headerSelectionText;
    private CheckableImageButton headerToggleButton;
    @Nullable
    private MaterialShapeDrawable background;
    private Button confirmButton;
    private boolean edgeToEdgeEnabled;
    @Nullable
    private CharSequence fullTitleText;
    @Nullable
    private CharSequence singleLineTitleText;

    public static long todayInUtcMilliseconds() {
        return UtcDates.getTodayCalendar().getTimeInMillis();
    }

    public static long thisMonthInUtcMilliseconds() {
        return Month.current().timeInMillis;
    }

    public String getHeaderText() {
        return this.getDateSelector().getSelectionDisplayString(this.getContext());
    }

    @NonNull
    static <S> MaterialDatePicker<S> newInstance(@NonNull Builder<S> options) {
        MaterialDatePicker<S> materialDatePickerDialogFragment = new MaterialDatePicker<S>();
        Bundle args = new Bundle();
        args.putInt(OVERRIDE_THEME_RES_ID, options.overrideThemeResId);
        args.putParcelable(DATE_SELECTOR_KEY, options.dateSelector);
        args.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)options.calendarConstraints);
        args.putParcelable(DAY_VIEW_DECORATOR_KEY, (Parcelable)options.dayViewDecorator);
        args.putInt(TITLE_TEXT_RES_ID_KEY, options.titleTextResId);
        args.putCharSequence(TITLE_TEXT_KEY, options.titleText);
        args.putInt(INPUT_MODE_KEY, options.inputMode);
        args.putInt(POSITIVE_BUTTON_TEXT_RES_ID_KEY, options.positiveButtonTextResId);
        args.putCharSequence(POSITIVE_BUTTON_TEXT_KEY, options.positiveButtonText);
        args.putInt(POSITIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY, options.positiveButtonContentDescriptionResId);
        args.putCharSequence(POSITIVE_BUTTON_CONTENT_DESCRIPTION_KEY, options.positiveButtonContentDescription);
        args.putInt(NEGATIVE_BUTTON_TEXT_RES_ID_KEY, options.negativeButtonTextResId);
        args.putCharSequence(NEGATIVE_BUTTON_TEXT_KEY, options.negativeButtonText);
        args.putInt(NEGATIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY, options.negativeButtonContentDescriptionResId);
        args.putCharSequence(NEGATIVE_BUTTON_CONTENT_DESCRIPTION_KEY, options.negativeButtonContentDescription);
        materialDatePickerDialogFragment.setArguments(args);
        return materialDatePickerDialogFragment;
    }

    public final void onSaveInstanceState(@NonNull Bundle bundle) {
        Month currentMonth;
        super.onSaveInstanceState(bundle);
        bundle.putInt(OVERRIDE_THEME_RES_ID, this.overrideThemeResId);
        bundle.putParcelable(DATE_SELECTOR_KEY, this.dateSelector);
        CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder(this.calendarConstraints);
        Month month = currentMonth = this.calendar == null ? null : this.calendar.getCurrentMonth();
        if (currentMonth != null) {
            constraintsBuilder.setOpenAt(currentMonth.timeInMillis);
        }
        bundle.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)constraintsBuilder.build());
        bundle.putParcelable(DAY_VIEW_DECORATOR_KEY, (Parcelable)this.dayViewDecorator);
        bundle.putInt(TITLE_TEXT_RES_ID_KEY, this.titleTextResId);
        bundle.putCharSequence(TITLE_TEXT_KEY, this.titleText);
        bundle.putInt(INPUT_MODE_KEY, this.inputMode);
        bundle.putInt(POSITIVE_BUTTON_TEXT_RES_ID_KEY, this.positiveButtonTextResId);
        bundle.putCharSequence(POSITIVE_BUTTON_TEXT_KEY, this.positiveButtonText);
        bundle.putInt(POSITIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY, this.positiveButtonContentDescriptionResId);
        bundle.putCharSequence(POSITIVE_BUTTON_CONTENT_DESCRIPTION_KEY, this.positiveButtonContentDescription);
        bundle.putInt(NEGATIVE_BUTTON_TEXT_RES_ID_KEY, this.negativeButtonTextResId);
        bundle.putCharSequence(NEGATIVE_BUTTON_TEXT_KEY, this.negativeButtonText);
        bundle.putInt(NEGATIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY, this.negativeButtonContentDescriptionResId);
        bundle.putCharSequence(NEGATIVE_BUTTON_CONTENT_DESCRIPTION_KEY, this.negativeButtonContentDescription);
    }

    public final void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Bundle activeBundle = bundle == null ? this.getArguments() : bundle;
        this.overrideThemeResId = activeBundle.getInt(OVERRIDE_THEME_RES_ID);
        this.dateSelector = (DateSelector)activeBundle.getParcelable(DATE_SELECTOR_KEY);
        this.calendarConstraints = (CalendarConstraints)activeBundle.getParcelable(CALENDAR_CONSTRAINTS_KEY);
        this.dayViewDecorator = (DayViewDecorator)activeBundle.getParcelable(DAY_VIEW_DECORATOR_KEY);
        this.titleTextResId = activeBundle.getInt(TITLE_TEXT_RES_ID_KEY);
        this.titleText = activeBundle.getCharSequence(TITLE_TEXT_KEY);
        this.inputMode = activeBundle.getInt(INPUT_MODE_KEY);
        this.positiveButtonTextResId = activeBundle.getInt(POSITIVE_BUTTON_TEXT_RES_ID_KEY);
        this.positiveButtonText = activeBundle.getCharSequence(POSITIVE_BUTTON_TEXT_KEY);
        this.positiveButtonContentDescriptionResId = activeBundle.getInt(POSITIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY);
        this.positiveButtonContentDescription = activeBundle.getCharSequence(POSITIVE_BUTTON_CONTENT_DESCRIPTION_KEY);
        this.negativeButtonTextResId = activeBundle.getInt(NEGATIVE_BUTTON_TEXT_RES_ID_KEY);
        this.negativeButtonText = activeBundle.getCharSequence(NEGATIVE_BUTTON_TEXT_KEY);
        this.negativeButtonContentDescriptionResId = activeBundle.getInt(NEGATIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY);
        this.negativeButtonContentDescription = activeBundle.getCharSequence(NEGATIVE_BUTTON_CONTENT_DESCRIPTION_KEY);
        this.fullTitleText = this.titleText != null ? this.titleText : this.requireContext().getResources().getText(this.titleTextResId);
        this.singleLineTitleText = MaterialDatePicker.getFirstLineBySeparator(this.fullTitleText);
    }

    private int getThemeResId(Context context) {
        if (this.overrideThemeResId != 0) {
            return this.overrideThemeResId;
        }
        return this.getDateSelector().getDefaultThemeResId(context);
    }

    @NonNull
    public final Dialog onCreateDialog(@Nullable Bundle bundle) {
        Dialog dialog = new Dialog(this.requireContext(), this.getThemeResId(this.requireContext()));
        Context context = dialog.getContext();
        this.fullscreen = MaterialDatePicker.isFullscreen(context);
        this.background = new MaterialShapeDrawable(context, null, R.attr.materialCalendarStyle, R.style.Widget_MaterialComponents_MaterialCalendar);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.MaterialCalendar, R.attr.materialCalendarStyle, R.style.Widget_MaterialComponents_MaterialCalendar);
        int backgroundColor = a.getColor(R.styleable.MaterialCalendar_backgroundTint, 0);
        a.recycle();
        this.background.initializeElevationOverlay(context);
        this.background.setFillColor(ColorStateList.valueOf((int)backgroundColor));
        this.background.setElevation(ViewCompat.getElevation((View)dialog.getWindow().getDecorView()));
        return dialog;
    }

    @NonNull
    public final View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        int layout2 = this.fullscreen ? R.layout.mtrl_picker_fullscreen : R.layout.mtrl_picker_dialog;
        View root = layoutInflater.inflate(layout2, viewGroup);
        Context context = root.getContext();
        if (this.dayViewDecorator != null) {
            this.dayViewDecorator.initialize(context);
        }
        if (this.fullscreen) {
            View frame = root.findViewById(R.id.mtrl_calendar_frame);
            frame.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(MaterialDatePicker.getPaddedPickerWidth(context), -2));
        } else {
            View pane = root.findViewById(R.id.mtrl_calendar_main_pane);
            pane.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(MaterialDatePicker.getPaddedPickerWidth(context), -1));
        }
        this.headerSelectionText = (TextView)root.findViewById(R.id.mtrl_picker_header_selection_text);
        ViewCompat.setAccessibilityLiveRegion((View)this.headerSelectionText, (int)1);
        this.headerToggleButton = (CheckableImageButton)root.findViewById(R.id.mtrl_picker_header_toggle);
        this.headerTitleTextView = (TextView)root.findViewById(R.id.mtrl_picker_title_text);
        this.initHeaderToggle(context);
        this.confirmButton = (Button)root.findViewById(R.id.confirm_button);
        if (this.getDateSelector().isSelectionComplete()) {
            this.confirmButton.setEnabled(true);
        } else {
            this.confirmButton.setEnabled(false);
        }
        this.confirmButton.setTag(CONFIRM_BUTTON_TAG);
        if (this.positiveButtonText != null) {
            this.confirmButton.setText(this.positiveButtonText);
        } else if (this.positiveButtonTextResId != 0) {
            this.confirmButton.setText(this.positiveButtonTextResId);
        }
        if (this.positiveButtonContentDescription != null) {
            this.confirmButton.setContentDescription(this.positiveButtonContentDescription);
        } else if (this.positiveButtonContentDescriptionResId != 0) {
            this.confirmButton.setContentDescription(this.getContext().getResources().getText(this.positiveButtonContentDescriptionResId));
        }
        this.confirmButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                for (MaterialPickerOnPositiveButtonClickListener listener : MaterialDatePicker.this.onPositiveButtonClickListeners) {
                    listener.onPositiveButtonClick(MaterialDatePicker.this.getSelection());
                }
                MaterialDatePicker.this.dismiss();
            }
        });
        Button cancelButton = (Button)root.findViewById(R.id.cancel_button);
        cancelButton.setTag(CANCEL_BUTTON_TAG);
        if (this.negativeButtonText != null) {
            cancelButton.setText(this.negativeButtonText);
        } else if (this.negativeButtonTextResId != 0) {
            cancelButton.setText(this.negativeButtonTextResId);
        }
        if (this.negativeButtonContentDescription != null) {
            cancelButton.setContentDescription(this.negativeButtonContentDescription);
        } else if (this.negativeButtonContentDescriptionResId != 0) {
            cancelButton.setContentDescription(this.getContext().getResources().getText(this.negativeButtonContentDescriptionResId));
        }
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                for (View.OnClickListener listener : MaterialDatePicker.this.onNegativeButtonClickListeners) {
                    listener.onClick(v);
                }
                MaterialDatePicker.this.dismiss();
            }
        });
        return root;
    }

    public void onStart() {
        super.onStart();
        Window window = this.requireDialog().getWindow();
        if (this.fullscreen) {
            window.setLayout(-1, -1);
            window.setBackgroundDrawable((Drawable)this.background);
            this.enableEdgeToEdgeIfNeeded(window);
        } else {
            window.setLayout(-2, -2);
            int inset = this.getResources().getDimensionPixelOffset(R.dimen.mtrl_calendar_dialog_background_inset);
            Rect insets = new Rect(inset, inset, inset, inset);
            window.setBackgroundDrawable((Drawable)new InsetDrawable((Drawable)this.background, inset, inset, inset, inset));
            window.getDecorView().setOnTouchListener((View.OnTouchListener)new InsetDialogOnTouchListener(this.requireDialog(), insets));
        }
        this.startPickerFragment();
    }

    public void onStop() {
        this.pickerFragment.clearOnSelectionChangedListeners();
        super.onStop();
    }

    public final void onCancel(@NonNull DialogInterface dialogInterface) {
        for (DialogInterface.OnCancelListener listener : this.onCancelListeners) {
            listener.onCancel(dialogInterface);
        }
        super.onCancel(dialogInterface);
    }

    public final void onDismiss(@NonNull DialogInterface dialogInterface) {
        for (DialogInterface.OnDismissListener listener : this.onDismissListeners) {
            listener.onDismiss(dialogInterface);
        }
        ViewGroup viewGroup = (ViewGroup)this.getView();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        super.onDismiss(dialogInterface);
    }

    @Nullable
    public final S getSelection() {
        return this.getDateSelector().getSelection();
    }

    public int getInputMode() {
        return this.inputMode;
    }

    private void enableEdgeToEdgeIfNeeded(Window window) {
        if (this.edgeToEdgeEnabled) {
            return;
        }
        final View headerLayout = this.requireView().findViewById(R.id.fullscreen_header);
        EdgeToEdgeUtils.applyEdgeToEdge(window, true, ViewUtils.getBackgroundColor(headerLayout), null);
        final int originalPaddingTop = headerLayout.getPaddingTop();
        final int originalHeaderHeight = headerLayout.getLayoutParams().height;
        ViewCompat.setOnApplyWindowInsetsListener((View)headerLayout, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                int topInset = insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).top;
                if (originalHeaderHeight >= 0) {
                    headerLayout.getLayoutParams().height = originalHeaderHeight + topInset;
                    headerLayout.setLayoutParams(headerLayout.getLayoutParams());
                }
                headerLayout.setPadding(headerLayout.getPaddingLeft(), originalPaddingTop + topInset, headerLayout.getPaddingRight(), headerLayout.getPaddingBottom());
                return insets;
            }
        });
        this.edgeToEdgeEnabled = true;
    }

    private void updateTitle() {
        this.headerTitleTextView.setText(this.inputMode == 1 && this.isLandscape() ? this.singleLineTitleText : this.fullTitleText);
    }

    @VisibleForTesting
    void updateHeader(String headerText) {
        this.headerSelectionText.setContentDescription((CharSequence)this.getHeaderContentDescription());
        this.headerSelectionText.setText((CharSequence)headerText);
    }

    private String getHeaderContentDescription() {
        return this.getDateSelector().getSelectionContentDescription(this.requireContext());
    }

    private void startPickerFragment() {
        int themeResId = this.getThemeResId(this.requireContext());
        this.calendar = MaterialCalendar.newInstance(this.getDateSelector(), themeResId, this.calendarConstraints, this.dayViewDecorator);
        this.pickerFragment = this.inputMode == 1 ? MaterialTextInputPicker.newInstance(this.getDateSelector(), themeResId, this.calendarConstraints) : this.calendar;
        this.updateTitle();
        this.updateHeader(this.getHeaderText());
        FragmentTransaction fragmentTransaction = this.getChildFragmentManager().beginTransaction();
        fragmentTransaction.replace(R.id.mtrl_calendar_frame, this.pickerFragment);
        fragmentTransaction.commitNow();
        this.pickerFragment.addOnSelectionChangedListener(new OnSelectionChangedListener<S>(){

            @Override
            public void onSelectionChanged(S selection) {
                MaterialDatePicker.this.updateHeader(MaterialDatePicker.this.getHeaderText());
                MaterialDatePicker.this.confirmButton.setEnabled(MaterialDatePicker.this.getDateSelector().isSelectionComplete());
            }

            @Override
            public void onIncompleteSelectionChanged() {
                MaterialDatePicker.this.confirmButton.setEnabled(false);
            }
        });
    }

    private void initHeaderToggle(Context context) {
        this.headerToggleButton.setTag(TOGGLE_BUTTON_TAG);
        this.headerToggleButton.setImageDrawable(MaterialDatePicker.createHeaderToggleDrawable(context));
        this.headerToggleButton.setChecked(this.inputMode != 0);
        ViewCompat.setAccessibilityDelegate((View)this.headerToggleButton, null);
        this.updateToggleContentDescription(this.headerToggleButton);
        this.headerToggleButton.setOnClickListener(v -> {
            this.confirmButton.setEnabled(this.getDateSelector().isSelectionComplete());
            this.headerToggleButton.toggle();
            this.inputMode = this.inputMode == 1 ? 0 : 1;
            this.updateToggleContentDescription(this.headerToggleButton);
            this.startPickerFragment();
        });
    }

    private void updateToggleContentDescription(@NonNull CheckableImageButton toggle) {
        String contentDescription = this.inputMode == 1 ? toggle.getContext().getString(R.string.mtrl_picker_toggle_to_calendar_input_mode) : toggle.getContext().getString(R.string.mtrl_picker_toggle_to_text_input_mode);
        this.headerToggleButton.setContentDescription(contentDescription);
    }

    private DateSelector<S> getDateSelector() {
        if (this.dateSelector == null) {
            this.dateSelector = (DateSelector)this.getArguments().getParcelable(DATE_SELECTOR_KEY);
        }
        return this.dateSelector;
    }

    @NonNull
    private static Drawable createHeaderToggleDrawable(Context context) {
        StateListDrawable toggleDrawable = new StateListDrawable();
        toggleDrawable.addState(new int[]{0x10100A0}, AppCompatResources.getDrawable((Context)context, (int)R.drawable.material_ic_calendar_black_24dp));
        toggleDrawable.addState(new int[0], AppCompatResources.getDrawable((Context)context, (int)R.drawable.material_ic_edit_black_24dp));
        return toggleDrawable;
    }

    @Nullable
    private static CharSequence getFirstLineBySeparator(@Nullable CharSequence charSequence) {
        if (charSequence != null) {
            String[] lines = TextUtils.split((String)String.valueOf(charSequence), (String)"\n");
            return lines.length > 1 ? lines[0] : charSequence;
        }
        return null;
    }

    private boolean isLandscape() {
        return this.getResources().getConfiguration().orientation == 2;
    }

    static boolean isFullscreen(@NonNull Context context) {
        return MaterialDatePicker.readMaterialCalendarStyleBoolean(context, 16843277);
    }

    static boolean isNestedScrollable(@NonNull Context context) {
        return MaterialDatePicker.readMaterialCalendarStyleBoolean(context, R.attr.nestedScrollable);
    }

    static boolean readMaterialCalendarStyleBoolean(@NonNull Context context, int attributeResId) {
        int calendarStyle = MaterialAttributes.resolveOrThrow(context, R.attr.materialCalendarStyle, MaterialCalendar.class.getCanonicalName());
        int[] attrs = new int[]{attributeResId};
        TypedArray a = context.obtainStyledAttributes(calendarStyle, attrs);
        boolean attributeValue = a.getBoolean(0, false);
        a.recycle();
        return attributeValue;
    }

    private static int getPaddedPickerWidth(@NonNull Context context) {
        Resources resources = context.getResources();
        int padding = resources.getDimensionPixelOffset(R.dimen.mtrl_calendar_content_padding);
        int daysInWeek = Month.current().daysInWeek;
        int dayWidth = resources.getDimensionPixelSize(R.dimen.mtrl_calendar_day_width);
        int horizontalSpace = resources.getDimensionPixelOffset(R.dimen.mtrl_calendar_month_horizontal_padding);
        return 2 * padding + daysInWeek * dayWidth + (daysInWeek - 1) * horizontalSpace;
    }

    public boolean addOnPositiveButtonClickListener(MaterialPickerOnPositiveButtonClickListener<? super S> onPositiveButtonClickListener) {
        return this.onPositiveButtonClickListeners.add(onPositiveButtonClickListener);
    }

    public boolean removeOnPositiveButtonClickListener(MaterialPickerOnPositiveButtonClickListener<? super S> onPositiveButtonClickListener) {
        return this.onPositiveButtonClickListeners.remove(onPositiveButtonClickListener);
    }

    public void clearOnPositiveButtonClickListeners() {
        this.onPositiveButtonClickListeners.clear();
    }

    public boolean addOnNegativeButtonClickListener(View.OnClickListener onNegativeButtonClickListener) {
        return this.onNegativeButtonClickListeners.add(onNegativeButtonClickListener);
    }

    public boolean removeOnNegativeButtonClickListener(View.OnClickListener onNegativeButtonClickListener) {
        return this.onNegativeButtonClickListeners.remove(onNegativeButtonClickListener);
    }

    public void clearOnNegativeButtonClickListeners() {
        this.onNegativeButtonClickListeners.clear();
    }

    public boolean addOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        return this.onCancelListeners.add(onCancelListener);
    }

    public boolean removeOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        return this.onCancelListeners.remove(onCancelListener);
    }

    public void clearOnCancelListeners() {
        this.onCancelListeners.clear();
    }

    public boolean addOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        return this.onDismissListeners.add(onDismissListener);
    }

    public boolean removeOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        return this.onDismissListeners.remove(onDismissListener);
    }

    public void clearOnDismissListeners() {
        this.onDismissListeners.clear();
    }

    public static final class Builder<S> {
        final DateSelector<S> dateSelector;
        int overrideThemeResId = 0;
        CalendarConstraints calendarConstraints;
        @Nullable
        DayViewDecorator dayViewDecorator;
        int titleTextResId = 0;
        CharSequence titleText = null;
        int positiveButtonTextResId = 0;
        CharSequence positiveButtonText = null;
        int positiveButtonContentDescriptionResId = 0;
        CharSequence positiveButtonContentDescription = null;
        int negativeButtonTextResId = 0;
        CharSequence negativeButtonText = null;
        int negativeButtonContentDescriptionResId = 0;
        CharSequence negativeButtonContentDescription = null;
        @Nullable
        S selection = null;
        int inputMode = 0;

        private Builder(DateSelector<S> dateSelector) {
            this.dateSelector = dateSelector;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static <S> Builder<S> customDatePicker(@NonNull DateSelector<S> dateSelector) {
            return new Builder<S>(dateSelector);
        }

        @NonNull
        public static Builder<Long> datePicker() {
            return new Builder<Long>(new SingleDateSelector());
        }

        @NonNull
        public static Builder<Pair<Long, Long>> dateRangePicker() {
            return new Builder<Pair<Long, Long>>(new RangeDateSelector());
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setTextInputFormat(@Nullable SimpleDateFormat format) {
            this.dateSelector.setTextInputFormat(format);
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setSelection(S selection) {
            this.selection = selection;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setTheme(@StyleRes int themeResId) {
            this.overrideThemeResId = themeResId;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setCalendarConstraints(CalendarConstraints bounds) {
            this.calendarConstraints = bounds;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setDayViewDecorator(@Nullable DayViewDecorator dayViewDecorator) {
            this.dayViewDecorator = dayViewDecorator;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setTitleText(@StringRes int titleTextResId) {
            this.titleTextResId = titleTextResId;
            this.titleText = null;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setTitleText(@Nullable CharSequence charSequence) {
            this.titleText = charSequence;
            this.titleTextResId = 0;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setPositiveButtonText(@StringRes int textId) {
            this.positiveButtonTextResId = textId;
            this.positiveButtonText = null;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setPositiveButtonText(@Nullable CharSequence text) {
            this.positiveButtonText = text;
            this.positiveButtonTextResId = 0;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setPositiveButtonContentDescription(@StringRes int contentDescriptionId) {
            this.positiveButtonContentDescriptionResId = contentDescriptionId;
            this.positiveButtonContentDescription = null;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setPositiveButtonContentDescription(@Nullable CharSequence contentDescription) {
            this.positiveButtonContentDescription = contentDescription;
            this.positiveButtonContentDescriptionResId = 0;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setNegativeButtonText(@StringRes int textId) {
            this.negativeButtonTextResId = textId;
            this.negativeButtonText = null;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setNegativeButtonText(@Nullable CharSequence text) {
            this.negativeButtonText = text;
            this.negativeButtonTextResId = 0;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setNegativeButtonContentDescription(@StringRes int contentDescriptionId) {
            this.negativeButtonContentDescriptionResId = contentDescriptionId;
            this.negativeButtonContentDescription = null;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setNegativeButtonContentDescription(@Nullable CharSequence contentDescription) {
            this.negativeButtonContentDescription = contentDescription;
            this.negativeButtonContentDescriptionResId = 0;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder<S> setInputMode(int inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        @NonNull
        public MaterialDatePicker<S> build() {
            if (this.calendarConstraints == null) {
                this.calendarConstraints = new CalendarConstraints.Builder().build();
            }
            if (this.titleTextResId == 0) {
                this.titleTextResId = this.dateSelector.getDefaultTitleResId();
            }
            if (this.selection != null) {
                this.dateSelector.setSelection(this.selection);
            }
            if (this.calendarConstraints.getOpenAt() == null) {
                this.calendarConstraints.setOpenAt(this.createDefaultOpenAt());
            }
            return MaterialDatePicker.newInstance(this);
        }

        private Month createDefaultOpenAt() {
            Month firstSelectedMonth;
            if (!this.dateSelector.getSelectedDays().isEmpty() && Builder.monthInValidRange(firstSelectedMonth = Month.create(this.dateSelector.getSelectedDays().iterator().next()), this.calendarConstraints)) {
                return firstSelectedMonth;
            }
            Month thisMonth = Month.current();
            return Builder.monthInValidRange(thisMonth, this.calendarConstraints) ? thisMonth : this.calendarConstraints.getStart();
        }

        private static boolean monthInValidRange(Month month, CalendarConstraints constraints) {
            return month.compareTo(constraints.getStart()) >= 0 && month.compareTo(constraints.getEnd()) <= 0;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface InputMode {
    }
}

