/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.FloatEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.res.ColorStateList;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.Property;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.animation.ImageMatrixProperty;
import com.google.android.material.animation.MatrixEvaluator;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.floatingactionbutton.BorderDrawable;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.internal.StateListAnimator;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.ripple.RippleDrawableCompat;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shadow.ShadowViewDelegate;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import java.util.ArrayList;

class FloatingActionButtonImpl {
    static final TimeInterpolator ELEVATION_ANIM_INTERPOLATOR = AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR;
    static final long ELEVATION_ANIM_DURATION = 100L;
    static final long ELEVATION_ANIM_DELAY = 100L;
    static final int ANIM_STATE_NONE = 0;
    static final int ANIM_STATE_HIDING = 1;
    static final int ANIM_STATE_SHOWING = 2;
    static final float SHADOW_MULTIPLIER = 1.5f;
    private static final float HIDE_OPACITY = 0.0f;
    private static final float HIDE_SCALE = 0.4f;
    private static final float HIDE_ICON_SCALE = 0.4f;
    private static final float SHOW_OPACITY = 1.0f;
    private static final float SHOW_SCALE = 1.0f;
    private static final float SHOW_ICON_SCALE = 1.0f;
    private static final float SPEC_HIDE_SCALE = 0.0f;
    private static final float SPEC_HIDE_ICON_SCALE = 0.0f;
    private static final int SHOW_ANIM_DURATION_ATTR = R.attr.motionDurationLong2;
    private static final int SHOW_ANIM_EASING_ATTR = R.attr.motionEasingEmphasizedInterpolator;
    private static final int HIDE_ANIM_DURATION_ATTR = R.attr.motionDurationMedium1;
    private static final int HIDE_ANIM_EASING_ATTR = R.attr.motionEasingEmphasizedAccelerateInterpolator;
    @Nullable
    ShapeAppearanceModel shapeAppearance;
    @Nullable
    MaterialShapeDrawable shapeDrawable;
    @Nullable
    Drawable rippleDrawable;
    @Nullable
    BorderDrawable borderDrawable;
    @Nullable
    Drawable contentBackground;
    boolean ensureMinTouchTargetSize;
    boolean shadowPaddingEnabled = true;
    float elevation;
    float hoveredFocusedTranslationZ;
    float pressedTranslationZ;
    int minTouchTargetSize;
    @NonNull
    private final StateListAnimator stateListAnimator;
    @Nullable
    private Animator currentAnimator;
    @Nullable
    private MotionSpec showMotionSpec;
    @Nullable
    private MotionSpec hideMotionSpec;
    private float rotation;
    private float imageMatrixScale = 1.0f;
    private int maxImageSize;
    private int animState = 0;
    private ArrayList<Animator.AnimatorListener> showListeners;
    private ArrayList<Animator.AnimatorListener> hideListeners;
    private ArrayList<InternalTransformationCallback> transformationCallbacks;
    static final int[] PRESSED_ENABLED_STATE_SET = new int[]{16842919, 16842910};
    static final int[] HOVERED_FOCUSED_ENABLED_STATE_SET = new int[]{16843623, 16842908, 16842910};
    static final int[] FOCUSED_ENABLED_STATE_SET = new int[]{16842908, 16842910};
    static final int[] HOVERED_ENABLED_STATE_SET = new int[]{16843623, 16842910};
    static final int[] ENABLED_STATE_SET = new int[]{16842910};
    static final int[] EMPTY_STATE_SET = new int[0];
    final FloatingActionButton view;
    final ShadowViewDelegate shadowViewDelegate;
    private final Rect tmpRect = new Rect();
    private final RectF tmpRectF1 = new RectF();
    private final RectF tmpRectF2 = new RectF();
    private final Matrix tmpMatrix = new Matrix();
    @Nullable
    private ViewTreeObserver.OnPreDrawListener preDrawListener;

    FloatingActionButtonImpl(FloatingActionButton view, ShadowViewDelegate shadowViewDelegate) {
        this.view = view;
        this.shadowViewDelegate = shadowViewDelegate;
        this.stateListAnimator = new StateListAnimator();
        this.stateListAnimator.addState(PRESSED_ENABLED_STATE_SET, this.createElevationAnimator(new ElevateToPressedTranslationZAnimation()));
        this.stateListAnimator.addState(HOVERED_FOCUSED_ENABLED_STATE_SET, this.createElevationAnimator(new ElevateToHoveredFocusedTranslationZAnimation()));
        this.stateListAnimator.addState(FOCUSED_ENABLED_STATE_SET, this.createElevationAnimator(new ElevateToHoveredFocusedTranslationZAnimation()));
        this.stateListAnimator.addState(HOVERED_ENABLED_STATE_SET, this.createElevationAnimator(new ElevateToHoveredFocusedTranslationZAnimation()));
        this.stateListAnimator.addState(ENABLED_STATE_SET, this.createElevationAnimator(new ResetElevationAnimation()));
        this.stateListAnimator.addState(EMPTY_STATE_SET, this.createElevationAnimator(new DisabledElevationAnimation()));
        this.rotation = this.view.getRotation();
    }

    void initializeBackgroundDrawable(ColorStateList backgroundTint, @Nullable PorterDuff.Mode backgroundTintMode, ColorStateList rippleColor, int borderWidth) {
        this.shapeDrawable = this.createShapeDrawable();
        this.shapeDrawable.setTintList(backgroundTint);
        if (backgroundTintMode != null) {
            this.shapeDrawable.setTintMode(backgroundTintMode);
        }
        this.shapeDrawable.setShadowColor(-12303292);
        this.shapeDrawable.initializeElevationOverlay(this.view.getContext());
        RippleDrawableCompat touchFeedbackShape = new RippleDrawableCompat(this.shapeDrawable.getShapeAppearanceModel());
        touchFeedbackShape.setTintList(RippleUtils.sanitizeRippleDrawableColor(rippleColor));
        this.rippleDrawable = touchFeedbackShape;
        Drawable[] layers = new Drawable[]{(Drawable)Preconditions.checkNotNull((Object)this.shapeDrawable), touchFeedbackShape};
        this.contentBackground = new LayerDrawable(layers);
    }

    void setBackgroundTintList(@Nullable ColorStateList tint) {
        if (this.shapeDrawable != null) {
            this.shapeDrawable.setTintList(tint);
        }
        if (this.borderDrawable != null) {
            this.borderDrawable.setBorderTint(tint);
        }
    }

    void setBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        if (this.shapeDrawable != null) {
            this.shapeDrawable.setTintMode(tintMode);
        }
    }

    void setMinTouchTargetSize(int minTouchTargetSize) {
        this.minTouchTargetSize = minTouchTargetSize;
    }

    void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.rippleDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.rippleDrawable, (ColorStateList)RippleUtils.sanitizeRippleDrawableColor(rippleColor));
        }
    }

    final void setElevation(float elevation) {
        if (this.elevation != elevation) {
            this.elevation = elevation;
            this.onElevationsChanged(this.elevation, this.hoveredFocusedTranslationZ, this.pressedTranslationZ);
        }
    }

    float getElevation() {
        return this.elevation;
    }

    float getHoveredFocusedTranslationZ() {
        return this.hoveredFocusedTranslationZ;
    }

    float getPressedTranslationZ() {
        return this.pressedTranslationZ;
    }

    final void setHoveredFocusedTranslationZ(float translationZ) {
        if (this.hoveredFocusedTranslationZ != translationZ) {
            this.hoveredFocusedTranslationZ = translationZ;
            this.onElevationsChanged(this.elevation, this.hoveredFocusedTranslationZ, this.pressedTranslationZ);
        }
    }

    final void setPressedTranslationZ(float translationZ) {
        if (this.pressedTranslationZ != translationZ) {
            this.pressedTranslationZ = translationZ;
            this.onElevationsChanged(this.elevation, this.hoveredFocusedTranslationZ, this.pressedTranslationZ);
        }
    }

    final void setMaxImageSize(int maxImageSize) {
        if (this.maxImageSize != maxImageSize) {
            this.maxImageSize = maxImageSize;
            this.updateImageMatrixScale();
        }
    }

    final void updateImageMatrixScale() {
        this.setImageMatrixScale(this.imageMatrixScale);
    }

    final void setImageMatrixScale(float scale) {
        this.imageMatrixScale = scale;
        Matrix matrix = this.tmpMatrix;
        this.calculateImageMatrixFromScale(scale, matrix);
        this.view.setImageMatrix(matrix);
    }

    private void calculateImageMatrixFromScale(float scale, @NonNull Matrix matrix) {
        matrix.reset();
        Drawable drawable2 = this.view.getDrawable();
        if (drawable2 != null && this.maxImageSize != 0) {
            RectF drawableBounds = this.tmpRectF1;
            RectF imageBounds = this.tmpRectF2;
            drawableBounds.set(0.0f, 0.0f, (float)drawable2.getIntrinsicWidth(), (float)drawable2.getIntrinsicHeight());
            imageBounds.set(0.0f, 0.0f, (float)this.maxImageSize, (float)this.maxImageSize);
            matrix.setRectToRect(drawableBounds, imageBounds, Matrix.ScaleToFit.CENTER);
            matrix.postScale(scale, scale, (float)this.maxImageSize / 2.0f, (float)this.maxImageSize / 2.0f);
        }
    }

    final void setShapeAppearance(@NonNull ShapeAppearanceModel shapeAppearance) {
        this.shapeAppearance = shapeAppearance;
        if (this.shapeDrawable != null) {
            this.shapeDrawable.setShapeAppearanceModel(shapeAppearance);
        }
        if (this.rippleDrawable instanceof Shapeable) {
            ((Shapeable)this.rippleDrawable).setShapeAppearanceModel(shapeAppearance);
        }
        if (this.borderDrawable != null) {
            this.borderDrawable.setShapeAppearanceModel(shapeAppearance);
        }
    }

    @Nullable
    final ShapeAppearanceModel getShapeAppearance() {
        return this.shapeAppearance;
    }

    @Nullable
    final MotionSpec getShowMotionSpec() {
        return this.showMotionSpec;
    }

    final void setShowMotionSpec(@Nullable MotionSpec spec) {
        this.showMotionSpec = spec;
    }

    @Nullable
    final MotionSpec getHideMotionSpec() {
        return this.hideMotionSpec;
    }

    final void setHideMotionSpec(@Nullable MotionSpec spec) {
        this.hideMotionSpec = spec;
    }

    final boolean shouldExpandBoundsForA11y() {
        return !this.ensureMinTouchTargetSize || this.view.getSizeDimension() >= this.minTouchTargetSize;
    }

    boolean getEnsureMinTouchTargetSize() {
        return this.ensureMinTouchTargetSize;
    }

    void setEnsureMinTouchTargetSize(boolean flag) {
        this.ensureMinTouchTargetSize = flag;
    }

    void setShadowPaddingEnabled(boolean shadowPaddingEnabled) {
        this.shadowPaddingEnabled = shadowPaddingEnabled;
        this.updatePadding();
    }

    void onElevationsChanged(float elevation, float hoveredFocusedTranslationZ, float pressedTranslationZ) {
        this.jumpDrawableToCurrentState();
        this.updatePadding();
        this.updateShapeElevation(elevation);
    }

    void updateShapeElevation(float elevation) {
        if (this.shapeDrawable != null) {
            this.shapeDrawable.setElevation(elevation);
        }
    }

    void onDrawableStateChanged(int[] state) {
        this.stateListAnimator.setState(state);
    }

    void jumpDrawableToCurrentState() {
        this.stateListAnimator.jumpToCurrentState();
    }

    void addOnShowAnimationListener(@NonNull Animator.AnimatorListener listener) {
        if (this.showListeners == null) {
            this.showListeners = new ArrayList();
        }
        this.showListeners.add(listener);
    }

    void removeOnShowAnimationListener(@NonNull Animator.AnimatorListener listener) {
        if (this.showListeners == null) {
            return;
        }
        this.showListeners.remove(listener);
    }

    public void addOnHideAnimationListener(@NonNull Animator.AnimatorListener listener) {
        if (this.hideListeners == null) {
            this.hideListeners = new ArrayList();
        }
        this.hideListeners.add(listener);
    }

    public void removeOnHideAnimationListener(@NonNull Animator.AnimatorListener listener) {
        if (this.hideListeners == null) {
            return;
        }
        this.hideListeners.remove(listener);
    }

    void hide(final @Nullable InternalVisibilityChangedListener listener, final boolean fromUser) {
        if (this.isOrWillBeHidden()) {
            return;
        }
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        if (this.shouldAnimateVisibilityChange()) {
            AnimatorSet set = this.hideMotionSpec != null ? this.createAnimator(this.hideMotionSpec, 0.0f, 0.0f, 0.0f) : this.createDefaultAnimator(0.0f, 0.4f, 0.4f, HIDE_ANIM_DURATION_ATTR, HIDE_ANIM_EASING_ATTR);
            set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                private boolean cancelled;

                public void onAnimationStart(Animator animation) {
                    FloatingActionButtonImpl.this.view.internalSetVisibility(0, fromUser);
                    FloatingActionButtonImpl.this.animState = 1;
                    FloatingActionButtonImpl.this.currentAnimator = animation;
                    this.cancelled = false;
                }

                public void onAnimationCancel(Animator animation) {
                    this.cancelled = true;
                }

                public void onAnimationEnd(Animator animation) {
                    FloatingActionButtonImpl.this.animState = 0;
                    FloatingActionButtonImpl.this.currentAnimator = null;
                    if (!this.cancelled) {
                        FloatingActionButtonImpl.this.view.internalSetVisibility(fromUser ? 8 : 4, fromUser);
                        if (listener != null) {
                            listener.onHidden();
                        }
                    }
                }
            });
            if (this.hideListeners != null) {
                for (Animator.AnimatorListener l : this.hideListeners) {
                    set.addListener(l);
                }
            }
            set.start();
        } else {
            this.view.internalSetVisibility(fromUser ? 8 : 4, fromUser);
            if (listener != null) {
                listener.onHidden();
            }
        }
    }

    void show(final @Nullable InternalVisibilityChangedListener listener, final boolean fromUser) {
        boolean useDefaultAnimation;
        if (this.isOrWillBeShown()) {
            return;
        }
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        boolean bl = useDefaultAnimation = this.showMotionSpec == null;
        if (this.shouldAnimateVisibilityChange()) {
            if (this.view.getVisibility() != 0) {
                this.view.setAlpha(0.0f);
                this.view.setScaleY(useDefaultAnimation ? 0.4f : 0.0f);
                this.view.setScaleX(useDefaultAnimation ? 0.4f : 0.0f);
                this.setImageMatrixScale(useDefaultAnimation ? 0.4f : 0.0f);
            }
            AnimatorSet set = this.showMotionSpec != null ? this.createAnimator(this.showMotionSpec, 1.0f, 1.0f, 1.0f) : this.createDefaultAnimator(1.0f, 1.0f, 1.0f, SHOW_ANIM_DURATION_ATTR, SHOW_ANIM_EASING_ATTR);
            set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    FloatingActionButtonImpl.this.view.internalSetVisibility(0, fromUser);
                    FloatingActionButtonImpl.this.animState = 2;
                    FloatingActionButtonImpl.this.currentAnimator = animation;
                }

                public void onAnimationEnd(Animator animation) {
                    FloatingActionButtonImpl.this.animState = 0;
                    FloatingActionButtonImpl.this.currentAnimator = null;
                    if (listener != null) {
                        listener.onShown();
                    }
                }
            });
            if (this.showListeners != null) {
                for (Animator.AnimatorListener l : this.showListeners) {
                    set.addListener(l);
                }
            }
            set.start();
        } else {
            this.view.internalSetVisibility(0, fromUser);
            this.view.setAlpha(1.0f);
            this.view.setScaleY(1.0f);
            this.view.setScaleX(1.0f);
            this.setImageMatrixScale(1.0f);
            if (listener != null) {
                listener.onShown();
            }
        }
    }

    @NonNull
    private AnimatorSet createAnimator(@NonNull MotionSpec spec, float opacity, float scale, float iconScale) {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        ObjectAnimator animatorOpacity = ObjectAnimator.ofFloat((Object)this.view, (Property)View.ALPHA, (float[])new float[]{opacity});
        spec.getTiming("opacity").apply((Animator)animatorOpacity);
        animators.add((Animator)animatorOpacity);
        ObjectAnimator animatorScaleX = ObjectAnimator.ofFloat((Object)this.view, (Property)View.SCALE_X, (float[])new float[]{scale});
        spec.getTiming("scale").apply((Animator)animatorScaleX);
        this.workAroundOreoBug(animatorScaleX);
        animators.add((Animator)animatorScaleX);
        ObjectAnimator animatorScaleY = ObjectAnimator.ofFloat((Object)this.view, (Property)View.SCALE_Y, (float[])new float[]{scale});
        spec.getTiming("scale").apply((Animator)animatorScaleY);
        this.workAroundOreoBug(animatorScaleY);
        animators.add((Animator)animatorScaleY);
        this.calculateImageMatrixFromScale(iconScale, this.tmpMatrix);
        ObjectAnimator animatorIconScale = ObjectAnimator.ofObject((Object)this.view, (Property)new ImageMatrixProperty(), (TypeEvaluator)new MatrixEvaluator(){

            @Override
            public Matrix evaluate(float fraction, @NonNull Matrix startValue, @NonNull Matrix endValue) {
                FloatingActionButtonImpl.this.imageMatrixScale = fraction;
                return super.evaluate(fraction, startValue, endValue);
            }
        }, (Object[])new Matrix[]{new Matrix(this.tmpMatrix)});
        spec.getTiming("iconScale").apply((Animator)animatorIconScale);
        animators.add((Animator)animatorIconScale);
        AnimatorSet set = new AnimatorSet();
        AnimatorSetCompat.playTogether(set, animators);
        return set;
    }

    private AnimatorSet createDefaultAnimator(final float targetOpacity, final float targetScale, final float targetIconScale, int duration, int interpolator) {
        AnimatorSet set = new AnimatorSet();
        ArrayList<Animator> animators = new ArrayList<Animator>();
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        final float startAlpha = this.view.getAlpha();
        final float startScaleX = this.view.getScaleX();
        final float startScaleY = this.view.getScaleY();
        final float startImageMatrixScale = this.imageMatrixScale;
        final Matrix matrix = new Matrix(this.tmpMatrix);
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                FloatingActionButtonImpl.this.view.setAlpha(AnimationUtils.lerp(startAlpha, targetOpacity, 0.0f, 0.2f, progress));
                FloatingActionButtonImpl.this.view.setScaleX(AnimationUtils.lerp(startScaleX, targetScale, progress));
                FloatingActionButtonImpl.this.view.setScaleY(AnimationUtils.lerp(startScaleY, targetScale, progress));
                FloatingActionButtonImpl.this.imageMatrixScale = AnimationUtils.lerp(startImageMatrixScale, targetIconScale, progress);
                FloatingActionButtonImpl.this.calculateImageMatrixFromScale(AnimationUtils.lerp(startImageMatrixScale, targetIconScale, progress), matrix);
                FloatingActionButtonImpl.this.view.setImageMatrix(matrix);
            }
        });
        animators.add((Animator)animator2);
        AnimatorSetCompat.playTogether(set, animators);
        set.setDuration((long)MotionUtils.resolveThemeDuration(this.view.getContext(), duration, this.view.getContext().getResources().getInteger(R.integer.material_motion_duration_long_1)));
        set.setInterpolator(MotionUtils.resolveThemeInterpolator(this.view.getContext(), interpolator, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        return set;
    }

    private void workAroundOreoBug(ObjectAnimator animator2) {
        if (Build.VERSION.SDK_INT != 26) {
            return;
        }
        animator2.setEvaluator((TypeEvaluator)new TypeEvaluator<Float>(){
            FloatEvaluator floatEvaluator = new FloatEvaluator();

            public Float evaluate(float fraction, Float startValue, Float endValue) {
                float evaluated = this.floatEvaluator.evaluate(fraction, (Number)startValue, (Number)endValue).floatValue();
                return Float.valueOf(evaluated < 0.1f ? 0.0f : evaluated);
            }
        });
    }

    void addTransformationCallback(@NonNull InternalTransformationCallback listener) {
        if (this.transformationCallbacks == null) {
            this.transformationCallbacks = new ArrayList();
        }
        this.transformationCallbacks.add(listener);
    }

    void removeTransformationCallback(@NonNull InternalTransformationCallback listener) {
        if (this.transformationCallbacks == null) {
            return;
        }
        this.transformationCallbacks.remove(listener);
    }

    void onTranslationChanged() {
        if (this.transformationCallbacks != null) {
            for (InternalTransformationCallback l : this.transformationCallbacks) {
                l.onTranslationChanged();
            }
        }
    }

    void onScaleChanged() {
        if (this.transformationCallbacks != null) {
            for (InternalTransformationCallback l : this.transformationCallbacks) {
                l.onScaleChanged();
            }
        }
    }

    @Nullable
    final Drawable getContentBackground() {
        return this.contentBackground;
    }

    void onCompatShadowChanged() {
    }

    final void updatePadding() {
        Rect rect = this.tmpRect;
        this.getPadding(rect);
        this.onPaddingUpdated(rect);
        this.shadowViewDelegate.setShadowPadding(rect.left, rect.top, rect.right, rect.bottom);
    }

    void getPadding(@NonNull Rect rect) {
        int touchTargetPadding = this.getTouchTargetPadding();
        float maxShadowSize = this.shadowPaddingEnabled ? this.getElevation() + this.pressedTranslationZ : 0.0f;
        int hPadding = Math.max(touchTargetPadding, (int)Math.ceil(maxShadowSize));
        int vPadding = Math.max(touchTargetPadding, (int)Math.ceil(maxShadowSize * 1.5f));
        rect.set(hPadding, vPadding, hPadding, vPadding);
    }

    int getTouchTargetPadding() {
        return this.ensureMinTouchTargetSize ? Math.max((this.minTouchTargetSize - this.view.getSizeDimension()) / 2, 0) : 0;
    }

    void onPaddingUpdated(@NonNull Rect padding) {
        Preconditions.checkNotNull((Object)this.contentBackground, (Object)"Didn't initialize content background");
        if (this.shouldAddPadding()) {
            InsetDrawable insetDrawable = new InsetDrawable(this.contentBackground, padding.left, padding.top, padding.right, padding.bottom);
            this.shadowViewDelegate.setBackgroundDrawable((Drawable)insetDrawable);
        } else {
            this.shadowViewDelegate.setBackgroundDrawable(this.contentBackground);
        }
    }

    boolean shouldAddPadding() {
        return true;
    }

    void onAttachedToWindow() {
        if (this.shapeDrawable != null) {
            MaterialShapeUtils.setParentAbsoluteElevation((View)this.view, this.shapeDrawable);
        }
        if (this.requirePreDrawListener()) {
            this.view.getViewTreeObserver().addOnPreDrawListener(this.getOrCreatePreDrawListener());
        }
    }

    void onDetachedFromWindow() {
        ViewTreeObserver viewTreeObserver = this.view.getViewTreeObserver();
        if (this.preDrawListener != null) {
            viewTreeObserver.removeOnPreDrawListener(this.preDrawListener);
            this.preDrawListener = null;
        }
    }

    boolean requirePreDrawListener() {
        return true;
    }

    void onPreDraw() {
        float rotation = this.view.getRotation();
        if (this.rotation != rotation) {
            this.rotation = rotation;
            this.updateFromViewRotation();
        }
    }

    @NonNull
    private ViewTreeObserver.OnPreDrawListener getOrCreatePreDrawListener() {
        if (this.preDrawListener == null) {
            this.preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    FloatingActionButtonImpl.this.onPreDraw();
                    return true;
                }
            };
        }
        return this.preDrawListener;
    }

    MaterialShapeDrawable createShapeDrawable() {
        ShapeAppearanceModel shapeAppearance = (ShapeAppearanceModel)Preconditions.checkNotNull((Object)this.shapeAppearance);
        return new MaterialShapeDrawable(shapeAppearance);
    }

    boolean isOrWillBeShown() {
        if (this.view.getVisibility() != 0) {
            return this.animState == 2;
        }
        return this.animState != 1;
    }

    boolean isOrWillBeHidden() {
        if (this.view.getVisibility() == 0) {
            return this.animState == 1;
        }
        return this.animState != 2;
    }

    @NonNull
    private ValueAnimator createElevationAnimator(@NonNull ShadowAnimatorImpl impl) {
        ValueAnimator animator2 = new ValueAnimator();
        animator2.setInterpolator(ELEVATION_ANIM_INTERPOLATOR);
        animator2.setDuration(100L);
        animator2.addListener((Animator.AnimatorListener)impl);
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)impl);
        animator2.setFloatValues(new float[]{0.0f, 1.0f});
        return animator2;
    }

    private boolean shouldAnimateVisibilityChange() {
        return ViewCompat.isLaidOut((View)this.view) && !this.view.isInEditMode();
    }

    void updateFromViewRotation() {
        if (Build.VERSION.SDK_INT == 19) {
            if (this.rotation % 90.0f != 0.0f) {
                if (this.view.getLayerType() != 1) {
                    this.view.setLayerType(1, null);
                }
            } else if (this.view.getLayerType() != 0) {
                this.view.setLayerType(0, null);
            }
        }
        if (this.shapeDrawable != null) {
            this.shapeDrawable.setShadowCompatRotation((int)this.rotation);
        }
    }

    private class DisabledElevationAnimation
    extends ShadowAnimatorImpl {
        DisabledElevationAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return 0.0f;
        }
    }

    private class ElevateToPressedTranslationZAnimation
    extends ShadowAnimatorImpl {
        ElevateToPressedTranslationZAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonImpl.this.elevation + FloatingActionButtonImpl.this.pressedTranslationZ;
        }
    }

    private class ElevateToHoveredFocusedTranslationZAnimation
    extends ShadowAnimatorImpl {
        ElevateToHoveredFocusedTranslationZAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonImpl.this.elevation + FloatingActionButtonImpl.this.hoveredFocusedTranslationZ;
        }
    }

    private class ResetElevationAnimation
    extends ShadowAnimatorImpl {
        ResetElevationAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonImpl.this.elevation;
        }
    }

    private abstract class ShadowAnimatorImpl
    extends AnimatorListenerAdapter
    implements ValueAnimator.AnimatorUpdateListener {
        private boolean validValues;
        private float shadowSizeStart;
        private float shadowSizeEnd;

        private ShadowAnimatorImpl() {
        }

        public void onAnimationUpdate(@NonNull ValueAnimator animator2) {
            if (!this.validValues) {
                this.shadowSizeStart = FloatingActionButtonImpl.this.shapeDrawable == null ? 0.0f : FloatingActionButtonImpl.this.shapeDrawable.getElevation();
                this.shadowSizeEnd = this.getTargetShadowSize();
                this.validValues = true;
            }
            FloatingActionButtonImpl.this.updateShapeElevation((int)(this.shadowSizeStart + (this.shadowSizeEnd - this.shadowSizeStart) * animator2.getAnimatedFraction()));
        }

        public void onAnimationEnd(Animator animator2) {
            FloatingActionButtonImpl.this.updateShapeElevation((int)this.shadowSizeEnd);
            this.validValues = false;
        }

        protected abstract float getTargetShadowSize();
    }

    static interface InternalVisibilityChangedListener {
        public void onShown();

        public void onHidden();
    }

    static interface InternalTransformationCallback {
        public void onTranslationChanged();

        public void onScaleChanged();
    }
}

