/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.material.internal.FadeThroughUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FadeThroughDrawable
extends Drawable {
    private final Drawable fadeOutDrawable;
    private final Drawable fadeInDrawable;
    private final float[] alphas;
    private float progress;

    public FadeThroughDrawable(@NonNull Drawable fadeOutDrawable, @NonNull Drawable fadeInDrawable) {
        this.fadeOutDrawable = fadeOutDrawable.getConstantState().newDrawable().mutate();
        this.fadeInDrawable = fadeInDrawable.getConstantState().newDrawable().mutate();
        this.fadeInDrawable.setAlpha(0);
        this.alphas = new float[2];
    }

    public void draw(@NonNull Canvas canvas) {
        this.fadeOutDrawable.draw(canvas);
        this.fadeInDrawable.draw(canvas);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.fadeOutDrawable.setBounds(left, top, right, bottom);
        this.fadeInDrawable.setBounds(left, top, right, bottom);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.fadeOutDrawable.getIntrinsicWidth(), this.fadeInDrawable.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.fadeOutDrawable.getIntrinsicHeight(), this.fadeInDrawable.getIntrinsicHeight());
    }

    public int getMinimumWidth() {
        return Math.max(this.fadeOutDrawable.getMinimumWidth(), this.fadeInDrawable.getMinimumWidth());
    }

    public int getMinimumHeight() {
        return Math.max(this.fadeOutDrawable.getMinimumHeight(), this.fadeInDrawable.getMinimumHeight());
    }

    public void setAlpha(int alpha) {
        if (this.progress <= 0.5f) {
            this.fadeOutDrawable.setAlpha(alpha);
            this.fadeInDrawable.setAlpha(0);
        } else {
            this.fadeOutDrawable.setAlpha(0);
            this.fadeInDrawable.setAlpha(alpha);
        }
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.fadeOutDrawable.setColorFilter(colorFilter);
        this.fadeInDrawable.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isStateful() {
        return this.fadeOutDrawable.isStateful() || this.fadeInDrawable.isStateful();
    }

    public boolean setState(int[] stateSet) {
        boolean fadeOutDrawableState = this.fadeOutDrawable.setState(stateSet);
        boolean fadeInDrawableState = this.fadeInDrawable.setState(stateSet);
        return fadeOutDrawableState || fadeInDrawableState;
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (this.progress != progress) {
            this.progress = progress;
            FadeThroughUtils.calculateFadeOutAndInAlphas(progress, this.alphas);
            this.fadeOutDrawable.setAlpha((int)(this.alphas[0] * 255.0f));
            this.fadeInDrawable.setAlpha((int)(this.alphas[1] * 255.0f));
            this.invalidateSelf();
        }
    }
}

