/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ManufacturerUtils {
    private static final String LGE = "lge";
    private static final String SAMSUNG = "samsung";
    private static final String MEIZU = "meizu";

    private ManufacturerUtils() {
    }

    public static boolean isMeizuDevice() {
        return ManufacturerUtils.getManufacturer().equals(MEIZU);
    }

    public static boolean isLGEDevice() {
        return ManufacturerUtils.getManufacturer().equals(LGE);
    }

    public static boolean isSamsungDevice() {
        return ManufacturerUtils.getManufacturer().equals(SAMSUNG);
    }

    public static boolean isDateInputKeyboardMissingSeparatorCharacters() {
        return ManufacturerUtils.isLGEDevice() || ManufacturerUtils.isSamsungDevice();
    }

    @NonNull
    private static String getManufacturer() {
        String manufacturer = Build.MANUFACTURER;
        if (manufacturer != null) {
            return manufacturer.toLowerCase(Locale.ENGLISH);
        }
        return "";
    }
}

