/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.materialswitch;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.SwitchCompat;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.R;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialSwitch
extends SwitchCompat {
    private static final int DEF_STYLE_RES = R.style.Widget_Material3_CompoundButton_MaterialSwitch;
    private static final int[] STATE_SET_WITH_ICON = new int[]{R.attr.state_with_icon};
    @Nullable
    private Drawable thumbDrawable;
    @Nullable
    private Drawable thumbIconDrawable;
    @Px
    private int thumbIconSize = -1;
    @Nullable
    private Drawable trackDrawable;
    @Nullable
    private Drawable trackDecorationDrawable;
    @Nullable
    private ColorStateList thumbTintList;
    @Nullable
    private ColorStateList thumbIconTintList;
    @NonNull
    private PorterDuff.Mode thumbIconTintMode;
    @Nullable
    private ColorStateList trackTintList;
    @Nullable
    private ColorStateList trackDecorationTintList;
    @NonNull
    private PorterDuff.Mode trackDecorationTintMode;
    private int[] currentStateUnchecked;
    private int[] currentStateChecked;

    public MaterialSwitch(@NonNull Context context) {
        this(context, null);
    }

    public MaterialSwitch(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.materialSwitchStyle);
    }

    public MaterialSwitch(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.thumbDrawable = super.getThumbDrawable();
        this.thumbTintList = super.getThumbTintList();
        super.setThumbTintList(null);
        this.trackDrawable = super.getTrackDrawable();
        this.trackTintList = super.getTrackTintList();
        super.setTrackTintList(null);
        TintTypedArray attributes = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.MaterialSwitch, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.thumbIconDrawable = attributes.getDrawable(R.styleable.MaterialSwitch_thumbIcon);
        this.thumbIconSize = attributes.getDimensionPixelSize(R.styleable.MaterialSwitch_thumbIconSize, -1);
        this.thumbIconTintList = attributes.getColorStateList(R.styleable.MaterialSwitch_thumbIconTint);
        this.thumbIconTintMode = ViewUtils.parseTintMode(attributes.getInt(R.styleable.MaterialSwitch_thumbIconTintMode, -1), PorterDuff.Mode.SRC_IN);
        this.trackDecorationDrawable = attributes.getDrawable(R.styleable.MaterialSwitch_trackDecoration);
        this.trackDecorationTintList = attributes.getColorStateList(R.styleable.MaterialSwitch_trackDecorationTint);
        this.trackDecorationTintMode = ViewUtils.parseTintMode(attributes.getInt(R.styleable.MaterialSwitch_trackDecorationTintMode, -1), PorterDuff.Mode.SRC_IN);
        attributes.recycle();
        this.setEnforceSwitchWidth(false);
        this.refreshThumbDrawable();
        this.refreshTrackDrawable();
    }

    public void invalidate() {
        this.updateDrawableTints();
        super.invalidate();
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.thumbIconDrawable != null) {
            MaterialSwitch.mergeDrawableStates((int[])drawableState, (int[])STATE_SET_WITH_ICON);
        }
        this.currentStateUnchecked = DrawableUtils.getUncheckedState(drawableState);
        this.currentStateChecked = DrawableUtils.getCheckedState(drawableState);
        return drawableState;
    }

    public void setThumbDrawable(@Nullable Drawable drawable2) {
        this.thumbDrawable = drawable2;
        this.refreshThumbDrawable();
    }

    @Nullable
    public Drawable getThumbDrawable() {
        return this.thumbDrawable;
    }

    public void setThumbTintList(@Nullable ColorStateList tintList) {
        this.thumbTintList = tintList;
        this.refreshThumbDrawable();
    }

    @Nullable
    public ColorStateList getThumbTintList() {
        return this.thumbTintList;
    }

    public void setThumbTintMode(@Nullable PorterDuff.Mode tintMode) {
        super.setThumbTintMode(tintMode);
        this.refreshThumbDrawable();
    }

    public void setThumbIconResource(@DrawableRes int resId) {
        this.setThumbIconDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)resId));
    }

    public void setThumbIconDrawable(@Nullable Drawable icon) {
        this.thumbIconDrawable = icon;
        this.refreshThumbDrawable();
    }

    @Nullable
    public Drawable getThumbIconDrawable() {
        return this.thumbIconDrawable;
    }

    public void setThumbIconSize(@Px int size) {
        if (this.thumbIconSize != size) {
            this.thumbIconSize = size;
            this.refreshThumbDrawable();
        }
    }

    @Px
    public int getThumbIconSize() {
        return this.thumbIconSize;
    }

    public void setThumbIconTintList(@Nullable ColorStateList tintList) {
        this.thumbIconTintList = tintList;
        this.refreshThumbDrawable();
    }

    @Nullable
    public ColorStateList getThumbIconTintList() {
        return this.thumbIconTintList;
    }

    public void setThumbIconTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.thumbIconTintMode = tintMode;
        this.refreshThumbDrawable();
    }

    @NonNull
    public PorterDuff.Mode getThumbIconTintMode() {
        return this.thumbIconTintMode;
    }

    public void setTrackDrawable(@Nullable Drawable track) {
        this.trackDrawable = track;
        this.refreshTrackDrawable();
    }

    @Nullable
    public Drawable getTrackDrawable() {
        return this.trackDrawable;
    }

    public void setTrackTintList(@Nullable ColorStateList tintList) {
        this.trackTintList = tintList;
        this.refreshTrackDrawable();
    }

    @Nullable
    public ColorStateList getTrackTintList() {
        return this.trackTintList;
    }

    public void setTrackTintMode(@Nullable PorterDuff.Mode tintMode) {
        super.setTrackTintMode(tintMode);
        this.refreshTrackDrawable();
    }

    public void setTrackDecorationResource(@DrawableRes int resId) {
        this.setTrackDecorationDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)resId));
    }

    public void setTrackDecorationDrawable(@Nullable Drawable trackDecoration) {
        this.trackDecorationDrawable = trackDecoration;
        this.refreshTrackDrawable();
    }

    @Nullable
    public Drawable getTrackDecorationDrawable() {
        return this.trackDecorationDrawable;
    }

    public void setTrackDecorationTintList(@Nullable ColorStateList tintList) {
        this.trackDecorationTintList = tintList;
        this.refreshTrackDrawable();
    }

    @Nullable
    public ColorStateList getTrackDecorationTintList() {
        return this.trackDecorationTintList;
    }

    public void setTrackDecorationTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.trackDecorationTintMode = tintMode;
        this.refreshTrackDrawable();
    }

    @NonNull
    public PorterDuff.Mode getTrackDecorationTintMode() {
        return this.trackDecorationTintMode;
    }

    private void refreshThumbDrawable() {
        this.thumbDrawable = DrawableUtils.createTintableDrawableIfNeeded(this.thumbDrawable, this.thumbTintList, this.getThumbTintMode());
        this.thumbIconDrawable = DrawableUtils.createTintableDrawableIfNeeded(this.thumbIconDrawable, this.thumbIconTintList, this.thumbIconTintMode);
        this.updateDrawableTints();
        super.setThumbDrawable(DrawableUtils.compositeTwoLayeredDrawable(this.thumbDrawable, this.thumbIconDrawable, this.thumbIconSize, this.thumbIconSize));
        this.refreshDrawableState();
    }

    private void refreshTrackDrawable() {
        this.trackDrawable = DrawableUtils.createTintableDrawableIfNeeded(this.trackDrawable, this.trackTintList, this.getTrackTintMode());
        this.trackDecorationDrawable = DrawableUtils.createTintableDrawableIfNeeded(this.trackDecorationDrawable, this.trackDecorationTintList, this.trackDecorationTintMode);
        this.updateDrawableTints();
        Object finalTrackDrawable = this.trackDrawable != null && this.trackDecorationDrawable != null ? new LayerDrawable(new Drawable[]{this.trackDrawable, this.trackDecorationDrawable}) : (this.trackDrawable != null ? this.trackDrawable : this.trackDecorationDrawable);
        if (finalTrackDrawable != null) {
            this.setSwitchMinWidth(finalTrackDrawable.getIntrinsicWidth());
        }
        super.setTrackDrawable(finalTrackDrawable);
    }

    private void updateDrawableTints() {
        if (this.thumbTintList == null && this.thumbIconTintList == null && this.trackTintList == null && this.trackDecorationTintList == null) {
            return;
        }
        float thumbPosition = this.getThumbPosition();
        if (this.thumbTintList != null) {
            MaterialSwitch.setInterpolatedDrawableTintIfPossible(this.thumbDrawable, this.thumbTintList, this.currentStateUnchecked, this.currentStateChecked, thumbPosition);
        }
        if (this.thumbIconTintList != null) {
            MaterialSwitch.setInterpolatedDrawableTintIfPossible(this.thumbIconDrawable, this.thumbIconTintList, this.currentStateUnchecked, this.currentStateChecked, thumbPosition);
        }
        if (this.trackTintList != null) {
            MaterialSwitch.setInterpolatedDrawableTintIfPossible(this.trackDrawable, this.trackTintList, this.currentStateUnchecked, this.currentStateChecked, thumbPosition);
        }
        if (this.trackDecorationTintList != null) {
            MaterialSwitch.setInterpolatedDrawableTintIfPossible(this.trackDecorationDrawable, this.trackDecorationTintList, this.currentStateUnchecked, this.currentStateChecked, thumbPosition);
        }
    }

    private static void setInterpolatedDrawableTintIfPossible(@Nullable Drawable drawable2, @Nullable ColorStateList tint, @NonNull int[] stateUnchecked, @NonNull int[] stateChecked, float thumbPosition) {
        if (drawable2 == null || tint == null) {
            return;
        }
        DrawableCompat.setTint((Drawable)drawable2, (int)ColorUtils.blendARGB((int)tint.getColorForState(stateUnchecked, 0), (int)tint.getColorForState(stateChecked, 0), (float)thumbPosition));
    }
}

